/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.jam.converters;

import com.intellij.jam.JamSimpleReferenceConverter;
import com.intellij.jam.JamStringAttributeElement;
import com.intellij.lang.properties.PropertiesImplUtil;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.lang.properties.psi.impl.PropertiesFileImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiLiteral;
import com.intellij.psi.PsiReference;
import com.intellij.spring.model.utils.SpringReferenceUtils;
import com.intellij.spring.model.utils.resources.SpringResourcesBuilder;
import com.intellij.spring.model.utils.resources.SpringResourcesUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.PairProcessor;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PropertiesFileConverter
extends JamSimpleReferenceConverter<Set<PropertiesFile>> {
    public Set<PropertiesFile> fromString(@Nullable String s, JamStringAttributeElement<Set<PropertiesFile>> context) {
        PsiAnnotationMemberValue psiElement = context.getPsiElement();
        if (s != null) {
            PsiLiteral psiLiteral;
            PsiLiteral psiLiteral2 = psiLiteral = psiElement instanceof PsiLiteral ? (PsiLiteral)psiElement : PropertiesFileConverter.getFakePsiLiteralElement((PsiElement)psiElement, s);
            if (psiLiteral != null) {
                return new LinkedHashSet<PropertiesFile>(PropertiesFileConverter.getResourceFiles(psiLiteral, s, ",", (Condition<PsiFileSystemItem>)((Condition)item -> item instanceof PropertiesFileImpl)));
            }
        }
        return Collections.emptySet();
    }

    @NotNull
    public PsiReference[] createReferences(JamStringAttributeElement<Set<PropertiesFile>> context) {
        PsiReference[] psiReferenceArray = PropertiesFileConverter.getReferences(context);
        if (psiReferenceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/jam/converters/PropertiesFileConverter", "createReferences"));
        }
        return psiReferenceArray;
    }

    private static PsiReference[] getReferences(JamStringAttributeElement<Set<PropertiesFile>> context) {
        PsiLiteral psiLiteral = context.getPsiLiteral();
        if (psiLiteral == null) {
            return PsiReference.EMPTY_ARRAY;
        }
        String s = ElementManipulators.getValueText((PsiElement)psiLiteral);
        return SpringResourcesUtil.getInstance().getReferences(SpringResourcesBuilder.create((PsiElement)psiLiteral, s).fromRoot(s.startsWith("/")).soft(false));
    }

    private static List<PropertiesFile> getResourceFiles(@NotNull PsiLiteral element, @NotNull String s, String delimiter, Condition<PsiFileSystemItem> filter) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/spring/model/jam/converters/PropertiesFileConverter", "getResourceFiles"));
        }
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/spring/model/jam/converters/PropertiesFileConverter", "getResourceFiles"));
        }
        ArrayList references = new ArrayList();
        int startInElement = ElementManipulators.getOffsetInElement((PsiElement)element);
        SpringReferenceUtils.processSeparatedString(s, delimiter, (PairProcessor<String, Integer>)((PairProcessor)(separatedString, offset) -> {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/spring/model/jam/converters/PropertiesFileConverter", "lambda$getResourceFiles$1"));
            }
            SpringResourcesBuilder builder = SpringResourcesBuilder.create((PsiElement)element, separatedString).offset(offset + startInElement);
            ContainerUtil.addAll((Collection)references, (Object[])SpringResourcesUtil.getInstance().getReferences(builder));
            return true;
        }));
        Collection files = SpringResourcesUtil.getInstance().getResourceItems(references.toArray(new PsiReference[references.size()]), filter);
        return ContainerUtil.mapNotNull(files, PropertiesImplUtil::getPropertiesFile);
    }

    @Nullable
    private static PsiLiteral getFakePsiLiteralElement(PsiElement element, @NotNull String s) {
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/spring/model/jam/converters/PropertiesFileConverter", "getFakePsiLiteralElement"));
        }
        if (element == null) {
            return null;
        }
        try {
            PsiExpression psiExpression = JavaPsiFacade.getElementFactory((Project)element.getProject()).createExpressionFromText("\"" + s + "\"", element);
            if (psiExpression instanceof PsiLiteral) {
                return (PsiLiteral)psiExpression;
            }
        }
        catch (IncorrectOperationException incorrectOperationException) {
            // empty catch block
        }
        return null;
    }
}

