/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.utils;

import com.intellij.openapi.util.TextRange;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.Stack;
import org.jetbrains.annotations.NotNull;

public class PlaceholderTextRanges {
    private PlaceholderTextRanges() {
    }

    @NotNull
    public static Set<TextRange> getPlaceholderRanges(@NotNull String s, @NotNull String prefix, @NotNull String suffix) {
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/spring/model/utils/PlaceholderTextRanges", "getPlaceholderRanges"));
        }
        if (prefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prefix", "com/intellij/spring/model/utils/PlaceholderTextRanges", "getPlaceholderRanges"));
        }
        if (suffix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suffix", "com/intellij/spring/model/utils/PlaceholderTextRanges", "getPlaceholderRanges"));
        }
        Set<TextRange> set = PlaceholderTextRanges.getPlaceholderRanges(s, prefix, suffix, false);
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/utils/PlaceholderTextRanges", "getPlaceholderRanges"));
        }
        return set;
    }

    @NotNull
    public static Set<TextRange> getPlaceholderRanges(@NotNull String s, @NotNull String prefix, @NotNull String suffix, boolean useFullTextRange) {
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/spring/model/utils/PlaceholderTextRanges", "getPlaceholderRanges"));
        }
        if (prefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prefix", "com/intellij/spring/model/utils/PlaceholderTextRanges", "getPlaceholderRanges"));
        }
        if (suffix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suffix", "com/intellij/spring/model/utils/PlaceholderTextRanges", "getPlaceholderRanges"));
        }
        Set<TextRange> set = PlaceholderTextRanges.getPlaceholderRanges(s, prefix, suffix, useFullTextRange, false);
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/utils/PlaceholderTextRanges", "getPlaceholderRanges"));
        }
        return set;
    }

    @NotNull
    public static Set<TextRange> getPlaceholderRanges(@NotNull String s, @NotNull String prefix, @NotNull String suffix, boolean useFullTextRange, boolean filterNestedRanges) {
        int nextSuffix;
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/spring/model/utils/PlaceholderTextRanges", "getPlaceholderRanges"));
        }
        if (prefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prefix", "com/intellij/spring/model/utils/PlaceholderTextRanges", "getPlaceholderRanges"));
        }
        if (suffix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suffix", "com/intellij/spring/model/utils/PlaceholderTextRanges", "getPlaceholderRanges"));
        }
        int current = s.indexOf(prefix);
        if (current == -1) {
            Set<TextRange> set = Collections.emptySet();
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/utils/PlaceholderTextRanges", "getPlaceholderRanges"));
            }
            return set;
        }
        LinkedHashSet<TextRange> ranges = new LinkedHashSet<TextRange>(2);
        Stack<Integer> prefixes = new Stack<Integer>();
        prefixes.push(current);
        while (current >= 0 && (nextSuffix = s.indexOf(suffix, current)) > 0) {
            int nextPrefix = s.indexOf(prefix, current + 1);
            while (nextPrefix > 0 && nextPrefix < nextSuffix) {
                prefixes.push(nextPrefix);
                nextPrefix = s.indexOf(prefix, nextPrefix + 1);
            }
            int startOffset = (Integer)prefixes.pop() + (useFullTextRange ? 0 : prefix.length());
            int endOffset = useFullTextRange ? nextSuffix + suffix.length() : nextSuffix;
            TextRange textRange = new TextRange(startOffset, endOffset);
            ranges.add(textRange);
            if (prefixes.isEmpty()) {
                current = s.indexOf(prefix, nextSuffix + suffix.length());
                prefixes.push(current);
                continue;
            }
            current = s.indexOf(prefix, nextSuffix);
            if (current > 0) {
                prefixes.push(current);
                continue;
            }
            current = s.indexOf(suffix, nextSuffix + suffix.length());
        }
        Set<TextRange> set = filterNestedRanges ? PlaceholderTextRanges.filterNested(ranges) : ranges;
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/utils/PlaceholderTextRanges", "getPlaceholderRanges"));
        }
        return set;
    }

    private static Set<TextRange> filterNested(Set<TextRange> allRanges) {
        LinkedHashSet<TextRange> filtered = new LinkedHashSet<TextRange>(allRanges.size());
        for (TextRange outer : allRanges) {
            boolean contains = PlaceholderTextRanges.anyRangeContains(allRanges, outer);
            if (contains) continue;
            filtered.add(outer);
        }
        return filtered;
    }

    private static boolean anyRangeContains(Set<TextRange> allRanges, TextRange inner) {
        for (TextRange outer : allRanges) {
            if (inner.equals((Object)outer) || !outer.contains(inner)) continue;
            return true;
        }
        return false;
    }
}

