/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.aop;

import com.intellij.aop.AopAdvice;
import com.intellij.aop.AopAdvisedElementsSearcher;
import com.intellij.aop.AopAspect;
import com.intellij.aop.AopProvider;
import com.intellij.aop.ArgNamesManipulator;
import com.intellij.aop.psi.AllAdvisedElementsSearcher;
import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NotNullFactory;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.impl.JavaConstantExpressionEvaluator;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.SpringManager;
import com.intellij.spring.aop.SpringAdvisedElementsSearcher;
import com.intellij.spring.aop.SpringArgNamesManipulator;
import com.intellij.spring.contexts.model.SpringModel;
import com.intellij.spring.contexts.model.XmlSpringModel;
import com.intellij.spring.dom.SpringDomUtils;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.spring.model.utils.SpringModelUtils;
import com.intellij.spring.model.xml.aop.AopConfig;
import com.intellij.spring.model.xml.aop.BasicAdvice;
import com.intellij.spring.model.xml.aop.SpringAopAdvice;
import com.intellij.util.NotNullFunction;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.DomUtil;
import gnu.trove.THashSet;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringAopProvider
extends AopProvider {
    private static final NotNullFunction<Project, AopAdvisedElementsSearcher> myEmptySearcher = project -> new AllAdvisedElementsSearcher(PsiManager.getInstance((Project)project), GlobalSearchScope.EMPTY_SCOPE);

    @NotNull
    public Set<? extends AopAspect> getAdditionalAspects(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/spring/aop/SpringAopProvider", "getAdditionalAspects"));
        }
        if (!SpringCommonUtils.hasSpringFacet((Module)module)) {
            Set set = Collections.emptySet();
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/aop/SpringAopProvider", "getAdditionalAspects"));
            }
            return set;
        }
        Set set = (Set)CachedValuesManager.getManager((Project)module.getProject()).getCachedValue((UserDataHolder)module, () -> {
            if (module == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/spring/aop/SpringAopProvider", "lambda$getAdditionalAspects$1"));
            }
            THashSet set = new THashSet();
            HashSet<XmlFile> configFiles = new HashSet<XmlFile>();
            Set models = SpringManager.getInstance((Project)module.getProject()).getAllModelsWithoutDependencies(module);
            for (SpringModel model : models) {
                if (!(model instanceof XmlSpringModel)) continue;
                for (DomFileElement element : ((XmlSpringModel)model).getLocalModelsRoots()) {
                    configFiles.add(element.getFile());
                    if (!SpringDomUtils.hasNamespace((DomFileElement)element, (String)"Spring AOP namespace key")) continue;
                    SpringAopProvider.addAopAspects((Set<AopAspect>)set, element.getRootElement());
                }
            }
            Object[] dependencies = SpringManager.getInstance((Project)module.getProject()).getModelsDependencies(module, (Object[])configFiles.toArray(new XmlFile[configFiles.size()]));
            return new CachedValueProvider.Result((Object)set, dependencies);
        });
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/aop/SpringAopProvider", "getAdditionalAspects"));
        }
        return set;
    }

    protected static Set<AopAspect> addAopAspects(Set<AopAspect> set, DomElement element) {
        for (DomElement child : DomUtil.getDefinedChildren((DomElement)element, (boolean)true, (boolean)false)) {
            if (child instanceof AopAspect) {
                AopAspect aspect = (AopAspect)child;
                set.add(aspect);
                continue;
            }
            if (!(child instanceof AopConfig)) continue;
            AopConfig config = (AopConfig)child;
            set.addAll(config.getAdvisors());
            set.addAll(config.getAspects());
        }
        return set;
    }

    public AopAdvisedElementsSearcher getAdvisedElementsSearcher(@NotNull PsiClass aClass) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/spring/aop/SpringAopProvider", "getAdvisedElementsSearcher"));
        }
        PsiFile file = aClass.getContainingFile();
        if (file == null) {
            return null;
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)file);
        if (module == null) {
            return (AopAdvisedElementsSearcher)myEmptySearcher.fun((Object)file.getProject());
        }
        return (AopAdvisedElementsSearcher)CachedValuesManager.getManager((Project)module.getProject()).getCachedValue((UserDataHolder)module, () -> CachedValueProvider.Result.create((Object)SpringAopProvider.getModuleElementsSearcher(module), (Object[])SpringManager.getInstance((Project)module.getProject()).getModelsDependencies(module, new Object[]{PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT})));
    }

    @NotNull
    private static AopAdvisedElementsSearcher getModuleElementsSearcher(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/spring/aop/SpringAopProvider", "getModuleElementsSearcher"));
        }
        PsiManager psiManager = PsiManager.getInstance((Project)module.getProject());
        if (SpringAopProvider.hasNoSpringFacetAtAll(module)) {
            AllAdvisedElementsSearcher allAdvisedElementsSearcher = new AllAdvisedElementsSearcher(psiManager, GlobalSearchScope.moduleWithDependenciesScope((Module)module));
            if (allAdvisedElementsSearcher == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/aop/SpringAopProvider", "getModuleElementsSearcher"));
            }
            return allAdvisedElementsSearcher;
        }
        NotNullFactory factory = () -> {
            if (module == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/spring/aop/SpringAopProvider", "lambda$getModuleElementsSearcher$3"));
            }
            return SpringManager.getInstance((Project)module.getProject()).getCombinedModel(module);
        };
        SpringAdvisedElementsSearcher springAdvisedElementsSearcher = new SpringAdvisedElementsSearcher(psiManager, (NotNullFactory<CommonSpringModel>)factory);
        if (springAdvisedElementsSearcher == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/aop/SpringAopProvider", "getModuleElementsSearcher"));
        }
        return springAdvisedElementsSearcher;
    }

    private static boolean hasNoSpringFacetAtAll(Module module) {
        return !SpringCommonUtils.hasSpringFacets((Project)module.getProject()) || ModuleUtilCore.visitMeAndDependentModules((Module)module, checkModule -> !SpringCommonUtils.hasSpringFacet((Module)checkModule));
    }

    @Nullable
    public Pair<? extends ArgNamesManipulator, PsiMethod> getCustomArgNamesManipulator(@NotNull PsiElement element) {
        DomElement domElement;
        XmlTag tag;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/spring/aop/SpringAopProvider", "getCustomArgNamesManipulator"));
        }
        if (element instanceof XmlAttributeValue && element.getParent() instanceof XmlAttribute && "pointcut-ref".equals(((XmlAttribute)element.getParent()).getLocalName()) && (tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)element, XmlTag.class)) != null && (domElement = DomManager.getDomManager((Project)element.getProject()).getDomElement(tag)) instanceof BasicAdvice) {
            BasicAdvice advice = (BasicAdvice)domElement;
            PsiMethod method = (PsiMethod)advice.getMethod().getValue();
            if (advice.getPointcut().getStringValue() == null && method != null) {
                return Pair.create((Object)((Object)new SpringArgNamesManipulator(tag)), (Object)method);
            }
        }
        return super.getCustomArgNamesManipulator(element);
    }

    public Integer getAdviceOrder(AopAdvice advice) {
        if (advice instanceof SpringAopAdvice) {
            return (Integer)((SpringAopAdvice)advice).getOrder().getValue();
        }
        PsiElement element = advice.getIdentifyingPsiElement();
        if (element instanceof PsiAnnotation) {
            PsiClass aClass = (PsiClass)PsiTreeUtil.getContextOfType((PsiElement)element, PsiClass.class, (boolean)false);
            if (aClass == null) {
                return null;
            }
            PsiAnnotation annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)aClass, (boolean)true, (String[])new String[]{"org.springframework.core.annotation.Order"});
            if (annotation != null) {
                Object o;
                PsiAnnotationMemberValue value = annotation.findDeclaredAttributeValue("value");
                if (value instanceof PsiExpression && (o = JavaConstantExpressionEvaluator.computeConstantExpression((PsiExpression)((PsiExpression)value), (boolean)false)) instanceof Integer) {
                    return (Integer)o;
                }
                return null;
            }
            PsiClass orderedClass = JavaPsiFacade.getInstance((Project)aClass.getProject()).findClass("org.springframework.core.Ordered", aClass.getResolveScope());
            if (orderedClass != null && aClass.isInheritor(orderedClass, true)) {
                PsiMethod[] methods;
                for (PsiMethod method : methods = aClass.findMethodsByName("getOrder", true)) {
                    PsiExpression value;
                    Object o;
                    PsiStatement first;
                    PsiCodeBlock body = method.getBody();
                    if (method.getParameterList().getParametersCount() != 0 || body == null || body.getStatements().length != 1 || !((first = body.getStatements()[0]) instanceof PsiReturnStatement) || !((o = JavaConstantExpressionEvaluator.computeConstantExpression((PsiExpression)(value = ((PsiReturnStatement)first).getReturnValue()), (boolean)false)) instanceof Integer)) continue;
                    return (Integer)o;
                }
            }
        }
        return super.getAdviceOrder(advice);
    }

    @NotNull
    public static SpringAdvisedElementsSearcher getLocalModelSearcher(@NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/spring/aop/SpringAopProvider", "getLocalModelSearcher"));
        }
        SpringAdvisedElementsSearcher springAdvisedElementsSearcher = (SpringAdvisedElementsSearcher)((Object)CachedValuesManager.getCachedValue((PsiElement)file, () -> {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/spring/aop/SpringAopProvider", "lambda$getLocalModelSearcher$6"));
            }
            SpringAdvisedElementsSearcher searcher = new SpringAdvisedElementsSearcher(file.getManager(), (NotNullFactory<CommonSpringModel>)((NotNullFactory)() -> {
                if (file == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/spring/aop/SpringAopProvider", "lambda$null$5"));
                }
                return file instanceof XmlFile ? SpringModelUtils.getInstance().getSpringModel((PsiElement)file) : SpringModel.UNKNOWN;
            }));
            return CachedValueProvider.Result.create((Object)((Object)searcher), (Object[])new Object[]{file});
        }));
        if (springAdvisedElementsSearcher == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/aop/SpringAopProvider", "getLocalModelSearcher"));
        }
        return springAdvisedElementsSearcher;
    }
}

