/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl;

import com.intellij.CommonBundle;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.generation.OverrideImplementUtil;
import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.javaee.J2EEBundle;
import com.intellij.javaee.ejb.EjbUtil;
import com.intellij.javaee.ejb.OldEjbRolesUtil;
import com.intellij.javaee.ejb.role.EjbClassRole;
import com.intellij.javaee.ejb.role.EjbClassRoleEnum;
import com.intellij.javaee.ejb.role.EjbDeclMethodRole;
import com.intellij.javaee.ejb.role.EjbDeclMethodRoleImpl;
import com.intellij.javaee.ejb.role.EjbMethodRoleImpl;
import com.intellij.javaee.model.common.ejb.EnterpriseBean;
import com.intellij.lang.StdLanguages;
import com.intellij.openapi.command.undo.UndoUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class EJBImplementationAction
extends PsiElementBaseIntentionAction {
    private static final Logger LOG = Logger.getInstance((String)EJBImplementationAction.class.getName());

    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/intention/impl/EJBImplementationAction", "isAvailable"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/intention/impl/EJBImplementationAction", "isAvailable"));
        }
        if (element instanceof PsiWhiteSpace) {
            return false;
        }
        PsiFile file = element.getContainingFile();
        if (!(file instanceof PsiJavaFile) || file.getLanguage() != StdLanguages.JAVA) {
            return false;
        }
        int offset = editor.getCaretModel().getOffset();
        PsiMethod targetMethod = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)element, PsiMethod.class);
        if (targetMethod == null || !targetMethod.isValid()) {
            return false;
        }
        if (PsiTreeUtil.getChildOfType((PsiElement)targetMethod, PsiErrorElement.class) != null) {
            return false;
        }
        if (targetMethod.getBody() != null && targetMethod.getBody().getTextRange().containsRange(offset, offset + 1)) {
            return false;
        }
        if (targetMethod.getDocComment() != null && targetMethod.getDocComment().getTextRange().containsRange(offset, offset + 1)) {
            return false;
        }
        String text = EJBImplementationAction.getExplanation(targetMethod);
        if (text != null) {
            this.setText(text);
            return true;
        }
        return false;
    }

    @NotNull
    public String getFamilyName() {
        String string = J2EEBundle.message((String)"intention.add.method.to.ejb.class.family", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/intention/impl/EJBImplementationAction", "getFamilyName"));
        }
        return string;
    }

    public static String getExplanation(PsiMethod method) {
        EjbDeclMethodRole methodRole = EJBImplementationAction.suggestMethodDeclRole(method);
        if (methodRole == null) {
            return null;
        }
        return EJBImplementationAction.getExplanationText(methodRole);
    }

    private static EjbDeclMethodRole suggestMethodDeclRole(PsiMethod method) {
        String methodName = method.getName();
        if (!method.hasModifierProperty("public") || method.hasModifierProperty("static") || EjbUtil.isSpecialEjbClassMethod(methodName) || method.isConstructor()) {
            return null;
        }
        PsiClass psiClass = method.getContainingClass();
        for (EjbClassRole classRole : OldEjbRolesUtil.getEjbRoles(psiClass)) {
            EnterpriseBean ejb;
            PsiClass ejbClass;
            EjbDeclMethodRole declMethodRole;
            EjbMethodRoleImpl methodRole;
            if (classRole.getEnterpriseBean() == null || classRole.getType() == EjbClassRoleEnum.EJB_CLASS_ROLE_EJB_CLASS || !((methodRole = EjbMethodRoleImpl.suggestMethodRole(classRole, method)) instanceof EjbDeclMethodRoleImpl) || (declMethodRole = (EjbDeclMethodRole)methodRole).isCompletelyImplemented() || (ejbClass = (PsiClass)(ejb = classRole.getEnterpriseBean()).getEjbClass().getValue()) == null) continue;
            return declMethodRole;
        }
        return null;
    }

    private static String getExplanationText(EjbDeclMethodRole declMethodRole) {
        PsiClass ejbClass = (PsiClass)declMethodRole.getEnterpriseBean().getEjbClass().getValue();
        if (ejbClass != null && ejbClass.isValid()) {
            PsiMethod[] impls = declMethodRole.suggestImplementations();
            ArrayList<String> suggestedNamesList = new ArrayList<String>(impls.length);
            for (PsiMethod impl : impls) {
                if (ejbClass.findMethodBySignature(impl, true) != null) continue;
                suggestedNamesList.add(impl.getName());
            }
            String[] suggestedNames = ArrayUtil.toStringArray(suggestedNamesList);
            if (suggestedNames.length != 0) {
                return J2EEBundle.message((String)"intention.add.method.to.ejb.class.text", (Object[])new Object[]{StringUtil.join((String[])suggestedNames, (String)","), ejbClass.getName()});
            }
        }
        return null;
    }

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        PsiClass ejbClass;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/intention/impl/EJBImplementationAction", "invoke"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/intention/impl/EJBImplementationAction", "invoke"));
        }
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        PsiMethod targetMethod = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)element, PsiMethod.class);
        LOG.assertTrue(targetMethod != null);
        EjbDeclMethodRole methodRole = EJBImplementationAction.suggestMethodDeclRole(targetMethod);
        EnterpriseBean ejb = methodRole.getEnterpriseBean();
        LOG.assertTrue(methodRole instanceof EjbDeclMethodRoleImpl);
        PsiClass psiClass = ejbClass = ejb == null ? null : (PsiClass)ejb.getEjbClass().getValue();
        if (ejbClass == null) {
            Messages.showMessageDialog((Project)project, (String)J2EEBundle.message((String)"intention.add.method.to.ejb.class.error.no.impl.class.message", (Object[])new Object[0]), (String)CommonBundle.getWarningTitle(), (Icon)Messages.getWarningIcon());
            return;
        }
        if (!FileModificationService.getInstance().preparePsiElementForWrite(element)) {
            return;
        }
        PsiFile targetFile = ejbClass.getContainingFile();
        if (!FileModificationService.getInstance().prepareFileForWrite(targetFile)) {
            return;
        }
        try {
            List methods = OverrideImplementUtil.overrideOrImplementMethod((PsiClass)ejbClass, (PsiMethod)targetMethod, (boolean)false);
            boolean dirty = false;
            for (PsiMethod method : methods) {
                EJBImplementationAction.introduceMethod(ejbClass, method);
                dirty = true;
            }
            if (dirty) {
                UndoUtil.markPsiFileForUndo((PsiFile)element.getContainingFile());
            }
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
    }

    private static boolean introduceMethod(PsiClass aClass, PsiMethod method) throws IncorrectOperationException {
        if (aClass.findMethodBySignature(method, true) == null) {
            aClass.add((PsiElement)method);
            return true;
        }
        return false;
    }
}

