/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.options;

import com.intellij.compiler.impl.CompositeScope;
import com.intellij.compiler.impl.ModuleCompileScope;
import com.intellij.javaee.J2EEBundle;
import com.intellij.javaee.artifact.JavaeeArtifactUtil;
import com.intellij.javaee.facet.JavaeeFacet;
import com.intellij.javaee.module.components.FilteredFileSetScope;
import com.intellij.javaee.module.view.JavaeeAbstractAction;
import com.intellij.javaee.module.view.nodes.JavaeeFacetNodeDescriptor;
import com.intellij.javaee.run.execution.update.FilteredByFileTypeCompileScope;
import com.intellij.javaee.ui.packaging.ExplodedWarArtifactType;
import com.intellij.javaee.web.WebRoot;
import com.intellij.javaee.web.WebUtil;
import com.intellij.javaee.web.facet.WebFacet;
import com.intellij.javaee.web.validation.JasperArtifactValidator;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.compiler.CompileScope;
import com.intellij.openapi.compiler.CompilerManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactType;
import com.intellij.packaging.impl.compiler.ArtifactCompileScope;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class ValidateAction
extends JavaeeAbstractAction {
    private static final FileType[] JSP_FILE_TYPES = new FileType[]{StdFileTypes.JSP, StdFileTypes.JSPX};

    public ValidateAction() {
        super(J2EEBundle.message((String)"action.name.validate", (Object[])new Object[0]), J2EEBundle.message((String)"action.description.validate", (Object[])new Object[0]), null);
    }

    protected boolean isActive(AnActionEvent e) {
        JavaeeFacet javaeeFacet = (JavaeeFacet)e.getData(JavaeeFacetNodeDescriptor.FACET_NODE_KEY);
        if (javaeeFacet != null) {
            e.getPresentation().setText(J2EEBundle.message((String)"action.text.validate.facet", (Object[])new Object[]{javaeeFacet.getName()}));
            return true;
        }
        VirtualFile[] files = (VirtualFile[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY);
        if (files == null || files.length == 0) {
            return false;
        }
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        if (project == null) {
            return false;
        }
        WebFacet webFacet = WebUtil.getWebFacet((VirtualFile)files[0], (Project)project);
        if (webFacet == null) {
            return false;
        }
        if (ValidateAction.getWebArtifacts(webFacet).isEmpty()) {
            return false;
        }
        String locationToValidate = ValidateAction.getJSPsLocationToValidate(webFacet, files);
        if (locationToValidate == null) {
            return false;
        }
        e.getPresentation().setText(J2EEBundle.message((String)"action.name.validate.location", (Object[])new Object[]{locationToValidate}));
        return true;
    }

    public void actionPerformed(AnActionEvent event) {
        Project project = (Project)event.getData(CommonDataKeys.PROJECT);
        JavaeeFacet javaeeFacet = (JavaeeFacet)event.getData(JavaeeFacetNodeDescriptor.FACET_NODE_KEY);
        WebFacet webFacet = javaeeFacet instanceof WebFacet ? (WebFacet)javaeeFacet : null;
        ArrayList<VirtualFile> originalFileDirs = new ArrayList<VirtualFile>();
        if (webFacet == null) {
            Object[] files = (VirtualFile[])event.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY);
            if (files != null) {
                webFacet = WebUtil.getWebFacet((VirtualFile)files[0], (Project)project);
                ContainerUtil.addAll(originalFileDirs, (Object[])files);
            }
        } else {
            for (WebRoot webRoot : webFacet.getWebRoots()) {
                VirtualFile dir = webRoot.getFile();
                if (dir == null) continue;
                originalFileDirs.add(dir);
            }
        }
        if (webFacet == null || originalFileDirs.size() == 0) {
            return;
        }
        FilteredFileSetScope jspScope = new FilteredFileSetScope(JSP_FILE_TYPES, originalFileDirs, new Module[]{webFacet.getModule()});
        Collection<Artifact> artifacts = ValidateAction.getWebArtifacts(webFacet);
        CompileScope artifactsScope = ArtifactCompileScope.createScopeWithArtifacts((CompileScope)jspScope, artifacts);
        JasperArtifactValidator.setForceValidation(artifactsScope);
        FilteredByFileTypeCompileScope javaScope = new FilteredByFileTypeCompileScope((CompileScope)new ModuleCompileScope(webFacet.getModule(), true), JSP_FILE_TYPES);
        CompilerManager.getInstance((Project)project).make((CompileScope)new CompositeScope(artifactsScope, (CompileScope)javaScope), null);
    }

    private static Collection<Artifact> getWebArtifacts(WebFacet webFacet) {
        Collection artifacts = JavaeeArtifactUtil.getInstance().getArtifactsContainingFacet((JavaeeFacet)webFacet, (ArtifactType)ExplodedWarArtifactType.getInstance());
        ArrayList<Artifact> result = new ArrayList<Artifact>();
        for (Artifact artifact : artifacts) {
            if (artifact.getOutputPath() == null) continue;
            result.add(artifact);
        }
        return result;
    }

    @Nullable
    private static String getJSPsLocationToValidate(WebFacet webFacet, VirtualFile[] files) {
        List webRoots = webFacet.getWebRoots();
        for (VirtualFile file : files) {
            FileType fileType = file.getFileType();
            if (ArrayUtil.contains((Object)fileType, (Object[])JSP_FILE_TYPES)) {
                return files.length == 1 ? J2EEBundle.message((String)"location.to.validate.jsp", (Object[])new Object[]{file.getName()}) : J2EEBundle.message((String)"location.to.validate.selected.jsps", (Object[])new Object[0]);
            }
            if (!file.isDirectory() || !WebUtil.isInsideWebRoots((VirtualFile)file, (List)webRoots)) continue;
            if (files.length == 1) {
                return J2EEBundle.message((String)"location.to.validate.all.jsps.in.directory", (Object[])new Object[]{file.getName()});
            }
            return J2EEBundle.message((String)"location.to.validate.all.jsps.in.selected.directories", (Object[])new Object[0]);
        }
        return null;
    }
}

