/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.ejb;

import com.intellij.codeInsight.MethodImplementor;
import com.intellij.codeInsight.generation.GenerationInfo;
import com.intellij.codeInsight.generation.OverrideImplementUtil;
import com.intellij.javaee.ejb.EjbHelper;
import com.intellij.javaee.ejb.EjbUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.util.Consumer;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class EjbMethodImplementor
implements MethodImplementor {
    @NotNull
    public PsiMethod[] getMethodsToImplement(PsiClass aClass) {
        PsiMethod[] psiMethodArray = EjbUtil.getEjbMethodsToImplement(aClass);
        if (psiMethodArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/ejb/EjbMethodImplementor", "getMethodsToImplement"));
        }
        return psiMethodArray;
    }

    @NotNull
    public PsiMethod[] createImplementationPrototypes(PsiClass aClass, PsiMethod method) throws IncorrectOperationException {
        PsiMethod[] results;
        for (PsiMethod result : results = EjbUtil.suggestImplementations(method)) {
            EjbUtil.tuneMethodForEjb(EjbHelper.getEjbHelper().getEjbRole(aClass), method, result);
        }
        if (results == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/ejb/EjbMethodImplementor", "createImplementationPrototypes"));
        }
        return results;
    }

    public GenerationInfo createGenerationInfo(PsiMethod method, boolean mergeIfExists) {
        return null;
    }

    @NotNull
    public Consumer<PsiMethod> createDecorator(PsiClass targetClass, PsiMethod baseMethod, boolean toCopyJavaDoc, boolean insertOverrideIfPossible) {
        Consumer consumer = OverrideImplementUtil.createDefaultDecorator((PsiClass)targetClass, (PsiMethod)baseMethod, (boolean)toCopyJavaDoc, (boolean)insertOverrideIfPossible);
        if (consumer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/ejb/EjbMethodImplementor", "createDecorator"));
        }
        return consumer;
    }
}

