/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.module.view.web;

import com.intellij.javaee.module.view.web.WebView;
import com.intellij.javaee.web.facet.WebFacetType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowFactory;
import com.intellij.openapi.wm.ex.ToolWindowEx;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import org.jetbrains.annotations.NotNull;

public class WebToolWindowFactory
implements ToolWindowFactory {
    public static final String TOOL_WINDOW_ID = "Web";

    public void createToolWindowContent(@NotNull Project project, @NotNull ToolWindow toolWindow) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javaee/module/view/web/WebToolWindowFactory", "createToolWindowContent"));
        }
        if (toolWindow == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolWindow", "com/intellij/javaee/module/view/web/WebToolWindowFactory", "createToolWindowContent"));
        }
        toolWindow.setAvailable(true, null);
        toolWindow.setToHideOnEmptyContent(true);
        toolWindow.setTitle(WebFacetType.getInstance().getPresentableName());
        WebView view = new WebView(project);
        view.setupToolWindow((ToolWindowEx)toolWindow);
        ContentManager contentManager = toolWindow.getContentManager();
        Content content = contentManager.getFactory().createContent(view.getComponent(), null, false);
        content.setDisposer((Disposable)view);
        content.setCloseable(false);
        content.setPreferredFocusableComponent(view.getComponent());
        contentManager.addContent(content);
        contentManager.setSelectedContent(content, true);
    }
}

