/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.oss.editor;

import com.intellij.jam.model.common.CommonModelElement;
import com.intellij.jam.model.common.CommonModelManager;
import com.intellij.javaee.model.xml.ejb.EjbBase;
import com.intellij.javaee.model.xml.ejb.EntityBean;
import com.intellij.javaee.model.xml.ejb.MessageDrivenBean;
import com.intellij.javaee.model.xml.ejb.SessionBean;
import com.intellij.javaee.module.view.ejb.editor.EjbAsVirtualFile;
import com.intellij.javaee.oss.editor.JavaeeEmptyEditor;
import com.intellij.javaee.oss.server.JavaeeIntegration;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.xml.ui.PerspectiveFileEditor;
import com.intellij.util.xml.ui.PerspectiveFileEditorProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JavaeeBeanProvider
extends PerspectiveFileEditorProvider {
    private final JavaeeIntegration myIntegration;
    private final double myWeight;

    protected JavaeeBeanProvider(JavaeeIntegration integration, double weight) {
        this.myIntegration = integration;
        this.myWeight = weight;
    }

    private JavaeeIntegration getIntegration() {
        return this.myIntegration;
    }

    public double getWeight() {
        return this.myWeight;
    }

    public final boolean accept(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javaee/oss/editor/JavaeeBeanProvider", "accept"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/javaee/oss/editor/JavaeeBeanProvider", "accept"));
        }
        boolean accept = false;
        if (file instanceof EjbAsVirtualFile) {
            EjbBase bean = (EjbBase)CommonModelManager.getInstance().getDomElement((CommonModelElement)((EjbAsVirtualFile)file).findElement(project));
            if (bean instanceof SessionBean) {
                accept = this.acceptSessionBean((SessionBean)bean);
            } else if (bean instanceof EntityBean) {
                accept = this.acceptEntityBean((EntityBean)bean);
            } else if (bean instanceof MessageDrivenBean) {
                accept = this.acceptMessageBean((MessageDrivenBean)bean);
            }
        }
        return accept;
    }

    @NotNull
    public final PerspectiveFileEditor createEditor(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javaee/oss/editor/JavaeeBeanProvider", "createEditor"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/javaee/oss/editor/JavaeeBeanProvider", "createEditor"));
        }
        PerspectiveFileEditor editor = null;
        if (file instanceof EjbAsVirtualFile) {
            EjbBase bean = (EjbBase)CommonModelManager.getInstance().getDomElement((CommonModelElement)((EjbAsVirtualFile)file).findElement(project));
            if (bean instanceof SessionBean) {
                editor = this.createSessionBeanEditor(project, file, (SessionBean)bean);
            } else if (bean instanceof EntityBean) {
                editor = this.createEntityBeanEditor(project, file, (EntityBean)bean);
            } else if (bean instanceof MessageDrivenBean) {
                editor = this.createMessageBeanEditor(project, file, (MessageDrivenBean)bean);
            }
        }
        if (editor == null) {
            editor = this.empty(project, file);
        }
        PerspectiveFileEditor perspectiveFileEditor = editor;
        if (perspectiveFileEditor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/oss/editor/JavaeeBeanProvider", "createEditor"));
        }
        return perspectiveFileEditor;
    }

    protected boolean acceptEntityBean(@NotNull EntityBean bean) {
        if (bean == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bean", "com/intellij/javaee/oss/editor/JavaeeBeanProvider", "acceptEntityBean"));
        }
        return false;
    }

    protected boolean acceptSessionBean(@NotNull SessionBean bean) {
        if (bean == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bean", "com/intellij/javaee/oss/editor/JavaeeBeanProvider", "acceptSessionBean"));
        }
        return false;
    }

    protected boolean acceptMessageBean(@NotNull MessageDrivenBean bean) {
        if (bean == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bean", "com/intellij/javaee/oss/editor/JavaeeBeanProvider", "acceptMessageBean"));
        }
        return false;
    }

    @Nullable
    protected PerspectiveFileEditor createEntityBeanEditor(@NotNull Project project, @NotNull VirtualFile file, @NotNull EntityBean bean) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javaee/oss/editor/JavaeeBeanProvider", "createEntityBeanEditor"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/javaee/oss/editor/JavaeeBeanProvider", "createEntityBeanEditor"));
        }
        if (bean == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bean", "com/intellij/javaee/oss/editor/JavaeeBeanProvider", "createEntityBeanEditor"));
        }
        return this.empty(project, file);
    }

    @Nullable
    protected PerspectiveFileEditor createSessionBeanEditor(@NotNull Project project, @NotNull VirtualFile file, @NotNull SessionBean bean) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javaee/oss/editor/JavaeeBeanProvider", "createSessionBeanEditor"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/javaee/oss/editor/JavaeeBeanProvider", "createSessionBeanEditor"));
        }
        if (bean == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bean", "com/intellij/javaee/oss/editor/JavaeeBeanProvider", "createSessionBeanEditor"));
        }
        return this.empty(project, file);
    }

    @Nullable
    protected PerspectiveFileEditor createMessageBeanEditor(@NotNull Project project, @NotNull VirtualFile file, @NotNull MessageDrivenBean bean) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javaee/oss/editor/JavaeeBeanProvider", "createMessageBeanEditor"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/javaee/oss/editor/JavaeeBeanProvider", "createMessageBeanEditor"));
        }
        if (bean == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bean", "com/intellij/javaee/oss/editor/JavaeeBeanProvider", "createMessageBeanEditor"));
        }
        return this.empty(project, file);
    }

    @NotNull
    private PerspectiveFileEditor empty(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javaee/oss/editor/JavaeeBeanProvider", "empty"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/javaee/oss/editor/JavaeeBeanProvider", "empty"));
        }
        JavaeeIntegration integration = this.getIntegration();
        JavaeeEmptyEditor javaeeEmptyEditor = new JavaeeEmptyEditor(project, file, integration.getPresentableName(), integration.getBigIcon());
        if (javaeeEmptyEditor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/oss/editor/JavaeeBeanProvider", "empty"));
        }
        return javaeeEmptyEditor;
    }
}

