/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.oss.server;

import com.intellij.facet.frameworks.LibrariesDownloadConnectionService;
import com.intellij.framework.FrameworkType;
import com.intellij.framework.impl.FrameworkTypeUtil;
import com.intellij.javaee.oss.server.JavaeeIntegration;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.deployment.DeploymentUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.PatternUtil;
import com.intellij.util.xmlb.XmlSerializationException;
import com.intellij.util.xmlb.XmlSerializer;
import com.intellij.util.xmlb.annotations.AbstractCollection;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.Property;
import com.intellij.util.xmlb.annotations.Tag;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AppServerFrameworkLibrariesDescriptionLoader {
    private static final Logger LOG = Logger.getInstance(AppServerFrameworkLibrariesDescriptionLoader.class);

    @NotNull
    public static Map<FrameworkType, List<File>> loadFrameworkLibraries(@NotNull JavaeeIntegration integration, @NotNull String serverHome, @NotNull String serverVersion) {
        if (integration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "integration", "com/intellij/javaee/oss/server/AppServerFrameworkLibrariesDescriptionLoader", "loadFrameworkLibraries"));
        }
        if (serverHome == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "serverHome", "com/intellij/javaee/oss/server/AppServerFrameworkLibrariesDescriptionLoader", "loadFrameworkLibraries"));
        }
        if (serverVersion == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "serverVersion", "com/intellij/javaee/oss/server/AppServerFrameworkLibrariesDescriptionLoader", "loadFrameworkLibraries"));
        }
        ApplicationManagerEx.getApplicationEx().assertTimeConsuming();
        String directoryName = integration.getFrameworkLibrariesDescriptionRemoteName();
        AppServerFrameworkLibrariesBean bean = null;
        if (directoryName != null) {
            try {
                URL remoteUrl = AppServerFrameworkLibrariesDescriptionLoader.createAppServerDescriptionUrl(directoryName);
                bean = (AppServerFrameworkLibrariesBean)XmlSerializer.deserialize((URL)remoteUrl, AppServerFrameworkLibrariesBean.class);
            }
            catch (XmlSerializationException e) {
                LOG.info("Cannot fetch server libraries description for " + directoryName + ": " + e.getMessage(), (Throwable)e);
            }
        }
        if (bean == null) {
            String descriptionPath = integration.getFrameworkLibrariesDescriptionPath();
            if (descriptionPath == null) {
                Map<FrameworkType, List<File>> map = Collections.emptyMap();
                if (map == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/oss/server/AppServerFrameworkLibrariesDescriptionLoader", "loadFrameworkLibraries"));
                }
                return map;
            }
            URL localUrl = ((Object)((Object)integration)).getClass().getResource(descriptionPath);
            LOG.assertTrue(localUrl != null, (Object)(descriptionPath + " not found in classpath of " + ((Object)((Object)integration)).getClass()));
            bean = (AppServerFrameworkLibrariesBean)XmlSerializer.deserialize((URL)localUrl, AppServerFrameworkLibrariesBean.class);
        }
        HashMap<FrameworkType, List<File>> map = new HashMap<FrameworkType, List<File>>();
        Map frameworkTypes = FrameworkTypeUtil.computeFrameworkTypeByIdMap();
        for (AppServerVersionBean versionBean : bean.myVersions) {
            Pattern pattern = PatternUtil.fromMask((String)versionBean.myVersion);
            for (AppServerFrameworkLibraryBean libraryBean : versionBean.myLibraries) {
                if (!pattern.matcher(serverVersion).matches()) continue;
                FrameworkType type = (FrameworkType)frameworkTypes.get(libraryBean.myFrameworkId);
                if (type != null) {
                    ArrayList<File> files = new ArrayList<File>();
                    for (AppServerFrameworkLibraryFileBean fileBean : libraryBean.myFiles) {
                        File file = new File(DeploymentUtil.concatPaths((String[])new String[]{serverHome, bean.myBasePath, fileBean.myPath}));
                        if (file.exists()) {
                            files.add(file);
                            continue;
                        }
                        LOG.info("Cannot find file '" + file + "' for '" + type.getId() + "' framework in app server '" + serverHome + "'");
                    }
                    if (files.isEmpty()) continue;
                    map.put(type, files);
                    continue;
                }
                LOG.info("Cannot find framework '" + libraryBean.myFrameworkId + "', libraries for application server won't be loaded");
            }
        }
        HashMap<FrameworkType, List<File>> hashMap = map;
        if (hashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/oss/server/AppServerFrameworkLibrariesDescriptionLoader", "loadFrameworkLibraries"));
        }
        return hashMap;
    }

    @Nullable
    private static URL createAppServerDescriptionUrl(@NotNull String directoryName) {
        if (directoryName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "directoryName", "com/intellij/javaee/oss/server/AppServerFrameworkLibrariesDescriptionLoader", "createAppServerDescriptionUrl"));
        }
        String serviceUrl = LibrariesDownloadConnectionService.getInstance().getServiceUrl();
        if (StringUtil.isNotEmpty((String)serviceUrl)) {
            try {
                return new URL(serviceUrl + "/app-server-libraries/" + directoryName + "/");
            }
            catch (MalformedURLException e) {
                LOG.error((Throwable)e);
            }
        }
        return null;
    }

    public static class AppServerFrameworkLibrariesBean {
        @Attribute(value="basePath")
        public String myBasePath;
        @Property(surroundWithTag=false)
        @AbstractCollection(surroundWithTag=false)
        public AppServerVersionBean[] myVersions;
    }

    @Tag(value="server")
    public static class AppServerVersionBean {
        @Attribute(value="version")
        public String myVersion;
        @Property(surroundWithTag=false)
        @AbstractCollection(surroundWithTag=false)
        public AppServerFrameworkLibraryBean[] myLibraries;
    }

    @Tag(value="library")
    public static class AppServerFrameworkLibraryBean {
        @Attribute(value="framework")
        public String myFrameworkId;
        @Property(surroundWithTag=false)
        @AbstractCollection(surroundWithTag=false)
        public AppServerFrameworkLibraryFileBean[] myFiles;
    }

    @Tag(value="file")
    public static class AppServerFrameworkLibraryFileBean {
        @Attribute(value="path")
        public String myPath;
        @Attribute(value="optional")
        public boolean myOptional;
    }
}

