/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.supportProvider.appServers;

import com.intellij.facet.impl.ui.libraries.FrameworkLibraryProvider;
import com.intellij.framework.FrameworkType;
import com.intellij.framework.library.LibraryBasedFrameworkType;
import com.intellij.j2ee.appServerIntegrations.impl.ApplicationServerImpl;
import com.intellij.javaee.appServerIntegrations.ApplicationServer;
import com.intellij.javaee.serverInstances.ApplicationServersManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryKind;
import com.intellij.util.containers.HashSet;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

class AppServerFrameworkLibraryProvider
extends FrameworkLibraryProvider {
    private static final Logger LOG = Logger.getInstance(AppServerFrameworkLibraryProvider.class);
    @NotNull
    private final ApplicationServer myServer;
    private final Map<FrameworkType, List<File>> myFrameworkLibraries;

    AppServerFrameworkLibraryProvider(@NotNull ApplicationServer server, Map<FrameworkType, List<File>> frameworkLibraries) {
        if (server == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "server", "com/intellij/javaee/supportProvider/appServers/AppServerFrameworkLibraryProvider", "<init>"));
        }
        this.myServer = server;
        this.myFrameworkLibraries = frameworkLibraries;
    }

    @NotNull
    public String getPresentableName() {
        String string = "'" + this.myServer.getName() + "' installation";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/supportProvider/appServers/AppServerFrameworkLibraryProvider", "getPresentableName"));
        }
        return string;
    }

    public Set<LibraryKind> getAvailableLibraryKinds() {
        HashSet libraryKinds = new HashSet();
        for (FrameworkType type : this.myFrameworkLibraries.keySet()) {
            if (!(type instanceof LibraryBasedFrameworkType)) continue;
            libraryKinds.add(((LibraryBasedFrameworkType)type).getLibraryType().getKind());
        }
        return libraryKinds;
    }

    @NotNull
    public Library createLibrary(@NotNull Set<? extends LibraryKind> suitableLibraryKinds) {
        if (suitableLibraryKinds == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suitableLibraryKinds", "com/intellij/javaee/supportProvider/appServers/AppServerFrameworkLibraryProvider", "createLibrary"));
        }
        Map<FrameworkType, List<File>> libraries = this.myFrameworkLibraries;
        for (Map.Entry<FrameworkType, List<File>> entry : libraries.entrySet()) {
            FrameworkType frameworkType = entry.getKey();
            if (!(frameworkType instanceof LibraryBasedFrameworkType) || !suitableLibraryKinds.contains(((LibraryBasedFrameworkType)frameworkType).getLibraryType().getKind())) continue;
            Library library = ((ApplicationServerImpl)this.myServer).getFrameworkLibrary(frameworkType);
            if (library != null) {
                Library library2 = library;
                if (library2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/supportProvider/appServers/AppServerFrameworkLibraryProvider", "createLibrary"));
                }
                return library2;
            }
            ApplicationServersManager.ApplicationServersManagerModifiableModel model = ApplicationServersManager.getInstance().createModifiableModel();
            library = model.addFrameworkLibrary(this.myServer, frameworkType, entry.getValue());
            model.commit();
            Library library3 = library;
            if (library3 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/supportProvider/appServers/AppServerFrameworkLibraryProvider", "createLibrary"));
            }
            return library3;
        }
        LOG.error("Cannot find library app server library: one of " + suitableLibraryKinds + " required, " + libraries.keySet() + " found");
        if (null == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/supportProvider/appServers/AppServerFrameworkLibraryProvider", "createLibrary"));
        }
        return null;
    }
}

