/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.inspections;

import com.intellij.codeInsight.daemon.impl.quickfix.MoveClassToSeparateFileFix;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.QuickFixFactory;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.jpa.JpaMessages;
import com.intellij.jpa.highlighting.JpaHighlightingMessages;
import com.intellij.jpa.highlighting.JpaInspectionUtil;
import com.intellij.jpa.inspections.AbstractJpaInspection;
import com.intellij.jpa.util.JpaUtil;
import com.intellij.persistence.roles.PersistenceClassRole;
import com.intellij.persistence.roles.PersistenceClassRoleEnum;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.containers.ContainerUtil;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class JpaObjectClassSignatureInspection
extends AbstractJpaInspection {
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = JpaMessages.message((String)"inspection.jpa.object.class.signature", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jpa/inspections/JpaObjectClassSignatureInspection", "getDisplayName"));
        }
        return string;
    }

    @NotNull
    public String getShortName() {
        if ("JpaObjectClassSignatureInspection" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jpa/inspections/JpaObjectClassSignatureInspection", "getShortName"));
        }
        return "JpaObjectClassSignatureInspection";
    }

    @Override
    protected void checkClass(PsiClass aClass, PersistenceClassRole role, ProblemsHolder holder, boolean isOnTheFly) {
        if (role.getPersistentObject() != null) {
            JpaObjectClassSignatureInspection.checkObjectClassSignature(aClass, role, holder);
        }
    }

    @Override
    protected void checkClassAllRoles(PsiClass aClass, PersistenceClassRole[] roles, ProblemsHolder holder, boolean isOnTheFly) {
        boolean isError;
        boolean bl = isError = ContainerUtil.find((Object[])roles, role -> role.getEntityListener() != null) != null && ContainerUtil.find((Object[])roles, role -> role.getPersistentObject() != null) != null;
        if (isError) {
            holder.registerProblem((PsiElement)aClass.getNameIdentifier(), JpaHighlightingMessages.message("class.both.persistent.and.entity.listener", aClass.getName()), new LocalQuickFix[0]);
        }
    }

    protected static void checkObjectClassSignature(PsiClass aClass, PersistenceClassRole role, ProblemsHolder holder) {
        if (JpaUtil.isHibernateProvider(role)) {
            if (role.getType() != PersistenceClassRoleEnum.MAPPED_SUPERCLASS) {
                JpaInspectionUtil.checkNoArgConstructorExists(aClass, holder, "public", "protected");
            }
        } else {
            if (aClass.getContainingClass() != null) {
                holder.registerProblem((PsiElement)aClass.getNameIdentifier(), JpaHighlightingMessages.message("persistent.object.class.should.be.top.level", aClass.getName()), new LocalQuickFix[]{JpaInspectionUtil.convertToQuickFix((IntentionAction)new MoveClassToSeparateFileFix(aClass))});
            }
            PsiModifierList modifierList = aClass.getModifierList();
            assert (modifierList != null);
            if (modifierList.hasModifierProperty("final")) {
                PsiElement modifier = PsiUtil.findModifierInList((PsiModifierList)modifierList, (String)"final");
                holder.registerProblem((PsiElement)(modifier == null ? aClass.getNameIdentifier() : modifier), JpaHighlightingMessages.message("persistent.object.class.0.should.not.be.final", aClass.getName()), new LocalQuickFix[]{JpaInspectionUtil.convertToQuickFix((IntentionAction)QuickFixFactory.getInstance().createModifierListFix(modifierList, "final", false, true))});
            }
            if (role.getType() != PersistenceClassRoleEnum.MAPPED_SUPERCLASS) {
                JpaInspectionUtil.checkNoArgConstructorExists(aClass, holder, "public", "protected");
            }
        }
    }
}

