/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.ql.psi.impl;

import com.intellij.jpa.ql.psi.QlInputParameter;
import com.intellij.jpa.ql.psi.QlPsiElementFactory;
import com.intellij.jpa.ql.psi.impl.QlExpressionImpl;
import com.intellij.jpa.ql.psi.impl.QlFileImpl;
import com.intellij.jpa.ql.types.QlType;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class QlInputParamImpl
extends QlExpressionImpl
implements QlInputParameter,
PsiReference {
    public QlInputParamImpl(ASTNode node) {
        super(node);
    }

    @Nullable
    public String getName() {
        ASTNode node = this.getNode();
        return node.getText().substring(1).trim();
    }

    public boolean isPositional() {
        return this.getNode().getText().startsWith("?");
    }

    public PsiReference getReference() {
        return this;
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/jpa/ql/psi/impl/QlInputParamImpl", "bindToElement"));
        }
        throw new UnsupportedOperationException("Method bindToElement is not yet implemented in " + this.getClass().getName());
    }

    @NotNull
    public String getCanonicalText() {
        String string = this.getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jpa/ql/psi/impl/QlInputParamImpl", "getCanonicalText"));
        }
        return string;
    }

    public PsiElement getElement() {
        return this;
    }

    public TextRange getRangeInElement() {
        return TextRange.from((int)1, (int)(this.getTextLength() - 1));
    }

    @NotNull
    public Object[] getVariants() {
        if (ArrayUtil.EMPTY_OBJECT_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jpa/ql/psi/impl/QlInputParamImpl", "getVariants"));
        }
        return ArrayUtil.EMPTY_OBJECT_ARRAY;
    }

    public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
        QlInputParameter p = QlPsiElementFactory.createInputParameter(":" + newElementName, this.getProject());
        return this.replace((PsiElement)ObjectUtils.assertNotNull((Object)p));
    }

    public boolean isReferenceTo(PsiElement element) {
        return element instanceof QlFileImpl.ParameterDefinition && element.equals(this.resolve());
    }

    public boolean isSoft() {
        return true;
    }

    @Override
    @Nullable
    public QlType getType() {
        return null;
    }

    @Nullable
    public PsiElement resolve() {
        return ((QlFileImpl)this.getContainingFile()).getParameterDeclarations().get(this.getName());
    }
}

