/*
 * Decompiled with CFR 0.152.
 */
package com.sampullara.cli;

import com.sampullara.cli.Args;
import com.sampullara.cli.Argument;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Properties;

public class PropertiesArgs {
    public static void parse(Object target, Properties arguments2) {
        Class<?> clazz = target instanceof Class ? (Class<?>)target : target.getClass();
        for (Field field2 : clazz.getDeclaredFields()) {
            PropertiesArgs.processField(target, field2, arguments2);
        }
        try {
            BeanInfo info = Introspector.getBeanInfo(clazz);
            for (PropertyDescriptor pd : info.getPropertyDescriptors()) {
                PropertiesArgs.processProperty(target, pd, arguments2);
            }
        }
        catch (IntrospectionException introspectionException) {
            // empty catch block
        }
    }

    private static void processField(Object target, Field field2, Properties arguments2) {
        Argument argument2 = field2.getAnnotation(Argument.class);
        if (argument2 != null) {
            String name2 = Args.getName(argument2, field2);
            String alias = Args.getAlias(argument2);
            Class<?> type2 = field2.getType();
            Object value2 = arguments2.get(name2);
            if (value2 == null && alias != null) {
                value2 = arguments2.get(alias);
            }
            if (value2 != null) {
                if (type2 == Boolean.TYPE || type2 == Boolean.class) {
                    value2 = true;
                }
                Args.setField(type2, field2, target, value2, argument2.delimiter());
            } else if (argument2.required()) {
                throw new IllegalArgumentException("You must set argument " + name2);
            }
        }
    }

    private static void processProperty(Object target, PropertyDescriptor property2, Properties arguments2) {
        Argument argument2;
        Method writeMethod = property2.getWriteMethod();
        if (writeMethod != null && (argument2 = writeMethod.getAnnotation(Argument.class)) != null) {
            String name2 = Args.getName(argument2, property2);
            String alias = Args.getAlias(argument2);
            Object value2 = arguments2.get(name2);
            if (value2 == null && alias != null) {
                value2 = arguments2.get(alias);
            }
            if (value2 != null) {
                Class<?> type2 = property2.getPropertyType();
                if (type2 == Boolean.TYPE || type2 == Boolean.class) {
                    value2 = true;
                }
                Args.setProperty(type2, property2, target, value2, argument2.delimiter());
            } else if (argument2.required()) {
                throw new IllegalArgumentException("You must set argument " + name2);
            }
        }
    }
}

