/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm;

import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.jvm.JvmBackend;
import org.jetbrains.kotlin.backend.jvm.JvmBackendContext;
import org.jetbrains.kotlin.codegen.CompilationErrorHandler;
import org.jetbrains.kotlin.codegen.state.GenerationState;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.progress.ProgressIndicatorAndCompilationCanceledStatus;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi2ir.Psi2IrTranslator;
import org.jetbrains.kotlin.psi2ir.generators.GeneratorContext;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ$\u0010\t\u001a\u00020\u00042\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/JvmBackendFacade;", "", "()V", "compileCorrectFiles", "", "state", "Lorg/jetbrains/kotlin/codegen/state/GenerationState;", "errorHandler", "Lorg/jetbrains/kotlin/codegen/CompilationErrorHandler;", "doGenerateFiles", "files", "", "Lorg/jetbrains/kotlin/psi/KtFile;", "backend.jvm"})
public final class JvmBackendFacade {
    public static final JvmBackendFacade INSTANCE;

    public final void compileCorrectFiles(@NotNull GenerationState state, @NotNull CompilationErrorHandler errorHandler) {
        Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
        Intrinsics.checkParameterIsNotNull((Object)errorHandler, (String)"errorHandler");
        ProgressIndicatorAndCompilationCanceledStatus.checkCanceled();
        state.beforeCompile();
        ProgressIndicatorAndCompilationCanceledStatus.checkCanceled();
        this.doGenerateFiles((Collection<? extends KtFile>)state.getFiles(), state, errorHandler);
    }

    public final void doGenerateFiles(@NotNull Collection<? extends KtFile> files2, @NotNull GenerationState state, @NotNull CompilationErrorHandler errorHandler) {
        Intrinsics.checkParameterIsNotNull(files2, (String)"files");
        Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
        Intrinsics.checkParameterIsNotNull((Object)errorHandler, (String)"errorHandler");
        Psi2IrTranslator psi2ir = new Psi2IrTranslator(null, 1, null);
        GeneratorContext psi2irContext = psi2ir.createGeneratorContext(state.getModule(), state.getBindingContext());
        IrModuleFragment irModuleFragment = psi2ir.generateModuleFragment(psi2irContext, files2);
        JvmBackendContext jvmBackendContext = new JvmBackendContext(state, psi2irContext.getSourceManager(), psi2irContext.getIrBuiltIns());
        JvmBackend jvmBackend = new JvmBackend(jvmBackendContext);
        for (IrFile irFile : irModuleFragment.getFiles()) {
            try {
                jvmBackend.generateFile(irFile);
                state.afterIndependentPart();
            }
            catch (Throwable e) {
                errorHandler.reportException(e, null);
            }
        }
    }

    private JvmBackendFacade() {
        INSTANCE = this;
    }

    static {
        new JvmBackendFacade();
    }
}

