/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.console;

import com.intellij.execution.console.LanguageConsoleView;
import com.intellij.execution.process.BaseOSProcessHandler;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import java.io.OutputStream;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.console.CommandExecutorKt;
import org.jetbrains.kotlin.console.CommandHistory;
import org.jetbrains.kotlin.console.HistoryUpdater;
import org.jetbrains.kotlin.console.KotlinConsoleRunner;
import org.jetbrains.kotlin.console.ReplOutputHandlerKt;
import org.jetbrains.kotlin.console.actions.RunExecuteActionsKt;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\t\u001a\u00020\nJ\b\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\fH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/console/CommandExecutor;", "", "runner", "Lorg/jetbrains/kotlin/console/KotlinConsoleRunner;", "(Lorg/jetbrains/kotlin/console/KotlinConsoleRunner;)V", "commandHistory", "Lorg/jetbrains/kotlin/console/CommandHistory;", "historyUpdater", "Lorg/jetbrains/kotlin/console/HistoryUpdater;", "executeCommand", "", "getTrimmedCommandText", "", "sendCommandToProcess", "command", "idea-repl"})
public final class CommandExecutor {
    private final CommandHistory commandHistory;
    private final HistoryUpdater historyUpdater;
    private final KotlinConsoleRunner runner;

    public final void executeCommand() {
        WriteCommandAction.runWriteCommandAction((Project)this.runner.getProject(), (Runnable)new Runnable(this){
            final /* synthetic */ CommandExecutor this$0;

            public final void run() {
                String commandText = CommandExecutor.access$getTrimmedCommandText(this.this$0);
                CharSequence charSequence = commandText;
                if (charSequence.length() == 0) {
                    return;
                }
                TextRange historyDocumentRange = CommandExecutor.access$getHistoryUpdater$p(this.this$0).printNewCommandInHistory(commandText);
                CommandExecutor.access$getCommandHistory$p(this.this$0).addEntry(new CommandHistory.Entry(commandText, historyDocumentRange));
                CommandExecutor.access$sendCommandToProcess(this.this$0, commandText);
            }
            {
                this.this$0 = commandExecutor;
            }
        });
    }

    private final String getTrimmedCommandText() {
        String string;
        LanguageConsoleView consoleView2 = this.runner.getConsoleView();
        Document document = consoleView2.getEditorDocument();
        String string2 = string = document.getText();
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        String inputText = ((Object)StringsKt.trim((CharSequence)string2)).toString();
        return inputText;
    }

    private final void sendCommandToProcess(String command) {
        Object object;
        ProcessHandler processHandler = this.runner.getProcessHandler();
        OutputStream outputStream2 = processHandler.getProcessInput();
        if (outputStream2 == null) {
            RunExecuteActionsKt.logError(this.getClass(), "<p>Broken process stream</p>");
            return;
        }
        OutputStream processInputOS = outputStream2;
        ProcessHandler processHandler2 = processHandler;
        if (!(processHandler2 instanceof BaseOSProcessHandler)) {
            processHandler2 = null;
        }
        if ((object = (BaseOSProcessHandler)processHandler2) == null || (object = object.getCharset()) == null) {
            object = Charsets.UTF_8;
        }
        Object charset = object;
        String xmlRes = String.valueOf(CommandExecutorKt.access$getXML_PREAMBLE$p()) + "<input>" + String.valueOf(StringUtil.escapeXml((String)StringUtil.replace((String)command, (String[])ReplOutputHandlerKt.getSOURCE_CHARS(), (String[])ReplOutputHandlerKt.getXML_REPLACEMENTS()))) + "</input>";
        String string = xmlRes + "\n";
        Object object2 = charset;
        Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"charset");
        Object object3 = object2;
        String string2 = string;
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        byte[] byArray = string2.getBytes((Charset)object3);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        byte[] bytes2 = byArray;
        processInputOS.write(bytes2);
        processInputOS.flush();
    }

    public CommandExecutor(@NotNull KotlinConsoleRunner runner) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)runner), (String)"runner");
        this.runner = runner;
        this.commandHistory = this.runner.getCommandHistory();
        this.historyUpdater = new HistoryUpdater(this.runner);
    }

    @NotNull
    public static final /* synthetic */ String access$getTrimmedCommandText(CommandExecutor $this) {
        return $this.getTrimmedCommandText();
    }

    @NotNull
    public static final /* synthetic */ HistoryUpdater access$getHistoryUpdater$p(CommandExecutor $this) {
        return $this.historyUpdater;
    }

    @NotNull
    public static final /* synthetic */ CommandHistory access$getCommandHistory$p(CommandExecutor $this) {
        return $this.commandHistory;
    }

    public static final /* synthetic */ void access$sendCommandToProcess(CommandExecutor $this, @NotNull String command) {
        $this.sendCommandToProcess(command);
    }
}

