/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.actions;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.popup.ListPopup;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.configuration.ConfigureKotlinInProjectUtilsKt;
import org.jetbrains.kotlin.idea.configuration.KotlinProjectConfigurator;
import org.jetbrains.kotlin.idea.configuration.KotlinSetupEnvironmentNotificationProvider;
import org.jetbrains.kotlin.idea.util.projectStructure.ProjectStructureUtilKt;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0016\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000bH&\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/idea/actions/ConfigureKotlinInProjectAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getApplicableConfigurators", "", "Lorg/jetbrains/kotlin/idea/configuration/KotlinProjectConfigurator;", "project", "Lcom/intellij/openapi/project/Project;", "idea"})
public abstract class ConfigureKotlinInProjectAction
extends AnAction {
    @NotNull
    public abstract Collection<KotlinProjectConfigurator> getApplicableConfigurators(@NotNull Project var1);

    public void actionPerformed(@NotNull AnActionEvent e) {
        boolean bl;
        Project project;
        block9: {
            Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
            Project project2 = e.getProject();
            if (project2 == null) {
                return;
            }
            Project project3 = project = project2;
            Intrinsics.checkExpressionValueIsNotNull((Object)project3, (String)"project");
            Iterable $receiver$iv = ConfigureKotlinInProjectUtilsKt.getModulesWithKotlinFiles(project3);
            Collection modules = $receiver$iv.isEmpty() ? (Collection)ProjectStructureUtilKt.allModules(project) : $receiver$iv;
            $receiver$iv = modules;
            for (Object element$iv : $receiver$iv) {
                Module it;
                Module module = it = (Module)element$iv;
                Intrinsics.checkExpressionValueIsNotNull((Object)module, (String)"it");
                if (ConfigureKotlinInProjectUtilsKt.isModuleConfigured(module)) continue;
                bl = false;
                break block9;
            }
            bl = true;
        }
        if (bl) {
            String string = e.getPresentation().getText();
            if (string == null) {
                Intrinsics.throwNpe();
            }
            Messages.showInfoMessage((String)"All modules with Kotlin files are configured", (String)string);
            return;
        }
        Project project4 = project;
        Intrinsics.checkExpressionValueIsNotNull((Object)project4, (String)"project");
        Collection<KotlinProjectConfigurator> configurators = this.getApplicableConfigurators(project4);
        if (configurators.size() == 1) {
            KotlinProjectConfigurator kotlinProjectConfigurator = (KotlinProjectConfigurator)CollectionsKt.first((Iterable)configurators);
            Project project5 = project;
            Intrinsics.checkExpressionValueIsNotNull((Object)project5, (String)"project");
            kotlinProjectConfigurator.configure(project5, CollectionsKt.emptyList());
        } else if (configurators.isEmpty()) {
            String string = e.getPresentation().getText();
            if (string == null) {
                Intrinsics.throwNpe();
            }
            Messages.showErrorDialog((String)"There aren't configurators available", (String)string);
        } else {
            Project project6 = project;
            Intrinsics.checkExpressionValueIsNotNull((Object)project6, (String)"project");
            ListPopup configuratorsPopup = KotlinSetupEnvironmentNotificationProvider.Companion.createConfiguratorsPopup(project6, CollectionsKt.toList((Iterable)configurators));
            configuratorsPopup.showInBestPositionFor(e.getDataContext());
        }
    }
}

