/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.codeInsight;

import com.intellij.psi.PsiFile;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.codeInsight.KotlinFileReferencesResolverKt;
import org.jetbrains.kotlin.idea.resolve.ResolutionFacade;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtTreeVisitorVoid;
import org.jetbrains.kotlin.psi.KtUserType;
import org.jetbrains.kotlin.resolve.BindingContext;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0010B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J.\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00042\u0006\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\nJ@\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00042\u0006\u0010\f\u001a\u00020\r2\u0010\b\u0002\u0010\u000e\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u000f2\b\b\u0002\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\n\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/idea/codeInsight/KotlinFileReferencesResolver;", "", "()V", "resolve", "", "Lorg/jetbrains/kotlin/psi/KtReferenceExpression;", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "element", "Lorg/jetbrains/kotlin/psi/KtElement;", "resolveQualifiers", "", "resolveShortNames", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "elements", "", "ResolveAllReferencesVisitor", "idea-analysis"})
public final class KotlinFileReferencesResolver {
    public static final KotlinFileReferencesResolver INSTANCE;

    @NotNull
    public final Map<KtReferenceExpression, BindingContext> resolve(@NotNull KtElement element2, boolean resolveQualifiers, boolean resolveShortNames) {
        KtFile ktFile;
        KtFile file2;
        Map<KtReferenceExpression, BindingContext> map2;
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        PsiFile psiFile = element2.getContainingFile();
        if (!(psiFile instanceof KtFile)) {
            psiFile = null;
        }
        if ((map2 = (KtFile)psiFile) == null || (map2 = INSTANCE.resolve(file2 = (ktFile = map2), CollectionsKt.listOf((Object)element2), resolveQualifiers, resolveShortNames)) == null) {
            Map map3 = Collections.emptyMap();
            map2 = map3;
            Intrinsics.checkExpressionValueIsNotNull(map3, (String)"Collections.emptyMap()");
        }
        return map2;
    }

    @NotNull
    public static /* bridge */ /* synthetic */ Map resolve$default(KotlinFileReferencesResolver kotlinFileReferencesResolver, KtElement ktElement, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        if ((n & 4) != 0) {
            bl2 = true;
        }
        return kotlinFileReferencesResolver.resolve(ktElement, bl, bl2);
    }

    @NotNull
    public final Map<KtReferenceExpression, BindingContext> resolve(@NotNull KtFile file2, @Nullable Iterable<? extends KtElement> elements2, boolean resolveQualifiers, boolean resolveShortNames) {
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        ResolveAllReferencesVisitor visitor2 = new ResolveAllReferencesVisitor(file2, resolveQualifiers, resolveShortNames);
        if (elements2 != null) {
            Iterable<? extends KtElement> $receiver$iv = elements2;
            Iterator<? extends KtElement> iterator2 = $receiver$iv.iterator();
            while (iterator2.hasNext()) {
                KtElement element$iv;
                KtElement it = element$iv = iterator2.next();
                it.accept(visitor2);
            }
        } else {
            file2.accept(visitor2);
        }
        return visitor2.getResult();
    }

    @NotNull
    public static /* bridge */ /* synthetic */ Map resolve$default(KotlinFileReferencesResolver kotlinFileReferencesResolver, KtFile ktFile, Iterable iterable, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 2) != 0) {
            iterable = null;
        }
        if ((n & 4) != 0) {
            bl = true;
        }
        if ((n & 8) != 0) {
            bl2 = true;
        }
        return kotlinFileReferencesResolver.resolve(ktFile, iterable, bl, bl2);
    }

    private KotlinFileReferencesResolver() {
        INSTANCE = this;
    }

    static {
        new KotlinFileReferencesResolver();
    }

    @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u001aH\u0016J\u0010\u0010\u001b\u001a\u00020\u00162\u0006\u0010\u001c\u001a\u00020\u001dH\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000fR\u001d\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/kotlin/idea/codeInsight/KotlinFileReferencesResolver$ResolveAllReferencesVisitor;", "Lorg/jetbrains/kotlin/psi/KtTreeVisitorVoid;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "resolveQualifiers", "", "resolveShortNames", "(Lorg/jetbrains/kotlin/psi/KtFile;ZZ)V", "resolutionFacade", "Lorg/jetbrains/kotlin/idea/resolve/ResolutionFacade;", "resolveMap", "Ljava/util/LinkedHashMap;", "Lorg/jetbrains/kotlin/psi/KtReferenceExpression;", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "getResolveQualifiers", "()Z", "getResolveShortNames", "result", "", "getResult", "()Ljava/util/Map;", "visitQualifiedExpression", "", "expression", "Lorg/jetbrains/kotlin/psi/KtQualifiedExpression;", "visitSimpleNameExpression", "Lorg/jetbrains/kotlin/psi/KtSimpleNameExpression;", "visitUserType", "userType", "Lorg/jetbrains/kotlin/psi/KtUserType;", "idea-analysis"})
    private static final class ResolveAllReferencesVisitor
    extends KtTreeVisitorVoid {
        private final ResolutionFacade resolutionFacade;
        private final LinkedHashMap<KtReferenceExpression, BindingContext> resolveMap;
        @NotNull
        private final Map<KtReferenceExpression, BindingContext> result;
        private final boolean resolveQualifiers;
        private final boolean resolveShortNames;

        @NotNull
        public final Map<KtReferenceExpression, BindingContext> getResult() {
            return this.result;
        }

        @Override
        public void visitUserType(@NotNull KtUserType userType2) {
            KtSimpleNameExpression referenceExpression;
            Intrinsics.checkParameterIsNotNull((Object)userType2, (String)"userType");
            if (this.resolveQualifiers) {
                userType2.acceptChildren(this);
            }
            if ((this.resolveShortNames || userType2.getQualifier() != null) && (referenceExpression = userType2.getReferenceExpression()) != null) {
                Map map2 = this.resolveMap;
                BindingContext bindingContext2 = ResolutionFacade.DefaultImpls.analyze$default(this.resolutionFacade, referenceExpression, null, 2, null);
                map2.put(referenceExpression, bindingContext2);
            }
        }

        @Override
        public void visitQualifiedExpression(@NotNull KtQualifiedExpression expression2) {
            block2: {
                KtReferenceExpression referenceExpression;
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                KtExpression receiverExpression = expression2.getReceiverExpression();
                if (this.resolveQualifiers || ResolutionFacade.DefaultImpls.analyze$default(this.resolutionFacade, expression2, null, 2, null).get(BindingContext.QUALIFIER, receiverExpression) == null) {
                    receiverExpression.accept(this);
                }
                KtExpression ktExpression = expression2.getSelectorExpression();
                KtReferenceExpression ktReferenceExpression = referenceExpression = ktExpression != null ? KotlinFileReferencesResolverKt.referenceExpression(ktExpression) : null;
                if (referenceExpression != null) {
                    Map map2 = this.resolveMap;
                    BindingContext bindingContext2 = ResolutionFacade.DefaultImpls.analyze$default(this.resolutionFacade, referenceExpression, null, 2, null);
                    map2.put(referenceExpression, bindingContext2);
                }
                KtExpression ktExpression2 = expression2.getSelectorExpression();
                if (ktExpression2 == null) break block2;
                ktExpression2.accept(this);
            }
        }

        @Override
        public void visitSimpleNameExpression(@NotNull KtSimpleNameExpression expression2) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            if (this.resolveShortNames) {
                Map map2 = this.resolveMap;
                BindingContext bindingContext2 = ResolutionFacade.DefaultImpls.analyze$default(this.resolutionFacade, expression2, null, 2, null);
                map2.put(expression2, bindingContext2);
            }
        }

        public final boolean getResolveQualifiers() {
            return this.resolveQualifiers;
        }

        public final boolean getResolveShortNames() {
            return this.resolveShortNames;
        }

        public ResolveAllReferencesVisitor(@NotNull KtFile file2, boolean resolveQualifiers, boolean resolveShortNames) {
            Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
            this.resolveQualifiers = resolveQualifiers;
            this.resolveShortNames = resolveShortNames;
            this.resolutionFacade = ResolutionUtils.getResolutionFacade(file2);
            this.resolveMap = new LinkedHashMap();
            this.result = this.resolveMap;
        }
    }
}

