/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.compiler.configuration;

import com.intellij.compiler.options.ComparingUtils;
import com.intellij.compiler.server.BuildManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ex.ProjectRootManagerEx;
import com.intellij.openapi.ui.TextComponentAccessor;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.ListCellRendererWrapper;
import com.intellij.ui.RawCommandLineEditor;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.text.VersionComparatorUtil;
import com.intellij.util.ui.ThreeStateCheckBox;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.common.arguments.CommonCompilerArguments;
import org.jetbrains.kotlin.cli.common.arguments.K2JSCompilerArguments;
import org.jetbrains.kotlin.cli.common.arguments.K2JVMCompilerArguments;
import org.jetbrains.kotlin.config.CompilerSettings;
import org.jetbrains.kotlin.config.CoroutineSupport;
import org.jetbrains.kotlin.config.JvmTarget;
import org.jetbrains.kotlin.config.LanguageVersion;
import org.jetbrains.kotlin.config.TargetPlatformKind;
import org.jetbrains.kotlin.idea.KotlinBundle;
import org.jetbrains.kotlin.idea.PluginStartupComponent;
import org.jetbrains.kotlin.idea.compiler.configuration.Kotlin2JsCompilerArgumentsHolder;
import org.jetbrains.kotlin.idea.compiler.configuration.Kotlin2JvmCompilerArgumentsHolder;
import org.jetbrains.kotlin.idea.compiler.configuration.KotlinCommonCompilerArgumentsHolder;
import org.jetbrains.kotlin.idea.compiler.configuration.KotlinCompilerSettings;
import org.jetbrains.kotlin.idea.compiler.configuration.KotlinCompilerWorkspaceSettings;
import org.jetbrains.kotlin.idea.facet.DescriptionListCellRenderer;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;

public class KotlinCompilerConfigurableTab
implements SearchableConfigurable,
Configurable.NoScroll {
    private static final Map<String, String> moduleKindDescriptions = new LinkedHashMap<String, String>();
    private final CommonCompilerArguments commonCompilerArguments;
    private final K2JSCompilerArguments k2jsCompilerArguments;
    private final K2JVMCompilerArguments k2jvmCompilerArguments;
    private final CompilerSettings compilerSettings;
    @Nullable
    private final KotlinCompilerWorkspaceSettings compilerWorkspaceSettings;
    private final Project project;
    private final boolean isProjectSettings;
    private JPanel contentPane;
    private ThreeStateCheckBox generateNoWarningsCheckBox;
    private RawCommandLineEditor additionalArgsOptionsField;
    private JLabel additionalArgsLabel;
    private ThreeStateCheckBox generateSourceMapsCheckBox;
    private TextFieldWithBrowseButton outputPrefixFile;
    private TextFieldWithBrowseButton outputPostfixFile;
    private JLabel labelForOutputPrefixFile;
    private JLabel labelForOutputPostfixFile;
    private JLabel labelForOutputDirectory;
    private JTextField outputDirectory;
    private ThreeStateCheckBox copyRuntimeFilesCheckBox;
    private ThreeStateCheckBox keepAliveCheckBox;
    private JCheckBox enablePreciseIncrementalCheckBox;
    private JComboBox moduleKindComboBox;
    private JTextField scriptTemplatesField;
    private JTextField scriptTemplatesClasspathField;
    private JLabel scriptTemplatesLabel;
    private JLabel scriptTemplatesClasspathLabel;
    private JPanel k2jvmPanel;
    private JPanel k2jsPanel;
    private JComboBox jvmVersionComboBox;
    private JComboBox languageVersionComboBox;
    private JPanel languageVersionPanel;
    private JComboBox coroutineSupportComboBox;
    private JPanel apiVersionPanel;
    private JComboBox apiVersionComboBox;
    private JPanel scriptPanel;

    public KotlinCompilerConfigurableTab(Project project, CommonCompilerArguments commonCompilerArguments, K2JSCompilerArguments k2jsCompilerArguments, CompilerSettings compilerSettings, @Nullable KotlinCompilerWorkspaceSettings compilerWorkspaceSettings, @Nullable K2JVMCompilerArguments k2jvmCompilerArguments, boolean isProjectSettings, boolean isMultiEditor) {
        this.project = project;
        this.commonCompilerArguments = commonCompilerArguments;
        this.k2jsCompilerArguments = k2jsCompilerArguments;
        this.compilerSettings = compilerSettings;
        this.compilerWorkspaceSettings = compilerWorkspaceSettings;
        this.k2jvmCompilerArguments = k2jvmCompilerArguments;
        this.isProjectSettings = isProjectSettings;
        this.$$$setupUI$$$();
        this.languageVersionComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                KotlinCompilerConfigurableTab.this.restrictAPIVersions();
            }
        });
        this.additionalArgsOptionsField.attachLabel(this.additionalArgsLabel);
        KotlinCompilerConfigurableTab.setupFileChooser(this.labelForOutputPrefixFile, this.outputPrefixFile, KotlinBundle.message("kotlin.compiler.js.option.output.prefix.browse.title", new Object[0]));
        KotlinCompilerConfigurableTab.setupFileChooser(this.labelForOutputPostfixFile, this.outputPostfixFile, KotlinBundle.message("kotlin.compiler.js.option.output.postfix.browse.title", new Object[0]));
        this.labelForOutputDirectory.setLabelFor(this.outputDirectory);
        this.copyRuntimeFilesCheckBox.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(@NotNull ChangeEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/kotlin/idea/compiler/configuration/KotlinCompilerConfigurableTab$2", "stateChanged"));
                }
                KotlinCompilerConfigurableTab.this.outputDirectory.setEnabled(KotlinCompilerConfigurableTab.this.copyRuntimeFilesCheckBox.isSelected());
                KotlinCompilerConfigurableTab.this.labelForOutputDirectory.setEnabled(KotlinCompilerConfigurableTab.this.copyRuntimeFilesCheckBox.isSelected());
            }
        });
        this.fillModuleKindList();
        this.fillJvmVersionList();
        this.fillLanguageAndAPIVersionList();
        this.fillCoroutineSupportList();
        if (compilerWorkspaceSettings == null) {
            this.keepAliveCheckBox.setVisible(false);
            this.k2jvmPanel.setVisible(false);
        }
        this.generateNoWarningsCheckBox.setThirdStateEnabled(isMultiEditor);
        this.generateSourceMapsCheckBox.setThirdStateEnabled(isMultiEditor);
        this.copyRuntimeFilesCheckBox.setThirdStateEnabled(isMultiEditor);
        this.keepAliveCheckBox.setThirdStateEnabled(isMultiEditor);
    }

    public KotlinCompilerConfigurableTab(Project project) {
        this(project, (CommonCompilerArguments)KotlinCommonCompilerArgumentsHolder.getInstance(project).getSettings(), (K2JSCompilerArguments)Kotlin2JsCompilerArgumentsHolder.getInstance(project).getSettings(), (CompilerSettings)KotlinCompilerSettings.getInstance(project).getSettings(), (KotlinCompilerWorkspaceSettings)ServiceManager.getService((Project)project, KotlinCompilerWorkspaceSettings.class), (K2JVMCompilerArguments)Kotlin2JvmCompilerArgumentsHolder.getInstance(project).getSettings(), true, false);
    }

    @NotNull
    private static String getModuleKindDescription(@NotNull String moduleKind) {
        if (moduleKind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleKind", "org/jetbrains/kotlin/idea/compiler/configuration/KotlinCompilerConfigurableTab", "getModuleKindDescription"));
        }
        String result2 = moduleKindDescriptions.get(moduleKind);
        assert (result2 != null) : "Module kind " + moduleKind + " was not added to combobox, therefore it should not be here";
        String string = result2;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/compiler/configuration/KotlinCompilerConfigurableTab", "getModuleKindDescription"));
        }
        return string;
    }

    @NotNull
    private static String getModuleKindOrDefault(@Nullable String moduleKindId) {
        if (moduleKindId == null) {
            moduleKindId = "plain";
        }
        String string = moduleKindId;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/compiler/configuration/KotlinCompilerConfigurableTab", "getModuleKindOrDefault"));
        }
        return string;
    }

    private static String getJvmVersionOrDefault(@Nullable String jvmVersion) {
        return jvmVersion != null ? jvmVersion : JvmTarget.DEFAULT.getDescription();
    }

    private static String getLanguageVersionOrDefault(@Nullable String languageVersion) {
        return languageVersion != null ? languageVersion : LanguageVersion.LATEST.getVersionString();
    }

    private static void setupFileChooser(@NotNull JLabel label2, @NotNull TextFieldWithBrowseButton fileChooser, @NotNull String title) {
        if (label2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "label", "org/jetbrains/kotlin/idea/compiler/configuration/KotlinCompilerConfigurableTab", "setupFileChooser"));
        }
        if (fileChooser == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileChooser", "org/jetbrains/kotlin/idea/compiler/configuration/KotlinCompilerConfigurableTab", "setupFileChooser"));
        }
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "org/jetbrains/kotlin/idea/compiler/configuration/KotlinCompilerConfigurableTab", "setupFileChooser"));
        }
        label2.setLabelFor((Component)fileChooser);
        fileChooser.addBrowseFolderListener(title, null, null, new FileChooserDescriptor(true, false, false, false, false, false), TextComponentAccessor.TEXT_FIELD_WHOLE_TEXT, false);
    }

    private static boolean isModified(@NotNull TextFieldWithBrowseButton chooser2, @Nullable String currentValue) {
        if (chooser2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "chooser", "org/jetbrains/kotlin/idea/compiler/configuration/KotlinCompilerConfigurableTab", "isModified"));
        }
        return !StringUtil.equals((CharSequence)StringUtil.nullize((String)chooser2.getText(), (boolean)true), (CharSequence)currentValue);
    }

    private void restrictAPIVersions() {
        String selectedAPIVersion = this.getSelectedAPIVersion();
        final String selectedLanguageVersion = this.getSelectedLanguageVersion();
        List permittedAPIVersions = ArraysKt.mapNotNull((Object[])LanguageVersion.values(), (Function1)new Function1<LanguageVersion, String>(){

            public String invoke(LanguageVersion version) {
                return VersionComparatorUtil.compare((String)version.getVersionString(), (String)selectedLanguageVersion) <= 0 ? version.getVersionString() : null;
            }
        });
        this.apiVersionComboBox.setModel(new DefaultComboBoxModel<Object>(permittedAPIVersions.toArray()));
        this.apiVersionComboBox.setSelectedItem(VersionComparatorUtil.compare((String)selectedAPIVersion, (String)selectedLanguageVersion) <= 0 ? selectedAPIVersion : selectedLanguageVersion);
    }

    private void fillJvmVersionList() {
        for (TargetPlatformKind.Jvm jvm : TargetPlatformKind.Jvm.Companion.getJVM_PLATFORMS()) {
            this.jvmVersionComboBox.addItem(((JvmTarget)jvm.getVersion()).getDescription());
        }
    }

    private void fillLanguageAndAPIVersionList() {
        for (LanguageVersion version : LanguageVersion.values()) {
            this.languageVersionComboBox.addItem(version.getDescription());
            this.apiVersionComboBox.addItem(version.getDescription());
        }
    }

    private void fillCoroutineSupportList() {
        for (CoroutineSupport coroutineSupport : CoroutineSupport.values()) {
            this.coroutineSupportComboBox.addItem(coroutineSupport);
        }
        this.coroutineSupportComboBox.setRenderer(new DescriptionListCellRenderer());
    }

    public void setTargetPlatform(@Nullable TargetPlatformKind<?> targetPlatform) {
        this.k2jsPanel.setVisible(TargetPlatformKind.JavaScript.INSTANCE.equals(targetPlatform));
    }

    private void fillModuleKindList() {
        for (String moduleKind : moduleKindDescriptions.keySet()) {
            this.moduleKindComboBox.addItem(moduleKind);
        }
        this.moduleKindComboBox.setRenderer(new ListCellRendererWrapper<String>(){

            public void customize(JList list2, String value2, int index2, boolean selected, boolean hasFocus) {
                this.setText(KotlinCompilerConfigurableTab.getModuleKindDescription(value2));
            }
        });
    }

    @NotNull
    public String getId() {
        if ("project.kotlinCompiler" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/compiler/configuration/KotlinCompilerConfigurableTab", "getId"));
        }
        return "project.kotlinCompiler";
    }

    @Nullable
    public Runnable enableSearch(String option) {
        return null;
    }

    @Nullable
    public JComponent createComponent() {
        return this.contentPane;
    }

    public boolean isModified() {
        return ComparingUtils.isModified((JCheckBox)this.generateNoWarningsCheckBox, (boolean)this.commonCompilerArguments.suppressWarnings) || !this.getSelectedLanguageVersion().equals(KotlinCompilerConfigurableTab.getLanguageVersionOrDefault(this.commonCompilerArguments.languageVersion)) || !this.getSelectedAPIVersion().equals(KotlinCompilerConfigurableTab.getLanguageVersionOrDefault(this.commonCompilerArguments.apiVersion)) || !this.coroutineSupportComboBox.getSelectedItem().equals(CoroutineSupport.byCompilerArguments(this.commonCompilerArguments)) || ComparingUtils.isModified((RawCommandLineEditor)this.additionalArgsOptionsField, (String)this.compilerSettings.additionalArguments) || ComparingUtils.isModified((JTextField)this.scriptTemplatesField, (String)this.compilerSettings.scriptTemplates) || ComparingUtils.isModified((JTextField)this.scriptTemplatesClasspathField, (String)this.compilerSettings.scriptTemplatesClasspath) || ComparingUtils.isModified((JCheckBox)this.copyRuntimeFilesCheckBox, (boolean)this.compilerSettings.copyJsLibraryFiles) || ComparingUtils.isModified((JTextField)this.outputDirectory, (String)this.compilerSettings.outputDirectoryForJsLibraryFiles) || this.compilerWorkspaceSettings != null && (ComparingUtils.isModified((JCheckBox)this.enablePreciseIncrementalCheckBox, (boolean)this.compilerWorkspaceSettings.getPreciseIncrementalEnabled()) || ComparingUtils.isModified((JCheckBox)this.keepAliveCheckBox, (boolean)this.compilerWorkspaceSettings.getEnableDaemon())) || ComparingUtils.isModified((JCheckBox)this.generateSourceMapsCheckBox, (boolean)this.k2jsCompilerArguments.sourceMap) || KotlinCompilerConfigurableTab.isModified(this.outputPrefixFile, this.k2jsCompilerArguments.outputPrefix) || KotlinCompilerConfigurableTab.isModified(this.outputPostfixFile, this.k2jsCompilerArguments.outputPostfix) || !this.getSelectedModuleKind().equals(KotlinCompilerConfigurableTab.getModuleKindOrDefault(this.k2jsCompilerArguments.moduleKind)) || this.k2jvmCompilerArguments != null && !this.getSelectedJvmVersion().equals(KotlinCompilerConfigurableTab.getJvmVersionOrDefault(this.k2jvmCompilerArguments.jvmTarget));
    }

    @NotNull
    private String getSelectedModuleKind() {
        String string = KotlinCompilerConfigurableTab.getModuleKindOrDefault((String)this.moduleKindComboBox.getSelectedItem());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/compiler/configuration/KotlinCompilerConfigurableTab", "getSelectedModuleKind"));
        }
        return string;
    }

    @NotNull
    private String getSelectedJvmVersion() {
        String string = KotlinCompilerConfigurableTab.getJvmVersionOrDefault((String)this.jvmVersionComboBox.getSelectedItem());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/compiler/configuration/KotlinCompilerConfigurableTab", "getSelectedJvmVersion"));
        }
        return string;
    }

    @NotNull
    private String getSelectedLanguageVersion() {
        String string = KotlinCompilerConfigurableTab.getLanguageVersionOrDefault((String)this.languageVersionComboBox.getSelectedItem());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/compiler/configuration/KotlinCompilerConfigurableTab", "getSelectedLanguageVersion"));
        }
        return string;
    }

    @NotNull
    private String getSelectedAPIVersion() {
        String string = KotlinCompilerConfigurableTab.getLanguageVersionOrDefault((String)this.apiVersionComboBox.getSelectedItem());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/compiler/configuration/KotlinCompilerConfigurableTab", "getSelectedAPIVersion"));
        }
        return string;
    }

    public void apply() throws ConfigurationException {
        if (this.isProjectSettings) {
            boolean shouldInvalidateCaches;
            boolean bl = shouldInvalidateCaches = this.commonCompilerArguments.languageVersion != this.getSelectedLanguageVersion() || this.commonCompilerArguments.apiVersion != this.getSelectedAPIVersion() || !this.coroutineSupportComboBox.getSelectedItem().equals(CoroutineSupport.byCompilerArguments(this.commonCompilerArguments));
            if (shouldInvalidateCaches) {
                ApplicationUtilsKt.runWriteAction(new Function0<Object>(){

                    public Object invoke() {
                        ProjectRootManagerEx.getInstanceEx((Project)KotlinCompilerConfigurableTab.this.project).makeRootsChange(EmptyRunnable.INSTANCE, false, true);
                        return null;
                    }
                });
            }
        }
        this.commonCompilerArguments.suppressWarnings = this.generateNoWarningsCheckBox.isSelected();
        this.commonCompilerArguments.languageVersion = this.getSelectedLanguageVersion();
        this.commonCompilerArguments.apiVersion = this.getSelectedAPIVersion();
        CoroutineSupport coroutineSupport = (CoroutineSupport)this.coroutineSupportComboBox.getSelectedItem();
        this.commonCompilerArguments.coroutinesEnable = coroutineSupport == CoroutineSupport.ENABLED;
        this.commonCompilerArguments.coroutinesWarn = coroutineSupport == CoroutineSupport.ENABLED_WITH_WARNING;
        this.commonCompilerArguments.coroutinesError = coroutineSupport == CoroutineSupport.DISABLED;
        this.compilerSettings.additionalArguments = this.additionalArgsOptionsField.getText();
        this.compilerSettings.scriptTemplates = this.scriptTemplatesField.getText();
        this.compilerSettings.scriptTemplatesClasspath = this.scriptTemplatesClasspathField.getText();
        this.compilerSettings.copyJsLibraryFiles = this.copyRuntimeFilesCheckBox.isSelected();
        this.compilerSettings.outputDirectoryForJsLibraryFiles = this.outputDirectory.getText();
        if (this.compilerWorkspaceSettings != null) {
            this.compilerWorkspaceSettings.setPreciseIncrementalEnabled(this.enablePreciseIncrementalCheckBox.isSelected());
            boolean oldEnableDaemon = this.compilerWorkspaceSettings.getEnableDaemon();
            this.compilerWorkspaceSettings.setEnableDaemon(this.keepAliveCheckBox.isSelected());
            if (this.keepAliveCheckBox.isSelected() != oldEnableDaemon) {
                PluginStartupComponent.getInstance().resetAliveFlag();
            }
        }
        this.k2jsCompilerArguments.sourceMap = this.generateSourceMapsCheckBox.isSelected();
        this.k2jsCompilerArguments.outputPrefix = StringUtil.nullize((String)this.outputPrefixFile.getText(), (boolean)true);
        this.k2jsCompilerArguments.outputPostfix = StringUtil.nullize((String)this.outputPostfixFile.getText(), (boolean)true);
        this.k2jsCompilerArguments.moduleKind = this.getSelectedModuleKind();
        if (this.k2jvmCompilerArguments != null) {
            this.k2jvmCompilerArguments.jvmTarget = this.getSelectedJvmVersion();
        }
        BuildManager.getInstance().clearState(this.project);
    }

    public void reset() {
        this.generateNoWarningsCheckBox.setSelected(this.commonCompilerArguments.suppressWarnings);
        this.languageVersionComboBox.setSelectedItem(KotlinCompilerConfigurableTab.getLanguageVersionOrDefault(this.commonCompilerArguments.languageVersion));
        this.apiVersionComboBox.setSelectedItem(KotlinCompilerConfigurableTab.getLanguageVersionOrDefault(this.commonCompilerArguments.apiVersion));
        this.restrictAPIVersions();
        this.coroutineSupportComboBox.setSelectedItem(CoroutineSupport.byCompilerArguments(this.commonCompilerArguments));
        this.additionalArgsOptionsField.setText(this.compilerSettings.additionalArguments);
        this.scriptTemplatesField.setText(this.compilerSettings.scriptTemplates);
        this.scriptTemplatesClasspathField.setText(this.compilerSettings.scriptTemplatesClasspath);
        this.copyRuntimeFilesCheckBox.setSelected(this.compilerSettings.copyJsLibraryFiles);
        this.outputDirectory.setText(this.compilerSettings.outputDirectoryForJsLibraryFiles);
        if (this.compilerWorkspaceSettings != null) {
            this.enablePreciseIncrementalCheckBox.setSelected(this.compilerWorkspaceSettings.getPreciseIncrementalEnabled());
            this.keepAliveCheckBox.setSelected(this.compilerWorkspaceSettings.getEnableDaemon());
        }
        this.generateSourceMapsCheckBox.setSelected(this.k2jsCompilerArguments.sourceMap);
        this.outputPrefixFile.setText(this.k2jsCompilerArguments.outputPrefix);
        this.outputPostfixFile.setText(this.k2jsCompilerArguments.outputPostfix);
        this.moduleKindComboBox.setSelectedItem(KotlinCompilerConfigurableTab.getModuleKindOrDefault(this.k2jsCompilerArguments.moduleKind));
        if (this.k2jvmCompilerArguments != null) {
            this.jvmVersionComboBox.setSelectedItem(KotlinCompilerConfigurableTab.getJvmVersionOrDefault(this.k2jvmCompilerArguments.jvmTarget));
        }
    }

    public void disposeUIResources() {
    }

    @Nls
    public String getDisplayName() {
        return "Kotlin Compiler";
    }

    @Nullable
    public String getHelpTopic() {
        return "reference.compiler.kotlin";
    }

    public JPanel getContentPane() {
        return this.contentPane;
    }

    public ThreeStateCheckBox getGenerateNoWarningsCheckBox() {
        return this.generateNoWarningsCheckBox;
    }

    public RawCommandLineEditor getAdditionalArgsOptionsField() {
        return this.additionalArgsOptionsField;
    }

    public ThreeStateCheckBox getGenerateSourceMapsCheckBox() {
        return this.generateSourceMapsCheckBox;
    }

    public TextFieldWithBrowseButton getOutputPrefixFile() {
        return this.outputPrefixFile;
    }

    public TextFieldWithBrowseButton getOutputPostfixFile() {
        return this.outputPostfixFile;
    }

    public JTextField getOutputDirectory() {
        return this.outputDirectory;
    }

    public ThreeStateCheckBox getCopyRuntimeFilesCheckBox() {
        return this.copyRuntimeFilesCheckBox;
    }

    public ThreeStateCheckBox getKeepAliveCheckBox() {
        return this.keepAliveCheckBox;
    }

    public JComboBox getModuleKindComboBox() {
        return this.moduleKindComboBox;
    }

    public JTextField getScriptTemplatesField() {
        return this.scriptTemplatesField;
    }

    public JTextField getScriptTemplatesClasspathField() {
        return this.scriptTemplatesClasspathField;
    }

    public JComboBox getLanguageVersionComboBox() {
        return this.languageVersionComboBox;
    }

    public JComboBox getApiVersionComboBox() {
        return this.apiVersionComboBox;
    }

    public JComboBox getCoroutineSupportComboBox() {
        return this.coroutineSupportComboBox;
    }

    static {
        moduleKindDescriptions.put("plain", "Plain (put to global scope)");
        moduleKindDescriptions.put("amd", "AMD");
        moduleKindDescriptions.put("commonjs", "CommonJS");
        moduleKindDescriptions.put("umd", "UMD (detect AMD or CommonJS if available, fallback to plain)");
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JTextField jTextField;
        JLabel jLabel;
        JTextField jTextField2;
        JLabel jLabel2;
        JPanel jPanel;
        JComboBox jComboBox;
        ThreeStateCheckBox threeStateCheckBox;
        JTextField jTextField3;
        JLabel jLabel3;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JLabel jLabel4;
        TextFieldWithBrowseButton textFieldWithBrowseButton2;
        JLabel jLabel5;
        ThreeStateCheckBox threeStateCheckBox2;
        JPanel jPanel2;
        JComboBox jComboBox2;
        JCheckBox jCheckBox;
        JPanel jPanel3;
        JLabel jLabel6;
        JComboBox jComboBox3;
        JPanel jPanel4;
        JComboBox jComboBox4;
        JComboBox jComboBox5;
        JPanel jPanel5;
        ThreeStateCheckBox threeStateCheckBox3;
        RawCommandLineEditor rawCommandLineEditor;
        ThreeStateCheckBox threeStateCheckBox4;
        JPanel jPanel6;
        this.contentPane = jPanel6 = new JPanel();
        jPanel6.setLayout(new GridLayoutManager(5, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel6.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4), null, 0, 0, null, null));
        Spacer spacer = new Spacer();
        jPanel6.add((Component)spacer, new GridConstraints(4, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout(new GridLayoutManager(6, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel6.add((Component)jPanel7, new GridConstraints(0, 0, 1, 1, 1, 1, 3, 3, null, null, null));
        this.generateNoWarningsCheckBox = threeStateCheckBox4 = new ThreeStateCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)threeStateCheckBox4, ResourceBundle.getBundle("org/jetbrains/kotlin/idea/KotlinBundle").getString("kotlin.compiler.option.generate.no.warnings"));
        threeStateCheckBox4.setSelected(false);
        threeStateCheckBox4.setState(ThreeStateCheckBox.State.NOT_SELECTED);
        jPanel7.add((Component)threeStateCheckBox4, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, new Dimension(209, 24), null));
        this.additionalArgsOptionsField = rawCommandLineEditor = new RawCommandLineEditor();
        rawCommandLineEditor.setDialogCaption(ResourceBundle.getBundle("org/jetbrains/kotlin/idea/KotlinBundle").getString("kotlin.compiler.option.additional.command.line.parameters.dialog.title"));
        jPanel7.add((Component)rawCommandLineEditor, new GridConstraints(4, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.keepAliveCheckBox = threeStateCheckBox3 = new ThreeStateCheckBox();
        threeStateCheckBox3.setText("Keep compiler process alive between invocations");
        threeStateCheckBox3.setState(ThreeStateCheckBox.State.NOT_SELECTED);
        jPanel7.add((Component)threeStateCheckBox3, new GridConstraints(5, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        this.languageVersionPanel = jPanel5 = new JPanel();
        jPanel5.setLayout(new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel7.add((Component)jPanel5, new GridConstraints(1, 0, 1, 2, 0, 3, 3, 3, null, null, null, 0, true));
        JLabel jLabel7 = new JLabel();
        jLabel7.setText("Language version");
        jLabel7.setDisplayedMnemonic('L');
        jLabel7.setDisplayedMnemonicIndex(0);
        jPanel5.add((Component)jLabel7, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, new Dimension(227, 16), null));
        this.languageVersionComboBox = jComboBox5 = new JComboBox();
        jPanel5.add(jComboBox5, new GridConstraints(0, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout(new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel7.add((Component)jPanel8, new GridConstraints(3, 0, 1, 2, 0, 3, 3, 3, null, null, null, 0, true));
        JLabel jLabel8 = new JLabel();
        jLabel8.setText("Coroutines (experimental)");
        jLabel8.setDisplayedMnemonic('U');
        jLabel8.setDisplayedMnemonicIndex(4);
        jPanel8.add((Component)jLabel8, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, new Dimension(221, 16), null));
        this.coroutineSupportComboBox = jComboBox4 = new JComboBox();
        jPanel8.add(jComboBox4, new GridConstraints(0, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        this.apiVersionPanel = jPanel4 = new JPanel();
        jPanel4.setLayout(new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel7.add((Component)jPanel4, new GridConstraints(2, 0, 1, 2, 0, 3, 3, 3, null, null, null, 0, true));
        JLabel jLabel9 = new JLabel();
        jLabel9.setText("API version");
        jLabel9.setDisplayedMnemonic('I');
        jLabel9.setDisplayedMnemonicIndex(2);
        jPanel4.add((Component)jLabel9, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, new Dimension(201, 16), null));
        this.apiVersionComboBox = jComboBox3 = new JComboBox();
        jPanel4.add(jComboBox3, new GridConstraints(0, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        this.additionalArgsLabel = jLabel6 = new JLabel();
        this.$$$loadLabelText$$$(jLabel6, ResourceBundle.getBundle("org/jetbrains/kotlin/idea/KotlinBundle").getString("kotlin.compiler.option.additional.command.line.parameters"));
        jPanel7.add((Component)jLabel6, new GridConstraints(4, 0, 1, 1, 8, 0, 0, 0, null, new Dimension(209, 16), null));
        this.k2jvmPanel = jPanel3 = new JPanel();
        jPanel3.setLayout(new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        ((Component)jPanel3).setVisible(true);
        jPanel3.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithoutIndent");
        jPanel6.add((Component)jPanel3, new GridConstraints(1, 0, 1, 1, 1, 1, 3, 3, null, null, null));
        jPanel3.setBorder(IdeBorderFactory.PlainSmallWithoutIndent.createTitledBorder((Border)BorderFactory.createEtchedBorder(), (String)ResourceBundle.getBundle("org/jetbrains/kotlin/idea/KotlinBundle").getString("kotlin.compiler.jvm.option.panel.title"), (int)0, (int)0, null, null));
        JLabel jLabel10 = new JLabel();
        jLabel10.setText("Target JVM version");
        jLabel10.setDisplayedMnemonic('J');
        jLabel10.setDisplayedMnemonicIndex(7);
        jPanel3.add((Component)jLabel10, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, new Dimension(201, 16), null));
        this.enablePreciseIncrementalCheckBox = jCheckBox = new JCheckBox();
        jCheckBox.setText("Enable precise incremental compilation");
        jPanel3.add((Component)jCheckBox, new GridConstraints(0, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        this.jvmVersionComboBox = jComboBox2 = new JComboBox();
        jPanel3.add(jComboBox2, new GridConstraints(1, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        this.k2jsPanel = jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayoutManager(6, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        ((Component)jPanel2).setVisible(true);
        jPanel2.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithoutIndent");
        jPanel6.add((Component)jPanel2, new GridConstraints(2, 0, 1, 1, 1, 1, 3, 3, null, null, null));
        jPanel2.setBorder(IdeBorderFactory.PlainSmallWithoutIndent.createTitledBorder((Border)BorderFactory.createEtchedBorder(), (String)ResourceBundle.getBundle("org/jetbrains/kotlin/idea/KotlinBundle").getString("kotlin.compiler.js.option.panel.title"), (int)0, (int)0, null, null));
        this.generateSourceMapsCheckBox = threeStateCheckBox2 = new ThreeStateCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)threeStateCheckBox2, ResourceBundle.getBundle("org/jetbrains/kotlin/idea/KotlinBundle").getString("kotlin.compiler.js.option.generate.sourcemaps"));
        threeStateCheckBox2.setState(ThreeStateCheckBox.State.NOT_SELECTED);
        jPanel2.add((Component)threeStateCheckBox2, new GridConstraints(0, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        this.labelForOutputPrefixFile = jLabel5 = new JLabel();
        this.$$$loadLabelText$$$(jLabel5, ResourceBundle.getBundle("org/jetbrains/kotlin/idea/KotlinBundle").getString("kotlin.compiler.js.option.output.prefix"));
        jPanel2.add((Component)jLabel5, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, new Dimension(256, 18), null));
        this.outputPrefixFile = textFieldWithBrowseButton2 = new TextFieldWithBrowseButton();
        jPanel2.add((Component)textFieldWithBrowseButton2, new GridConstraints(1, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        this.labelForOutputPostfixFile = jLabel4 = new JLabel();
        this.$$$loadLabelText$$$(jLabel4, ResourceBundle.getBundle("org/jetbrains/kotlin/idea/KotlinBundle").getString("kotlin.compiler.js.option.output.postfix"));
        jPanel2.add((Component)jLabel4, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, new Dimension(256, 18), null));
        this.outputPostfixFile = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel2.add((Component)textFieldWithBrowseButton, new GridConstraints(2, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        this.labelForOutputDirectory = jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, ResourceBundle.getBundle("org/jetbrains/kotlin/idea/KotlinBundle").getString("kotlin.compiler.js.option.output.copy.dir"));
        jPanel2.add((Component)jLabel3, new GridConstraints(4, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.outputDirectory = jTextField3 = new JTextField();
        jTextField3.setText("lib");
        jPanel2.add((Component)jTextField3, new GridConstraints(4, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.copyRuntimeFilesCheckBox = threeStateCheckBox = new ThreeStateCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)threeStateCheckBox, ResourceBundle.getBundle("org/jetbrains/kotlin/idea/KotlinBundle").getString("kotlin.compiler.js.option.output.copy.files"));
        threeStateCheckBox.setState(ThreeStateCheckBox.State.NOT_SELECTED);
        jPanel2.add((Component)threeStateCheckBox, new GridConstraints(3, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        JLabel jLabel11 = new JLabel();
        jLabel11.setText("Module kind:");
        jLabel11.setDisplayedMnemonic('K');
        jLabel11.setDisplayedMnemonicIndex(7);
        jPanel2.add((Component)jLabel11, new GridConstraints(5, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.moduleKindComboBox = jComboBox = new JComboBox();
        DefaultComboBoxModel defaultComboBoxModel = new DefaultComboBoxModel();
        jComboBox.setModel(defaultComboBoxModel);
        jPanel2.add(jComboBox, new GridConstraints(5, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        this.scriptPanel = jPanel = new JPanel();
        jPanel.setLayout(new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        ((Component)jPanel).setVisible(true);
        jPanel.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithoutIndent");
        jPanel6.add((Component)jPanel, new GridConstraints(3, 0, 1, 1, 1, 1, 3, 3, null, null, null));
        jPanel.setBorder(IdeBorderFactory.PlainSmallWithoutIndent.createTitledBorder((Border)BorderFactory.createEtchedBorder(), (String)"Kotlin Scripting", (int)0, (int)0, null, null));
        this.scriptTemplatesLabel = jLabel2 = new JLabel();
        jLabel2.setText("Script template classes:");
        jLabel2.setDisplayedMnemonic('T');
        jLabel2.setDisplayedMnemonicIndex(7);
        jPanel.add((Component)jLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, new Dimension(209, 16), null, 1));
        this.scriptTemplatesField = jTextField2 = new JTextField();
        jPanel.add((Component)jTextField2, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.scriptTemplatesClasspathLabel = jLabel = new JLabel();
        jLabel.setText("Script templates classpath:");
        jLabel.setDisplayedMnemonic('P');
        jLabel.setDisplayedMnemonicIndex(22);
        jPanel.add((Component)jLabel, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, new Dimension(209, 16), null, 1));
        this.scriptTemplatesClasspathField = jTextField = new JTextField();
        jPanel.add((Component)jTextField, new GridConstraints(1, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        jLabel11.setLabelFor(jComboBox);
        jLabel2.setLabelFor(jTextField2);
        jLabel.setLabelFor(jTextField);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.contentPane;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

