/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.completion.handlers;

import com.intellij.codeInsight.AutoPopupController;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.completion.CompletionUtilsKt;
import org.jetbrains.kotlin.idea.completion.handlers.HandlerUtilsKt;
import org.jetbrains.kotlin.idea.completion.smart.SmartCompletion;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u0000 \u001b2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u001bB'\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\b\b\u0002\u0010\b\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\tJ\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0002H\u0016J\u0016\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0002J\u0018\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002R\u0011\u0010\b\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000bR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/idea/completion/handlers/WithTailInsertHandler;", "Lcom/intellij/codeInsight/completion/InsertHandler;", "Lcom/intellij/codeInsight/lookup/LookupElement;", "tailText", "", "spaceBefore", "", "spaceAfter", "overwriteText", "(Ljava/lang/String;ZZZ)V", "getOverwriteText", "()Z", "getSpaceAfter", "getSpaceBefore", "getTailText", "()Ljava/lang/String;", "handleInsert", "", "context", "Lcom/intellij/codeInsight/completion/InsertionContext;", "item", "postHandleInsert", "shouldOverwriteChar", "document", "Lcom/intellij/openapi/editor/Document;", "offset", "", "Companion", "idea-completion"})
public final class WithTailInsertHandler
implements InsertHandler<LookupElement> {
    @NotNull
    private final String tailText;
    private final boolean spaceBefore;
    private final boolean spaceAfter;
    private final boolean overwriteText;
    @NotNull
    private static final WithTailInsertHandler COMMA;
    @NotNull
    private static final WithTailInsertHandler RPARENTH;
    @NotNull
    private static final WithTailInsertHandler RBRACKET;
    @NotNull
    private static final WithTailInsertHandler RBRACE;
    @NotNull
    private static final WithTailInsertHandler ELSE;
    @NotNull
    private static final WithTailInsertHandler EQ;
    @NotNull
    private static final WithTailInsertHandler SPACE;
    public static final Companion Companion;

    public void handleInsert(@NotNull InsertionContext context, @NotNull LookupElement item) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)item, (String)"item");
        item.handleInsert(context);
        this.postHandleInsert(context, item);
    }

    public final void postHandleInsert(@NotNull InsertionContext context, @NotNull LookupElement item) {
        Object tailOffset;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)item, (String)"item");
        char completionChar = context.getCompletionChar();
        if (Intrinsics.areEqual((Object)Character.valueOf(completionChar), (Object)StringsKt.singleOrNull((CharSequence)this.tailText)) || this.spaceAfter && completionChar == ' ') {
            context.setAddCompletionChar(false);
        }
        Document document = context.getDocument();
        PsiDocumentManager.getInstance((Project)context.getProject()).doPostponedOperationsAndUnblockDocument(document);
        Ref.IntRef intRef = new Ref.IntRef();
        intRef.element = context.getTailOffset();
        if (completionChar == '\t' && item.getUserData(CompletionUtilsKt.getKEEP_OLD_ARGUMENT_LIST_ON_TAB_KEY()) != null) {
            Integer n = CompletionUtilsKt.tryGetOffset(context.getOffsetMap(), SmartCompletion.Companion.getOLD_ARGUMENTS_REPLACEMENT_OFFSET());
            if (n != null) {
                int it;
                Integer n2 = n;
                tailOffset.element = it = ((Number)n2).intValue();
            }
        }
        boolean moveCaret = context.getEditor().getCaretModel().getOffset() == tailOffset.element;
        boolean insert = true;
        if (this.overwriteText) {
            int offset2 = tailOffset.element;
            if (Intrinsics.areEqual((Object)this.tailText, (Object)" ") ^ true) {
                offset2 = HandlerUtilsKt.skipSpacesAndLineBreaks(document.getCharsSequence(), offset2);
            }
            Document document2 = document;
            Intrinsics.checkExpressionValueIsNotNull((Object)document2, (String)"document");
            if (this.shouldOverwriteChar(document2, offset2)) {
                insert = false;
                tailOffset.element = offset2 += this.tailText.length();
                if (this.spaceAfter && HandlerUtilsKt.isCharAt(document.getCharsSequence(), offset2, ' ')) {
                    document.deleteString(offset2, offset2 + 1);
                }
            }
        }
        String textToInsert = "";
        if (insert) {
            textToInsert = this.tailText;
            if (this.spaceBefore) {
                textToInsert = " " + textToInsert;
            }
        }
        if (this.spaceAfter) {
            textToInsert = textToInsert + " ";
        }
        document.insertString(tailOffset.element, (CharSequence)textToInsert);
        if (moveCaret) {
            context.getEditor().getCaretModel().moveToOffset(tailOffset.element + textToInsert.length());
            if (Intrinsics.areEqual((Object)this.tailText, (Object)",")) {
                AutoPopupController autoPopupController = AutoPopupController.getInstance((Project)context.getProject());
                if (autoPopupController != null) {
                    autoPopupController.autoPopupParameterInfo(context.getEditor(), null);
                }
            }
        }
        tailOffset = null;
    }

    private final boolean shouldOverwriteChar(Document document, int offset2) {
        if (!HandlerUtilsKt.isTextAt(document, offset2, this.tailText)) {
            return false;
        }
        return !Intrinsics.areEqual((Object)this.tailText, (Object)" ") || !HandlerUtilsKt.isCharAt(document.getCharsSequence(), offset2 + 1, '}');
    }

    @NotNull
    public final String getTailText() {
        return this.tailText;
    }

    public final boolean getSpaceBefore() {
        return this.spaceBefore;
    }

    public final boolean getSpaceAfter() {
        return this.spaceAfter;
    }

    public final boolean getOverwriteText() {
        return this.overwriteText;
    }

    public WithTailInsertHandler(@NotNull String tailText, boolean spaceBefore, boolean spaceAfter, boolean overwriteText) {
        Intrinsics.checkParameterIsNotNull((Object)tailText, (String)"tailText");
        this.tailText = tailText;
        this.spaceBefore = spaceBefore;
        this.spaceAfter = spaceAfter;
        this.overwriteText = overwriteText;
    }

    public /* synthetic */ WithTailInsertHandler(String string, boolean bl, boolean bl2, boolean bl3, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            bl3 = true;
        }
        this(string, bl, bl2, bl3);
    }

    static {
        Companion = new Companion(null);
        COMMA = new WithTailInsertHandler(",", false, true, false, 8, null);
        RPARENTH = new WithTailInsertHandler(")", false, false, false, 8, null);
        RBRACKET = new WithTailInsertHandler("]", false, false, false, 8, null);
        RBRACE = new WithTailInsertHandler("}", true, false, false, 8, null);
        ELSE = new WithTailInsertHandler("else", true, true, false, 8, null);
        EQ = new WithTailInsertHandler("=", true, true, false, 8, null);
        SPACE = new WithTailInsertHandler(" ", false, false, true);
    }

    @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000f\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0011\u0010\t\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006R\u0011\u0010\u000b\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0006R\u0011\u0010\r\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u0006R\u0011\u0010\u000f\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0006R\u0011\u0010\u0011\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0006\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/idea/completion/handlers/WithTailInsertHandler$Companion;", "", "()V", "COMMA", "Lorg/jetbrains/kotlin/idea/completion/handlers/WithTailInsertHandler;", "getCOMMA", "()Lorg/jetbrains/kotlin/idea/completion/handlers/WithTailInsertHandler;", "ELSE", "getELSE", "EQ", "getEQ", "RBRACE", "getRBRACE", "RBRACKET", "getRBRACKET", "RPARENTH", "getRPARENTH", "SPACE", "getSPACE", "idea-completion"})
    public static final class Companion {
        @NotNull
        public final WithTailInsertHandler getCOMMA() {
            return COMMA;
        }

        @NotNull
        public final WithTailInsertHandler getRPARENTH() {
            return RPARENTH;
        }

        @NotNull
        public final WithTailInsertHandler getRBRACKET() {
            return RBRACKET;
        }

        @NotNull
        public final WithTailInsertHandler getRBRACE() {
            return RBRACE;
        }

        @NotNull
        public final WithTailInsertHandler getELSE() {
            return ELSE;
        }

        @NotNull
        public final WithTailInsertHandler getEQ() {
            return EQ;
        }

        @NotNull
        public final WithTailInsertHandler getSPACE() {
            return SPACE;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

