/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.configuration;

import com.intellij.codeInsight.CodeInsightUtilCore;
import com.intellij.ide.actions.OpenFileAction;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.ExternalLibraryDescriptor;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.WritingAccessProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmSuppressWildcards;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.KotlinPluginUtil;
import org.jetbrains.kotlin.idea.configuration.ConfigureKotlinInProjectUtilsKt;
import org.jetbrains.kotlin.idea.configuration.ConfigureKotlinStatus;
import org.jetbrains.kotlin.idea.configuration.KotlinProjectConfigurator;
import org.jetbrains.kotlin.idea.configuration.KotlinWithGradleConfigurator;
import org.jetbrains.kotlin.idea.configuration.KotlinWithGradleConfigurator$Companion$WhenMappings;
import org.jetbrains.kotlin.idea.configuration.NotificationMessageCollector;
import org.jetbrains.kotlin.idea.configuration.NotificationMessageCollectorKt;
import org.jetbrains.kotlin.idea.framework.ui.ConfigureDialogWithModulesAndVersion;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;
import org.jetbrains.kotlin.idea.versions.KotlinRuntimeLibraryUtilKt;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrApplicationStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrMethodCallExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.util.GrStatementOwner;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b&\u0018\u0000 #2\u00020\u0001:\u0001#B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\u0004H\u0014J\u0018\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\u0004H\u0004J&\u0010\u000f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u0011J\u001e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017H\u0017J\u0012\u0010\u0019\u001a\u00020\u00042\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0014J\u0012\u0010\u001c\u001a\u00020\u00042\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0016J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u0018H\u0016J\u0010\u0010 \u001a\u00020\b2\u0006\u0010\u001f\u001a\u00020\u0018H\u0014J\u0010\u0010!\u001a\u00020\b2\u0006\u0010\"\u001a\u00020\nH\u0002R\u0012\u0010\u0003\u001a\u00020\u0004X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006$"}, d2={"Lorg/jetbrains/kotlin/idea/configuration/KotlinWithGradleConfigurator;", "Lorg/jetbrains/kotlin/idea/configuration/KotlinProjectConfigurator;", "()V", "applyPluginDirective", "", "getApplyPluginDirective", "()Ljava/lang/String;", "addElementsToFile", "", "groovyFile", "Lorg/jetbrains/plugins/groovy/lang/psi/GroovyFile;", "isTopLevelProjectFile", "version", "addElementsToModuleFile", "file", "changeGradleFile", "collector", "Lorg/jetbrains/kotlin/idea/configuration/NotificationMessageCollector;", "configure", "", "project", "Lcom/intellij/openapi/project/Project;", "excludeModules", "", "Lcom/intellij/openapi/module/Module;", "getDependencyDirective", "sdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "getRuntimeLibrary", "getStatus", "Lorg/jetbrains/kotlin/idea/configuration/ConfigureKotlinStatus;", "module", "isApplicable", "isFileConfigured", "projectGradleFile", "Companion", "idea"})
public abstract class KotlinWithGradleConfigurator
implements KotlinProjectConfigurator {
    private static final String VERSION_TEMPLATE = "$VERSION$";
    @NotNull
    private static final String GROUP_ID = "org.jetbrains.kotlin";
    @NotNull
    private static final String GRADLE_PLUGIN_ID = "kotlin-gradle-plugin";
    @NotNull
    private static final String CLASSPATH = "classpath \"org.jetbrains.kotlin:kotlin-gradle-plugin:$kotlin_version\"";
    @NotNull
    private static final String SNAPSHOT_REPOSITORY_SNIPPET;
    @NotNull
    private static final String EAP_REPOSITORY_SNIPPET;
    @NotNull
    private static final String EAP_11_REPOSITORY_SNIPPET;
    private static final String MAVEN_CENTRAL = "mavenCentral()\n";
    private static final String JCENTER = "jcenter()\n";
    private static final String VERSION;
    public static final Companion Companion;

    @Override
    @NotNull
    public ConfigureKotlinStatus getStatus(@NotNull Module module) {
        Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
        if (!this.isApplicable(module)) {
            return ConfigureKotlinStatus.NON_APPLICABLE;
        }
        if (ConfigureKotlinInProjectUtilsKt.hasAnyKotlinRuntimeInScope(module)) {
            return ConfigureKotlinStatus.CONFIGURED;
        }
        Project project = module.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"module.project");
        GroovyFile moduleGradleFile = KotlinWithGradleConfigurator.Companion.getBuildGradleFile(project, KotlinWithGradleConfigurator.Companion.getModuleFilePath(module));
        if (moduleGradleFile != null && !this.isFileConfigured(moduleGradleFile)) {
            return ConfigureKotlinStatus.CAN_BE_CONFIGURED;
        }
        Project project2 = module.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"module.project");
        Project project3 = module.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project3, (String)"module.project");
        GroovyFile projectGradleFile = KotlinWithGradleConfigurator.Companion.getBuildGradleFile(project2, KotlinWithGradleConfigurator.Companion.getTopLevelProjectFilePath(project3));
        if (projectGradleFile != null && !this.isFileConfigured(projectGradleFile)) {
            return ConfigureKotlinStatus.CAN_BE_CONFIGURED;
        }
        return ConfigureKotlinStatus.BROKEN;
    }

    protected boolean isApplicable(@NotNull Module module) {
        Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
        return KotlinPluginUtil.isGradleModule(module) && !KotlinPluginUtil.isAndroidGradleModule(module);
    }

    private final boolean isFileConfigured(GroovyFile projectGradleFile) {
        String fileText;
        String string = fileText = projectGradleFile.getText();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"fileText");
        return KotlinWithGradleConfigurator.Companion.containsDirective(string, this.getApplyPluginDirective()) && StringsKt.contains$default((CharSequence)fileText, (CharSequence)GROUP_ID, (boolean)false, (int)2, null) && StringsKt.contains$default((CharSequence)fileText, (CharSequence)"kotlin-stdlib", (boolean)false, (int)2, null);
    }

    @Override
    @JvmSuppressWildcards
    public void configure(@NotNull Project project, @NotNull Collection<Module> excludeModules) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull(excludeModules, (String)"excludeModules");
        ConfigureDialogWithModulesAndVersion dialog2 = new ConfigureDialogWithModulesAndVersion(project, this, excludeModules);
        dialog2.show();
        if (!dialog2.isOK()) {
            return;
        }
        ApplicationUtilsKt.executeCommand$default(project, "Configure Kotlin", null, (Function0)new Function0<Unit>(this, project, dialog2){
            final /* synthetic */ KotlinWithGradleConfigurator this$0;
            final /* synthetic */ Project $project;
            final /* synthetic */ ConfigureDialogWithModulesAndVersion $dialog;

            public final void invoke() {
                NotificationMessageCollector collector2 = NotificationMessageCollectorKt.createConfigureKotlinNotificationCollector(this.$project);
                HashSet<GroovyFile> changedFiles = new HashSet<GroovyFile>();
                GroovyFile projectGradleFile = org.jetbrains.kotlin.idea.configuration.KotlinWithGradleConfigurator$Companion.access$getBuildGradleFile(KotlinWithGradleConfigurator.Companion, this.$project, org.jetbrains.kotlin.idea.configuration.KotlinWithGradleConfigurator$Companion.access$getTopLevelProjectFilePath(KotlinWithGradleConfigurator.Companion, this.$project));
                if (projectGradleFile != null && org.jetbrains.kotlin.idea.configuration.KotlinWithGradleConfigurator$Companion.access$canConfigureFile(KotlinWithGradleConfigurator.Companion, projectGradleFile)) {
                    String string = this.$dialog.getKotlinVersion();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"dialog.kotlinVersion");
                    boolean isModified2 = this.this$0.changeGradleFile(projectGradleFile, true, string, collector2);
                    if (isModified2) {
                        changedFiles.add(projectGradleFile);
                    }
                }
                Iterator<Object> iterator2 = this.$dialog.getModulesToConfigure().iterator();
                while (iterator2.hasNext()) {
                    Module module;
                    Module module2 = module = iterator2.next();
                    Intrinsics.checkExpressionValueIsNotNull((Object)module2, (String)"module");
                    GroovyFile file2 = org.jetbrains.kotlin.idea.configuration.KotlinWithGradleConfigurator$Companion.access$getBuildGradleFile(KotlinWithGradleConfigurator.Companion, this.$project, org.jetbrains.kotlin.idea.configuration.KotlinWithGradleConfigurator$Companion.access$getModuleFilePath(KotlinWithGradleConfigurator.Companion, module2));
                    if (file2 != null && org.jetbrains.kotlin.idea.configuration.KotlinWithGradleConfigurator$Companion.access$canConfigureFile(KotlinWithGradleConfigurator.Companion, file2)) {
                        String string = this.$dialog.getKotlinVersion();
                        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"dialog.kotlinVersion");
                        boolean isModified3 = this.this$0.changeGradleFile(file2, false, string, collector2);
                        if (!isModified3) continue;
                        changedFiles.add(file2);
                        continue;
                    }
                    org.jetbrains.kotlin.idea.configuration.KotlinWithGradleConfigurator$Companion.access$showErrorMessage(KotlinWithGradleConfigurator.Companion, this.$project, "Cannot find build.gradle file for module " + module.getName());
                }
                for (GroovyFile file3 : changedFiles) {
                    OpenFileAction.openFile((VirtualFile)file3.getVirtualFile(), (Project)this.$project);
                }
                collector2.showNotification();
            }
            {
                this.this$0 = kotlinWithGradleConfigurator;
                this.$project = project;
                this.$dialog = configureDialogWithModulesAndVersion;
                super(0);
            }
        }, 2, null);
    }

    protected final boolean addElementsToModuleFile(@NotNull GroovyFile file2, @NotNull String version) {
        Sdk sdk;
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)version, (String)"version");
        boolean wasModified = false;
        String string = file2.getText();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"file.text");
        if (!KotlinWithGradleConfigurator.Companion.containsDirective(string, this.getApplyPluginDirective())) {
            GrExpression apply2 = GroovyPsiElementFactory.getInstance((Project)file2.getProject()).createExpressionFromText((CharSequence)this.getApplyPluginDirective());
            GrApplicationStatement applyStatement = KotlinWithGradleConfigurator.Companion.getApplyStatement(file2);
            if (applyStatement != null) {
                file2.addAfter((PsiElement)apply2, (PsiElement)applyStatement);
                wasModified = true;
            } else {
                GrClosableBlock buildScript = KotlinWithGradleConfigurator.Companion.getBlockByName((PsiElement)file2, "buildscript");
                if (buildScript != null) {
                    file2.addAfter((PsiElement)apply2, buildScript.getParent());
                    wasModified = true;
                } else {
                    GrStatement grStatement = (GrStatement)ArraysKt.lastOrNull((Object[])file2.getStatements());
                    file2.addAfter((PsiElement)apply2, grStatement != null ? (PsiElement)grStatement : file2.getFirstChild());
                    wasModified = true;
                }
            }
        }
        GrClosableBlock repositoriesBlock = KotlinWithGradleConfigurator.Companion.getRepositoriesBlock((GrStatementOwner)file2);
        wasModified |= KotlinWithGradleConfigurator.Companion.addRepository(repositoriesBlock, version);
        GrClosableBlock dependenciesBlock = KotlinWithGradleConfigurator.Companion.getDependenciesBlock((GrStatementOwner)file2);
        Module module = ModuleUtil.findModuleForPsiElement((PsiElement)((PsiElement)file2));
        if (module != null) {
            Module module2;
            Module it = module2 = module;
            sdk = ModuleRootManager.getInstance((Module)it).getSdk();
        } else {
            sdk = null;
        }
        Sdk sdk2 = sdk;
        return wasModified |= KotlinWithGradleConfigurator.Companion.addExpressionInBlockIfNeeded(this.getDependencyDirective(sdk2), dependenciesBlock, false);
    }

    @NotNull
    protected String getDependencyDirective(@Nullable Sdk sdk) {
        return this.getRuntimeLibrary(sdk);
    }

    @NotNull
    protected abstract String getApplyPluginDirective();

    protected boolean addElementsToFile(@NotNull GroovyFile groovyFile, boolean isTopLevelProjectFile, @NotNull String version) {
        Intrinsics.checkParameterIsNotNull((Object)groovyFile, (String)"groovyFile");
        Intrinsics.checkParameterIsNotNull((Object)version, (String)"version");
        if (!isTopLevelProjectFile) {
            boolean wasModified = Companion.addElementsToProjectFile(groovyFile, version);
            return wasModified |= this.addElementsToModuleFile(groovyFile, version);
        }
        return false;
    }

    public final boolean changeGradleFile(@NotNull GroovyFile groovyFile, boolean isTopLevelProjectFile, @NotNull String version, @NotNull NotificationMessageCollector collector2) {
        Intrinsics.checkParameterIsNotNull((Object)groovyFile, (String)"groovyFile");
        Intrinsics.checkParameterIsNotNull((Object)version, (String)"version");
        Intrinsics.checkParameterIsNotNull((Object)collector2, (String)"collector");
        boolean isModified2 = (Boolean)ApplicationUtilsKt.executeWriteCommand(groovyFile.getProject(), "Configure build.gradle", null, (Function0)new Function0<Boolean>(this, groovyFile, isTopLevelProjectFile, version){
            final /* synthetic */ KotlinWithGradleConfigurator this$0;
            final /* synthetic */ GroovyFile $groovyFile;
            final /* synthetic */ boolean $isTopLevelProjectFile;
            final /* synthetic */ String $version;

            /*
             * WARNING - void declaration
             */
            public final boolean invoke() {
                void var1_1;
                boolean isModified2 = this.this$0.addElementsToFile(this.$groovyFile, this.$isTopLevelProjectFile, this.$version);
                CodeInsightUtilCore.forcePsiPostprocessAndRestoreElement((PsiElement)((PsiElement)this.$groovyFile));
                return (boolean)var1_1;
            }
            {
                this.this$0 = kotlinWithGradleConfigurator;
                this.$groovyFile = groovyFile;
                this.$isTopLevelProjectFile = bl;
                this.$version = string;
                super(0);
            }
        });
        VirtualFile virtualFile2 = groovyFile.getVirtualFile();
        if (virtualFile2 != null && isModified2) {
            collector2.addMessage(virtualFile2.getPath() + " was modified");
        }
        return isModified2;
    }

    @NotNull
    public String getRuntimeLibrary(@Nullable Sdk sdk) {
        return Companion.getRuntimeLibraryForSdk(sdk);
    }

    static {
        Companion = new Companion(null);
        VERSION_TEMPLATE = VERSION_TEMPLATE;
        GROUP_ID = GROUP_ID;
        GRADLE_PLUGIN_ID = GRADLE_PLUGIN_ID;
        CLASSPATH = "classpath " + "\"" + Companion.getGROUP_ID() + ":" + Companion.getGRADLE_PLUGIN_ID() + ":" + "$" + "kotlin_version" + "\"";
        SNAPSHOT_REPOSITORY_SNIPPET = "maven {\nurl '" + ConfigureKotlinInProjectUtilsKt.SNAPSHOT_REPOSITORY.getUrl() + "'\n}";
        EAP_REPOSITORY_SNIPPET = "maven {\nurl '" + ConfigureKotlinInProjectUtilsKt.EAP_REPOSITORY.getUrl() + "'\n}";
        EAP_11_REPOSITORY_SNIPPET = "maven {\nurl '" + ConfigureKotlinInProjectUtilsKt.EAP_11_REPOSITORY.getUrl() + "'\n}";
        MAVEN_CENTRAL = MAVEN_CENTRAL;
        JCENTER = JCENTER;
        StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
        String string = "ext.kotlin_version = '%s'";
        Object[] objectArray = new Object[]{KotlinWithGradleConfigurator.Companion.getVERSION_TEMPLATE()};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"java.lang.String.format(format, *args)");
        VERSION = string2;
    }

    @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0015\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0004J \u0010\u001e\u001a\u00020\u001a2\u0006\u0010\u001f\u001a\u00020\u00042\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u001aH\u0002J\u0018\u0010#\u001a\u00020\u001a2\u0006\u0010\u001f\u001a\u00020\u00042\u0006\u0010 \u001a\u00020!H\u0002J\u001e\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+J\u0016\u0010,\u001a\u00020\u001a2\u0006\u0010\u001f\u001a\u00020\u00042\u0006\u0010 \u001a\u00020!J,\u0010-\u001a\u00020%2\u0006\u0010 \u001a\u00020!2\u0006\u0010.\u001a\u00020\u00042\u0012\u0010/\u001a\u000e\u0012\u0004\u0012\u000201\u0012\u0004\u0012\u00020\u001a00H\u0002J\u0018\u00102\u001a\u00020\u001a2\u0006\u00103\u001a\u00020!2\u0006\u0010\u001d\u001a\u00020\u0004H\u0002J\u0010\u00104\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J \u00105\u001a\u0004\u0018\u0001062\u0006\u00107\u001a\u00020\u001c2\u0006\u00108\u001a\u00020\u00042\u0006\u00109\u001a\u00020\u001aJ(\u0010:\u001a\u0004\u0018\u0001062\u0006\u0010&\u001a\u00020'2\u0014\u0010;\u001a\u0010\u0012\u0004\u0012\u00020\u001c\u0012\u0006\u0012\u0004\u0018\u00010600H\u0002J\u0018\u0010<\u001a\u0004\u0018\u0001062\u0006\u0010&\u001a\u00020'2\u0006\u0010=\u001a\u00020\u0004J\u0018\u0010<\u001a\u0004\u0018\u0001062\u0006\u00107\u001a\u00020\u001c2\u0006\u0010=\u001a\u00020\u0004J.\u0010>\u001a\u0004\u0018\u0001062\u0006\u0010&\u001a\u00020'2\b\u0010?\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u00108\u001a\u0004\u0018\u00010\u00042\u0006\u00109\u001a\u00020\u001aJ \u0010>\u001a\u0004\u0018\u0001062\u0006\u00107\u001a\u00020\u001c2\u0006\u0010?\u001a\u00020\u00042\u0006\u00109\u001a\u00020\u001aJ*\u0010@\u001a\u0004\u0018\u0001062\u0006\u00107\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u00042\u0006\u00109\u001a\u00020\u001a2\u0006\u0010A\u001a\u00020\u0004H\u0002J\u0018\u0010B\u001a\u00020\u001a2\u0006\u0010C\u001a\u00020\u00042\u0006\u0010D\u001a\u00020\u0004H\u0002J\u0012\u0010E\u001a\u0004\u0018\u00010F2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u001a\u0010G\u001a\u0004\u0018\u00010!2\u0006\u0010H\u001a\u0002062\u0006\u0010I\u001a\u00020\u0004H\u0002J\u0016\u0010J\u001a\u00020!2\u0006\u0010H\u001a\u00020K2\u0006\u0010I\u001a\u00020\u0004J\u001c\u0010L\u001a\u0004\u0018\u00010\u001c2\u0006\u0010M\u001a\u00020N2\b\u0010O\u001a\u0004\u0018\u00010\u0004H\u0002J\u0010\u0010P\u001a\u00020!2\u0006\u0010\u001b\u001a\u00020KH\u0002J\u0010\u0010Q\u001a\u00020!2\u0006\u0010\u001b\u001a\u00020KH\u0002J\u0010\u0010R\u001a\u00020!2\u0006\u0010\u001b\u001a\u00020KH\u0002J\u0010\u0010S\u001a\u00020!2\u0006\u0010\u001b\u001a\u00020KH\u0002J\u000e\u0010T\u001a\u00020\u00042\u0006\u0010U\u001a\u00020\u0004J\u0010\u0010V\u001a\u0004\u0018\u00010\u00042\u0006\u0010&\u001a\u00020'J\u0012\u0010W\u001a\u0004\u0018\u00010\u00042\u0006\u0010&\u001a\u00020'H\u0002J\u0010\u0010X\u001a\u00020!2\u0006\u0010\u001b\u001a\u00020KH\u0002J\u0010\u0010Y\u001a\u00020\u00042\b\u0010Z\u001a\u0004\u0018\u00010[J\u0010\u0010\\\u001a\u00020\u00042\u0006\u0010M\u001a\u00020NH\u0002J\u0010\u0010]\u001a\u00020\u001a2\u0006\u00103\u001a\u00020!H\u0002J\u001a\u0010^\u001a\u00020%2\u0006\u0010M\u001a\u00020N2\b\u0010_\u001a\u0004\u0018\u00010\u0004H\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0011\u0010\t\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006R\u0014\u0010\u000b\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0006R\u0014\u0010\r\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u0006R\u0014\u0010\u000f\u001a\u00020\u0004X\u0082D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0006R\u0014\u0010\u0011\u001a\u00020\u0004X\u0082D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0006R\u0011\u0010\u0013\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0006R\u0014\u0010\u0015\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0006R\u0014\u0010\u0017\u001a\u00020\u0004X\u0082D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0006\u00a8\u0006`"}, d2={"Lorg/jetbrains/kotlin/idea/configuration/KotlinWithGradleConfigurator$Companion;", "", "()V", "CLASSPATH", "", "getCLASSPATH", "()Ljava/lang/String;", "EAP_11_REPOSITORY_SNIPPET", "getEAP_11_REPOSITORY_SNIPPET", "EAP_REPOSITORY_SNIPPET", "getEAP_REPOSITORY_SNIPPET", "GRADLE_PLUGIN_ID", "getGRADLE_PLUGIN_ID", "GROUP_ID", "getGROUP_ID", "JCENTER", "getJCENTER", "MAVEN_CENTRAL", "getMAVEN_CENTRAL", "SNAPSHOT_REPOSITORY_SNIPPET", "getSNAPSHOT_REPOSITORY_SNIPPET", "VERSION", "getVERSION", "VERSION_TEMPLATE", "getVERSION_TEMPLATE", "addElementsToProjectFile", "", "file", "Lorg/jetbrains/plugins/groovy/lang/psi/GroovyFile;", "version", "addExpressionInBlockIfNeeded", "text", "block", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/blocks/GrClosableBlock;", "isFirst", "addFirstExpressionInBlockIfNeeded", "addKotlinLibraryToModule", "", "module", "Lcom/intellij/openapi/module/Module;", "scope", "Lcom/intellij/openapi/roots/DependencyScope;", "libraryDescriptor", "Lcom/intellij/openapi/roots/ExternalLibraryDescriptor;", "addLastExpressionInBlockIfNeeded", "addOrReplaceExpression", "snippet", "predicate", "Lkotlin/Function1;", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/GrStatement;", "addRepository", "repositoriesBlock", "canConfigureFile", "changeApiVersion", "Lcom/intellij/psi/PsiElement;", "gradleFile", "apiVersion", "forTests", "changeBuildGradle", "body", "changeCoroutineConfiguration", "coroutineOption", "changeLanguageVersion", "languageVersion", "changeVersion", "versionParameter", "containsDirective", "fileText", "directive", "getApplyStatement", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/expressions/GrApplicationStatement;", "getBlockByName", "parent", "name", "getBlockOrCreate", "Lorg/jetbrains/plugins/groovy/lang/psi/api/util/GrStatementOwner;", "getBuildGradleFile", "project", "Lcom/intellij/openapi/project/Project;", "path", "getBuildScriptBlock", "getBuildScriptDependenciesBlock", "getBuildScriptRepositoriesBlock", "getDependenciesBlock", "getDependencySnippet", "artifactId", "getKotlinStdlibVersion", "getModuleFilePath", "getRepositoriesBlock", "getRuntimeLibraryForSdk", "sdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "getTopLevelProjectFilePath", "isRepositoryConfigured", "showErrorMessage", "message", "idea"})
    public static final class Companion {
        private final String getVERSION_TEMPLATE() {
            return VERSION_TEMPLATE;
        }

        @NotNull
        public final String getGROUP_ID() {
            return GROUP_ID;
        }

        @NotNull
        public final String getGRADLE_PLUGIN_ID() {
            return GRADLE_PLUGIN_ID;
        }

        @NotNull
        public final String getCLASSPATH() {
            return CLASSPATH;
        }

        @NotNull
        public final String getSNAPSHOT_REPOSITORY_SNIPPET() {
            return SNAPSHOT_REPOSITORY_SNIPPET;
        }

        @NotNull
        public final String getEAP_REPOSITORY_SNIPPET() {
            return EAP_REPOSITORY_SNIPPET;
        }

        @NotNull
        public final String getEAP_11_REPOSITORY_SNIPPET() {
            return EAP_11_REPOSITORY_SNIPPET;
        }

        private final String getMAVEN_CENTRAL() {
            return MAVEN_CENTRAL;
        }

        private final String getJCENTER() {
            return JCENTER;
        }

        private final String getVERSION() {
            return VERSION;
        }

        private final boolean containsDirective(String fileText, String directive) {
            return StringsKt.contains$default((CharSequence)fileText, (CharSequence)directive, (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)fileText, (CharSequence)StringsKt.replace$default((String)directive, (String)"\"", (String)"'", (boolean)false, (int)4, null), (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)fileText, (CharSequence)StringsKt.replace$default((String)directive, (String)"'", (String)"\"", (boolean)false, (int)4, null), (boolean)false, (int)2, null);
        }

        public final void addKotlinLibraryToModule(@NotNull Module module, @NotNull DependencyScope scope2, @NotNull ExternalLibraryDescriptor libraryDescriptor) {
            Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
            Intrinsics.checkParameterIsNotNull((Object)scope2, (String)"scope");
            Intrinsics.checkParameterIsNotNull((Object)libraryDescriptor, (String)"libraryDescriptor");
            String gradleFilePath = this.getModuleFilePath(module);
            Project project = module.getProject();
            Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"module.project");
            GroovyFile gradleFile = this.getBuildGradleFile(project, gradleFilePath);
            if (gradleFile != null && this.canConfigureFile(gradleFile)) {
                ApplicationUtilsKt.executeWriteCommand(gradleFile.getProject(), "Add Kotlin library", (Function0<Unit>)((Function0)new Function0<Unit>(scope2, module, libraryDescriptor, gradleFile){
                    final /* synthetic */ DependencyScope $scope;
                    final /* synthetic */ Module $module;
                    final /* synthetic */ ExternalLibraryDescriptor $libraryDescriptor;
                    final /* synthetic */ GroovyFile $gradleFile;

                    public final void invoke() {
                        String string;
                        switch (KotlinWithGradleConfigurator$Companion$WhenMappings.$EnumSwitchMapping$0[this.$scope.ordinal()]) {
                            case 1: {
                                string = "compile";
                                break;
                            }
                            case 2: {
                                if (KotlinPluginUtil.isAndroidGradleModule(this.$module)) {
                                    string = "compile";
                                    break;
                                }
                                string = "testCompile";
                                break;
                            }
                            case 3: {
                                string = "runtime";
                                break;
                            }
                            case 4: {
                                string = "compile";
                                break;
                            }
                            default: {
                                string = "compile";
                            }
                        }
                        String groovyScope = string;
                        StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
                        String string2 = "%s \"%s:%s:%s\"";
                        Object[] objectArray = new Object[]{groovyScope, this.$libraryDescriptor.getLibraryGroupId(), this.$libraryDescriptor.getLibraryArtifactId(), this.$libraryDescriptor.getMaxVersion()};
                        String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
                        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"java.lang.String.format(format, *args)");
                        String dependencyString = string3;
                        GrClosableBlock dependenciesBlock = org.jetbrains.kotlin.idea.configuration.KotlinWithGradleConfigurator$Companion.access$getDependenciesBlock(KotlinWithGradleConfigurator.Companion, (GrStatementOwner)this.$gradleFile);
                        KotlinWithGradleConfigurator.Companion.addLastExpressionInBlockIfNeeded(dependencyString, dependenciesBlock);
                        CodeInsightUtilCore.forcePsiPostprocessAndRestoreElement((PsiElement)((PsiElement)this.$gradleFile));
                    }
                    {
                        this.$scope = dependencyScope;
                        this.$module = module;
                        this.$libraryDescriptor = externalLibraryDescriptor;
                        this.$gradleFile = groovyFile;
                        super(0);
                    }
                }));
                VirtualFile virtualFile2 = gradleFile.getVirtualFile();
                if (virtualFile2 != null) {
                    Project project2 = gradleFile.getProject();
                    Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"gradleFile.project");
                    NotificationMessageCollectorKt.createConfigureKotlinNotificationCollector(project2).addMessage(virtualFile2.getPath() + " was modified").showNotification();
                }
            }
        }

        @Nullable
        public final PsiElement changeCoroutineConfiguration(@NotNull Module module, @NotNull String coroutineOption) {
            Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
            Intrinsics.checkParameterIsNotNull((Object)coroutineOption, (String)"coroutineOption");
            return this.changeBuildGradle(module, (Function1<? super GroovyFile, ? extends PsiElement>)((Function1)new Function1<GroovyFile, PsiElement>(coroutineOption){
                final /* synthetic */ String $coroutineOption;

                @Nullable
                public final PsiElement invoke(@NotNull GroovyFile gradleFile) {
                    Intrinsics.checkParameterIsNotNull((Object)gradleFile, (String)"gradleFile");
                    return KotlinWithGradleConfigurator.Companion.changeCoroutineConfiguration(gradleFile, this.$coroutineOption);
                }
                {
                    this.$coroutineOption = string;
                    super(1);
                }
            }));
        }

        @Nullable
        public final PsiElement changeCoroutineConfiguration(@NotNull GroovyFile gradleFile, @NotNull String coroutineOption) {
            Intrinsics.checkParameterIsNotNull((Object)gradleFile, (String)"gradleFile");
            Intrinsics.checkParameterIsNotNull((Object)coroutineOption, (String)"coroutineOption");
            String snippet = "coroutines " + "\"" + coroutineOption + "\"";
            GrClosableBlock kotlinBlock = this.getBlockOrCreate((GrStatementOwner)gradleFile, "kotlin");
            GrClosableBlock experimentalBlock = this.getBlockOrCreate((GrStatementOwner)kotlinBlock, "experimental");
            this.addOrReplaceExpression(experimentalBlock, snippet, (Function1<? super GrStatement, Boolean>)((Function1)changeCoroutineConfiguration.2.INSTANCE));
            return kotlinBlock.getParent();
        }

        @Nullable
        public final PsiElement changeLanguageVersion(@NotNull Module module, @Nullable String languageVersion, @Nullable String apiVersion, boolean forTests) {
            Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
            return this.changeBuildGradle(module, (Function1<? super GroovyFile, ? extends PsiElement>)((Function1)new Function1<GroovyFile, PsiElement>(languageVersion, forTests, apiVersion){
                final /* synthetic */ String $languageVersion;
                final /* synthetic */ boolean $forTests;
                final /* synthetic */ String $apiVersion;

                /*
                 * WARNING - void declaration
                 */
                @Nullable
                public final PsiElement invoke(@NotNull GroovyFile gradleFile) {
                    void var2_2;
                    Intrinsics.checkParameterIsNotNull((Object)gradleFile, (String)"gradleFile");
                    PsiElement result2 = null;
                    if (this.$languageVersion != null) {
                        result2 = KotlinWithGradleConfigurator.Companion.changeLanguageVersion(gradleFile, this.$languageVersion, this.$forTests);
                    }
                    if (this.$apiVersion != null) {
                        result2 = KotlinWithGradleConfigurator.Companion.changeApiVersion(gradleFile, this.$apiVersion, this.$forTests);
                    }
                    return var2_2;
                }
                {
                    this.$languageVersion = string;
                    this.$forTests = bl;
                    this.$apiVersion = string2;
                    super(1);
                }
            }));
        }

        @Nullable
        public static /* bridge */ /* synthetic */ PsiElement changeLanguageVersion$default(Companion companion, Module module, String string, String string2, boolean bl, int n, Object object) {
            if ((n & 4) != 0) {
                string2 = null;
            }
            return companion.changeLanguageVersion(module, string, string2, bl);
        }

        @Nullable
        public final PsiElement changeLanguageVersion(@NotNull GroovyFile gradleFile, @NotNull String languageVersion, boolean forTests) {
            Intrinsics.checkParameterIsNotNull((Object)gradleFile, (String)"gradleFile");
            Intrinsics.checkParameterIsNotNull((Object)languageVersion, (String)"languageVersion");
            return this.changeVersion(gradleFile, languageVersion, forTests, "languageVersion");
        }

        @Nullable
        public final PsiElement changeApiVersion(@NotNull GroovyFile gradleFile, @NotNull String apiVersion, boolean forTests) {
            Intrinsics.checkParameterIsNotNull((Object)gradleFile, (String)"gradleFile");
            Intrinsics.checkParameterIsNotNull((Object)apiVersion, (String)"apiVersion");
            return this.changeVersion(gradleFile, apiVersion, forTests, "apiVersion");
        }

        private final PsiElement changeVersion(GroovyFile gradleFile, String version, boolean forTests, String versionParameter) {
            String snippet = versionParameter + " = " + "\"" + version + "\"";
            GrClosableBlock kotlinBlock = this.getBlockOrCreate((GrStatementOwner)gradleFile, forTests ? "compileTestKotlin" : "compileKotlin");
            GrClosableBlock experimentalBlock = this.getBlockOrCreate((GrStatementOwner)kotlinBlock, "kotlinOptions");
            this.addOrReplaceExpression(experimentalBlock, snippet, (Function1<? super GrStatement, Boolean>)((Function1)new Function1<GrStatement, Boolean>(versionParameter){
                final /* synthetic */ String $versionParameter;

                public final boolean invoke(@NotNull GrStatement stmt) {
                    GrAssignmentExpression grAssignmentExpression;
                    Intrinsics.checkParameterIsNotNull((Object)stmt, (String)"stmt");
                    GrStatement grStatement = stmt;
                    if (!(grStatement instanceof GrAssignmentExpression)) {
                        grStatement = null;
                    }
                    return Intrinsics.areEqual((Object)((grAssignmentExpression = (GrAssignmentExpression)grStatement) != null && (grAssignmentExpression = grAssignmentExpression.getLValue()) != null ? grAssignmentExpression.getText() : null), (Object)this.$versionParameter);
                }
                {
                    this.$versionParameter = string;
                    super(1);
                }
            }));
            return kotlinBlock.getParent();
        }

        private final PsiElement changeBuildGradle(Module module, Function1<? super GroovyFile, ? extends PsiElement> body2) {
            String gradleFilePath = this.getModuleFilePath(module);
            Project project = module.getProject();
            Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"module.project");
            GroovyFile gradleFile = this.getBuildGradleFile(project, gradleFilePath);
            if (gradleFile != null && this.canConfigureFile(gradleFile)) {
                return (PsiElement)ApplicationUtilsKt.executeWriteCommand(gradleFile.getProject(), "Change build.gradle configuration", null, (Function0)new Function0<PsiElement>(body2, gradleFile){
                    final /* synthetic */ Function1 $body;
                    final /* synthetic */ GroovyFile $gradleFile;

                    @Nullable
                    public final PsiElement invoke() {
                        return (PsiElement)this.$body.invoke((Object)this.$gradleFile);
                    }
                    {
                        this.$body = function1;
                        this.$gradleFile = groovyFile;
                        super(0);
                    }
                });
            }
            return null;
        }

        private final void addOrReplaceExpression(GrClosableBlock block, String snippet, Function1<? super GrStatement, Boolean> predicate) {
            Object object;
            block2: {
                Object[] $receiver$iv = block.getStatements();
                for (int i = 0; i < $receiver$iv.length; ++i) {
                    Object element$iv = $receiver$iv[i];
                    if (!((Boolean)predicate.invoke(element$iv)).booleanValue()) continue;
                    object = element$iv;
                    break block2;
                }
                object = null;
            }
            GrStatement grStatement = (GrStatement)object;
            if (grStatement != null) {
                GrStatement grStatement2;
                GrStatement stmt = grStatement2 = grStatement;
                GrExpression newStatement = GroovyPsiElementFactory.getInstance((Project)block.getProject()).createExpressionFromText((CharSequence)snippet);
                CodeStyleManager.getInstance((Project)block.getProject()).reformat((PsiElement)newStatement);
                stmt.replaceWithStatement((GrStatement)newStatement);
                return;
            }
            this.addLastExpressionInBlockIfNeeded(snippet, block);
        }

        @Nullable
        public final String getKotlinStdlibVersion(@NotNull Module module) {
            Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
            String gradleFilePath = this.getModuleFilePath(module);
            Project project = module.getProject();
            Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"module.project");
            GroovyFile groovyFile = this.getBuildGradleFile(project, gradleFilePath);
            if (groovyFile == null) {
                return null;
            }
            GroovyFile gradleFile = groovyFile;
            String versionProperty = "$kotlin_version";
            GrClosableBlock block = this.getBuildScriptBlock((GrStatementOwner)gradleFile);
            if (StringsKt.contains$default((CharSequence)block.getText(), (CharSequence)"ext.kotlin_version = ", (boolean)false, (int)2, null)) {
                return versionProperty;
            }
            GrStatement[] dependencies2 = this.getDependenciesBlock((GrStatementOwner)gradleFile).getStatements();
            String stdlibArtifactPrefix = "org.jetbrains.kotlin:kotlin-stdlib:";
            for (int i = 0; i < dependencies2.length; ++i) {
                String string;
                GrStatement dependency = dependencies2[i];
                String dependencyText = dependency.getText();
                int startIndex = StringsKt.indexOf$default((CharSequence)dependencyText, (String)stdlibArtifactPrefix, (int)0, (boolean)false, (int)6, null) + stdlibArtifactPrefix.length();
                int endIndex = dependencyText.length() - 1;
                if (startIndex == -1 || endIndex == -1) continue;
                String string2 = string = dependencyText;
                if (string2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                String string3 = string2.substring(startIndex, endIndex);
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                return string3;
            }
            return null;
        }

        public final boolean addElementsToProjectFile(@NotNull GroovyFile file2, @NotNull String version) {
            Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
            Intrinsics.checkParameterIsNotNull((Object)version, (String)"version");
            GrClosableBlock buildScriptBlock = this.getBuildScriptBlock((GrStatementOwner)file2);
            boolean wasModified = this.addFirstExpressionInBlockIfNeeded(StringsKt.replace$default((String)this.getVERSION(), (String)this.getVERSION_TEMPLATE(), (String)version, (boolean)false, (int)4, null), buildScriptBlock);
            GrClosableBlock buildScriptRepositoriesBlock = this.getBuildScriptRepositoriesBlock((GrStatementOwner)file2);
            wasModified |= this.addRepository(buildScriptRepositoriesBlock, version);
            GrClosableBlock buildScriptDependenciesBlock = this.getBuildScriptDependenciesBlock((GrStatementOwner)file2);
            return wasModified |= this.addLastExpressionInBlockIfNeeded(this.getCLASSPATH(), buildScriptDependenciesBlock);
        }

        private final boolean isRepositoryConfigured(GrClosableBlock repositoriesBlock) {
            return StringsKt.contains$default((CharSequence)repositoriesBlock.getText(), (CharSequence)this.getMAVEN_CENTRAL(), (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)repositoriesBlock.getText(), (CharSequence)this.getJCENTER(), (boolean)false, (int)2, null);
        }

        private final boolean canConfigureFile(GroovyFile file2) {
            return WritingAccessProvider.isPotentiallyWritable((VirtualFile)file2.getVirtualFile(), null);
        }

        private final GroovyFile getBuildGradleFile(Project project, String path) {
            if (path == null) {
                return null;
            }
            VirtualFile virtualFile2 = VfsUtil.findFileByIoFile((File)new File(path), (boolean)true);
            if (virtualFile2 == null) {
                return null;
            }
            VirtualFile file2 = virtualFile2;
            PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file2);
            if (!(psiFile instanceof GroovyFile)) {
                psiFile = null;
            }
            GroovyFile groovyFile = (GroovyFile)psiFile;
            if (groovyFile == null) {
                return null;
            }
            GroovyFile psiFile2 = groovyFile;
            return psiFile2;
        }

        private final String getTopLevelProjectFilePath(Project project) {
            return project.getBasePath() + "/" + "build.gradle";
        }

        private final String getModuleFilePath(Module module) {
            String moduleDir = new File(module.getModuleFilePath()).getParent();
            File buildGradleFile = new File(moduleDir + "/" + "build.gradle");
            if (buildGradleFile.exists()) {
                return buildGradleFile.getPath();
            }
            VirtualFile[] virtualFileArray = ModuleRootManager.getInstance((Module)module).getContentRoots();
            for (int i = 0; i < virtualFileArray.length; ++i) {
                VirtualFile file2 = virtualFileArray[i];
                buildGradleFile = new File(file2.getPath() + "/" + "build.gradle");
                if (!buildGradleFile.exists()) continue;
                return buildGradleFile.getPath();
            }
            String externalProjectPath = ExternalSystemApiUtil.getExternalProjectPath((Module)module);
            if (externalProjectPath != null && (buildGradleFile = new File(externalProjectPath + "/" + "build.gradle")).exists()) {
                return buildGradleFile.getPath();
            }
            return null;
        }

        private final GrClosableBlock getDependenciesBlock(GrStatementOwner file2) {
            return this.getBlockOrCreate(file2, "dependencies");
        }

        private final GrClosableBlock getBuildScriptBlock(GrStatementOwner file2) {
            return this.getBlockOrCreate(file2, "buildscript");
        }

        private final GrClosableBlock getBuildScriptDependenciesBlock(GrStatementOwner file2) {
            GrClosableBlock buildScript = this.getBuildScriptBlock(file2);
            return this.getBlockOrCreate((GrStatementOwner)buildScript, "dependencies");
        }

        private final GrClosableBlock getBuildScriptRepositoriesBlock(GrStatementOwner file2) {
            GrClosableBlock buildScript = this.getBuildScriptBlock(file2);
            return this.getBlockOrCreate((GrStatementOwner)buildScript, "repositories");
        }

        private final GrClosableBlock getRepositoriesBlock(GrStatementOwner file2) {
            return this.getBlockOrCreate(file2, "repositories");
        }

        @NotNull
        public final GrClosableBlock getBlockOrCreate(@NotNull GrStatementOwner parent2, @NotNull String name2) {
            Intrinsics.checkParameterIsNotNull((Object)parent2, (String)"parent");
            Intrinsics.checkParameterIsNotNull((Object)name2, (String)"name");
            GrClosableBlock block = this.getBlockByName((PsiElement)parent2, name2);
            if (block == null) {
                GroovyPsiElementFactory factory2 = GroovyPsiElementFactory.getInstance((Project)parent2.getProject());
                GrExpression newBlock = factory2.createExpressionFromText((CharSequence)(name2 + "{" + "\n" + "}" + "\n"));
                GrStatement grStatement = (GrStatement)ArraysKt.lastOrNull((Object[])parent2.getStatements());
                parent2.addAfter((PsiElement)newBlock, grStatement != null ? (PsiElement)grStatement : parent2.getFirstChild());
                GrClosableBlock grClosableBlock = this.getBlockByName((PsiElement)parent2, name2);
                if (grClosableBlock == null) {
                    Intrinsics.throwNpe();
                }
                block = grClosableBlock;
            }
            return block;
        }

        public final boolean addLastExpressionInBlockIfNeeded(@NotNull String text2, @NotNull GrClosableBlock block) {
            Intrinsics.checkParameterIsNotNull((Object)text2, (String)"text");
            Intrinsics.checkParameterIsNotNull((Object)block, (String)"block");
            return this.addExpressionInBlockIfNeeded(text2, block, false);
        }

        private final boolean addFirstExpressionInBlockIfNeeded(String text2, GrClosableBlock block) {
            return this.addExpressionInBlockIfNeeded(text2, block, true);
        }

        private final GrClosableBlock getBlockByName(PsiElement parent2, String name2) {
            GrClosableBlock grClosableBlock;
            Object v1;
            Iterable iterable;
            block5: {
                Iterable $receiver$iv$iv;
                Object[] elements$iv$iv;
                Object[] $receiver$iv = parent2;
                PsiElement[] psiElementArray = PsiTreeUtil.getChildrenOfType((PsiElement)$receiver$iv, GrMethodCallExpression.class);
                if (psiElementArray == null) {
                    elements$iv$iv = new GrMethodCallExpression[]{};
                    psiElementArray = (PsiElement[])elements$iv$iv;
                }
                $receiver$iv = psiElementArray;
                elements$iv$iv = $receiver$iv;
                Collection destination$iv$iv = new ArrayList();
                for (int i = 0; i < ((void)$receiver$iv$iv).length; ++i) {
                    void element$iv$iv = $receiver$iv$iv[i];
                    GrMethodCallExpression it = (GrMethodCallExpression)element$iv$iv;
                    Object[] objectArray = it.getClosureArguments();
                    Object[] objectArray2 = objectArray;
                    if (!(!(objectArray2.length == 0))) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $receiver$iv$iv = iterable = (Iterable)((List)destination$iv$iv);
                for (Object e : $receiver$iv$iv) {
                    GrMethodCallExpression it = (GrMethodCallExpression)e;
                    if (!Intrinsics.areEqual((Object)it.getInvokedExpression().getText(), (Object)name2)) continue;
                    v1 = e;
                    break block5;
                }
                v1 = null;
            }
            GrMethodCallExpression grMethodCallExpression = v1;
            if (grMethodCallExpression != null) {
                iterable = grMethodCallExpression;
                GrMethodCallExpression it = (GrMethodCallExpression)iterable;
                grClosableBlock = it.getClosureArguments()[0];
            } else {
                grClosableBlock = null;
            }
            return grClosableBlock;
        }

        private final boolean addExpressionInBlockIfNeeded(String text2, GrClosableBlock block, boolean isFirst) {
            Object[] objectArray;
            Object[] objectArray2;
            if (StringsKt.contains$default((CharSequence)block.getText(), (CharSequence)text2, (boolean)false, (int)2, null)) {
                return false;
            }
            GrExpression newStatement = GroovyPsiElementFactory.getInstance((Project)block.getProject()).createExpressionFromText((CharSequence)text2);
            CodeStyleManager.getInstance((Project)block.getProject()).reformat((PsiElement)newStatement);
            GrStatement[] statements = block.getStatements();
            if (!isFirst && !((objectArray2 = (objectArray = (Object[])statements)).length == 0)) {
                GrStatement lastStatement = statements[((Object[])statements).length - 1];
                if (lastStatement != null) {
                    block.addAfter((PsiElement)newStatement, (PsiElement)lastStatement);
                }
            } else {
                PsiElement firstChild = block.getFirstChild();
                if (firstChild != null) {
                    block.addAfter((PsiElement)newStatement, firstChild);
                }
            }
            return true;
        }

        private final GrApplicationStatement getApplyStatement(GroovyFile file2) {
            Object object;
            block2: {
                Object[] objectArray;
                PsiElement $receiver$iv = (PsiElement)file2;
                PsiElement[] psiElementArray = PsiTreeUtil.getChildrenOfType((PsiElement)$receiver$iv, GrApplicationStatement.class);
                if (psiElementArray == null) {
                    GrApplicationStatement[] elements$iv$iv = new GrApplicationStatement[]{};
                    psiElementArray = (PsiElement[])elements$iv$iv;
                }
                Object[] objectArray2 = objectArray = (Object[])psiElementArray;
                for (int i = 0; i < objectArray2.length; ++i) {
                    Object object2 = objectArray2[i];
                    GrApplicationStatement it = (GrApplicationStatement)object2;
                    if (!Intrinsics.areEqual((Object)it.getInvokedExpression().getText(), (Object)"apply")) continue;
                    object = object2;
                    break block2;
                }
                object = null;
            }
            return (GrApplicationStatement)object;
        }

        private final void showErrorMessage(Project project, String message2) {
            Messages.showErrorDialog((Project)project, (String)("<html>Couldn't configure kotlin-gradle plugin automatically.<br/>" + (message2 != null ? message2 + "<br/>" : "") + "<br/>See manual installation instructions <a href=\"https://kotlinlang.org/docs/reference/using-gradle.html\">here</a>.</html>"), (String)"Configure Kotlin-Gradle Plugin");
        }

        private final boolean addRepository(GrClosableBlock repositoriesBlock, String version) {
            String string;
            if (ConfigureKotlinInProjectUtilsKt.isSnapshot(version)) {
                string = this.getSNAPSHOT_REPOSITORY_SNIPPET();
            } else if (ConfigureKotlinInProjectUtilsKt.useEap11Repository(version)) {
                string = this.getEAP_11_REPOSITORY_SNIPPET();
            } else if (ConfigureKotlinInProjectUtilsKt.isEap(version)) {
                string = this.getEAP_REPOSITORY_SNIPPET();
            } else if (!this.isRepositoryConfigured(repositoriesBlock)) {
                string = this.getMAVEN_CENTRAL();
            } else {
                return false;
            }
            String snippet = string;
            return this.addLastExpressionInBlockIfNeeded(snippet, repositoriesBlock);
        }

        @NotNull
        public final String getRuntimeLibraryForSdk(@Nullable Sdk sdk) {
            return this.getDependencySnippet(KotlinRuntimeLibraryUtilKt.getStdlibArtifactId(sdk));
        }

        @NotNull
        public final String getDependencySnippet(@NotNull String artifactId) {
            Intrinsics.checkParameterIsNotNull((Object)artifactId, (String)"artifactId");
            return "compile " + "\"" + "org.jetbrains.kotlin:" + artifactId + ":" + "$" + "kotlin_version" + "\"";
        }

        private Companion() {
        }

        public static final /* synthetic */ boolean access$canConfigureFile(Companion $this, @NotNull GroovyFile file2) {
            return $this.canConfigureFile(file2);
        }

        public static final /* synthetic */ void access$showErrorMessage(Companion $this, @NotNull Project project, @Nullable String message2) {
            $this.showErrorMessage(project, message2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

