/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger;

import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.jdi.VirtualMachineProxy;
import com.intellij.debugger.jdi.VirtualMachineProxyImpl;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.compiler.CompilerPaths;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.ReferenceType;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.codegen.inline.FileMapping;
import org.jetbrains.kotlin.codegen.inline.RangeMapping;
import org.jetbrains.kotlin.codegen.inline.SMAP;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.debugger.BytecodeDebugInfo;
import org.jetbrains.kotlin.idea.debugger.BytecodeMethodKey;
import org.jetbrains.kotlin.idea.debugger.DebuggerUtils;
import org.jetbrains.kotlin.idea.debugger.NoStrataPositionManagerHelperKt;
import org.jetbrains.kotlin.idea.debugger.NoStrataPositionManagerHelperKt$isInCrossinlineArgument$argumentFunctions$1$$special$;
import org.jetbrains.kotlin.idea.debugger.SmapData;
import org.jetbrains.kotlin.idea.debugger.SmapUtilKt;
import org.jetbrains.kotlin.idea.debugger.SourceLineKind;
import org.jetbrains.kotlin.idea.debugger.evaluate.KotlinDebuggerCaches;
import org.jetbrains.kotlin.idea.refactoring.KotlinRefactoringUtilKt;
import org.jetbrains.kotlin.idea.util.ProjectRootsUtil;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.load.kotlin.JvmVirtualFileFinder;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.FqNamesUtilKt;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.inline.InlineUtil;
import org.jetbrains.kotlin.resolve.jvm.JvmClassName;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.utils.addToStdlib.AddToStdlibKt;
import org.jetbrains.org.objectweb.asm.ClassReader;
import org.jetbrains.org.objectweb.asm.ClassVisitor;
import org.jetbrains.org.objectweb.asm.Label;
import org.jetbrains.org.objectweb.asm.MethodVisitor;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=2, d1={"\u0000\u0090\u0001\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a>\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00010\u0011H\u0002\u001a\"\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u0012H\u0002\u001a'\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u001c\u001a&\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u000fH\u0000\u001a&\u0010$\u001a\u0010\u0012\u0004\u0012\u00020&\u0012\u0004\u0012\u00020\u0019\u0018\u00010%2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\f\u001a\u00020\rH\u0000\u001a>\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00190\u001e2\u0006\u0010(\u001a\u00020\u00192\u0006\u0010)\u001a\u00020\u000b2\u0006\u0010*\u001a\u00020\t2\u0006\u0010+\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010#\u001a\u00020\u000fH\u0002\u001a\u000e\u0010,\u001a\u00020\u00012\u0006\u0010-\u001a\u00020.\u001a\u001e\u0010/\u001a\u00020\u00012\u0006\u00100\u001a\u00020\u00122\u0006\u00101\u001a\u00020\u00192\u0006\u0010\f\u001a\u00020\r\u001aB\u00102\u001a\u0010\u0012\u0004\u0012\u00020\u0019\u0012\u0006\u0012\u0004\u0018\u00010&0%2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u00103\u001a\u00020\u00012\u0006\u0010\f\u001a\u00020\r2\b\b\u0002\u00104\u001a\u00020\u00012\n\b\u0002\u00105\u001a\u0004\u0018\u00010&\u001a \u00106\u001a\u0004\u0018\u00010\u00072\u0006\u0010\f\u001a\u00020\r2\u0006\u00107\u001a\u0002082\u0006\u00100\u001a\u00020\u0012\u001a\"\u00109\u001a\u0004\u0018\u00010:2\u0006\u0010\f\u001a\u00020\r2\u0006\u00107\u001a\u0002082\u0006\u00100\u001a\u00020\u0012H\u0002\u001a.\u0010;\u001a \u0012\u0004\u0012\u00020=\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u000b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00190>0<0<2\u0006\u0010?\u001a\u00020:H\u0002\u001a\n\u00103\u001a\u00020\u0001*\u00020@\"\u001e\u0010\u0000\u001a\u00020\u00018\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0002\u0010\u0003\"\u0004\b\u0004\u0010\u0005\u00a8\u0006A"}, d2={"emulateDexDebugInTests", "", "getEmulateDexDebugInTests", "()Z", "setEmulateDexDebugInTests", "(Z)V", "findAndReadClassFile", "Lorg/jetbrains/kotlin/idea/debugger/BytecodeDebugInfo;", "fqName", "Lorg/jetbrains/kotlin/name/FqName;", "fileName", "", "project", "Lcom/intellij/openapi/project/Project;", "searchScope", "Lcom/intellij/psi/search/GlobalSearchScope;", "fileFilter", "Lkotlin/Function1;", "Lcom/intellij/openapi/vfs/VirtualFile;", "findClassFileByPath", "Ljava/io/File;", "packageName", "className", "outputDir", "getLastLineNumberForLocation", "", "location", "Lcom/sun/jdi/Location;", "(Lcom/sun/jdi/Location;Lcom/intellij/openapi/project/Project;Lcom/intellij/psi/search/GlobalSearchScope;)Ljava/lang/Integer;", "getLocationsOfInlinedLine", "", "type", "Lcom/sun/jdi/ReferenceType;", "position", "Lcom/intellij/debugger/SourcePosition;", "sourceSearchScope", "getOriginalPositionOfInlinedLine", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/psi/KtFile;", "inlinedLinesNumbers", "inlineLineNumber", "inlineFileName", "destinationTypeFqName", "destinationFileName", "isInCrossinlineArgument", "ktElement", "Lorg/jetbrains/kotlin/psi/KtElement;", "isInlineFunctionLineNumber", "file", "lineNumber", "ktLocationInfo", "isDexDebug", "preferInlined", "locationFile", "readBytecodeInfo", "jvmName", "Lorg/jetbrains/kotlin/resolve/jvm/JvmClassName;", "readClassFileImpl", "", "readLineNumberTableMapping", "", "Lorg/jetbrains/kotlin/idea/debugger/BytecodeMethodKey;", "", "bytes", "Lcom/intellij/debugger/engine/DebugProcess;", "idea"})
public final class NoStrataPositionManagerHelperKt {
    private static volatile boolean emulateDexDebugInTests;

    public static final boolean isInlineFunctionLineNumber(@NotNull VirtualFile file2, int lineNumber, @NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        if (ProjectRootsUtil.isProjectSourceFile(project, file2)) {
            PsiFile psiFile = KotlinRefactoringUtilKt.toPsiFile(file2, project);
            if (psiFile == null) {
                return false;
            }
            int linesInFile = KotlinRefactoringUtilKt.getLineCount((PsiElement)psiFile);
            return lineNumber > linesInFile;
        }
        return true;
    }

    @Nullable
    public static final BytecodeDebugInfo readBytecodeInfo(@NotNull Project project, @NotNull JvmClassName jvmName, @NotNull VirtualFile file2) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)jvmName, (String)"jvmName");
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        return KotlinDebuggerCaches.Companion.getOrReadDebugInfoFromBytecode(project, jvmName, file2);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Pair<Integer, KtFile> ktLocationInfo(@NotNull Location location2, boolean isDexDebug, @NotNull Project project, boolean preferInlined, @Nullable KtFile locationFile) {
        Intrinsics.checkParameterIsNotNull((Object)location2, (String)"location");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        if (isDexDebug && (locationFile == null || location2.lineNumber() > KotlinRefactoringUtilKt.getLineCount((PsiElement)locationFile))) {
            Integer thisFunLine2;
            if (!preferInlined && (thisFunLine2 = (Integer)ApplicationUtilsKt.runReadAction((Function0)new Function0<Integer>(location2, project){
                final /* synthetic */ Location $location;
                final /* synthetic */ Project $project;

                @Nullable
                public final Integer invoke() {
                    return NoStrataPositionManagerHelperKt.getLastLineNumberForLocation$default(this.$location, this.$project, null, 4, null);
                }
                {
                    this.$location = location2;
                    this.$project = project;
                    super(0);
                }
            })) != null && Intrinsics.areEqual((Object)thisFunLine2, (Object)location2.lineNumber()) ^ true) {
                return TuplesKt.to((Object)thisFunLine2, (Object)locationFile);
            }
            Pair inlinePosition2 = (Pair)ApplicationUtilsKt.runReadAction((Function0)new Function0<Pair<? extends KtFile, ? extends Integer>>(location2, project){
                final /* synthetic */ Location $location;
                final /* synthetic */ Project $project;

                @Nullable
                public final Pair<KtFile, Integer> invoke() {
                    return NoStrataPositionManagerHelperKt.getOriginalPositionOfInlinedLine(this.$location, this.$project);
                }
                {
                    this.$location = location2;
                    this.$project = project;
                    super(0);
                }
            });
            if (inlinePosition2 != null) {
                void file2;
                void line;
                Pair pair2 = inlinePosition2;
                KtFile ktFile = (KtFile)pair2.component1();
                int n = ((Number)pair2.component2()).intValue();
                pair2 = null;
                return TuplesKt.to((Object)((int)(line + true)), (Object)file2);
            }
        }
        return TuplesKt.to((Object)location2.lineNumber(), (Object)locationFile);
    }

    @NotNull
    public static /* bridge */ /* synthetic */ Pair ktLocationInfo$default(Location location2, boolean bl, Project project, boolean bl2, KtFile ktFile, int n, Object object) {
        if ((n & 8) != 0) {
            bl2 = false;
        }
        if ((n & 0x10) != 0) {
            ktFile = null;
        }
        return NoStrataPositionManagerHelperKt.ktLocationInfo(location2, bl, project, bl2, ktFile);
    }

    @Nullable
    public static final Integer getLastLineNumberForLocation(@NotNull Location location2, @NotNull Project project, @NotNull GlobalSearchScope searchScope2) {
        Object v6;
        block6: {
            Intrinsics.checkParameterIsNotNull((Object)location2, (String)"location");
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Intrinsics.checkParameterIsNotNull((Object)searchScope2, (String)"searchScope");
            int lineNumber = location2.lineNumber();
            FqName fqName2 = new FqName(location2.declaringType().name());
            String fileName = location2.sourceName();
            Method method = location2.method();
            if (method == null) {
                return null;
            }
            Method method2 = method;
            String string = method2.name();
            if (string == null) {
                return null;
            }
            String name2 = string;
            String string2 = method2.signature();
            if (string2 == null) {
                return null;
            }
            String signature = string2;
            String string3 = fileName;
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"fileName");
            BytecodeDebugInfo bytecodeDebugInfo = NoStrataPositionManagerHelperKt.findAndReadClassFile(fqName2, string3, project, searchScope2, (Function1<? super VirtualFile, Boolean>)((Function1)new Function1<VirtualFile, Boolean>(lineNumber, project){
                final /* synthetic */ int $lineNumber;
                final /* synthetic */ Project $project;

                public final boolean invoke(@NotNull VirtualFile it) {
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    return NoStrataPositionManagerHelperKt.isInlineFunctionLineNumber(it, this.$lineNumber, this.$project);
                }
                {
                    this.$lineNumber = n;
                    this.$project = project;
                    super(1);
                }
            }));
            if (bytecodeDebugInfo == null) {
                return null;
            }
            BytecodeDebugInfo debugInfo2 = bytecodeDebugInfo;
            Map<String, Set<Integer>> map2 = debugInfo2.getLineTableMapping().get(new BytecodeMethodKey(name2, signature));
            if (map2 == null) {
                return null;
            }
            Map<String, Set<Integer>> lineMapping = map2;
            Iterable $receiver$iv = lineMapping.values();
            for (Object element$iv : $receiver$iv) {
                Set it = (Set)element$iv;
                if (!it.contains(lineNumber)) continue;
                v6 = element$iv;
                break block6;
            }
            v6 = null;
        }
        Set set = v6;
        return set != null ? (Integer)CollectionsKt.last((Iterable)set) : null;
    }

    @Nullable
    public static /* bridge */ /* synthetic */ Integer getLastLineNumberForLocation$default(Location location2, Project project, GlobalSearchScope globalSearchScope, int n, Object object) {
        if ((n & 4) != 0) {
            GlobalSearchScope globalSearchScope2 = GlobalSearchScope.allScope((Project)project);
            Intrinsics.checkExpressionValueIsNotNull((Object)globalSearchScope2, (String)"GlobalSearchScope.allScope(project)");
            globalSearchScope = globalSearchScope2;
        }
        return NoStrataPositionManagerHelperKt.getLastLineNumberForLocation(location2, project, globalSearchScope);
    }

    private static final byte[] readClassFileImpl(Project project, JvmClassName jvmName, VirtualFile file2) {
        byte[] byArray;
        FqName fqName2 = jvmName.getFqNameForClassNameWithoutDollars();
        FqName fqName3 = jvmName.getPackageFqName();
        Intrinsics.checkExpressionValueIsNotNull((Object)fqName3, (String)"jvmName.packageFqName");
        FqName fqNameWithInners = FqNamesUtilKt.tail(fqName2, fqName3);
        Function0<byte[]> readFromLibrary$ = new Function0<byte[]>(project, file2, jvmName, fqNameWithInners){
            final /* synthetic */ Project $project;
            final /* synthetic */ VirtualFile $file;
            final /* synthetic */ JvmClassName $jvmName;
            final /* synthetic */ FqName $fqNameWithInners;

            @Nullable
            public final byte[] invoke() {
                if (!ProjectRootsUtil.isLibrarySourceFile(this.$project, this.$file)) {
                    return null;
                }
                ClassId classId = new ClassId(this.$jvmName.getPackageFqName(), Name.identifier(this.$fqNameWithInners.asString()));
                JvmVirtualFileFinder fileFinder = JvmVirtualFileFinder.SERVICE.getInstance(this.$project);
                VirtualFile virtualFile2 = fileFinder.findVirtualFileWithHeader(classId);
                if (virtualFile2 == null) {
                    return null;
                }
                VirtualFile classFile = virtualFile2;
                return classFile.contentsToByteArray();
            }
            {
                this.$project = project;
                this.$file = virtualFile2;
                this.$jvmName = jvmClassName;
                this.$fqNameWithInners = fqName2;
                super(0);
            }
        };
        Function1<Boolean, byte[]> readFromOutput$ = new Function1<Boolean, byte[]>(project, file2, fqNameWithInners, jvmName){
            final /* synthetic */ Project $project;
            final /* synthetic */ VirtualFile $file;
            final /* synthetic */ FqName $fqNameWithInners;
            final /* synthetic */ JvmClassName $jvmName;

            @Nullable
            public final byte[] invoke(boolean isForTestClasses) {
                if (!ProjectRootsUtil.isProjectSourceFile(this.$project, this.$file)) {
                    return null;
                }
                Module module = ProjectFileIndex.SERVICE.getInstance((Project)this.$project).getModuleForFile(this.$file);
                VirtualFile virtualFile2 = CompilerPaths.getModuleOutputDirectory((Module)module, (boolean)isForTestClasses);
                if (virtualFile2 == null) {
                    return null;
                }
                VirtualFile outputDir2 = virtualFile2;
                String className2 = StringsKt.replace$default((String)this.$fqNameWithInners.asString(), (char)'.', (char)'$', (boolean)false, (int)4, null);
                String string = this.$jvmName.getPackageFqName().asString();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"jvmName.packageFqName.asString()");
                VirtualFile virtualFile3 = outputDir2;
                Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile3, (String)"outputDir");
                File classByDirectory = NoStrataPositionManagerHelperKt.access$findClassFileByPath(string, className2, virtualFile3);
                if (classByDirectory == null) {
                    if (!isForTestClasses) {
                        return null;
                    }
                    String outputModeDirName = outputDir2.getName();
                    VirtualFile virtualFile4 = outputDir2.getParent();
                    if (virtualFile4 == null || (virtualFile4 = virtualFile4.getParent()) == null || (virtualFile4 = virtualFile4.findChild("androidTest")) == null || (virtualFile4 = virtualFile4.findChild(outputModeDirName)) == null) {
                        return null;
                    }
                    VirtualFile androidTestOutputDir = virtualFile4;
                    String string2 = this.$jvmName.getPackageFqName().asString();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"jvmName.packageFqName.asString()");
                    VirtualFile virtualFile5 = androidTestOutputDir;
                    Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile5, (String)"androidTestOutputDir");
                    File file2 = NoStrataPositionManagerHelperKt.access$findClassFileByPath(string2, className2, virtualFile5);
                    if (file2 == null) {
                        return null;
                    }
                    classByDirectory = file2;
                }
                return FilesKt.readBytes((File)classByDirectory);
            }
            {
                this.$project = project;
                this.$file = virtualFile2;
                this.$fqNameWithInners = fqName2;
                this.$jvmName = jvmClassName;
                super(1);
            }
        };
        Function0<byte[]> readFromSourceOutput$ = new Function0<byte[]>(readFromOutput$){
            final /* synthetic */ readClassFileImpl.2 $readFromOutput;

            @Nullable
            public final byte[] invoke() {
                return this.$readFromOutput.invoke(false);
            }
            {
                this.$readFromOutput = var1_1;
                super(0);
            }
        };
        Function0<byte[]> readFromTestOutput$ = new Function0<byte[]>(readFromOutput$){
            final /* synthetic */ readClassFileImpl.2 $readFromOutput;

            @Nullable
            public final byte[] invoke() {
                return this.$readFromOutput.invoke(true);
            }
            {
                this.$readFromOutput = var1_1;
                super(0);
            }
        };
        byte[] byArray2 = readFromLibrary$.invoke();
        if (byArray2 == null) {
            byArray2 = byArray = readFromSourceOutput$.invoke();
        }
        if (byArray2 == null) {
            byArray = readFromTestOutput$.invoke();
        }
        return byArray;
    }

    private static final File findClassFileByPath(String packageName, String className2, VirtualFile outputDir2) {
        File beforeDexFileClassFile;
        File file2 = AddToStdlibKt.check(new File(outputDir2.getPath()), findClassFileByPath.outDirFile.1.INSTANCE);
        if (file2 == null) {
            return null;
        }
        File outDirFile2 = file2;
        String string = File.separator;
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"File.separator");
        File parentDirectory = new File(outDirFile2, StringsKt.replace$default((String)packageName, (String)".", (String)string, (boolean)false, (int)4, null));
        if (!parentDirectory.exists()) {
            return null;
        }
        if (ApplicationManager.getApplication().isUnitTestMode() && (beforeDexFileClassFile = new File(parentDirectory, className2 + ".class.before_dex")).exists()) {
            return beforeDexFileClassFile;
        }
        File classFile = new File(parentDirectory, className2 + ".class");
        if (classFile.exists()) {
            return classFile;
        }
        return null;
    }

    private static final Map<BytecodeMethodKey, Map<String, Set<Integer>>> readLineNumberTableMapping(byte[] bytes2) {
        HashMap lineNumberMapping = new HashMap();
        new ClassReader(bytes2).accept(new ClassVisitor(lineNumberMapping, 327680){
            final /* synthetic */ HashMap $lineNumberMapping;

            @Nullable
            public MethodVisitor visitMethod(int access, @Nullable String name2, @Nullable String desc, @Nullable String signature, @Nullable String[] exceptions) {
                if (name2 == null || desc == null) {
                    return null;
                }
                BytecodeMethodKey methodKey = new BytecodeMethodKey(name2, desc);
                HashMap<K, V> methodLinesMapping = new HashMap<K, V>();
                Map map2 = this.$lineNumberMapping;
                HashMap<K, V> hashMap = methodLinesMapping;
                map2.put(methodKey, hashMap);
                return new MethodVisitor(methodLinesMapping, 327680, null){
                    final /* synthetic */ HashMap $methodLinesMapping;

                    /*
                     * WARNING - void declaration
                     */
                    public void visitLineNumber(int line, @Nullable Label start) {
                        if (start != null) {
                            Object object;
                            void $receiver$iv;
                            Map map2 = this.$methodLinesMapping;
                            String string = start.toString();
                            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"start.toString()");
                            String key$iv = string;
                            if (!$receiver$iv.containsKey(key$iv)) {
                                LinkedHashSet<E> answer$iv = new LinkedHashSet<E>();
                                $receiver$iv.put(key$iv, answer$iv);
                                object = answer$iv;
                            } else {
                                object = $receiver$iv.get(key$iv);
                            }
                            ((Set)object).add(line);
                        }
                    }
                    {
                        this.$methodLinesMapping = $captured_local_variable$0;
                        super($super_call_param$1, $super_call_param$2);
                    }
                };
            }
            {
                this.$lineNumberMapping = $captured_local_variable$0;
                super($super_call_param$1);
            }
        }, 0);
        return lineNumberMapping;
    }

    @Nullable
    public static final Pair<KtFile, Integer> getOriginalPositionOfInlinedLine(@NotNull Location location2, @NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)location2, (String)"location");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        int lineNumber = location2.lineNumber();
        FqName fqName2 = new FqName(location2.declaringType().name());
        String fileName = location2.sourceName();
        GlobalSearchScope searchScope2 = GlobalSearchScope.allScope((Project)project);
        String string = fileName;
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"fileName");
        GlobalSearchScope globalSearchScope = searchScope2;
        Intrinsics.checkExpressionValueIsNotNull((Object)globalSearchScope, (String)"searchScope");
        BytecodeDebugInfo bytecodeDebugInfo = NoStrataPositionManagerHelperKt.findAndReadClassFile(fqName2, string, project, globalSearchScope, (Function1<? super VirtualFile, Boolean>)((Function1)new Function1<VirtualFile, Boolean>(lineNumber, project){
            final /* synthetic */ int $lineNumber;
            final /* synthetic */ Project $project;

            public final boolean invoke(@NotNull VirtualFile it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return NoStrataPositionManagerHelperKt.isInlineFunctionLineNumber(it, this.$lineNumber, this.$project);
            }
            {
                this.$lineNumber = n;
                this.$project = project;
                super(1);
            }
        }));
        if (bytecodeDebugInfo == null) {
            return null;
        }
        BytecodeDebugInfo debugInfo2 = bytecodeDebugInfo;
        SmapData smapData = debugInfo2.getSmapData();
        if (smapData == null) {
            return null;
        }
        SmapData smapData2 = smapData;
        GlobalSearchScope globalSearchScope2 = searchScope2;
        Intrinsics.checkExpressionValueIsNotNull((Object)globalSearchScope2, (String)"searchScope");
        return SmapUtilKt.mapStacktraceLineToSource(smapData2, lineNumber, project, SourceLineKind.EXECUTED_LINE, globalSearchScope2);
    }

    private static final BytecodeDebugInfo findAndReadClassFile(FqName fqName2, String fileName, Project project, GlobalSearchScope searchScope2, Function1<? super VirtualFile, Boolean> fileFilter) {
        JvmClassName jvmClassName;
        String internalName = StringsKt.replace$default((String)fqName2.asString(), (char)'.', (char)'/', (boolean)false, (int)4, null);
        JvmClassName jvmClassName2 = jvmClassName = JvmClassName.byInternalName(internalName);
        Intrinsics.checkExpressionValueIsNotNull((Object)jvmClassName2, (String)"jvmClassName");
        KtFile ktFile = DebuggerUtils.INSTANCE.findSourceFileForClassIncludeLibrarySources(project, searchScope2, jvmClassName2, fileName);
        if (ktFile == null) {
            return null;
        }
        KtFile file2 = ktFile;
        VirtualFile virtualFile2 = file2.getVirtualFile();
        if (virtualFile2 == null) {
            return null;
        }
        VirtualFile virtualFile3 = virtualFile2;
        if (!((Boolean)fileFilter.invoke((Object)virtualFile3)).booleanValue()) {
            return null;
        }
        JvmClassName jvmClassName3 = jvmClassName;
        Intrinsics.checkExpressionValueIsNotNull((Object)jvmClassName3, (String)"jvmClassName");
        return NoStrataPositionManagerHelperKt.readBytecodeInfo(project, jvmClassName3, virtualFile3);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<Location> getLocationsOfInlinedLine(@NotNull ReferenceType type2, @NotNull SourcePosition position2, @NotNull GlobalSearchScope sourceSearchScope) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        boolean isInCrossinlineArgument2;
        Object v2;
        PsiElement element2;
        Project project;
        int line;
        block6: {
            Intrinsics.checkParameterIsNotNull((Object)type2, (String)"type");
            Intrinsics.checkParameterIsNotNull((Object)position2, (String)"position");
            Intrinsics.checkParameterIsNotNull((Object)sourceSearchScope, (String)"sourceSearchScope");
            line = position2.getLine();
            PsiFile file2 = position2.getFile();
            project = position2.getFile().getProject();
            Integer n = KotlinRefactoringUtilKt.getLineStartOffset(file2, line);
            if (n == null) {
                return CollectionsKt.emptyList();
            }
            int lineStartOffset = n;
            PsiElement psiElement2 = file2.findElementAt(lineStartOffset);
            if (psiElement2 == null) {
                return CollectionsKt.emptyList();
            }
            element2 = psiElement2;
            Sequence<PsiElement> $receiver$iv2 = PsiUtilsKt.getParents(element2);
            for (Object element$iv : $receiver$iv2) {
                if (!(element$iv instanceof KtElement)) continue;
                v2 = element$iv;
                break block6;
            }
            v2 = null;
        }
        KtElement ktElement = v2;
        if (ktElement == null) {
            return CollectionsKt.emptyList();
        }
        KtElement ktElement2 = ktElement;
        boolean isInInline2 = (Boolean)ApplicationUtilsKt.runReadAction((Function0)new Function0<Boolean>(element2){
            final /* synthetic */ PsiElement $element;

            public final boolean invoke() {
                boolean bl;
                block1: {
                    Sequence<PsiElement> $receiver$iv = PsiUtilsKt.getParents(this.$element);
                    for (E element$iv : $receiver$iv) {
                        PsiElement it = (PsiElement)element$iv;
                        if (!(it instanceof KtFunction && ((KtFunction)it).hasModifier(KtTokens.INLINE_KEYWORD))) continue;
                        bl = true;
                        break block1;
                    }
                    bl = false;
                }
                return bl;
            }
            {
                this.$element = psiElement2;
                super(0);
            }
        });
        if (!isInInline2 && !(isInCrossinlineArgument2 = NoStrataPositionManagerHelperKt.isInCrossinlineArgument(ktElement2))) {
            return CollectionsKt.emptyList();
        }
        String string = position2.getFile().getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"position.file.name");
        FqName fqName2 = new FqName(type2.name());
        String string2 = type2.sourceName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"type.sourceName()");
        Project project2 = project;
        Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"project");
        List<Integer> lines = NoStrataPositionManagerHelperKt.inlinedLinesNumbers(line + 1, string, fqName2, string2, project2, sourceSearchScope);
        Iterable iterable = $receiver$iv = (Iterable)lines;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            int it = ((Number)element$iv$iv).intValue();
            Iterable list$iv$iv = type2.locationsOfLine(it);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List inlineLocations2 = (List)destination$iv$iv;
        return inlineLocations2;
    }

    public static final boolean isInCrossinlineArgument(@NotNull KtElement ktElement) {
        boolean bl;
        block1: {
            Intrinsics.checkParameterIsNotNull((Object)ktElement, (String)"ktElement");
            Sequence argumentFunctions2 = (Sequence)ApplicationUtilsKt.runReadAction((Function0)new Function0<Sequence<? extends KtFunction>>(ktElement){
                final /* synthetic */ KtElement $ktElement;

                @NotNull
                public final Sequence<KtFunction> invoke() {
                    Sequence $receiver$iv = SequencesKt.filter(PsiUtilsKt.getParents((PsiElement)this.$ktElement), (Function1)isInCrossinlineArgument.argumentFunctions.1.INSTANCE);
                    Sequence sequence2 = SequencesKt.filter((Sequence)$receiver$iv, (Function1)isInCrossinlineArgument$argumentFunctions$1$$special$$inlined$filterIsInstance$1.INSTANCE);
                    if (sequence2 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type kotlin.sequences.Sequence<R>");
                    }
                    return sequence2;
                }
                {
                    this.$ktElement = ktElement;
                    super(0);
                }
            });
            BindingContext bindingContext2 = ResolutionUtils.analyze(ktElement, BodyResolveMode.PARTIAL);
            Sequence $receiver$iv = argumentFunctions2;
            for (Object element$iv : $receiver$iv) {
                ValueParameterDescriptor argumentDescriptor;
                KtFunction it = (KtFunction)element$iv;
                ValueParameterDescriptor valueParameterDescriptor = argumentDescriptor = InlineUtil.getInlineArgumentDescriptor(it, bindingContext2);
                if (!(valueParameterDescriptor != null ? valueParameterDescriptor.isCrossinline() : false)) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    private static final List<Integer> inlinedLinesNumbers(int inlineLineNumber, String inlineFileName, FqName destinationTypeFqName, String destinationFileName, Project project, GlobalSearchScope sourceSearchScope) {
        void $receiver$iv$iv;
        void $receiver$iv$iv2;
        Iterable $receiver$iv;
        JvmClassName jvmClassName;
        String internalName = StringsKt.replace$default((String)destinationTypeFqName.asString(), (char)'.', (char)'/', (boolean)false, (int)4, null);
        JvmClassName jvmClassName2 = jvmClassName = JvmClassName.byInternalName(internalName);
        Intrinsics.checkExpressionValueIsNotNull((Object)jvmClassName2, (String)"jvmClassName");
        KtFile ktFile = DebuggerUtils.INSTANCE.findSourceFileForClassIncludeLibrarySources(project, sourceSearchScope, jvmClassName2, destinationFileName);
        if (ktFile == null) {
            return CollectionsKt.emptyList();
        }
        KtFile file2 = ktFile;
        VirtualFile virtualFile2 = file2.getVirtualFile();
        if (virtualFile2 == null) {
            return CollectionsKt.emptyList();
        }
        VirtualFile virtualFile3 = virtualFile2;
        JvmClassName jvmClassName3 = jvmClassName;
        Intrinsics.checkExpressionValueIsNotNull((Object)jvmClassName3, (String)"jvmClassName");
        BytecodeDebugInfo bytecodeDebugInfo = NoStrataPositionManagerHelperKt.readBytecodeInfo(project, jvmClassName3, virtualFile3);
        if (bytecodeDebugInfo == null) {
            return CollectionsKt.emptyList();
        }
        BytecodeDebugInfo debugInfo2 = bytecodeDebugInfo;
        SmapData smapData = debugInfo2.getSmapData();
        if (smapData == null) {
            return CollectionsKt.emptyList();
        }
        SmapData smapData2 = smapData;
        SMAP sMAP = smapData2.getKotlinStrata();
        if (sMAP == null) {
            return CollectionsKt.emptyList();
        }
        SMAP smap = sMAP;
        Iterable iterable = $receiver$iv = (Iterable)smap.getFileMappings();
        Iterable destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv2) {
            FileMapping it = (FileMapping)element$iv$iv;
            if (!Intrinsics.areEqual((Object)it.getName(), (Object)inlineFileName)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List mappingsToInlinedFile = (List)destination$iv$iv;
        Iterable $receiver$iv2 = mappingsToInlinedFile;
        destination$iv$iv = $receiver$iv2;
        Collection destination$iv$iv2 = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            FileMapping it = (FileMapping)element$iv$iv;
            Iterable list$iv$iv = it.getLineMappings();
            CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
        }
        List mappingIntervals = (List)destination$iv$iv2;
        List mappedLines2 = SequencesKt.toList((Sequence)SequencesKt.filter((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)mappingIntervals), (Function1)((Function1)new Function1<RangeMapping, Boolean>(inlineLineNumber){
            final /* synthetic */ int $inlineLineNumber;

            public final boolean invoke(@NotNull RangeMapping rangeMapping) {
                Intrinsics.checkParameterIsNotNull((Object)rangeMapping, (String)"rangeMapping");
                return rangeMapping.hasMappingForSource(this.$inlineLineNumber);
            }
            {
                this.$inlineLineNumber = n;
                super(1);
            }
        })), (Function1)((Function1)new Function1<RangeMapping, Integer>(inlineLineNumber){
            final /* synthetic */ int $inlineLineNumber;

            public final int invoke(@NotNull RangeMapping rangeMapping) {
                Intrinsics.checkParameterIsNotNull((Object)rangeMapping, (String)"rangeMapping");
                return rangeMapping.mapSourceToDest(this.$inlineLineNumber);
            }
            {
                this.$inlineLineNumber = n;
                super(1);
            }
        })), (Function1)inlinedLinesNumbers.mappedLines.3.INSTANCE));
        return mappedLines2;
    }

    public static final boolean getEmulateDexDebugInTests() {
        return emulateDexDebugInTests;
    }

    public static final void setEmulateDexDebugInTests(boolean bl) {
        emulateDexDebugInTests = bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isDexDebug(@NotNull DebugProcess $receiver) {
        Object object;
        VirtualMachineProxy virtualMachineProxy;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        if (emulateDexDebugInTests) {
            if (ApplicationManager.getApplication().isUnitTestMode()) return true;
        }
        if (!((virtualMachineProxy = $receiver.getVirtualMachineProxy()) instanceof VirtualMachineProxyImpl)) {
            virtualMachineProxy = null;
        }
        if (!Intrinsics.areEqual((Object)((object = (VirtualMachineProxyImpl)virtualMachineProxy) != null && (object = object.getVirtualMachine()) != null ? object.name() : null), (Object)"Dalvik")) return false;
        return true;
    }

    @Nullable
    public static final /* synthetic */ byte[] access$readClassFileImpl(@NotNull Project project, @NotNull JvmClassName jvmName, @NotNull VirtualFile file2) {
        return NoStrataPositionManagerHelperKt.readClassFileImpl(project, jvmName, file2);
    }

    @NotNull
    public static final /* synthetic */ Map access$readLineNumberTableMapping(@NotNull byte[] bytes2) {
        return NoStrataPositionManagerHelperKt.readLineNumberTableMapping(bytes2);
    }

    @Nullable
    public static final /* synthetic */ File access$findClassFileByPath(@NotNull String packageName, @NotNull String className2, @NotNull VirtualFile outputDir2) {
        return NoStrataPositionManagerHelperKt.findClassFileByPath(packageName, className2, outputDir2);
    }
}

