/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.evaluate.compilingEvaluator;

import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.JdkVersionUtil;
import com.intellij.openapi.util.SystemInfo;
import com.sun.jdi.ClassLoaderReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.debugger.evaluate.CompilingEvaluatorUtils;
import org.jetbrains.kotlin.idea.debugger.evaluate.compilingEvaluator.ClassBytes;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=2, d1={"\u0000>\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a:\u0010\u0003\u001a\u00020\u00042\u0018\u0010\u0005\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u00070\u00062\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u001a(\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u00122\u0018\u0010\u0005\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u00070\u0006\"\u0014\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"LAMBDA_SUPERCLASSES", "", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/compilingEvaluator/ClassBytes;", "defineClasses", "", "classes", "", "Lkotlin/Pair;", "", "", "context", "Lcom/intellij/debugger/engine/evaluation/EvaluationContext;", "process", "Lcom/intellij/debugger/engine/DebugProcess;", "classLoader", "Lcom/sun/jdi/ClassLoaderReference;", "loadClasses", "evaluationContext", "Lcom/intellij/debugger/engine/evaluation/EvaluationContextImpl;", "idea"})
public final class CompilingEvaluatorKt {
    private static final List<ClassBytes> LAMBDA_SUPERCLASSES = CollectionsKt.listOf((Object)new ClassBytes("kotlin.jvm.internal.Lambda"));

    public static final void loadClasses(@NotNull EvaluationContextImpl evaluationContext, @NotNull Collection<Pair<String, byte[]>> classes2) {
        ClassLoaderReference classLoader;
        Intrinsics.checkParameterIsNotNull((Object)evaluationContext, (String)"evaluationContext");
        Intrinsics.checkParameterIsNotNull(classes2, (String)"classes");
        DebugProcessImpl process2 = evaluationContext.getDebugProcess();
        try {
            ClassLoaderReference classLoaderReference = CompilingEvaluatorUtils.getClassLoader((EvaluationContext)evaluationContext, (DebugProcess)process2);
            Intrinsics.checkExpressionValueIsNotNull((Object)classLoaderReference, (String)"CompilingEvaluatorUtils.\u2026aluationContext, process)");
            classLoader = classLoaderReference;
        }
        catch (Exception e) {
            throw (Throwable)new EvaluateException("Error creating evaluation class loader: " + e, (Throwable)e);
        }
        String version = process2.getVirtualMachineProxy().version();
        JavaSdkVersion sdkVersion = JdkVersionUtil.getVersion((String)version);
        if (!SystemInfo.isJavaVersionAtLeast((String)sdkVersion.getDescription())) {
            throw (Throwable)new EvaluateException("Unable to compile for target level " + sdkVersion.getDescription() + ". Need to run IDEA on java version at least " + sdkVersion.getDescription() + ", currently running on " + SystemInfo.JAVA_RUNTIME_VERSION);
        }
        try {
            EvaluationContext evaluationContext2 = (EvaluationContext)evaluationContext;
            DebugProcessImpl debugProcessImpl = process2;
            Intrinsics.checkExpressionValueIsNotNull((Object)debugProcessImpl, (String)"process");
            CompilingEvaluatorKt.defineClasses(classes2, evaluationContext2, (DebugProcess)debugProcessImpl, classLoader);
        }
        catch (Exception e) {
            throw (Throwable)new EvaluateException("Error during classes definition " + e, (Throwable)e);
        }
        evaluationContext.setClassLoader(classLoader);
    }

    /*
     * WARNING - void declaration
     */
    private static final void defineClasses(Collection<Pair<String, byte[]>> classes2, EvaluationContext context, DebugProcess process2, ClassLoaderReference classLoader) {
        void $receiver$iv$iv;
        Iterable $receiver$iv = LAMBDA_SUPERCLASSES;
        Iterable iterable = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            ClassBytes classBytes = (ClassBytes)item$iv$iv;
            Collection collection = destination$iv$iv;
            Pair pair2 = TuplesKt.to((Object)it.getName(), (Object)it.getBytes());
            collection.add(pair2);
        }
        List lambdaSuperclasses = (List)destination$iv$iv;
        for (Pair pair3 : CollectionsKt.plus((Collection)lambdaSuperclasses, (Iterable)classes2)) {
            String className2 = (String)pair3.component1();
            byte[] bytes2 = (byte[])pair3.component2();
            CompilingEvaluatorUtils.defineClass(className2, bytes2, context, process2, classLoader);
        }
    }
}

