/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.decompiler.builtIns;

import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.BuiltInsBinaryVersion;
import org.jetbrains.kotlin.idea.decompiler.builtIns.BuiltInDefinitionFile;
import org.jetbrains.kotlin.idea.decompiler.builtIns.KotlinBuiltInDecompilerKt;
import org.jetbrains.kotlin.idea.decompiler.builtIns.KotlinBuiltInDeserializerForDecompiler;
import org.jetbrains.kotlin.idea.decompiler.builtIns.KotlinBuiltInFileType;
import org.jetbrains.kotlin.idea.decompiler.common.IncompatibleAbiVersionKt;
import org.jetbrains.kotlin.idea.decompiler.textBuilder.BuildDecompiledTextKt;
import org.jetbrains.kotlin.idea.decompiler.textBuilder.DecompiledText;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.renderer.DescriptorRenderer;
import org.jetbrains.kotlin.renderer.DescriptorRendererOptions;
import org.jetbrains.kotlin.serialization.ProtoBuf;
import org.jetbrains.kotlin.serialization.deserialization.BinaryVersion;
import org.jetbrains.kotlin.utils.CollectionsKt;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=2, d1={"\u0000\u0014\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u000e\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"decompilerRendererForBuiltIns", "Lorg/jetbrains/kotlin/renderer/DescriptorRenderer;", "buildDecompiledTextForBuiltIns", "Lorg/jetbrains/kotlin/idea/decompiler/textBuilder/DecompiledText;", "builtInFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "idea-analysis"})
public final class KotlinBuiltInDecompilerKt {
    private static final DescriptorRenderer decompilerRendererForBuiltIns = DescriptorRenderer.Companion.withOptions((Function1<? super DescriptorRendererOptions, Unit>)((Function1)decompilerRendererForBuiltIns.1.INSTANCE));

    @NotNull
    public static final DecompiledText buildDecompiledTextForBuiltIns(@NotNull VirtualFile builtInFile) {
        BuiltInDefinitionFile file2;
        Intrinsics.checkParameterIsNotNull((Object)builtInFile, (String)"builtInFile");
        if (Intrinsics.areEqual((Object)builtInFile.getFileType(), (Object)KotlinBuiltInFileType.INSTANCE) ^ true) {
            String string = "Unexpected file type " + builtInFile.getFileType();
            throw (Throwable)new IllegalStateException(string.toString());
        }
        BuiltInDefinitionFile builtInDefinitionFile = BuiltInDefinitionFile.Companion.read(builtInFile);
        if (builtInDefinitionFile == null) {
            String string = "Unexpectedly empty built-in file: " + builtInFile;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        BuiltInDefinitionFile builtInDefinitionFile2 = file2 = builtInDefinitionFile;
        if (builtInDefinitionFile2 instanceof BuiltInDefinitionFile.Incompatible) {
            return IncompatibleAbiVersionKt.createIncompatibleAbiVersionDecompiledText((BinaryVersion)BuiltInsBinaryVersion.INSTANCE, (BinaryVersion)((BuiltInDefinitionFile.Incompatible)file2).getVersion());
        }
        if (builtInDefinitionFile2 instanceof BuiltInDefinitionFile.Compatible) {
            FqName packageFqName = ((BuiltInDefinitionFile.Compatible)file2).getPackageFqName();
            KotlinBuiltInDeserializerForDecompiler resolver2 = new KotlinBuiltInDeserializerForDecompiler(packageFqName, ((BuiltInDefinitionFile.Compatible)file2).getProto(), ((BuiltInDefinitionFile.Compatible)file2).getNameResolver());
            ArrayList declarations2 = new ArrayList();
            declarations2.addAll(resolver2.resolveDeclarationsInFacade(packageFqName));
            for (ProtoBuf.Class classProto : ((BuiltInDefinitionFile.Compatible)file2).getClassesToDecompile()) {
                ClassId classId = ((BuiltInDefinitionFile.Compatible)file2).getNameResolver().getClassId(classProto.getFqName());
                CollectionsKt.addIfNotNull(declarations2, resolver2.resolveTopLevelClass(classId));
            }
            return BuildDecompiledTextKt.buildDecompiledText$default(packageFqName, declarations2, decompilerRendererForBuiltIns, null, 8, null);
        }
        throw new NoWhenBranchMatchedException();
    }
}

