/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.decompiler.js;

import com.intellij.openapi.vfs.VirtualFile;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.serialization.ProtoBuf;
import org.jetbrains.kotlin.serialization.deserialization.NameResolverImpl;
import org.jetbrains.kotlin.serialization.js.JsProtoBuf;
import org.jetbrains.kotlin.serialization.js.JsSerializerProtocol;
import org.jetbrains.kotlin.utils.JsMetadataVersion;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000 \u00032\u00020\u0001:\u0003\u0003\u0004\u0005B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u0082\u0001\u0002\u0006\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/idea/decompiler/js/KjsmFile;", "", "()V", "Companion", "Compatible", "Incompatible", "Lorg/jetbrains/kotlin/idea/decompiler/js/KjsmFile$Incompatible;", "Lorg/jetbrains/kotlin/idea/decompiler/js/KjsmFile$Compatible;", "idea-analysis"})
public abstract class KjsmFile {
    public static final Companion Companion = new Companion(null);

    private KjsmFile() {
    }

    public /* synthetic */ KjsmFile(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/idea/decompiler/js/KjsmFile$Incompatible;", "Lorg/jetbrains/kotlin/idea/decompiler/js/KjsmFile;", "version", "Lorg/jetbrains/kotlin/utils/JsMetadataVersion;", "(Lorg/jetbrains/kotlin/utils/JsMetadataVersion;)V", "getVersion", "()Lorg/jetbrains/kotlin/utils/JsMetadataVersion;", "idea-analysis"})
    public static final class Incompatible
    extends KjsmFile {
        @NotNull
        private final JsMetadataVersion version;

        @NotNull
        public final JsMetadataVersion getVersion() {
            return this.version;
        }

        public Incompatible(@NotNull JsMetadataVersion version) {
            Intrinsics.checkParameterIsNotNull((Object)version, (String)"version");
            super(null);
            this.version = version;
        }
    }

    @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u001f\u0010\u0007\u001a\u0010\u0012\f\u0012\n \n*\u0004\u0018\u00010\t0\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/idea/decompiler/js/KjsmFile$Compatible;", "Lorg/jetbrains/kotlin/idea/decompiler/js/KjsmFile;", "header", "Lorg/jetbrains/kotlin/serialization/js/JsProtoBuf$Header;", "proto", "Lorg/jetbrains/kotlin/serialization/js/JsProtoBuf$Library$Part;", "(Lorg/jetbrains/kotlin/serialization/js/JsProtoBuf$Header;Lorg/jetbrains/kotlin/serialization/js/JsProtoBuf$Library$Part;)V", "classesToDecompile", "", "Lorg/jetbrains/kotlin/serialization/ProtoBuf$Class;", "kotlin.jvm.PlatformType", "getClassesToDecompile", "()Ljava/util/List;", "getHeader", "()Lorg/jetbrains/kotlin/serialization/js/JsProtoBuf$Header;", "nameResolver", "Lorg/jetbrains/kotlin/serialization/deserialization/NameResolverImpl;", "getNameResolver", "()Lorg/jetbrains/kotlin/serialization/deserialization/NameResolverImpl;", "packageFqName", "Lorg/jetbrains/kotlin/name/FqName;", "getPackageFqName", "()Lorg/jetbrains/kotlin/name/FqName;", "getProto", "()Lorg/jetbrains/kotlin/serialization/js/JsProtoBuf$Library$Part;", "idea-analysis"})
    public static final class Compatible
    extends KjsmFile {
        @NotNull
        private final FqName packageFqName;
        @NotNull
        private final NameResolverImpl nameResolver;
        @NotNull
        private final List<ProtoBuf.Class> classesToDecompile;
        @NotNull
        private final JsProtoBuf.Header header;
        @NotNull
        private final JsProtoBuf.Library.Part proto;

        @NotNull
        public final FqName getPackageFqName() {
            return this.packageFqName;
        }

        @NotNull
        public final NameResolverImpl getNameResolver() {
            return this.nameResolver;
        }

        @NotNull
        public final List<ProtoBuf.Class> getClassesToDecompile() {
            return this.classesToDecompile;
        }

        @NotNull
        public final JsProtoBuf.Header getHeader() {
            return this.header;
        }

        @NotNull
        public final JsProtoBuf.Library.Part getProto() {
            return this.proto;
        }

        /*
         * WARNING - void declaration
         */
        public Compatible(@NotNull JsProtoBuf.Header header, @NotNull JsProtoBuf.Library.Part proto) {
            List list2;
            void $receiver$iv$iv;
            void $receiver$iv;
            Intrinsics.checkParameterIsNotNull((Object)header, (String)"header");
            Intrinsics.checkParameterIsNotNull((Object)proto, (String)"proto");
            super(null);
            this.header = header;
            this.proto = proto;
            this.packageFqName = new FqName(this.header.getPackageFqName());
            ProtoBuf.StringTable stringTable = this.proto.getStrings();
            Intrinsics.checkExpressionValueIsNotNull((Object)stringTable, (String)"proto.strings");
            ProtoBuf.QualifiedNameTable qualifiedNameTable = this.proto.getQualifiedNames();
            Intrinsics.checkExpressionValueIsNotNull((Object)qualifiedNameTable, (String)"proto.qualifiedNames");
            this.nameResolver = new NameResolverImpl(stringTable, qualifiedNameTable);
            Iterable iterable = this.proto.getClass_List();
            Compatible compatible = this;
            void var4_5 = $receiver$iv;
            Collection destination$iv$iv = new ArrayList();
            for (Object element$iv$iv : $receiver$iv$iv) {
                ProtoBuf.Class proto2 = (ProtoBuf.Class)element$iv$iv;
                if (this.nameResolver.getClassId(proto2.getFqName()).isNestedClass()) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            compatible.classesToDecompile = list2 = (List)destination$iv$iv;
        }
    }

    @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/idea/decompiler/js/KjsmFile$Companion;", "", "()V", "read", "Lorg/jetbrains/kotlin/idea/decompiler/js/KjsmFile;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "readFileContentsSafely", "", "idea-analysis"})
    public static final class Companion {
        @Nullable
        public final KjsmFile read(@NotNull VirtualFile file2) {
            Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
            byte[] byArray = this.readFileContentsSafely(file2);
            if (byArray == null) {
                return null;
            }
            ByteArrayInputStream stream2 = new ByteArrayInputStream(byArray);
            JsMetadataVersion version = JsMetadataVersion.Companion.readFrom(stream2);
            if (!version.isCompatible()) {
                return new Incompatible(version);
            }
            JsProtoBuf.Header header = JsProtoBuf.Header.parseDelimitedFrom(stream2);
            JsProtoBuf.Library.Part proto = JsProtoBuf.Library.Part.parseFrom(stream2, JsSerializerProtocol.INSTANCE.getExtensionRegistry());
            JsProtoBuf.Header header2 = header;
            Intrinsics.checkExpressionValueIsNotNull((Object)header2, (String)"header");
            JsProtoBuf.Library.Part part = proto;
            Intrinsics.checkExpressionValueIsNotNull((Object)part, (String)"proto");
            Compatible result2 = new Compatible(header2, part);
            return result2;
        }

        private final byte[] readFileContentsSafely(VirtualFile file2) {
            byte[] byArray;
            if (!file2.isValid()) {
                return null;
            }
            try {
                byArray = file2.contentsToByteArray();
            }
            catch (IOException e) {
                byArray = null;
            }
            return byArray;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

