/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.decompiler.js;

import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.decompiler.common.IncompatibleAbiVersionKt;
import org.jetbrains.kotlin.idea.decompiler.js.KjsmFile;
import org.jetbrains.kotlin.idea.decompiler.js.KotlinJavaScriptDeserializerForDecompiler;
import org.jetbrains.kotlin.idea.decompiler.js.KotlinJavaScriptMetaFileDecompilerKt;
import org.jetbrains.kotlin.idea.decompiler.js.KotlinJavaScriptMetaFileType;
import org.jetbrains.kotlin.idea.decompiler.textBuilder.BuildDecompiledTextKt;
import org.jetbrains.kotlin.idea.decompiler.textBuilder.DecompiledText;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.renderer.DescriptorRenderer;
import org.jetbrains.kotlin.renderer.DescriptorRendererOptions;
import org.jetbrains.kotlin.serialization.ProtoBuf;
import org.jetbrains.kotlin.serialization.deserialization.BinaryVersion;
import org.jetbrains.kotlin.utils.CollectionsKt;
import org.jetbrains.kotlin.utils.JsMetadataVersion;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=2, d1={"\u0000\u0014\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u000e\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"decompilerRendererForJS", "Lorg/jetbrains/kotlin/renderer/DescriptorRenderer;", "buildDecompiledTextFromJsMetadata", "Lorg/jetbrains/kotlin/idea/decompiler/textBuilder/DecompiledText;", "kjsmFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "idea-analysis"})
public final class KotlinJavaScriptMetaFileDecompilerKt {
    private static final DescriptorRenderer decompilerRendererForJS = DescriptorRenderer.Companion.withOptions((Function1<? super DescriptorRendererOptions, Unit>)((Function1)decompilerRendererForJS.1.INSTANCE));

    @NotNull
    public static final DecompiledText buildDecompiledTextFromJsMetadata(@NotNull VirtualFile kjsmFile) {
        Intrinsics.checkParameterIsNotNull((Object)kjsmFile, (String)"kjsmFile");
        if (Intrinsics.areEqual((Object)kjsmFile.getFileType(), (Object)KotlinJavaScriptMetaFileType.INSTANCE) ^ true) {
            String string = "Unexpected file type " + kjsmFile.getFileType();
            throw (Throwable)new IllegalStateException(string.toString());
        }
        KjsmFile file2 = KjsmFile.Companion.read(kjsmFile);
        KjsmFile kjsmFile2 = file2;
        if (Intrinsics.areEqual((Object)kjsmFile2, null)) {
            return IncompatibleAbiVersionKt.createIncompatibleAbiVersionDecompiledText((BinaryVersion)JsMetadataVersion.INSTANCE, (BinaryVersion)JsMetadataVersion.INVALID_VERSION);
        }
        if (kjsmFile2 instanceof KjsmFile.Incompatible) {
            return IncompatibleAbiVersionKt.createIncompatibleAbiVersionDecompiledText((BinaryVersion)JsMetadataVersion.INSTANCE, (BinaryVersion)((KjsmFile.Incompatible)file2).getVersion());
        }
        if (kjsmFile2 instanceof KjsmFile.Compatible) {
            FqName packageFqName = ((KjsmFile.Compatible)file2).getPackageFqName();
            KotlinJavaScriptDeserializerForDecompiler resolver2 = new KotlinJavaScriptDeserializerForDecompiler(packageFqName, ((KjsmFile.Compatible)file2).getProto(), ((KjsmFile.Compatible)file2).getNameResolver());
            ArrayList declarations2 = new ArrayList();
            declarations2.addAll(resolver2.resolveDeclarationsInFacade(packageFqName));
            for (ProtoBuf.Class klass2 : ((KjsmFile.Compatible)file2).getClassesToDecompile()) {
                ClassId classId = ((KjsmFile.Compatible)file2).getNameResolver().getClassId(klass2.getFqName());
                CollectionsKt.addIfNotNull(declarations2, resolver2.resolveTopLevelClass(classId));
            }
            return BuildDecompiledTextKt.buildDecompiledText$default(packageFqName, declarations2, decompilerRendererForJS, null, 8, null);
        }
        throw new NoWhenBranchMatchedException();
    }
}

