/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.decompiler.navigation;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.EverythingGlobalScope;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.MemberDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.PackageViewDescriptor;
import org.jetbrains.kotlin.descriptors.ParameterDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.TypeAliasDescriptor;
import org.jetbrains.kotlin.descriptors.impl.TypeAliasConstructorDescriptor;
import org.jetbrains.kotlin.idea.caches.resolve.GetModuleInfoKt;
import org.jetbrains.kotlin.idea.caches.resolve.IdeaModuleInfo;
import org.jetbrains.kotlin.idea.caches.resolve.LibraryInfo;
import org.jetbrains.kotlin.idea.caches.resolve.LibrarySourceInfo;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionFacadeImplKt;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.decompiler.KtDecompiledFile;
import org.jetbrains.kotlin.idea.decompiler.navigation.ByDescriptorIndexer;
import org.jetbrains.kotlin.idea.stubindex.KotlinFullClassNameIndex;
import org.jetbrains.kotlin.idea.stubindex.KotlinSourceFilterScope;
import org.jetbrains.kotlin.idea.stubindex.KotlinTopLevelFunctionFqnNameIndex;
import org.jetbrains.kotlin.idea.stubindex.KotlinTopLevelPropertyFqnNameIndex;
import org.jetbrains.kotlin.idea.stubindex.KotlinTopLevelTypeAliasFqNameIndex;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.types.ErrorUtils;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=2, d1={"\u0000(\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u001a \u0010\u0000\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u001a\u0018\u0010\u0007\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u001a\u001e\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u001a\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0006H\u0002\u00a8\u0006\r"}, d2={"findCandidateDeclarationsInIndex", "", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "project", "Lcom/intellij/openapi/project/Project;", "referencedDescriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "findDecompiledDeclaration", "findDecompiledFilesForDescriptor", "Lorg/jetbrains/kotlin/idea/decompiler/KtDecompiledFile;", "isLocal", "", "descriptor", "idea-analysis"})
public final class FindDecompiledDeclarationKt {
    @Nullable
    public static final KtDeclaration findDecompiledDeclaration(@NotNull Project project, @NotNull DeclarationDescriptor referencedDescriptor) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)referencedDescriptor, (String)"referencedDescriptor");
        if (ErrorUtils.isError(referencedDescriptor)) {
            return null;
        }
        if (FindDecompiledDeclarationKt.isLocal(referencedDescriptor)) {
            return null;
        }
        if (referencedDescriptor instanceof PackageFragmentDescriptor || referencedDescriptor instanceof PackageViewDescriptor) {
            return null;
        }
        Collection<KtDecompiledFile> decompiledFiles = FindDecompiledDeclarationKt.findDecompiledFilesForDescriptor(project, referencedDescriptor);
        ModuleDescriptor referencedModule = DescriptorUtilsKt.getModule(referencedDescriptor);
        return (KtDeclaration)SequencesKt.firstOrNull((Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)decompiledFiles), (Function1)((Function1)new Function1<KtDecompiledFile, KtDeclaration>(project, referencedModule, referencedDescriptor){
            final /* synthetic */ Project $project;
            final /* synthetic */ ModuleDescriptor $referencedModule;
            final /* synthetic */ DeclarationDescriptor $referencedDescriptor;

            @Nullable
            public final KtDeclaration invoke(@NotNull KtDecompiledFile file2) {
                ModuleDescriptor libraryModule;
                ModuleDescriptor moduleDescriptor;
                LibraryInfo libraryInfo;
                IdeaModuleInfo moduleInfo;
                Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
                IdeaModuleInfo ideaModuleInfo = moduleInfo = GetModuleInfoKt.getNullableModuleInfo((PsiElement)file2);
                LibraryInfo libraryInfo2 = libraryInfo = ideaModuleInfo instanceof LibraryInfo ? (LibraryInfo)moduleInfo : (ideaModuleInfo instanceof LibrarySourceInfo ? new LibraryInfo(this.$project, ((LibrarySourceInfo)moduleInfo).getLibrary()) : null);
                if (libraryInfo2 != null) {
                    LibraryInfo libraryInfo3;
                    LibraryInfo it = libraryInfo3 = libraryInfo2;
                    moduleDescriptor = ResolutionFacadeImplKt.findModuleDescriptor(ResolutionUtils.getResolutionFacade(file2), it);
                } else {
                    moduleDescriptor = libraryModule = null;
                }
                if (libraryModule != null && Intrinsics.areEqual((Object)this.$referencedModule.getName(), (Object)KotlinBuiltIns.BUILTINS_MODULE_NAME) ^ true && Intrinsics.areEqual((Object)this.$referencedModule.getName(), (Object)libraryModule.getName()) ^ true) {
                    return null;
                }
                return ByDescriptorIndexer.INSTANCE.getDeclarationForDescriptor$idea_analysis(this.$referencedDescriptor, file2);
            }
            {
                this.$project = project;
                this.$referencedModule = moduleDescriptor;
                this.$referencedDescriptor = declarationDescriptor;
                super(1);
            }
        })));
    }

    private static final boolean isLocal(DeclarationDescriptor descriptor2) {
        if (descriptor2 instanceof ParameterDescriptor) {
            DeclarationDescriptor declarationDescriptor = ((ParameterDescriptor)descriptor2).getContainingDeclaration();
            Intrinsics.checkExpressionValueIsNotNull((Object)declarationDescriptor, (String)"descriptor.containingDeclaration");
            return FindDecompiledDeclarationKt.isLocal(declarationDescriptor);
        }
        return DescriptorUtils.isLocal(descriptor2);
    }

    /*
     * WARNING - void declaration
     */
    private static final Collection<KtDecompiledFile> findDecompiledFilesForDescriptor(Project project, DeclarationDescriptor referencedDescriptor) {
        void var3_3;
        void $receiver$iv;
        Iterable iterable = FindDecompiledDeclarationKt.findCandidateDeclarationsInIndex(project, referencedDescriptor);
        Collection destination$iv = new LinkedHashSet();
        void $receiver$iv$iv = $receiver$iv;
        Iterator iterator2 = $receiver$iv$iv.iterator();
        while (iterator2.hasNext()) {
            KtDecompiledFile ktDecompiledFile;
            KtDeclaration it;
            Object element$iv$iv;
            Object element$iv = element$iv$iv = iterator2.next();
            KtDeclaration ktDeclaration = it = (KtDeclaration)element$iv;
            Object object = ktDeclaration != null ? ktDeclaration.getContainingFile() : null;
            if (!(object instanceof KtDecompiledFile)) {
                object = null;
            }
            if ((KtDecompiledFile)object == null) continue;
            KtDecompiledFile it$iv = ktDecompiledFile;
            destination$iv.add(it$iv);
        }
        return var3_3;
    }

    private static final Collection<KtDeclaration> findCandidateDeclarationsInIndex(Project project, DeclarationDescriptor referencedDescriptor) {
        Collection<KtDeclaration> collection;
        MemberDescriptor memberDescriptor;
        MemberDescriptor memberDescriptor2;
        MemberDescriptor memberDescriptor3;
        GlobalSearchScope scope2 = KotlinSourceFilterScope.Companion.libraryClassFiles((GlobalSearchScope)new EverythingGlobalScope(project), project);
        ClassDescriptor containingClass = DescriptorUtils.getParentOfType(referencedDescriptor, ClassDescriptor.class, false);
        if (containingClass != null) {
            Collection<KtDeclaration> collection2 = KotlinFullClassNameIndex.getInstance().get(DescriptorUtilsKt.getFqNameSafe(containingClass).asString(), project, scope2);
            Intrinsics.checkExpressionValueIsNotNull(collection2, (String)"KotlinFullClassNameIndex\u2026String(), project, scope)");
            return collection2;
        }
        PropertyDescriptor propertyDescriptor = DescriptorUtils.getParentOfType(referencedDescriptor, PropertyDescriptor.class, false);
        if (propertyDescriptor != null) {
            memberDescriptor3 = propertyDescriptor;
        } else {
            TypeAliasConstructorDescriptor typeAliasConstructorDescriptor = DescriptorUtils.getParentOfType(referencedDescriptor, TypeAliasConstructorDescriptor.class, false);
            memberDescriptor3 = memberDescriptor2 = (MemberDescriptor)(typeAliasConstructorDescriptor != null ? typeAliasConstructorDescriptor.getTypeAliasDescriptor() : null);
        }
        if (memberDescriptor3 == null) {
            memberDescriptor2 = memberDescriptor = (MemberDescriptor)DescriptorUtils.getParentOfType(referencedDescriptor, FunctionDescriptor.class, false);
        }
        if (memberDescriptor2 == null) {
            memberDescriptor = DescriptorUtils.getParentOfType(referencedDescriptor, TypeAliasDescriptor.class, false);
        }
        if (memberDescriptor == null) {
            return CollectionsKt.emptyList();
        }
        MemberDescriptor topLevelDeclaration = memberDescriptor;
        if (!DescriptorUtils.isTopLevelDeclaration(topLevelDeclaration)) {
            return CollectionsKt.emptyList();
        }
        String fqName2 = DescriptorUtilsKt.getFqNameSafe(topLevelDeclaration).asString();
        MemberDescriptor memberDescriptor4 = topLevelDeclaration;
        if (memberDescriptor4 instanceof FunctionDescriptor) {
            Collection<KtNamedFunction> collection3 = KotlinTopLevelFunctionFqnNameIndex.getInstance().get(fqName2, project, scope2);
            collection = collection3;
            Intrinsics.checkExpressionValueIsNotNull(collection3, (String)"KotlinTopLevelFunctionFq\u2026t(fqName, project, scope)");
        } else if (memberDescriptor4 instanceof PropertyDescriptor) {
            Collection<KtProperty> collection4 = KotlinTopLevelPropertyFqnNameIndex.getInstance().get(fqName2, project, scope2);
            collection = collection4;
            Intrinsics.checkExpressionValueIsNotNull(collection4, (String)"KotlinTopLevelPropertyFq\u2026t(fqName, project, scope)");
        } else if (memberDescriptor4 instanceof TypeAliasDescriptor) {
            KotlinTopLevelTypeAliasFqNameIndex kotlinTopLevelTypeAliasFqNameIndex = KotlinTopLevelTypeAliasFqNameIndex.Companion.getInstance();
            String string = fqName2;
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"fqName");
            collection = kotlinTopLevelTypeAliasFqNameIndex.get(string, project, scope2);
        } else {
            String string = "Referenced non local declaration that is not inside top level function, property, class or typealias:" + "\n" + " " + referencedDescriptor;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        return collection;
    }
}

