/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.decompiler.navigation;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.EverythingGlobalScope;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.stubs.StringStubIndexExtension;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.asJava.LightClassUtilsKt;
import org.jetbrains.kotlin.builtins.DefaultBuiltIns;
import org.jetbrains.kotlin.config.LanguageVersionSettingsImpl;
import org.jetbrains.kotlin.context.ContextKt;
import org.jetbrains.kotlin.context.MutableModuleContext;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.frontend.di.InjectionKt;
import org.jetbrains.kotlin.idea.decompiler.navigation.MemberMatching;
import org.jetbrains.kotlin.idea.stubindex.KotlinFullClassNameIndex;
import org.jetbrains.kotlin.idea.stubindex.KotlinSourceFilterScope;
import org.jetbrains.kotlin.idea.stubindex.KotlinTopLevelFunctionFqnNameIndex;
import org.jetbrains.kotlin.idea.stubindex.KotlinTopLevelPropertyFqnNameIndex;
import org.jetbrains.kotlin.idea.stubindex.KotlinTopLevelTypeAliasFqNameIndex;
import org.jetbrains.kotlin.idea.util.ProjectRootsUtil;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.platform.JavaToKotlinClassMap;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassBody;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtEnumEntry;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtImportDirective;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtPrimaryConstructor;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtSecondaryConstructor;
import org.jetbrains.kotlin.psi.KtTypeAlias;
import org.jetbrains.kotlin.psi.KtTypeParameterListOwner;
import org.jetbrains.kotlin.psi.KtVisitor;
import org.jetbrains.kotlin.resolve.BindingTraceContext;
import org.jetbrains.kotlin.resolve.TargetPlatform;
import org.jetbrains.kotlin.resolve.lazy.KotlinCodeAnalyzer;
import org.jetbrains.kotlin.resolve.lazy.ResolveSession;
import org.jetbrains.kotlin.resolve.lazy.declarations.FileBasedDeclarationProviderFactory;

public class SourceNavigationHelper {
    private static final Logger LOG = Logger.getInstance(SourceNavigationHelper.class);
    private static boolean forceResolve = false;

    private SourceNavigationHelper() {
    }

    @NotNull
    private static GlobalSearchScope createLibraryOrSourcesScope(@NotNull KtNamedDeclaration declaration2, @NotNull NavigationKind navigationKind) {
        if (declaration2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "org/jetbrains/kotlin/idea/decompiler/navigation/SourceNavigationHelper", "createLibraryOrSourcesScope"));
        }
        if (navigationKind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "navigationKind", "org/jetbrains/kotlin/idea/decompiler/navigation/SourceNavigationHelper", "createLibraryOrSourcesScope"));
        }
        KtFile containingFile = declaration2.getContainingKtFile();
        VirtualFile libraryFile = containingFile.getVirtualFile();
        if (libraryFile == null) {
            GlobalSearchScope globalSearchScope = GlobalSearchScope.EMPTY_SCOPE;
            if (globalSearchScope == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/decompiler/navigation/SourceNavigationHelper", "createLibraryOrSourcesScope"));
            }
            return globalSearchScope;
        }
        boolean includeLibrarySources = navigationKind == NavigationKind.CLASS_FILES_TO_SOURCES;
        if (ProjectRootsUtil.isInContent(declaration2, false, includeLibrarySources, !includeLibrarySources, true)) {
            GlobalSearchScope globalSearchScope = GlobalSearchScope.EMPTY_SCOPE;
            if (globalSearchScope == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/decompiler/navigation/SourceNavigationHelper", "createLibraryOrSourcesScope"));
            }
            return globalSearchScope;
        }
        Project project = declaration2.getProject();
        GlobalSearchScope globalSearchScope = includeLibrarySources ? KotlinSourceFilterScope.librarySources((GlobalSearchScope)new EverythingGlobalScope(project), project) : KotlinSourceFilterScope.libraryClassFiles((GlobalSearchScope)new EverythingGlobalScope(project), project);
        if (globalSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/decompiler/navigation/SourceNavigationHelper", "createLibraryOrSourcesScope"));
        }
        return globalSearchScope;
    }

    private static List<KtFile> getContainingFiles(@NotNull Iterable<KtNamedDeclaration> declarations2) {
        if (declarations2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declarations", "org/jetbrains/kotlin/idea/decompiler/navigation/SourceNavigationHelper", "getContainingFiles"));
        }
        HashSet result2 = Sets.newHashSet();
        for (KtNamedDeclaration declaration2 : declarations2) {
            PsiFile containingFile = declaration2.getContainingFile();
            if (!(containingFile instanceof KtFile)) continue;
            result2.add((KtFile)containingFile);
        }
        return Lists.newArrayList((Iterable)result2);
    }

    private static boolean haveRenamesInImports(@NotNull List<KtFile> files2) {
        if (files2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "org/jetbrains/kotlin/idea/decompiler/navigation/SourceNavigationHelper", "haveRenamesInImports"));
        }
        for (KtFile file2 : files2) {
            for (KtImportDirective importDirective : file2.getImportDirectives()) {
                if (importDirective.getAliasName() == null) continue;
                return true;
            }
        }
        return false;
    }

    @Nullable
    private static KtNamedDeclaration findSpecialProperty(@NotNull Name memberName, @NotNull KtClass containingClass) {
        if (memberName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "memberName", "org/jetbrains/kotlin/idea/decompiler/navigation/SourceNavigationHelper", "findSpecialProperty"));
        }
        if (containingClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingClass", "org/jetbrains/kotlin/idea/decompiler/navigation/SourceNavigationHelper", "findSpecialProperty"));
        }
        List<KtParameter> constructorParameters = containingClass.getPrimaryConstructorParameters();
        for (KtParameter constructorParameter : constructorParameters) {
            if (!memberName.equals(constructorParameter.getNameAsName()) || !constructorParameter.hasValOrVar()) continue;
            return constructorParameter;
        }
        if (containingClass.hasModifier(KtTokens.ENUM_KEYWORD)) {
            for (KtEnumEntry enumEntry : ContainerUtil.findAll(containingClass.getDeclarations(), KtEnumEntry.class)) {
                if (!memberName.equals(enumEntry.getNameAsName())) continue;
                return enumEntry;
            }
        }
        return null;
    }

    @Nullable
    private static KtNamedDeclaration convertPropertyOrFunction(@NotNull KtNamedDeclaration declaration2, @NotNull NavigationKind navigationKind) {
        Collection<KtNamedDeclaration> candidates2;
        if (declaration2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "org/jetbrains/kotlin/idea/decompiler/navigation/SourceNavigationHelper", "convertPropertyOrFunction"));
        }
        if (navigationKind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "navigationKind", "org/jetbrains/kotlin/idea/decompiler/navigation/SourceNavigationHelper", "convertPropertyOrFunction"));
        }
        if (declaration2 instanceof KtPrimaryConstructor) {
            KtClassOrObject sourceClassOrObject = SourceNavigationHelper.findClassOrObject(((KtPrimaryConstructor)declaration2).getContainingClassOrObject(), navigationKind);
            KtPrimaryConstructor primaryConstructor2 = sourceClassOrObject != null ? sourceClassOrObject.getPrimaryConstructor() : null;
            return (KtNamedDeclaration)((Object)(primaryConstructor2 != null ? primaryConstructor2 : sourceClassOrObject));
        }
        String memberNameAsString = declaration2.getName();
        if (memberNameAsString == null) {
            LOG.debug("JetSourceNavigationHelper.convertPropertyOrFunction(): null name for declaration " + declaration2);
            return null;
        }
        Name memberName = Name.identifier(memberNameAsString);
        PsiElement decompiledContainer = declaration2.getParent();
        if (decompiledContainer instanceof KtFile) {
            candidates2 = SourceNavigationHelper.getInitialTopLevelCandidates(declaration2, navigationKind);
        } else if (decompiledContainer instanceof KtClassBody) {
            KtClassOrObject decompiledClassOrObject = (KtClassOrObject)decompiledContainer.getParent();
            KtClassOrObject sourceClassOrObject = SourceNavigationHelper.findClassOrObject(decompiledClassOrObject, navigationKind);
            Collection<Object> collection = candidates2 = sourceClassOrObject == null ? Collections.emptyList() : SourceNavigationHelper.getInitialMemberCandidates(sourceClassOrObject, memberName, declaration2.getClass());
            if (candidates2.isEmpty() && declaration2 instanceof KtProperty && sourceClassOrObject instanceof KtClass) {
                return SourceNavigationHelper.findSpecialProperty(memberName, (KtClass)sourceClassOrObject);
            }
        } else {
            throw new IllegalStateException("Unexpected container of " + (navigationKind == NavigationKind.CLASS_FILES_TO_SOURCES ? "decompiled" : "source") + " declaration: " + decompiledContainer.getClass().getSimpleName());
        }
        if (candidates2.isEmpty()) {
            return null;
        }
        candidates2 = SourceNavigationHelper.filterByOrderEntries(declaration2, candidates2);
        if (!forceResolve) {
            if ((candidates2 = SourceNavigationHelper.filterByReceiverPresenceAndParametersCount(declaration2, candidates2)).size() <= 1) {
                return candidates2.isEmpty() ? null : candidates2.iterator().next();
            }
            if (!SourceNavigationHelper.haveRenamesInImports(SourceNavigationHelper.getContainingFiles(candidates2)) && (candidates2 = SourceNavigationHelper.filterByReceiverAndParameterTypes(declaration2, candidates2)).size() <= 1) {
                return candidates2.isEmpty() ? null : candidates2.iterator().next();
            }
        }
        KotlinCodeAnalyzer analyzer = SourceNavigationHelper.createAnalyzer(candidates2, declaration2.getProject());
        for (KtNamedDeclaration candidate : candidates2) {
            CallableDescriptor candidateDescriptor = (CallableDescriptor)analyzer.resolveToDescriptor(candidate);
            if (!MemberMatching.receiversMatch(declaration2, candidateDescriptor) || !MemberMatching.valueParametersTypesMatch(declaration2, candidateDescriptor) || !MemberMatching.typeParametersMatch((KtTypeParameterListOwner)declaration2, candidateDescriptor.getTypeParameters())) continue;
            return candidate;
        }
        return null;
    }

    @NotNull
    private static KotlinCodeAnalyzer createAnalyzer(@NotNull Collection<KtNamedDeclaration> candidates2, @NotNull Project project) {
        if (candidates2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidates", "org/jetbrains/kotlin/idea/decompiler/navigation/SourceNavigationHelper", "createAnalyzer"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/idea/decompiler/navigation/SourceNavigationHelper", "createAnalyzer"));
        }
        MutableModuleContext newModuleContext = ContextKt.ContextForNewModule(ContextKt.ProjectContext(project), Name.special("<library module>"), DefaultBuiltIns.getInstance(), null);
        newModuleContext.setDependencies(newModuleContext.getModule(), newModuleContext.getModule().getBuiltIns().getBuiltInsModule());
        FileBasedDeclarationProviderFactory providerFactory = new FileBasedDeclarationProviderFactory(newModuleContext.getStorageManager(), SourceNavigationHelper.getContainingFiles(candidates2));
        ResolveSession resolveSession = InjectionKt.createLazyResolveSession(newModuleContext, providerFactory, new BindingTraceContext(), TargetPlatform.Default.INSTANCE, LanguageVersionSettingsImpl.DEFAULT);
        newModuleContext.initializeModuleContents(resolveSession.getPackageFragmentProvider());
        ResolveSession resolveSession2 = resolveSession;
        if (resolveSession2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/decompiler/navigation/SourceNavigationHelper", "createAnalyzer"));
        }
        return resolveSession2;
    }

    @Nullable
    private static <T extends KtNamedDeclaration> T findFirstMatchingInIndex(@NotNull T entity, @NotNull NavigationKind navigationKind, @NotNull StringStubIndexExtension<T> index2) {
        if (entity == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "entity", "org/jetbrains/kotlin/idea/decompiler/navigation/SourceNavigationHelper", "findFirstMatchingInIndex"));
        }
        if (navigationKind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "navigationKind", "org/jetbrains/kotlin/idea/decompiler/navigation/SourceNavigationHelper", "findFirstMatchingInIndex"));
        }
        if (index2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "index", "org/jetbrains/kotlin/idea/decompiler/navigation/SourceNavigationHelper", "findFirstMatchingInIndex"));
        }
        FqName classFqName = entity.getFqName();
        assert (classFqName != null);
        GlobalSearchScope librarySourcesScope = SourceNavigationHelper.createLibraryOrSourcesScope(entity, navigationKind);
        if (librarySourcesScope == GlobalSearchScope.EMPTY_SCOPE) {
            return null;
        }
        Collection classes2 = index2.get((Object)classFqName.asString(), entity.getProject(), librarySourcesScope);
        if (classes2.isEmpty()) {
            return null;
        }
        return (T)((KtNamedDeclaration)classes2.iterator().next());
    }

    @Nullable
    private static KtClassOrObject findClassOrObject(@NotNull KtClassOrObject decompiledClassOrObject, @NotNull NavigationKind navigationKind) {
        if (decompiledClassOrObject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "decompiledClassOrObject", "org/jetbrains/kotlin/idea/decompiler/navigation/SourceNavigationHelper", "findClassOrObject"));
        }
        if (navigationKind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "navigationKind", "org/jetbrains/kotlin/idea/decompiler/navigation/SourceNavigationHelper", "findClassOrObject"));
        }
        return SourceNavigationHelper.findFirstMatchingInIndex(decompiledClassOrObject, navigationKind, KotlinFullClassNameIndex.getInstance());
    }

    @NotNull
    private static Collection<KtNamedDeclaration> getInitialTopLevelCandidates(@NotNull KtNamedDeclaration declaration2, @NotNull NavigationKind navigationKind) {
        if (declaration2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "org/jetbrains/kotlin/idea/decompiler/navigation/SourceNavigationHelper", "getInitialTopLevelCandidates"));
        }
        if (navigationKind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "navigationKind", "org/jetbrains/kotlin/idea/decompiler/navigation/SourceNavigationHelper", "getInitialTopLevelCandidates"));
        }
        FqName memberFqName = declaration2.getFqName();
        assert (memberFqName != null);
        GlobalSearchScope librarySourcesScope = SourceNavigationHelper.createLibraryOrSourcesScope(declaration2, navigationKind);
        if (librarySourcesScope == GlobalSearchScope.EMPTY_SCOPE) {
            List<KtNamedDeclaration> list2 = Collections.emptyList();
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/decompiler/navigation/SourceNavigationHelper", "getInitialTopLevelCandidates"));
            }
            return list2;
        }
        StringStubIndexExtension<? extends KtNamedDeclaration> index2 = SourceNavigationHelper.getIndexForTopLevelPropertyOrFunction(declaration2);
        Collection collection = index2.get((Object)memberFqName.asString(), declaration2.getProject(), librarySourcesScope);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/decompiler/navigation/SourceNavigationHelper", "getInitialTopLevelCandidates"));
        }
        return collection;
    }

    private static StringStubIndexExtension<? extends KtNamedDeclaration> getIndexForTopLevelPropertyOrFunction(@NotNull KtNamedDeclaration decompiledDeclaration) {
        if (decompiledDeclaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "decompiledDeclaration", "org/jetbrains/kotlin/idea/decompiler/navigation/SourceNavigationHelper", "getIndexForTopLevelPropertyOrFunction"));
        }
        if (decompiledDeclaration instanceof KtNamedFunction) {
            return KotlinTopLevelFunctionFqnNameIndex.getInstance();
        }
        if (decompiledDeclaration instanceof KtProperty) {
            return KotlinTopLevelPropertyFqnNameIndex.getInstance();
        }
        throw new IllegalArgumentException("Neither function nor declaration: " + decompiledDeclaration.getClass().getName());
    }

    @NotNull
    private static List<KtNamedDeclaration> getInitialMemberCandidates(@NotNull KtClassOrObject sourceClassOrObject, final @NotNull Name name2, @NotNull Class<KtNamedDeclaration> declarationClass) {
        if (sourceClassOrObject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceClassOrObject", "org/jetbrains/kotlin/idea/decompiler/navigation/SourceNavigationHelper", "getInitialMemberCandidates"));
        }
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/idea/decompiler/navigation/SourceNavigationHelper", "getInitialMemberCandidates"));
        }
        if (declarationClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declarationClass", "org/jetbrains/kotlin/idea/decompiler/navigation/SourceNavigationHelper", "getInitialMemberCandidates"));
        }
        List allByClass = ContainerUtil.findAll(sourceClassOrObject.getDeclarations(), declarationClass);
        List list2 = ContainerUtil.filter((Collection)allByClass, (Condition)new Condition<KtNamedDeclaration>(){

            public boolean value(KtNamedDeclaration declaration2) {
                return name2.equals(declaration2.getNameAsSafeName());
            }
        });
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/decompiler/navigation/SourceNavigationHelper", "getInitialMemberCandidates"));
        }
        return list2;
    }

    @NotNull
    private static List<KtNamedDeclaration> filterByOrderEntries(@NotNull KtNamedDeclaration declaration2, @NotNull Collection<KtNamedDeclaration> candidates2) {
        if (declaration2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "org/jetbrains/kotlin/idea/decompiler/navigation/SourceNavigationHelper", "filterByOrderEntries"));
        }
        if (candidates2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidates", "org/jetbrains/kotlin/idea/decompiler/navigation/SourceNavigationHelper", "filterByOrderEntries"));
        }
        final ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)declaration2.getProject()).getFileIndex();
        final List orderEntries = fileIndex.getOrderEntriesForFile(declaration2.getContainingFile().getVirtualFile());
        List list2 = CollectionsKt.filter(candidates2, (Function1)new Function1<KtNamedDeclaration, Boolean>(){

            public Boolean invoke(KtNamedDeclaration candidate) {
                List candidateOrderEntries = fileIndex.getOrderEntriesForFile(candidate.getContainingFile().getVirtualFile());
                return ContainerUtil.intersects((Collection)orderEntries, (Collection)candidateOrderEntries);
            }
        });
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/decompiler/navigation/SourceNavigationHelper", "filterByOrderEntries"));
        }
        return list2;
    }

    @NotNull
    private static List<KtNamedDeclaration> filterByReceiverPresenceAndParametersCount(final @NotNull KtNamedDeclaration decompiledDeclaration, @NotNull Collection<KtNamedDeclaration> candidates2) {
        if (decompiledDeclaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "decompiledDeclaration", "org/jetbrains/kotlin/idea/decompiler/navigation/SourceNavigationHelper", "filterByReceiverPresenceAndParametersCount"));
        }
        if (candidates2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidates", "org/jetbrains/kotlin/idea/decompiler/navigation/SourceNavigationHelper", "filterByReceiverPresenceAndParametersCount"));
        }
        List list2 = ContainerUtil.filter(candidates2, (Condition)new Condition<KtNamedDeclaration>(){

            public boolean value(KtNamedDeclaration candidate) {
                return MemberMatching.sameReceiverPresenceAndParametersCount(candidate, decompiledDeclaration);
            }
        });
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/decompiler/navigation/SourceNavigationHelper", "filterByReceiverPresenceAndParametersCount"));
        }
        return list2;
    }

    @NotNull
    private static List<KtNamedDeclaration> filterByReceiverAndParameterTypes(final @NotNull KtNamedDeclaration decompiledDeclaration, @NotNull Collection<KtNamedDeclaration> candidates2) {
        if (decompiledDeclaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "decompiledDeclaration", "org/jetbrains/kotlin/idea/decompiler/navigation/SourceNavigationHelper", "filterByReceiverAndParameterTypes"));
        }
        if (candidates2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidates", "org/jetbrains/kotlin/idea/decompiler/navigation/SourceNavigationHelper", "filterByReceiverAndParameterTypes"));
        }
        List list2 = ContainerUtil.filter(candidates2, (Condition)new Condition<KtNamedDeclaration>(){

            public boolean value(KtNamedDeclaration candidate) {
                return MemberMatching.receiverAndParametersShortTypesMatch(candidate, decompiledDeclaration);
            }
        });
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/decompiler/navigation/SourceNavigationHelper", "filterByReceiverAndParameterTypes"));
        }
        return list2;
    }

    public static void setForceResolve(boolean forceResolve) {
        SourceNavigationHelper.forceResolve = forceResolve;
    }

    @Nullable
    public static PsiClass getOriginalPsiClassOrCreateLightClass(@NotNull KtClassOrObject classOrObject) {
        ClassId javaClassId;
        if (classOrObject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classOrObject", "org/jetbrains/kotlin/idea/decompiler/navigation/SourceNavigationHelper", "getOriginalPsiClassOrCreateLightClass"));
        }
        FqName fqName2 = classOrObject.getFqName();
        if (fqName2 != null && (javaClassId = JavaToKotlinClassMap.INSTANCE.mapKotlinToJava(fqName2.toUnsafe())) != null) {
            return JavaPsiFacade.getInstance((Project)classOrObject.getProject()).findClass(javaClassId.asSingleFqName().asString(), GlobalSearchScope.allScope((Project)classOrObject.getProject()));
        }
        return LightClassUtilsKt.toLightClass(classOrObject);
    }

    @Nullable
    public static PsiClass getOriginalClass(@NotNull KtClassOrObject classOrObject) {
        if (classOrObject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classOrObject", "org/jetbrains/kotlin/idea/decompiler/navigation/SourceNavigationHelper", "getOriginalClass"));
        }
        FqName fqName2 = classOrObject.getFqName();
        if (fqName2 == null) {
            return null;
        }
        KtFile file2 = classOrObject.getContainingKtFile();
        VirtualFile vFile = file2.getVirtualFile();
        Project project = file2.getProject();
        final ProjectFileIndex idx = ProjectRootManager.getInstance((Project)project).getFileIndex();
        if (vFile == null || !idx.isInLibrarySource(vFile)) {
            return null;
        }
        THashSet orderEntries = new THashSet((Collection)idx.getOrderEntriesForFile(vFile));
        return JavaPsiFacade.getInstance((Project)project).findClass(fqName2.asString(), new GlobalSearchScope(project, (Set)orderEntries){
            final /* synthetic */ Set val$orderEntries;
            {
                this.val$orderEntries = set;
                super(arg0);
            }

            public int compare(@NotNull VirtualFile file1, @NotNull VirtualFile file2) {
                if (file1 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file1", "org/jetbrains/kotlin/idea/decompiler/navigation/SourceNavigationHelper$5", "compare"));
                }
                if (file2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file2", "org/jetbrains/kotlin/idea/decompiler/navigation/SourceNavigationHelper$5", "compare"));
                }
                return 0;
            }

            public boolean contains(@NotNull VirtualFile file2) {
                if (file2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/idea/decompiler/navigation/SourceNavigationHelper$5", "contains"));
                }
                List entries2 = idx.getOrderEntriesForFile(file2);
                for (OrderEntry entry : entries2) {
                    if (!this.val$orderEntries.contains(entry)) continue;
                    return true;
                }
                return false;
            }

            public boolean isSearchInModuleContent(@NotNull Module aModule) {
                if (aModule == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aModule", "org/jetbrains/kotlin/idea/decompiler/navigation/SourceNavigationHelper$5", "isSearchInModuleContent"));
                }
                return false;
            }

            public boolean isSearchInLibraries() {
                return true;
            }
        });
    }

    @NotNull
    public static KtDeclaration getNavigationElement(@NotNull KtDeclaration declaration2) {
        if (declaration2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "org/jetbrains/kotlin/idea/decompiler/navigation/SourceNavigationHelper", "getNavigationElement"));
        }
        KtDeclaration ktDeclaration = SourceNavigationHelper.navigateToDeclaration(declaration2, NavigationKind.CLASS_FILES_TO_SOURCES);
        if (ktDeclaration == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/decompiler/navigation/SourceNavigationHelper", "getNavigationElement"));
        }
        return ktDeclaration;
    }

    @NotNull
    public static KtDeclaration getOriginalElement(@NotNull KtDeclaration declaration2) {
        if (declaration2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "org/jetbrains/kotlin/idea/decompiler/navigation/SourceNavigationHelper", "getOriginalElement"));
        }
        KtDeclaration ktDeclaration = SourceNavigationHelper.navigateToDeclaration(declaration2, NavigationKind.SOURCES_TO_CLASS_FILES);
        if (ktDeclaration == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/decompiler/navigation/SourceNavigationHelper", "getOriginalElement"));
        }
        return ktDeclaration;
    }

    @NotNull
    public static KtDeclaration navigateToDeclaration(@NotNull KtDeclaration from, @NotNull NavigationKind navigationKind) {
        if (from == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "from", "org/jetbrains/kotlin/idea/decompiler/navigation/SourceNavigationHelper", "navigateToDeclaration"));
        }
        if (navigationKind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "navigationKind", "org/jetbrains/kotlin/idea/decompiler/navigation/SourceNavigationHelper", "navigateToDeclaration"));
        }
        if (DumbService.isDumb((Project)from.getProject())) {
            KtDeclaration ktDeclaration = from;
            if (ktDeclaration == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/decompiler/navigation/SourceNavigationHelper", "navigateToDeclaration"));
            }
            return ktDeclaration;
        }
        switch (navigationKind) {
            case CLASS_FILES_TO_SOURCES: {
                if (from.getContainingKtFile().isCompiled()) break;
                KtDeclaration ktDeclaration = from;
                if (ktDeclaration == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/decompiler/navigation/SourceNavigationHelper", "navigateToDeclaration"));
                }
                return ktDeclaration;
            }
            case SOURCES_TO_CLASS_FILES: {
                if (from.getContainingKtFile().isCompiled()) {
                    KtDeclaration ktDeclaration = from;
                    if (ktDeclaration == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/decompiler/navigation/SourceNavigationHelper", "navigateToDeclaration"));
                    }
                    return ktDeclaration;
                }
                if (!ProjectRootsUtil.isInContent(from, false, true, false, true)) {
                    KtDeclaration ktDeclaration = from;
                    if (ktDeclaration == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/decompiler/navigation/SourceNavigationHelper", "navigateToDeclaration"));
                    }
                    return ktDeclaration;
                }
                if (!KtPsiUtil.isLocal(from)) break;
                KtDeclaration ktDeclaration = from;
                if (ktDeclaration == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/decompiler/navigation/SourceNavigationHelper", "navigateToDeclaration"));
                }
                return ktDeclaration;
            }
        }
        KtDeclaration result2 = from.accept(new SourceAndDecompiledConversionVisitor(navigationKind), null);
        KtDeclaration ktDeclaration = result2 != null ? result2 : from;
        if (ktDeclaration == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/decompiler/navigation/SourceNavigationHelper", "navigateToDeclaration"));
        }
        return ktDeclaration;
    }

    private static class SourceAndDecompiledConversionVisitor
    extends KtVisitor<KtDeclaration, Void> {
        private final NavigationKind navigationKind;

        public SourceAndDecompiledConversionVisitor(@NotNull NavigationKind navigationKind) {
            if (navigationKind == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "navigationKind", "org/jetbrains/kotlin/idea/decompiler/navigation/SourceNavigationHelper$SourceAndDecompiledConversionVisitor", "<init>"));
            }
            this.navigationKind = navigationKind;
        }

        @Override
        public KtDeclaration visitNamedFunction(@NotNull KtNamedFunction function2, Void data) {
            if (function2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "org/jetbrains/kotlin/idea/decompiler/navigation/SourceNavigationHelper$SourceAndDecompiledConversionVisitor", "visitNamedFunction"));
            }
            return SourceNavigationHelper.convertPropertyOrFunction(function2, this.navigationKind);
        }

        @Override
        public KtDeclaration visitProperty(@NotNull KtProperty property2, Void data) {
            if (property2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "org/jetbrains/kotlin/idea/decompiler/navigation/SourceNavigationHelper$SourceAndDecompiledConversionVisitor", "visitProperty"));
            }
            return SourceNavigationHelper.convertPropertyOrFunction(property2, this.navigationKind);
        }

        @Override
        public KtDeclaration visitObjectDeclaration(@NotNull KtObjectDeclaration declaration2, Void data) {
            if (declaration2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "org/jetbrains/kotlin/idea/decompiler/navigation/SourceNavigationHelper$SourceAndDecompiledConversionVisitor", "visitObjectDeclaration"));
            }
            return SourceNavigationHelper.findClassOrObject(declaration2, this.navigationKind);
        }

        @Override
        public KtDeclaration visitClass(@NotNull KtClass klass2, Void data) {
            if (klass2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "klass", "org/jetbrains/kotlin/idea/decompiler/navigation/SourceNavigationHelper$SourceAndDecompiledConversionVisitor", "visitClass"));
            }
            return SourceNavigationHelper.findClassOrObject(klass2, this.navigationKind);
        }

        @Override
        public KtDeclaration visitTypeAlias(@NotNull KtTypeAlias typeAlias2, Void data) {
            if (typeAlias2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeAlias", "org/jetbrains/kotlin/idea/decompiler/navigation/SourceNavigationHelper$SourceAndDecompiledConversionVisitor", "visitTypeAlias"));
            }
            return SourceNavigationHelper.findFirstMatchingInIndex(typeAlias2, this.navigationKind, KotlinTopLevelTypeAliasFqNameIndex.getInstance());
        }

        @Override
        public KtDeclaration visitParameter(@NotNull KtParameter parameter, Void data) {
            if (parameter == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameter", "org/jetbrains/kotlin/idea/decompiler/navigation/SourceNavigationHelper$SourceAndDecompiledConversionVisitor", "visitParameter"));
            }
            KtCallableDeclaration callableDeclaration = (KtCallableDeclaration)parameter.getParent().getParent();
            List<KtParameter> parameters2 = callableDeclaration.getValueParameters();
            int index2 = parameters2.indexOf(parameter);
            KtCallableDeclaration sourceCallable = (KtCallableDeclaration)callableDeclaration.accept(this, null);
            if (sourceCallable == null) {
                return null;
            }
            List<KtParameter> sourceParameters = sourceCallable.getValueParameters();
            if (sourceParameters.size() != parameters2.size()) {
                return null;
            }
            return sourceParameters.get(index2);
        }

        @Override
        public KtDeclaration visitPrimaryConstructor(@NotNull KtPrimaryConstructor constructor2, Void data) {
            if (constructor2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constructor", "org/jetbrains/kotlin/idea/decompiler/navigation/SourceNavigationHelper$SourceAndDecompiledConversionVisitor", "visitPrimaryConstructor"));
            }
            return SourceNavigationHelper.convertPropertyOrFunction(constructor2, this.navigationKind);
        }

        @Override
        public KtDeclaration visitSecondaryConstructor(@NotNull KtSecondaryConstructor constructor2, Void data) {
            if (constructor2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constructor", "org/jetbrains/kotlin/idea/decompiler/navigation/SourceNavigationHelper$SourceAndDecompiledConversionVisitor", "visitSecondaryConstructor"));
            }
            return SourceNavigationHelper.convertPropertyOrFunction(constructor2, this.navigationKind);
        }
    }

    public static enum NavigationKind {
        CLASS_FILES_TO_SOURCES,
        SOURCES_TO_CLASS_FILES;

    }
}

