/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.facet;

import com.intellij.facet.Facet;
import com.intellij.facet.ModifiableFacetModel;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.util.text.VersionComparatorUtil;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.reflect.KDeclarationContainer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.common.arguments.ArgumentUtilsKt;
import org.jetbrains.kotlin.cli.common.arguments.CommonCompilerArguments;
import org.jetbrains.kotlin.cli.common.arguments.K2JSCompilerArguments;
import org.jetbrains.kotlin.cli.common.arguments.K2JVMCompilerArguments;
import org.jetbrains.kotlin.compilerRunner.ArgumentUtils;
import org.jetbrains.kotlin.config.CompilerSettings;
import org.jetbrains.kotlin.config.CoroutineSupport;
import org.jetbrains.kotlin.config.JvmTarget;
import org.jetbrains.kotlin.config.KotlinCompilerInfo;
import org.jetbrains.kotlin.config.KotlinFacetSettings;
import org.jetbrains.kotlin.config.KotlinVersionInfo;
import org.jetbrains.kotlin.config.LanguageVersion;
import org.jetbrains.kotlin.config.TargetPlatformKind;
import org.jetbrains.kotlin.idea.compiler.configuration.Kotlin2JsCompilerArgumentsHolder;
import org.jetbrains.kotlin.idea.compiler.configuration.Kotlin2JvmCompilerArgumentsHolder;
import org.jetbrains.kotlin.idea.compiler.configuration.KotlinCommonCompilerArgumentsHolder;
import org.jetbrains.kotlin.idea.compiler.configuration.KotlinCompilerSettings;
import org.jetbrains.kotlin.idea.facet.FacetUtilsKt;
import org.jetbrains.kotlin.idea.facet.KotlinFacet;
import org.jetbrains.kotlin.idea.facet.KotlinFacetConfiguration;
import org.jetbrains.kotlin.idea.facet.KotlinFacetType;
import org.jetbrains.kotlin.idea.facet.KotlinVersionInfoProviderKt;
import org.jetbrains.kotlin.idea.versions.KotlinRuntimeLibraryUtilKt;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=2, d1={"\u0000V\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u001e\u0010\r\u001a\u0006\u0012\u0002\b\u00030\n2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0002\u001a*\u0010\u0012\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0016\u001a\u00020\u0017\u001a0\u0010\u0018\u001a\u00020\u0013*\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u00022\u0006\u0010\u001a\u001a\u00020\u001b2\f\u0010\u001c\u001a\b\u0012\u0002\b\u0003\u0018\u00010\n2\u0006\u0010\u001d\u001a\u00020\u001e\u001a\u001a\u0010\u001f\u001a\u00020\u0017*\u00020\u000f2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010 \u001a\u00020!\u001a\u001c\u0010\"\u001a\u00020\u0013*\u00020#2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011\"\u0014\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u001e\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\"\u001f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\u0006\u0012\u0002\b\u00030\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006$"}, d2={"commonExposedFields", "", "", "jsExposedFields", "jvmExposedFields", "exposedFields", "Lorg/jetbrains/kotlin/cli/common/arguments/CommonCompilerArguments;", "getExposedFields", "(Lorg/jetbrains/kotlin/cli/common/arguments/CommonCompilerArguments;)Ljava/util/List;", "mavenLibraryIds", "Lorg/jetbrains/kotlin/config/TargetPlatformKind;", "getMavenLibraryIds", "(Lorg/jetbrains/kotlin/config/TargetPlatformKind;)Ljava/util/List;", "getDefaultTargetPlatform", "module", "Lcom/intellij/openapi/module/Module;", "rootModel", "Lcom/intellij/openapi/roots/ModuleRootModel;", "parseCompilerArgumentsToFacet", "", "arguments", "defaultArguments", "kotlinFacet", "Lorg/jetbrains/kotlin/idea/facet/KotlinFacet;", "configureFacet", "compilerVersion", "coroutineSupport", "Lorg/jetbrains/kotlin/config/CoroutineSupport;", "platformKind", "modelsProvider", "Lcom/intellij/openapi/externalSystem/service/project/IdeModifiableModelsProvider;", "getOrCreateFacet", "useProjectSettings", "", "initializeIfNeeded", "Lorg/jetbrains/kotlin/config/KotlinFacetSettings;", "idea"})
public final class FacetUtilsKt {
    private static final List<String> commonExposedFields = CollectionsKt.listOf((Object[])new String[]{"languageVersion", "apiVersion", "suppressWarnings", "coroutinesEnable", "coroutinesWarn", "coroutinesError"});
    private static final List<String> jvmExposedFields = CollectionsKt.plus((Collection)commonExposedFields, (Iterable)CollectionsKt.listOf((Object)"jvmTarget"));
    private static final List<String> jsExposedFields = CollectionsKt.plus((Collection)commonExposedFields, (Iterable)CollectionsKt.listOf((Object[])new String[]{"sourceMap", "outputPrefix", "outputPostfix", "moduleKind"}));

    private static final TargetPlatformKind<?> getDefaultTargetPlatform(Module module, ModuleRootModel rootModel) {
        JavaSdkVersion javaSdkVersion;
        Sdk sdk;
        Collection<String> collection = KotlinVersionInfoProviderKt.getRuntimeLibraryVersions(module, rootModel, TargetPlatformKind.JavaScript.INSTANCE);
        if (!collection.isEmpty()) {
            return TargetPlatformKind.JavaScript.INSTANCE;
        }
        collection = KotlinVersionInfoProviderKt.getRuntimeLibraryVersions(module, rootModel, TargetPlatformKind.Common.INSTANCE);
        if (!collection.isEmpty()) {
            return TargetPlatformKind.Common.INSTANCE;
        }
        ModuleRootModel moduleRootModel = rootModel;
        if (moduleRootModel == null) {
            moduleRootModel = (ModuleRootModel)ModuleRootManager.getInstance((Module)module);
        }
        Sdk sdk2 = sdk = moduleRootModel.getSdk();
        Object object = sdk2 != null ? sdk2.getSdkType() : null;
        if (!(object instanceof JavaSdk)) {
            object = null;
        }
        JavaSdk javaSdk = (JavaSdk)object;
        if (javaSdk != null) {
            Sdk sdk3 = sdk;
            if (sdk3 == null) {
                Intrinsics.throwNpe();
            }
            javaSdkVersion = javaSdk.getVersion(sdk3);
        } else {
            javaSdkVersion = null;
        }
        JavaSdkVersion sdkVersion = javaSdkVersion;
        return sdkVersion == null || sdkVersion.compareTo((Enum)JavaSdkVersion.JDK_1_8) >= 0 ? (TargetPlatformKind)TargetPlatformKind.Jvm.Companion.get(JvmTarget.JVM_1_8) : (TargetPlatformKind)TargetPlatformKind.Jvm.Companion.get(JvmTarget.JVM_1_6);
    }

    public static final void initializeIfNeeded(@NotNull KotlinFacetSettings $receiver, @NotNull Module module, @Nullable ModuleRootModel rootModel) {
        Object object;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
        Project project = module.getProject();
        CommonCompilerArguments commonArguments = (CommonCompilerArguments)KotlinCommonCompilerArgumentsHolder.getInstance(module.getProject()).getSettings();
        Object $receiver2 = object = $receiver.getVersionInfo();
        if (((KotlinVersionInfo)$receiver2).getTargetPlatformKind() == null) {
            ((KotlinVersionInfo)$receiver2).setTargetPlatformKind(FacetUtilsKt.getDefaultTargetPlatform(module, rootModel));
        }
        if (((KotlinVersionInfo)$receiver2).getLanguageLevel() == null) {
            LanguageVersion languageVersion = $receiver.getUseProjectSettings() ? LanguageVersion.Companion.fromVersionString(commonArguments.languageVersion) : null;
            if (languageVersion == null) {
                languageVersion = KotlinVersionInfoProviderKt.getDefaultLanguageLevel$default(module, null, 2, null);
            }
            ((KotlinVersionInfo)$receiver2).setLanguageLevel(languageVersion);
        }
        if (((KotlinVersionInfo)$receiver2).getApiLevel() == null) {
            LanguageVersion languageVersion;
            if ($receiver.getUseProjectSettings()) {
                languageVersion = LanguageVersion.Companion.fromVersionString(commonArguments.apiVersion);
                if (languageVersion == null) {
                    languageVersion = ((KotlinVersionInfo)$receiver2).getLanguageLevel();
                }
            } else {
                LanguageVersion languageVersion2 = ((KotlinVersionInfo)$receiver2).getLanguageLevel();
                if (languageVersion2 == null) {
                    Intrinsics.throwNpe();
                }
                Comparable comparable = (Comparable)((Object)languageVersion2);
                TargetPlatformKind<?> targetPlatformKind = ((KotlinVersionInfo)$receiver2).getTargetPlatformKind();
                if (targetPlatformKind == null) {
                    Intrinsics.throwNpe();
                }
                languageVersion = (LanguageVersion)((Object)RangesKt.coerceAtMost((Comparable)comparable, (Comparable)((Comparable)((Object)KotlinVersionInfoProviderKt.getLibraryLanguageLevel(module, rootModel, targetPlatformKind)))));
            }
            ((KotlinVersionInfo)$receiver2).setApiLevel(languageVersion);
        }
        object = $receiver.getCompilerInfo();
        $receiver2 = (KotlinCompilerInfo)object;
        if (((KotlinCompilerInfo)$receiver2).getCommonCompilerArguments() == null) {
            ((KotlinCompilerInfo)$receiver2).setCommonCompilerArguments(ArgumentUtilsKt.copyBean(commonArguments));
        }
        if (((KotlinCompilerInfo)$receiver2).getCompilerSettings() == null) {
            ((KotlinCompilerInfo)$receiver2).setCompilerSettings((CompilerSettings)ArgumentUtilsKt.copyBean(KotlinCompilerSettings.getInstance(project).getSettings()));
        }
        if (((KotlinCompilerInfo)$receiver2).getK2jsCompilerArguments() == null) {
            ((KotlinCompilerInfo)$receiver2).setK2jsCompilerArguments((K2JSCompilerArguments)ArgumentUtilsKt.copyBean(Kotlin2JsCompilerArgumentsHolder.getInstance(project).getSettings()));
        }
        if (((KotlinCompilerInfo)$receiver2).getK2jvmCompilerArguments() == null) {
            ((KotlinCompilerInfo)$receiver2).setK2jvmCompilerArguments((K2JVMCompilerArguments)ArgumentUtilsKt.copyBean(Kotlin2JvmCompilerArgumentsHolder.getInstance(project).getSettings()));
        }
    }

    @NotNull
    public static final List<String> getMavenLibraryIds(@NotNull TargetPlatformKind<?> $receiver) {
        List list2;
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        TargetPlatformKind<?> targetPlatformKind = $receiver;
        if (targetPlatformKind instanceof TargetPlatformKind.Jvm) {
            list2 = CollectionsKt.listOf((Object[])new String[]{KotlinRuntimeLibraryUtilKt.getMAVEN_STDLIB_ID(), KotlinRuntimeLibraryUtilKt.getMAVEN_STDLIB_ID_JRE7(), KotlinRuntimeLibraryUtilKt.getMAVEN_STDLIB_ID_JRE8()});
        } else if (targetPlatformKind instanceof TargetPlatformKind.JavaScript) {
            list2 = CollectionsKt.listOf((Object[])new String[]{KotlinRuntimeLibraryUtilKt.getMAVEN_JS_STDLIB_ID(), KotlinRuntimeLibraryUtilKt.getMAVEN_OLD_JS_STDLIB_ID()});
        } else if (targetPlatformKind instanceof TargetPlatformKind.Common) {
            list2 = CollectionsKt.listOf((Object)KotlinRuntimeLibraryUtilKt.getMAVEN_COMMON_STDLIB_ID());
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return list2;
    }

    @NotNull
    public static final KotlinFacet getOrCreateFacet(@NotNull Module $receiver, @NotNull IdeModifiableModelsProvider modelsProvider, boolean useProjectSettings) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)modelsProvider, (String)"modelsProvider");
        ModifiableFacetModel facetModel = modelsProvider.getModifiableFacetModel($receiver);
        KotlinFacet kotlinFacet = (KotlinFacet)facetModel.findFacet(KotlinFacetType.Companion.getTYPE_ID(), KotlinFacetType.Companion.getINSTANCE().getDefaultFacetName());
        if (kotlinFacet == null) {
            Object object;
            Object $receiver2 = object = KotlinFacetType.Companion.getINSTANCE();
            String string = $receiver2.getDefaultFacetName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"defaultFacetName");
            object = $receiver2.createFacet($receiver, string, $receiver2.createDefaultConfiguration(), (Facet<?>)null);
            $receiver2 = (KotlinFacet)((Object)object);
            facetModel.addFacet((Facet)$receiver2);
            kotlinFacet = (KotlinFacet)((Object)object);
        }
        KotlinFacet facet = kotlinFacet;
        ((KotlinFacetConfiguration)facet.getConfiguration()).getSettings().setUseProjectSettings(useProjectSettings);
        KotlinFacet kotlinFacet2 = facet;
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)kotlinFacet2), (String)"facet");
        return kotlinFacet2;
    }

    public static final void configureFacet(@NotNull KotlinFacet $receiver, @NotNull String compilerVersion, @NotNull CoroutineSupport coroutineSupport, @Nullable TargetPlatformKind<?> platformKind, @NotNull IdeModifiableModelsProvider modelsProvider) {
        block7: {
            KotlinVersionInfo kotlinVersionInfo;
            KotlinFacetSettings kotlinFacetSettings;
            Intrinsics.checkParameterIsNotNull((Object)((Object)$receiver), (String)"$receiver");
            Intrinsics.checkParameterIsNotNull((Object)compilerVersion, (String)"compilerVersion");
            Intrinsics.checkParameterIsNotNull((Object)coroutineSupport, (String)"coroutineSupport");
            Intrinsics.checkParameterIsNotNull((Object)modelsProvider, (String)"modelsProvider");
            Module module = $receiver.getModule();
            KotlinFacetSettings $receiver2 = kotlinFacetSettings = ((KotlinFacetConfiguration)$receiver.getConfiguration()).getSettings();
            $receiver2.getVersionInfo().setTargetPlatformKind(platformKind);
            $receiver2.getVersionInfo().setApiLevel(null);
            Module module2 = module;
            Intrinsics.checkExpressionValueIsNotNull((Object)module2, (String)"module");
            FacetUtilsKt.initializeIfNeeded($receiver2, module2, (ModuleRootModel)modelsProvider.getModifiableRootModel(module));
            KotlinVersionInfo $receiver3 = kotlinVersionInfo = $receiver2.getVersionInfo();
            LanguageVersion languageVersion = LanguageVersion.Companion.fromFullVersionString(compilerVersion);
            if (languageVersion == null) {
                languageVersion = LanguageVersion.LATEST;
            }
            $receiver3.setLanguageLevel(languageVersion);
            LanguageVersion languageVersion2 = $receiver3.getApiLevel();
            if (languageVersion2 == null) {
                Intrinsics.throwNpe();
            }
            LanguageVersion languageVersion3 = $receiver3.getLanguageLevel();
            if (languageVersion3 == null) {
                Intrinsics.throwNpe();
            }
            if (languageVersion2.compareTo((Enum)languageVersion3) > 0) {
                $receiver3.setApiLevel($receiver3.getLanguageLevel());
            }
            $receiver2.getCompilerInfo().setCoroutineSupport(coroutineSupport);
            if ($receiver2.getCompilerInfo().getCommonCompilerArguments() != null) {
                LanguageVersion languageVersion4 = $receiver2.getVersionInfo().getLanguageLevel();
                if (languageVersion4 == null) {
                    Intrinsics.throwNpe();
                }
                $receiver2.getCompilerInfo().getCommonCompilerArguments().languageVersion = languageVersion4.getVersionString();
            }
            if ($receiver2.getCompilerInfo().getCommonCompilerArguments() == null) break block7;
            LanguageVersion languageVersion5 = $receiver2.getVersionInfo().getApiLevel();
            if (languageVersion5 == null) {
                Intrinsics.throwNpe();
            }
            $receiver2.getCompilerInfo().getCommonCompilerArguments().apiVersion = languageVersion5.getVersionString();
        }
    }

    private static final List<String> getExposedFields(@NotNull CommonCompilerArguments $receiver) {
        CommonCompilerArguments commonCompilerArguments = $receiver;
        return commonCompilerArguments instanceof K2JVMCompilerArguments ? jvmExposedFields : (commonCompilerArguments instanceof K2JSCompilerArguments ? jsExposedFields : commonExposedFields);
    }

    /*
     * WARNING - void declaration
     */
    public static final void parseCompilerArgumentsToFacet(@NotNull List<String> arguments2, @NotNull List<String> defaultArguments, @NotNull KotlinFacet kotlinFacet) {
        Object object;
        Object it;
        String $i$f$toTypedArray;
        Collection $receiver$iv;
        KotlinFacetSettings kotlinFacetSettings;
        Collection $receiver$iv2;
        Intrinsics.checkParameterIsNotNull(arguments2, (String)"arguments");
        Intrinsics.checkParameterIsNotNull(defaultArguments, (String)"defaultArguments");
        Intrinsics.checkParameterIsNotNull((Object)((Object)kotlinFacet), (String)"kotlinFacet");
        Collection collection = $receiver$iv2 = (Collection)arguments2;
        if (collection == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
        }
        Collection thisCollection$iv = collection;
        String[] stringArray = thisCollection$iv.toArray(new String[thisCollection$iv.size()]);
        if (stringArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        String[] argumentArray = (String[])((Object[])stringArray);
        KotlinFacetSettings $receiver = kotlinFacetSettings = ((KotlinFacetConfiguration)kotlinFacet.getConfiguration()).getSettings();
        CommonCompilerArguments commonCompilerArguments = $receiver.getCompilerInfo().getCommonCompilerArguments();
        if (commonCompilerArguments == null) {
            Intrinsics.throwNpe();
        }
        CommonCompilerArguments commonCompilerArguments2 = commonCompilerArguments;
        TargetPlatformKind<?> targetPlatformKind = $receiver.getVersionInfo().getTargetPlatformKind();
        CommonCompilerArguments commonCompilerArguments3 = targetPlatformKind instanceof TargetPlatformKind.Jvm ? (CommonCompilerArguments)$receiver.getCompilerInfo().getK2jvmCompilerArguments() : (targetPlatformKind instanceof TargetPlatformKind.JavaScript ? (CommonCompilerArguments)$receiver.getCompilerInfo().getK2jsCompilerArguments() : commonCompilerArguments2);
        if (commonCompilerArguments3 == null) {
            Intrinsics.throwNpe();
        }
        CommonCompilerArguments compilerArguments = commonCompilerArguments3;
        CommonCompilerArguments defaultCompilerArguments = (CommonCompilerArguments)compilerArguments.getClass().newInstance();
        Collection collection2 = $receiver$iv = (Collection)defaultArguments;
        if (collection2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
        }
        Collection thisCollection$iv2 = collection2;
        String[] stringArray2 = thisCollection$iv2.toArray(new String[thisCollection$iv2.size()]);
        if (stringArray2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        ArgumentUtilsKt.parseArguments((String[])((Object[])stringArray2), defaultCompilerArguments, true);
        CoroutineSupport oldCoroutineSupport = CoroutineSupport.Companion.byCompilerArguments(commonCompilerArguments2);
        commonCompilerArguments2.coroutinesEnable = false;
        commonCompilerArguments2.coroutinesWarn = false;
        commonCompilerArguments2.coroutinesError = false;
        if (Intrinsics.areEqual((Object)compilerArguments, (Object)commonCompilerArguments2) ^ true) {
            compilerArguments.coroutinesEnable = false;
            compilerArguments.coroutinesWarn = false;
            compilerArguments.coroutinesError = false;
        }
        ArgumentUtilsKt.parseArguments(argumentArray, compilerArguments, true);
        boolean restoreCoroutineSupport = !compilerArguments.coroutinesEnable && !compilerArguments.coroutinesWarn && !compilerArguments.coroutinesError;
        String string = compilerArguments.apiVersion;
        if (string != null) {
            $i$f$toTypedArray = string;
            it = $i$f$toTypedArray;
            $receiver.getVersionInfo().setApiLevel(LanguageVersion.Companion.fromVersionString((String)it));
        }
        String string2 = compilerArguments.languageVersion;
        if (string2 != null) {
            $i$f$toTypedArray = string2;
            it = $i$f$toTypedArray;
            $receiver.getVersionInfo().setLanguageLevel(LanguageVersion.Companion.fromVersionString((String)it));
        }
        if ($receiver.getVersionInfo().getTargetPlatformKind() instanceof TargetPlatformKind.Jvm) {
            String jvmTarget;
            K2JVMCompilerArguments k2JVMCompilerArguments = $receiver.getCompilerInfo().getK2jvmCompilerArguments();
            if (k2JVMCompilerArguments == null) {
                Intrinsics.throwNpe();
            }
            if ((jvmTarget = k2JVMCompilerArguments.jvmTarget) != null) {
                Object v9;
                block15: {
                    void $receiver$iv3;
                    it = TargetPlatformKind.Jvm.Companion.getJVM_PLATFORMS();
                    object = $receiver.getVersionInfo();
                    for (Object element$iv : $receiver$iv3) {
                        TargetPlatformKind.Jvm it2 = (TargetPlatformKind.Jvm)element$iv;
                        if (!(VersionComparatorUtil.compare((String)((JvmTarget)it2.getVersion()).getDescription(), (String)jvmTarget) >= 0)) continue;
                        v9 = element$iv;
                        break block15;
                    }
                    v9 = null;
                }
                Object var17_18 = v9;
                TargetPlatformKind.Jvm jvm = var17_18;
                ((KotlinVersionInfo)object).setTargetPlatformKind(jvm != null ? (TargetPlatformKind)jvm : (TargetPlatformKind)CollectionsKt.last(TargetPlatformKind.Jvm.Companion.getJVM_PLATFORMS()));
            }
        }
        List<String> exposedFields = FacetUtilsKt.getExposedFields(compilerArguments);
        Function1<Field, Boolean> exposeAsAdditionalArgument$ = new Function1<Field, Boolean>(exposedFields, compilerArguments, defaultCompilerArguments){
            final /* synthetic */ List $exposedFields;
            final /* synthetic */ CommonCompilerArguments $compilerArguments;
            final /* synthetic */ CommonCompilerArguments $defaultCompilerArguments;

            public final boolean invoke(@NotNull Field field2) {
                Intrinsics.checkParameterIsNotNull((Object)field2, (String)"field");
                return this.$exposedFields.contains(field2.getName()) ^ true && Intrinsics.areEqual((Object)field2.get(this.$compilerArguments), (Object)field2.get(this.$defaultCompilerArguments)) ^ true;
            }
            {
                this.$exposedFields = list2;
                this.$compilerArguments = commonCompilerArguments;
                this.$defaultCompilerArguments = commonCompilerArguments2;
                super(1);
            }
        };
        Object object2 = compilerArguments.getClass().newInstance();
        CommonCompilerArguments $receiver2 = (CommonCompilerArguments)object2;
        ArgumentUtilsKt.copyFieldsSatisfying(compilerArguments, $receiver2, (Function1<? super Field, Boolean>)((Function1)new Function1<Field, Boolean>(compilerArguments, exposeAsAdditionalArgument$){
            final /* synthetic */ CommonCompilerArguments $compilerArguments$inlined;
            final /* synthetic */ parseCompilerArgumentsToFacet.1.4 $exposeAsAdditionalArgument$inlined;
            {
                this.$compilerArguments$inlined = commonCompilerArguments;
                this.$exposeAsAdditionalArgument$inlined = var2_2;
                super(1);
            }

            public final boolean invoke(Field p1) {
                return this.$exposeAsAdditionalArgument$inlined.invoke(p1);
            }

            public final KDeclarationContainer getOwner() {
                return null;
            }

            public final String getName() {
                return "exposeAsAdditionalArgument";
            }

            public final String getSignature() {
                return "invoke(Ljava/lang/reflect/Field;)Z";
            }
        }));
        String additionalArgumentsString = CollectionsKt.joinToString$default((Iterable)ArgumentUtils.convertArgumentsToStringList($receiver2), (CharSequence)" ", null, null, (int)0, null, null, (int)62, null);
        CompilerSettings compilerSettings = $receiver.getCompilerInfo().getCompilerSettings();
        if (compilerSettings == null) {
            Intrinsics.throwNpe();
        }
        object2 = additionalArgumentsString;
        object = compilerSettings;
        boolean bl = object2.length() > 0;
        ((CompilerSettings)object).additionalArguments = bl ? additionalArgumentsString : CompilerSettings.Companion.getDEFAULT_ADDITIONAL_ARGUMENTS();
        object2 = compilerArguments.getClass().newInstance();
        $receiver2 = (CommonCompilerArguments)object2;
        ArgumentUtilsKt.copyFieldsSatisfying($receiver2, compilerArguments, (Function1<? super Field, Boolean>)((Function1)new Function1<Field, Boolean>(compilerArguments, exposeAsAdditionalArgument$){
            final /* synthetic */ CommonCompilerArguments $compilerArguments$inlined;
            final /* synthetic */ parseCompilerArgumentsToFacet.1.4 $exposeAsAdditionalArgument$inlined;
            {
                this.$compilerArguments$inlined = commonCompilerArguments;
                this.$exposeAsAdditionalArgument$inlined = var2_2;
                super(1);
            }

            public final boolean invoke(Field p1) {
                return this.$exposeAsAdditionalArgument$inlined.invoke(p1);
            }

            public final KDeclarationContainer getOwner() {
                return null;
            }

            public final String getName() {
                return "exposeAsAdditionalArgument";
            }

            public final String getSignature() {
                return "invoke(Ljava/lang/reflect/Field;)Z";
            }
        }));
        ArgumentUtilsKt.copyInheritedFields(compilerArguments, commonCompilerArguments2);
        if (restoreCoroutineSupport) {
            $receiver.getCompilerInfo().setCoroutineSupport(oldCoroutineSupport);
        }
    }
}

