/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.formatter;

import com.intellij.formatting.ASTBlock;
import com.intellij.formatting.Alignment;
import com.intellij.formatting.Block;
import com.intellij.formatting.ChildAttributes;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Spacing;
import com.intellij.formatting.Wrap;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.formatter.KotlinSpacingBuilder;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001BU\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00010\u0010\u00a2\u0006\u0002\u0010\u0011J\n\u0010\u0014\u001a\u0004\u0018\u00010\bH\u0016J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\n\u0010\u0019\u001a\u0004\u0018\u00010\nH\u0016J\b\u0010\u001a\u001a\u00020\u0003H\u0016J\u001c\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u001e\u001a\u00020\u0006H\u0016J\u000e\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0016J\b\u0010 \u001a\u00020\u0013H\u0016J\n\u0010!\u001a\u0004\u0018\u00010\fH\u0016J\b\u0010\"\u001a\u00020#H\u0016J\b\u0010$\u001a\u00020#H\u0016J\b\u0010%\u001a\u00020&H\u0016R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00010\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lorg/jetbrains/kotlin/idea/formatter/SyntheticKotlinBlock;", "Lcom/intellij/formatting/ASTBlock;", "node", "Lcom/intellij/lang/ASTNode;", "subBlocks", "", "Lcom/intellij/formatting/Block;", "alignment", "Lcom/intellij/formatting/Alignment;", "indent", "Lcom/intellij/formatting/Indent;", "wrap", "Lcom/intellij/formatting/Wrap;", "spacingBuilder", "Lorg/jetbrains/kotlin/idea/formatter/KotlinSpacingBuilder;", "createSyntheticSpacingNodeBlock", "Lkotlin/Function1;", "(Lcom/intellij/lang/ASTNode;Ljava/util/List;Lcom/intellij/formatting/Alignment;Lcom/intellij/formatting/Indent;Lcom/intellij/formatting/Wrap;Lorg/jetbrains/kotlin/idea/formatter/KotlinSpacingBuilder;Lkotlin/jvm/functions/Function1;)V", "textRange", "Lcom/intellij/openapi/util/TextRange;", "getAlignment", "getChildAttributes", "Lcom/intellij/formatting/ChildAttributes;", "newChildIndex", "", "getIndent", "getNode", "getSpacing", "Lcom/intellij/formatting/Spacing;", "child1", "child2", "getSubBlocks", "getTextRange", "getWrap", "isIncomplete", "", "isLeaf", "toString", "", "formatter"})
public final class SyntheticKotlinBlock
implements ASTBlock {
    private final TextRange textRange;
    private final ASTNode node;
    private final List<Block> subBlocks;
    private final Alignment alignment;
    private final Indent indent;
    private final Wrap wrap;
    private final KotlinSpacingBuilder spacingBuilder;
    private final Function1<ASTNode, ASTBlock> createSyntheticSpacingNodeBlock;

    @NotNull
    public TextRange getTextRange() {
        return this.textRange;
    }

    @NotNull
    public List<Block> getSubBlocks() {
        return this.subBlocks;
    }

    @Nullable
    public Wrap getWrap() {
        return this.wrap;
    }

    @Nullable
    public Indent getIndent() {
        return this.indent;
    }

    @Nullable
    public Alignment getAlignment() {
        return this.alignment;
    }

    @NotNull
    public ChildAttributes getChildAttributes(int newChildIndex) {
        return new ChildAttributes(this.getIndent(), null);
    }

    public boolean isIncomplete() {
        return ((Block)CollectionsKt.last(this.getSubBlocks())).isIncomplete();
    }

    public boolean isLeaf() {
        return false;
    }

    @NotNull
    public ASTNode getNode() {
        return this.node;
    }

    @Nullable
    public Spacing getSpacing(@Nullable Block child1, @NotNull Block child2) {
        Intrinsics.checkParameterIsNotNull((Object)child2, (String)"child2");
        ASTNode aSTNode = this.node.getTreeParent();
        if (aSTNode == null) {
            Intrinsics.throwNpe();
        }
        return this.spacingBuilder.getSpacing((Block)this.createSyntheticSpacingNodeBlock.invoke((Object)aSTNode), child1, child2);
    }

    @NotNull
    public String toString() {
        PsiFile file2;
        PsiElement psi;
        Block child = (Block)CollectionsKt.first(this.subBlocks);
        ASTNode treeNode = null;
        while (treeNode == null) {
            Block block = child;
            if (block instanceof SyntheticKotlinBlock) {
                child = (Block)CollectionsKt.first(((SyntheticKotlinBlock)child).getSubBlocks());
                continue;
            }
            if (!(block instanceof ASTBlock)) break;
            treeNode = ((ASTBlock)child).getNode();
        }
        TextRange textRange = this.getTextRange();
        if (treeNode != null && (psi = treeNode.getPsi()) != null && (file2 = psi.getContainingFile()) != null) {
            StringBuilder stringBuilder = new StringBuilder();
            String string = file2.getText();
            if (string == null) {
                Intrinsics.throwNpe();
            }
            return stringBuilder.append(((Object)string.subSequence(textRange.getStartOffset(), textRange.getEndOffset())).toString()).append(" ").append(textRange).toString();
        }
        return this.getClass().getName() + ": " + textRange;
    }

    public SyntheticKotlinBlock(@NotNull ASTNode node, @NotNull List<Block> subBlocks, @Nullable Alignment alignment, @Nullable Indent indent, @Nullable Wrap wrap, @NotNull KotlinSpacingBuilder spacingBuilder, @NotNull Function1<? super ASTNode, ? extends ASTBlock> createSyntheticSpacingNodeBlock2) {
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        Intrinsics.checkParameterIsNotNull(subBlocks, (String)"subBlocks");
        Intrinsics.checkParameterIsNotNull((Object)spacingBuilder, (String)"spacingBuilder");
        Intrinsics.checkParameterIsNotNull(createSyntheticSpacingNodeBlock2, (String)"createSyntheticSpacingNodeBlock");
        this.node = node;
        this.subBlocks = subBlocks;
        this.alignment = alignment;
        this.indent = indent;
        this.wrap = wrap;
        this.spacingBuilder = spacingBuilder;
        this.createSyntheticSpacingNodeBlock = createSyntheticSpacingNodeBlock2;
        this.textRange = new TextRange(((Block)CollectionsKt.first(this.subBlocks)).getTextRange().getStartOffset(), ((Block)CollectionsKt.last(this.subBlocks)).getTextRange().getEndOffset());
    }
}

