/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.framework.ui;

import com.google.common.collect.Lists;
import com.google.common.io.Closeables;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.net.HttpConfigurable;
import com.intellij.util.text.VersionComparatorUtil;
import com.intellij.util.ui.AsyncProcessIcon;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.configuration.ConfigureKotlinInProjectUtilsKt;
import org.jetbrains.kotlin.idea.configuration.KotlinProjectConfigurator;
import org.jetbrains.kotlin.idea.framework.ui.ChooseModulePanel;
import org.jetbrains.kotlin.idea.versions.KotlinRuntimeLibraryUtilKt;

public class ConfigureDialogWithModulesAndVersion
extends DialogWrapper {
    private static final String VERSIONS_LIST_URL = "http://search.maven.org/solrsearch/select?q=g:%22org.jetbrains.kotlin%22+AND+a:%22kotlin-runtime%22&core=gav&rows=20&wt=json";
    private static final String EAP_VERSIONS_URL = "https://bintray.com/kotlin/kotlin-eap/kotlin/";
    private final ChooseModulePanel chooseModulePanel;
    private JPanel contentPane;
    private JPanel chooseModulesPanelPlace;
    private JComboBox kotlinVersionComboBox;
    private JPanel infoPanel;
    private final AsyncProcessIcon processIcon;

    public ConfigureDialogWithModulesAndVersion(@NotNull Project project, @NotNull KotlinProjectConfigurator configurator, @NotNull Collection<Module> excludeModules) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/idea/framework/ui/ConfigureDialogWithModulesAndVersion", "<init>"));
        }
        if (configurator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configurator", "org/jetbrains/kotlin/idea/framework/ui/ConfigureDialogWithModulesAndVersion", "<init>"));
        }
        if (excludeModules == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "excludeModules", "org/jetbrains/kotlin/idea/framework/ui/ConfigureDialogWithModulesAndVersion", "<init>"));
        }
        super(project);
        this.$$$setupUI$$$();
        this.processIcon = new AsyncProcessIcon("loader");
        this.setTitle("Configure Kotlin in Project");
        this.init();
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(project, "Find Kotlin Maven plugin versions", false){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "org/jetbrains/kotlin/idea/framework/ui/ConfigureDialogWithModulesAndVersion$1", "run"));
                }
                ConfigureDialogWithModulesAndVersion.this.loadKotlinVersions();
            }
        });
        this.kotlinVersionComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(@NotNull ActionEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/kotlin/idea/framework/ui/ConfigureDialogWithModulesAndVersion$2", "actionPerformed"));
                }
                ConfigureDialogWithModulesAndVersion.this.updateComponents();
            }
        });
        this.kotlinVersionComboBox.addItem("loading...");
        this.kotlinVersionComboBox.setEnabled(false);
        this.processIcon.resume();
        this.infoPanel.add((Component)this.processIcon, "Center");
        this.chooseModulePanel = new ChooseModulePanel(project, configurator, excludeModules);
        this.chooseModulesPanelPlace.add((Component)this.chooseModulePanel.getContentPane(), "Center");
        this.updateComponents();
    }

    public List<Module> getModulesToConfigure() {
        return this.chooseModulePanel.getModulesToConfigure();
    }

    public String getKotlinVersion() {
        return (String)this.kotlinVersionComboBox.getSelectedItem();
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return this.contentPane;
    }

    private void loadKotlinVersions() {
        Collection<String> items;
        try {
            items = ConfigureDialogWithModulesAndVersion.loadVersions();
            this.hideLoader();
        }
        catch (Throwable t) {
            items = Collections.singletonList("1.0.0");
            this.showWarning();
        }
        this.updateVersions(items);
    }

    private void hideLoader() {
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                ConfigureDialogWithModulesAndVersion.this.infoPanel.setVisible(false);
                ConfigureDialogWithModulesAndVersion.this.infoPanel.updateUI();
            }
        }, ModalityState.stateForComponent((Component)this.infoPanel));
    }

    private void showWarning() {
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                ConfigureDialogWithModulesAndVersion.this.infoPanel.remove((Component)ConfigureDialogWithModulesAndVersion.this.processIcon);
                ConfigureDialogWithModulesAndVersion.this.infoPanel.add((Component)new JLabel(UIUtil.getBalloonWarningIcon()), "Center");
                ConfigureDialogWithModulesAndVersion.this.infoPanel.setToolTipText("Couldn't load versions list from search.maven.org");
                ConfigureDialogWithModulesAndVersion.this.infoPanel.setCursor(Cursor.getPredefinedCursor(12));
                ConfigureDialogWithModulesAndVersion.this.infoPanel.updateUI();
            }
        }, ModalityState.stateForComponent((Component)this.infoPanel));
    }

    private void updateVersions(final @NotNull Collection<String> newItems) {
        if (newItems == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newItems", "org/jetbrains/kotlin/idea/framework/ui/ConfigureDialogWithModulesAndVersion", "updateVersions"));
        }
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                ConfigureDialogWithModulesAndVersion.this.kotlinVersionComboBox.removeAllItems();
                ConfigureDialogWithModulesAndVersion.this.kotlinVersionComboBox.setEnabled(true);
                for (String newItem : newItems) {
                    ConfigureDialogWithModulesAndVersion.this.kotlinVersionComboBox.addItem(newItem);
                }
                ConfigureDialogWithModulesAndVersion.this.kotlinVersionComboBox.setSelectedIndex(0);
            }
        }, ModalityState.stateForComponent((Component)this.kotlinVersionComboBox));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    protected static Collection<String> loadVersions() throws Exception {
        int timeout;
        ArrayList versions = Lists.newArrayList();
        String bundledRuntimeVersion = KotlinRuntimeLibraryUtilKt.bundledRuntimeVersion();
        if (ConfigureKotlinInProjectUtilsKt.isEap(bundledRuntimeVersion)) {
            HttpURLConnection eapConnection = HttpConfigurable.getInstance().openHttpConnection(EAP_VERSIONS_URL + bundledRuntimeVersion);
            try {
                timeout = (int)TimeUnit.SECONDS.toMillis(30L);
                eapConnection.setConnectTimeout(timeout);
                eapConnection.setReadTimeout(timeout);
                if (eapConnection.getResponseCode() == 200) {
                    versions.add(bundledRuntimeVersion);
                }
            }
            finally {
                eapConnection.disconnect();
            }
        }
        HttpURLConnection urlConnection = HttpConfigurable.getInstance().openHttpConnection(VERSIONS_LIST_URL);
        try {
            timeout = (int)TimeUnit.SECONDS.toMillis(30L);
            urlConnection.setConnectTimeout(timeout);
            urlConnection.setReadTimeout(timeout);
            urlConnection.connect();
            InputStreamReader streamReader = new InputStreamReader(urlConnection.getInputStream());
            try {
                JsonElement rootElement = new JsonParser().parse((Reader)streamReader);
                JsonArray docsElements = rootElement.getAsJsonObject().get("response").getAsJsonObject().get("docs").getAsJsonArray();
                for (JsonElement element2 : docsElements) {
                    String versionNumber = element2.getAsJsonObject().get("v").getAsString();
                    if (VersionComparatorUtil.compare((String)"1.0.0", (String)versionNumber) > 0) continue;
                    versions.add(versionNumber);
                }
            }
            finally {
                Closeables.closeQuietly((Reader)streamReader);
            }
        }
        finally {
            urlConnection.disconnect();
        }
        ArrayList arrayList = versions;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/framework/ui/ConfigureDialogWithModulesAndVersion", "loadVersions"));
        }
        return arrayList;
    }

    private void updateComponents() {
        this.setOKActionEnabled(this.kotlinVersionComboBox.isEnabled());
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JPanel jPanel2;
        JComboBox jComboBox;
        JPanel jPanel3;
        this.contentPane = jPanel3 = new JPanel();
        jPanel3.setLayout(new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        Spacer spacer = new Spacer();
        jPanel3.add((Component)spacer, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new GridLayoutManager(1, 3, new Insets(10, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel4, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JLabel jLabel = new JLabel();
        jLabel.setText("Kotlin compiler and runtime version:");
        jPanel4.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.kotlinVersionComboBox = jComboBox = new JComboBox();
        jPanel4.add(jComboBox, new GridConstraints(0, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        this.infoPanel = jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(0, 0));
        jPanel4.add((Component)jPanel2, new GridConstraints(0, 2, 1, 1, 0, 3, 0, 0, new Dimension(20, -1), new Dimension(20, -1), new Dimension(20, -1)));
        this.chooseModulesPanelPlace = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel3.add((Component)jPanel, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        ButtonGroup buttonGroup = new ButtonGroup();
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.contentPane;
    }
}

