/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.intentions;

import com.intellij.openapi.editor.Editor;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.intentions.SelfTargetingOffsetIndependentIntention;
import org.jetbrains.kotlin.idea.intentions.UtilsKt;
import org.jetbrains.kotlin.psi.CreateByPatternKt;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtParenthesizedExpression;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.psi.KtValueArgument;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b&\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0007J\u001a\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00022\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\r\u001a\u00020\u0002H\u0016R\u0011\u0010\u0006\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\t\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/idea/intentions/ReplaceMathMethodsWithKotlinNativeMethodsIntention;", "Lorg/jetbrains/kotlin/idea/intentions/SelfTargetingOffsetIndependentIntention;", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "text", "", "replacedMethodName", "mathMethodName", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getMathMethodName", "()Ljava/lang/String;", "getReplacedMethodName", "applyTo", "", "element", "editor", "Lcom/intellij/openapi/editor/Editor;", "isApplicableTo", "", "idea"})
public abstract class ReplaceMathMethodsWithKotlinNativeMethodsIntention
extends SelfTargetingOffsetIndependentIntention<KtCallExpression> {
    @NotNull
    private final String replacedMethodName;
    @NotNull
    private final String mathMethodName;

    @Override
    public void applyTo(@NotNull KtCallExpression element2, @Nullable Editor editor) {
        Object object;
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        PsiElement $receiver$iv = (PsiElement)element2;
        KtDotQualifiedExpression ktDotQualifiedExpression = (KtDotQualifiedExpression)PsiTreeUtil.getParentOfType((PsiElement)$receiver$iv, KtDotQualifiedExpression.class, (boolean)true);
        NavigatablePsiElement target = ktDotQualifiedExpression != null ? (NavigatablePsiElement)ktDotQualifiedExpression : (NavigatablePsiElement)element2;
        List<KtValueArgument> valueArguments2 = element2.getValueArguments();
        String methodName = this.replacedMethodName;
        KtPsiFactory ktPsiFactory = KtPsiFactoryKt.KtPsiFactory((PsiElement)element2);
        String string = "$" + "0." + methodName + "(" + "$" + "1)";
        Object[] objectArray = new Object[2];
        String string2 = valueArguments2.get(0).getText();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"valueArguments[0].text");
        objectArray[0] = string2;
        String string3 = valueArguments2.get(1).getText();
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"valueArguments[1].text");
        objectArray[1] = string3;
        KtExpression newExpression2 = CreateByPatternKt.createExpressionByPattern(ktPsiFactory, string, objectArray);
        PsiElement $receiver$iv2 = (PsiElement)target;
        PsiElement result$iv = $receiver$iv2.replace((PsiElement)newExpression2);
        if (result$iv instanceof KtExpression) {
            object = result$iv;
        } else {
            PsiElement psiElement2 = result$iv;
            if (psiElement2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtParenthesizedExpression");
            }
            KtExpression ktExpression = ((KtParenthesizedExpression)psiElement2).getExpression();
            if (ktExpression == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtExpression");
            }
            object = ktExpression;
        }
    }

    @Override
    public boolean isApplicableTo(@NotNull KtCallExpression element2) {
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        KtExpression ktExpression = element2.getCalleeExpression();
        return Intrinsics.areEqual((Object)(ktExpression != null ? ktExpression.getText() : null), (Object)this.mathMethodName) && element2.getValueArguments().size() == 2 && UtilsKt.isMethodCall(element2, "java.lang.Math." + this.mathMethodName);
    }

    @NotNull
    public final String getReplacedMethodName() {
        return this.replacedMethodName;
    }

    @NotNull
    public final String getMathMethodName() {
        return this.mathMethodName;
    }

    public ReplaceMathMethodsWithKotlinNativeMethodsIntention(@NotNull String text2, @NotNull String replacedMethodName, @NotNull String mathMethodName) {
        Intrinsics.checkParameterIsNotNull((Object)text2, (String)"text");
        Intrinsics.checkParameterIsNotNull((Object)replacedMethodName, (String)"replacedMethodName");
        Intrinsics.checkParameterIsNotNull((Object)mathMethodName, (String)"mathMethodName");
        super(KtCallExpression.class, text2, null, 4, null);
        this.replacedMethodName = replacedMethodName;
        this.mathMethodName = mathMethodName;
    }
}

