/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.intentions;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.intentions.SelfTargetingRangeIntention;
import org.jetbrains.kotlin.lexer.KtSingleValueToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.CreateByPatternKt;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtIsExpression;
import org.jetbrains.kotlin.psi.KtOperationExpression;
import org.jetbrains.kotlin.psi.KtPrefixExpression;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtTypeReference;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0016J\u001a\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0006\u001a\u00020\u00022\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0016J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0006\u001a\u00020\u0002J\u000e\u0010\r\u001a\u0004\u0018\u00010\u000e*\u00020\u000fH\u0002\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/idea/intentions/SimplifyNegatedBinaryExpressionIntention;", "Lorg/jetbrains/kotlin/idea/intentions/SelfTargetingRangeIntention;", "Lorg/jetbrains/kotlin/psi/KtPrefixExpression;", "()V", "applicabilityRange", "Lcom/intellij/openapi/util/TextRange;", "element", "applyTo", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "isApplicableTo", "", "negate", "Lorg/jetbrains/kotlin/lexer/KtSingleValueToken;", "Lcom/intellij/psi/tree/IElementType;", "idea"})
public final class SimplifyNegatedBinaryExpressionIntention
extends SelfTargetingRangeIntention<KtPrefixExpression> {
    private final KtSingleValueToken negate(@NotNull IElementType $receiver) {
        IElementType iElementType = $receiver;
        return Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtTokens.IN_KEYWORD)) ? (KtSingleValueToken)KtTokens.NOT_IN : (Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtTokens.NOT_IN)) ? (KtSingleValueToken)KtTokens.IN_KEYWORD : (Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtTokens.IS_KEYWORD)) ? (KtSingleValueToken)KtTokens.NOT_IS : (Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtTokens.NOT_IS)) ? (KtSingleValueToken)KtTokens.IS_KEYWORD : (Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtTokens.EQEQ)) ? KtTokens.EXCLEQ : (Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtTokens.EXCLEQ)) ? KtTokens.EQEQ : (Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtTokens.LT)) ? KtTokens.GTEQ : (Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtTokens.GTEQ)) ? KtTokens.LT : (Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtTokens.GT)) ? KtTokens.LTEQ : (Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtTokens.LTEQ)) ? KtTokens.GT : null)))))))));
    }

    @Override
    @Nullable
    public TextRange applicabilityRange(@NotNull KtPrefixExpression element2) {
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        return this.isApplicableTo(element2) ? element2.getOperationReference().getTextRange() : null;
    }

    public final boolean isApplicableTo(@NotNull KtPrefixExpression element2) {
        IElementType iElementType;
        KtOperationExpression expression2;
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        if (Intrinsics.areEqual((Object)element2.getOperationToken(), (Object)((Object)KtTokens.EXCL)) ^ true) {
            return false;
        }
        KtExpression ktExpression = KtPsiUtil.deparenthesize(element2.getBaseExpression());
        if (!(ktExpression instanceof KtOperationExpression)) {
            ktExpression = null;
        }
        KtOperationExpression ktOperationExpression = (KtOperationExpression)ktExpression;
        if (ktOperationExpression == null) {
            return false;
        }
        KtOperationExpression ktOperationExpression2 = expression2 = ktOperationExpression;
        if (ktOperationExpression2 instanceof KtIsExpression) {
            if (((KtIsExpression)expression2).getTypeReference() == null) {
                return false;
            }
        } else if (ktOperationExpression2 instanceof KtBinaryExpression) {
            if (((KtBinaryExpression)expression2).getLeft() == null || ((KtBinaryExpression)expression2).getRight() == null) {
                return false;
            }
        } else {
            return false;
        }
        if (!((iElementType = expression2.getOperationReference().getReferencedNameElementType()) instanceof KtSingleValueToken)) {
            iElementType = null;
        }
        KtSingleValueToken ktSingleValueToken = (KtSingleValueToken)iElementType;
        if (ktSingleValueToken == null) {
            return false;
        }
        KtSingleValueToken operation = ktSingleValueToken;
        KtSingleValueToken ktSingleValueToken2 = this.negate(operation);
        if (ktSingleValueToken2 == null) {
            return false;
        }
        KtSingleValueToken negatedOperation = ktSingleValueToken2;
        this.setText("Simplify negated '" + operation.getValue() + "' expression to '" + negatedOperation.getValue() + "'");
        return true;
    }

    @Override
    public void applyTo(@NotNull KtPrefixExpression element2, @Nullable Editor editor) {
        KtExpression ktExpression;
        KtExpression expression2;
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        KtExpression ktExpression2 = KtPsiUtil.deparenthesize(element2.getBaseExpression());
        if (ktExpression2 == null) {
            Intrinsics.throwNpe();
        }
        KtExpression ktExpression3 = expression2 = ktExpression2;
        if (ktExpression3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtOperationExpression");
        }
        KtSingleValueToken ktSingleValueToken = this.negate(((KtOperationExpression)ktExpression3).getOperationReference().getReferencedNameElementType());
        if (ktSingleValueToken == null) {
            Intrinsics.throwNpe();
        }
        String operation = ktSingleValueToken.getValue();
        KtExpression ktExpression4 = expression2;
        Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression4, (String)"expression");
        KtPsiFactory psiFactory = KtPsiFactoryKt.KtPsiFactory((PsiElement)ktExpression4);
        KtExpression ktExpression5 = expression2;
        if (ktExpression5 instanceof KtIsExpression) {
            Object[] objectArray = new Object[3];
            KtExpression ktExpression6 = ((KtIsExpression)expression2).getLeftHandSide();
            Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression6, (String)"expression.leftHandSide");
            objectArray[0] = ktExpression6;
            String string = operation;
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"operation");
            objectArray[1] = string;
            KtTypeReference ktTypeReference = ((KtIsExpression)expression2).getTypeReference();
            if (ktTypeReference == null) {
                Intrinsics.throwNpe();
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)ktTypeReference, (String)"expression.typeReference!!");
            objectArray[2] = ktTypeReference;
            ktExpression = CreateByPatternKt.createExpressionByPattern(psiFactory, "$0 $1 $2", objectArray);
        } else if (ktExpression5 instanceof KtBinaryExpression) {
            Object[] objectArray = new Object[3];
            KtExpression ktExpression7 = ((KtBinaryExpression)expression2).getLeft();
            if (ktExpression7 == null) {
                Intrinsics.throwNpe();
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression7, (String)"expression.left!!");
            objectArray[0] = ktExpression7;
            String string = operation;
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"operation");
            objectArray[1] = string;
            KtExpression ktExpression8 = ((KtBinaryExpression)expression2).getRight();
            if (ktExpression8 == null) {
                Intrinsics.throwNpe();
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression8, (String)"expression.right!!");
            objectArray[2] = ktExpression8;
            ktExpression = CreateByPatternKt.createExpressionByPattern(psiFactory, "$0 $1 $2", objectArray);
        } else {
            throw (Throwable)new IllegalArgumentException();
        }
        KtExpression newExpression2 = ktExpression;
        element2.replace((PsiElement)newExpression2);
    }

    public SimplifyNegatedBinaryExpressionIntention() {
        super(KtPrefixExpression.class, "Simplify negated binary expression", null, 4, null);
    }
}

