/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.intentions.branchedTransformations.intentions;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.intentions.SelfTargetingRangeIntention;
import org.jetbrains.kotlin.idea.intentions.branchedTransformations.BranchedFoldingUtils;
import org.jetbrains.kotlin.psi.CreateByPatternKt;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtReturnExpression;
import org.jetbrains.kotlin.psi.KtWhenEntry;
import org.jetbrains.kotlin.psi.KtWhenExpression;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0016J\u001a\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0006\u001a\u00020\u00022\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/idea/intentions/branchedTransformations/intentions/FoldWhenToReturnIntention;", "Lorg/jetbrains/kotlin/idea/intentions/SelfTargetingRangeIntention;", "Lorg/jetbrains/kotlin/psi/KtWhenExpression;", "()V", "applicabilityRange", "Lcom/intellij/openapi/util/TextRange;", "element", "applyTo", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "idea"})
public final class FoldWhenToReturnIntention
extends SelfTargetingRangeIntention<KtWhenExpression> {
    @Override
    @Nullable
    public TextRange applicabilityRange(@NotNull KtWhenExpression element2) {
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        if (!KtPsiUtil.checkWhenExpressionHasSingleElse(element2)) {
            return null;
        }
        List<KtWhenEntry> entries2 = element2.getEntries();
        if (entries2.isEmpty()) {
            return null;
        }
        for (KtWhenEntry entry : entries2) {
            if (BranchedFoldingUtils.INSTANCE.getFoldableBranchedReturn(entry.getExpression()) != null) continue;
            return null;
        }
        return element2.getWhenKeyword().getTextRange();
    }

    @Override
    public void applyTo(@NotNull KtWhenExpression element2, @Nullable Editor editor) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        boolean bl2 = bl = !element2.getEntries().isEmpty();
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        KtExpression ktExpression = CreateByPatternKt.createExpressionByPattern(KtPsiFactoryKt.KtPsiFactory((PsiElement)element2), "return $0", element2);
        if (ktExpression == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtReturnExpression");
        }
        KtReturnExpression newReturnExpression = (KtReturnExpression)ktExpression;
        KtExpression ktExpression2 = newReturnExpression.getReturnedExpression();
        if (ktExpression2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtWhenExpression");
        }
        KtWhenExpression newWhenExpression = (KtWhenExpression)ktExpression2;
        for (KtWhenEntry entry : newWhenExpression.getEntries()) {
            KtExpression currExpr;
            KtReturnExpression currReturn;
            KtExpression ktExpression3 = entry.getExpression();
            if (ktExpression3 == null) {
                Intrinsics.throwNpe();
            }
            if (BranchedFoldingUtils.INSTANCE.getFoldableBranchedReturn(ktExpression3) == null) {
                Intrinsics.throwNpe();
            }
            if (currReturn.getReturnedExpression() == null) {
                Intrinsics.throwNpe();
            }
            KtExpression ktExpression4 = currExpr;
            Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression4, (String)"currExpr");
            currReturn.replace((PsiElement)ktExpression4);
        }
        element2.replace((PsiElement)newReturnExpression);
    }

    public FoldWhenToReturnIntention() {
        super(KtWhenExpression.class, "Lift return out of 'when' expression", null, 4, null);
    }
}

