/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.internal;

import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.psi.PsiElement;
import com.intellij.util.Alarm;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Scanner;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import kotlin.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.java.decompiler.IdeaLogger;
import org.jetbrains.kotlin.backend.common.output.OutputFile;
import org.jetbrains.kotlin.codegen.ClassBuilderFactories;
import org.jetbrains.kotlin.codegen.ClassFileFactory;
import org.jetbrains.kotlin.codegen.CompilationErrorHandler;
import org.jetbrains.kotlin.codegen.KotlinCodegenFacade;
import org.jetbrains.kotlin.codegen.state.GenerationState;
import org.jetbrains.kotlin.config.CommonConfigurationKeys;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.config.JVMConfigurationKeys;
import org.jetbrains.kotlin.config.JvmTarget;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.rendering.DefaultErrorMessages;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.debugger.DebuggerUtils;
import org.jetbrains.kotlin.idea.internal.KotlinDecompilerAdapterKt;
import org.jetbrains.kotlin.idea.internal.KotlinDecompilerService;
import org.jetbrains.kotlin.idea.internal.Location;
import org.jetbrains.kotlin.idea.project.PlatformKt;
import org.jetbrains.kotlin.idea.resolve.ResolutionFacade;
import org.jetbrains.kotlin.idea.util.InfinitePeriodicalTask;
import org.jetbrains.kotlin.idea.util.LongRunningReadTask;
import org.jetbrains.kotlin.idea.util.ProjectRootsUtil;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtScript;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.utils.StringsKt;

public class KotlinBytecodeToolWindow
extends JPanel
implements Disposable {
    private final Logger LOG = Logger.getInstance(KotlinBytecodeToolWindow.class);
    private static final int UPDATE_DELAY = 1000;
    private static final String DEFAULT_TEXT = "/*\nGenerated bytecode for Kotlin source file.\nNo Kotlin source file is opened.\n*/";
    private final Editor myEditor;
    private final Project myProject;
    private final ToolWindow toolWindow;
    private final JCheckBox enableInline;
    private final JCheckBox enableOptimization;
    private final JCheckBox enableAssertions;
    private final JButton decompile;
    private final JCheckBox jvm8Target;
    private final JCheckBox ir;

    public KotlinBytecodeToolWindow(Project project, ToolWindow toolWindow) {
        super(new BorderLayout());
        this.myProject = project;
        this.toolWindow = toolWindow;
        this.myEditor = EditorFactory.getInstance().createEditor(EditorFactory.getInstance().createDocument((CharSequence)""), project, (FileType)JavaFileType.INSTANCE, true);
        this.add(this.myEditor.getComponent());
        JPanel optionPanel = new JPanel(new FlowLayout());
        this.add((Component)optionPanel, "North");
        this.decompile = new JButton("Decompile");
        if (KotlinDecompilerService.Companion.getInstance() != null) {
            optionPanel.add(this.decompile);
            this.decompile.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Location location2 = Location.fromEditor(FileEditorManager.getInstance((Project)KotlinBytecodeToolWindow.this.myProject).getSelectedTextEditor(), KotlinBytecodeToolWindow.this.myProject);
                    KtFile file2 = location2.getKFile();
                    if (file2 != null) {
                        try {
                            KotlinDecompilerAdapterKt.showDecompiledCode(file2);
                        }
                        catch (IdeaLogger.InternalException ex) {
                            KotlinBytecodeToolWindow.this.LOG.info((Throwable)ex);
                            Messages.showErrorDialog((Project)KotlinBytecodeToolWindow.this.myProject, (String)("Failed to decompile " + file2.getName() + ": " + (Object)((Object)ex)), (String)"Kotlin Bytecode Decompiler");
                        }
                    }
                }
            });
        }
        this.enableInline = new JCheckBox("Inline", true);
        this.enableOptimization = new JCheckBox("Optimization", true);
        this.enableAssertions = new JCheckBox("Assertions", true);
        this.jvm8Target = new JCheckBox("JVM 8 target", false);
        this.ir = new JCheckBox("IR", false);
        optionPanel.add(this.enableInline);
        optionPanel.add(this.enableOptimization);
        optionPanel.add(this.enableAssertions);
        optionPanel.add(this.ir);
        optionPanel.add(this.jvm8Target);
        new InfinitePeriodicalTask(1000L, Alarm.ThreadToUse.SWING_THREAD, this, (Computable<? extends LongRunningReadTask>)new Computable<LongRunningReadTask>(){

            public LongRunningReadTask compute() {
                return new UpdateBytecodeToolWindowTask();
            }
        }).start();
        this.setText(DEFAULT_TEXT);
    }

    @NotNull
    public static String getBytecodeForFile(@NotNull KtFile ktFile, @NotNull CompilerConfiguration configuration2) {
        GenerationState state;
        if (ktFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ktFile", "org/jetbrains/kotlin/idea/internal/KotlinBytecodeToolWindow", "getBytecodeForFile"));
        }
        if (configuration2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "org/jetbrains/kotlin/idea/internal/KotlinBytecodeToolWindow", "getBytecodeForFile"));
        }
        try {
            state = KotlinBytecodeToolWindow.compileSingleFile(ktFile, configuration2);
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Exception e) {
            String string = KotlinBytecodeToolWindow.printStackTraceToString(e);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/internal/KotlinBytecodeToolWindow", "getBytecodeForFile"));
            }
            return string;
        }
        StringBuilder answer = new StringBuilder();
        Collection<Diagnostic> diagnostics = state.getCollectedExtraJvmDiagnostics().all();
        if (!diagnostics.isEmpty()) {
            answer.append("// Backend Errors: \n");
            answer.append("// ================\n");
            for (Diagnostic diagnostic : diagnostics) {
                answer.append("// Error at ").append(diagnostic.getPsiFile().getName()).append(StringsKt.join(diagnostic.getTextRanges(), ",")).append(": ").append(DefaultErrorMessages.render(diagnostic)).append("\n");
            }
            answer.append("// ================\n\n");
        }
        ClassFileFactory outputFiles = state.getFactory();
        for (OutputFile outputFile : outputFiles.asList()) {
            answer.append("// ================");
            answer.append(outputFile.getRelativePath());
            answer.append(" =================\n");
            answer.append(outputFile.asText()).append("\n\n");
        }
        String string = answer.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/internal/KotlinBytecodeToolWindow", "getBytecodeForFile"));
        }
        return string;
    }

    @NotNull
    public static GenerationState compileSingleFile(final @NotNull KtFile ktFile, @NotNull CompilerConfiguration configuration2) {
        if (ktFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ktFile", "org/jetbrains/kotlin/idea/internal/KotlinBytecodeToolWindow", "compileSingleFile"));
        }
        if (configuration2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "org/jetbrains/kotlin/idea/internal/KotlinBytecodeToolWindow", "compileSingleFile"));
        }
        ResolutionFacade resolutionFacade = ResolutionUtils.getResolutionFacade(ktFile);
        BindingContext bindingContextForFile = resolutionFacade.analyzeFullyAndGetResult(Collections.singletonList(ktFile)).getBindingContext();
        Pair<BindingContext, List<KtFile>> result2 = DebuggerUtils.INSTANCE.analyzeInlinedFunctions(resolutionFacade, ktFile, configuration2.getBoolean(CommonConfigurationKeys.DISABLE_INLINE), bindingContextForFile);
        BindingContext bindingContext2 = (BindingContext)result2.getFirst();
        List toProcess = (List)result2.getSecond();
        GenerationState.GenerateClassFilter generateClassFilter2 = new GenerationState.GenerateClassFilter(){

            @Override
            public boolean shouldGeneratePackagePart(@NotNull KtFile file2) {
                if (file2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/idea/internal/KotlinBytecodeToolWindow$3", "shouldGeneratePackagePart"));
                }
                return file2 == ktFile;
            }

            @Override
            public boolean shouldAnnotateClass(@NotNull KtClassOrObject processingClassOrObject) {
                if (processingClassOrObject == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processingClassOrObject", "org/jetbrains/kotlin/idea/internal/KotlinBytecodeToolWindow$3", "shouldAnnotateClass"));
                }
                return true;
            }

            @Override
            public boolean shouldGenerateClass(@NotNull KtClassOrObject processingClassOrObject) {
                if (processingClassOrObject == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processingClassOrObject", "org/jetbrains/kotlin/idea/internal/KotlinBytecodeToolWindow$3", "shouldGenerateClass"));
                }
                return processingClassOrObject.getContainingKtFile() == ktFile;
            }

            @Override
            public boolean shouldGenerateScript(@NotNull KtScript script) {
                if (script == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "script", "org/jetbrains/kotlin/idea/internal/KotlinBytecodeToolWindow$3", "shouldGenerateScript"));
                }
                return script.getContainingKtFile() == ktFile;
            }
        };
        GenerationState state = new GenerationState(ktFile.getProject(), ClassBuilderFactories.TEST, resolutionFacade.getModuleDescriptor(), bindingContext2, toProcess, configuration2, generateClassFilter2);
        KotlinCodegenFacade.compileCorrectFiles(state, CompilationErrorHandler.THROW_EXCEPTION);
        GenerationState generationState = state;
        if (generationState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/internal/KotlinBytecodeToolWindow", "compileSingleFile"));
        }
        return generationState;
    }

    private static com.intellij.openapi.util.Pair<Integer, Integer> mapLines(String text2, int startLine, int endLine) {
        int ktLineNum;
        int byteCodeLine = 0;
        int byteCodeStartLine = -1;
        int byteCodeEndLine = -1;
        ArrayList<Integer> lines = new ArrayList<Integer>();
        for (String string : text2.split("\n")) {
            String string2 = string.trim();
            if (!string2.startsWith("LINENUMBER")) continue;
            ktLineNum = new Scanner(string2.substring("LINENUMBER".length())).nextInt() - 1;
            lines.add(ktLineNum);
        }
        Collections.sort(lines);
        for (Integer line : lines) {
            if (line < startLine) continue;
            startLine = line;
            break;
        }
        for (String string : text2.split("\n")) {
            String string3 = string.trim();
            if (string3.startsWith("LINENUMBER")) {
                ktLineNum = new Scanner(string3.substring("LINENUMBER".length())).nextInt() - 1;
                if (byteCodeStartLine < 0 && ktLineNum == startLine) {
                    byteCodeStartLine = byteCodeLine;
                }
                if (byteCodeStartLine > 0 && ktLineNum > endLine) {
                    byteCodeEndLine = byteCodeLine - 1;
                    break;
                }
            }
            if (byteCodeStartLine >= 0 && (string3.startsWith("MAXSTACK") || string3.startsWith("LOCALVARIABLE") || string3.isEmpty())) {
                byteCodeEndLine = byteCodeLine - 1;
                break;
            }
            ++byteCodeLine;
        }
        if (byteCodeStartLine == -1 || byteCodeEndLine == -1) {
            return new com.intellij.openapi.util.Pair((Object)0, (Object)0);
        }
        return new com.intellij.openapi.util.Pair((Object)byteCodeStartLine, (Object)byteCodeEndLine);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String printStackTraceToString(Throwable e) {
        StringWriter out = new StringWriter(1024);
        try (PrintWriter printWriter = new PrintWriter(out);){
            e.printStackTrace(printWriter);
            String string = out.toString().replace("\r", "");
            return string;
        }
    }

    private void setText(final @NotNull String resultText) {
        if (resultText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resultText", "org/jetbrains/kotlin/idea/internal/KotlinBytecodeToolWindow", "setText"));
        }
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                KotlinBytecodeToolWindow.this.myEditor.getDocument().setText((CharSequence)StringUtil.convertLineSeparators((String)resultText));
            }
        });
    }

    public void dispose() {
        EditorFactory.getInstance().releaseEditor(this.myEditor);
    }

    private class UpdateBytecodeToolWindowTask
    extends LongRunningReadTask<Location, String> {
        private UpdateBytecodeToolWindowTask() {
        }

        @Override
        protected Location prepareRequestInfo() {
            if (!KotlinBytecodeToolWindow.this.toolWindow.isVisible()) {
                return null;
            }
            Location location2 = Location.fromEditor(FileEditorManager.getInstance((Project)KotlinBytecodeToolWindow.this.myProject).getSelectedTextEditor(), KotlinBytecodeToolWindow.this.myProject);
            if (location2.getEditor() == null) {
                return null;
            }
            KtFile file2 = location2.getKFile();
            if (file2 == null || !ProjectRootsUtil.isInProjectSource((PsiElement)file2)) {
                return null;
            }
            return location2;
        }

        @Override
        @NotNull
        protected Location cloneRequestInfo(@NotNull Location location2) {
            if (location2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "location", "org/jetbrains/kotlin/idea/internal/KotlinBytecodeToolWindow$UpdateBytecodeToolWindowTask", "cloneRequestInfo"));
            }
            Location newLocation = super.cloneRequestInfo(location2);
            assert (location2.equals(newLocation)) : "cloneRequestInfo should generate same location object";
            Location location3 = newLocation;
            if (location3 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/internal/KotlinBytecodeToolWindow$UpdateBytecodeToolWindowTask", "cloneRequestInfo"));
            }
            return location3;
        }

        @Override
        protected void hideResultOnInvalidLocation() {
            KotlinBytecodeToolWindow.this.setText(KotlinBytecodeToolWindow.DEFAULT_TEXT);
        }

        @Override
        @NotNull
        protected String processRequest(@NotNull Location location2) {
            if (location2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "location", "org/jetbrains/kotlin/idea/internal/KotlinBytecodeToolWindow$UpdateBytecodeToolWindowTask", "processRequest"));
            }
            KtFile ktFile = location2.getKFile();
            assert (ktFile != null);
            CompilerConfiguration configuration2 = new CompilerConfiguration();
            if (!KotlinBytecodeToolWindow.this.enableInline.isSelected()) {
                configuration2.put(CommonConfigurationKeys.DISABLE_INLINE, true);
            }
            if (!KotlinBytecodeToolWindow.this.enableAssertions.isSelected()) {
                configuration2.put(JVMConfigurationKeys.DISABLE_CALL_ASSERTIONS, true);
                configuration2.put(JVMConfigurationKeys.DISABLE_PARAM_ASSERTIONS, true);
            }
            if (!KotlinBytecodeToolWindow.this.enableOptimization.isSelected()) {
                configuration2.put(JVMConfigurationKeys.DISABLE_OPTIMIZATION, true);
            }
            if (KotlinBytecodeToolWindow.this.jvm8Target.isSelected()) {
                configuration2.put(JVMConfigurationKeys.JVM_TARGET, JvmTarget.JVM_1_8);
            }
            if (KotlinBytecodeToolWindow.this.ir.isSelected()) {
                configuration2.put(JVMConfigurationKeys.IR, true);
            }
            LanguageVersionSettings languageVersionSettings = PlatformKt.getLanguageVersionSettings(ktFile);
            configuration2.put(CommonConfigurationKeys.LANGUAGE_VERSION_SETTINGS, languageVersionSettings);
            String string = KotlinBytecodeToolWindow.getBytecodeForFile(ktFile, configuration2);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/internal/KotlinBytecodeToolWindow$UpdateBytecodeToolWindowTask", "processRequest"));
            }
            return string;
        }

        @Override
        protected void onResultReady(@NotNull Location requestInfo, String resultText) {
            if (requestInfo == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "requestInfo", "org/jetbrains/kotlin/idea/internal/KotlinBytecodeToolWindow$UpdateBytecodeToolWindowTask", "onResultReady"));
            }
            Editor editor = requestInfo.getEditor();
            assert (editor != null);
            if (resultText == null) {
                return;
            }
            KotlinBytecodeToolWindow.this.setText(resultText);
            int fileStartOffset = requestInfo.getStartOffset();
            int fileEndOffset = requestInfo.getEndOffset();
            Document document = editor.getDocument();
            int startLine = document.getLineNumber(fileStartOffset);
            int endLine = document.getLineNumber(fileEndOffset);
            if (endLine > startLine && fileEndOffset > 0 && document.getCharsSequence().charAt(fileEndOffset - 1) == '\n') {
                --endLine;
            }
            Document byteCodeDocument = KotlinBytecodeToolWindow.this.myEditor.getDocument();
            com.intellij.openapi.util.Pair linesRange = KotlinBytecodeToolWindow.mapLines(byteCodeDocument.getText(), startLine, endLine);
            int endSelectionLineIndex = Math.min((Integer)linesRange.second + 1, byteCodeDocument.getLineCount());
            int startOffset = byteCodeDocument.getLineStartOffset(((Integer)linesRange.first).intValue());
            int endOffset = Math.min(byteCodeDocument.getLineStartOffset(endSelectionLineIndex), byteCodeDocument.getTextLength());
            KotlinBytecodeToolWindow.this.myEditor.getCaretModel().moveToOffset(endOffset);
            KotlinBytecodeToolWindow.this.myEditor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
            KotlinBytecodeToolWindow.this.myEditor.getCaretModel().moveToOffset(startOffset);
            KotlinBytecodeToolWindow.this.myEditor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
            KotlinBytecodeToolWindow.this.myEditor.getSelectionModel().setSelection(startOffset, endOffset);
        }
    }
}

