/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.ModalityKt;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.quickfix.KotlinQuickFixAction;
import org.jetbrains.kotlin.idea.quickfix.KotlinSingleIntentionActionFactory;
import org.jetbrains.kotlin.idea.quickfix.MakeOverriddenMemberOpenFix$Companion$WhenMappings;
import org.jetbrains.kotlin.idea.refactoring.KotlinRefactoringUtilKt;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00182\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0018B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u000b\u001a\u00020\u0007H\u0016J\b\u0010\f\u001a\u00020\u0007H\u0016J\"\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0014J\"\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u0017H\u0016R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/MakeOverriddenMemberOpenFix;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinQuickFixAction;", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "declaration", "(Lorg/jetbrains/kotlin/psi/KtDeclaration;)V", "containingDeclarationsNames", "Ljava/util/ArrayList;", "", "overriddenNonOverridableMembers", "Lcom/intellij/psi/SmartPsiElementPointer;", "Lorg/jetbrains/kotlin/psi/KtCallableDeclaration;", "getFamilyName", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "isAvailable", "", "Lcom/intellij/psi/PsiFile;", "Companion", "idea"})
public final class MakeOverriddenMemberOpenFix
extends KotlinQuickFixAction<KtDeclaration> {
    private final ArrayList<SmartPsiElementPointer<KtCallableDeclaration>> overriddenNonOverridableMembers;
    private final ArrayList<String> containingDeclarationsNames;
    public static final Companion Companion = new Companion(null);

    @Override
    public boolean isAvailable(@NotNull Project project, @Nullable Editor editor, @NotNull PsiFile file2) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        KtDeclaration ktDeclaration = (KtDeclaration)this.getElement();
        if (ktDeclaration == null) {
            return false;
        }
        KtDeclaration element2 = ktDeclaration;
        if (!super.isAvailable(project, editor, file2) || !(file2 instanceof KtFile)) {
            return false;
        }
        this.overriddenNonOverridableMembers.clear();
        this.containingDeclarationsNames.clear();
        DeclarationDescriptor descriptor2 = ResolutionUtils.resolveToDescriptor$default(element2, null, 1, null);
        if (!(descriptor2 instanceof CallableMemberDescriptor)) {
            return false;
        }
        for (CallableMemberDescriptor overriddenDescriptor2 : MakeOverriddenMemberOpenFix.Companion.getAllDeclaredNonOverridableOverriddenDescriptors((CallableMemberDescriptor)descriptor2)) {
            boolean bl = Intrinsics.areEqual((Object)((Object)overriddenDescriptor2.getKind()), (Object)((Object)CallableMemberDescriptor.Kind.DECLARATION));
            if (_Assertions.ENABLED && !bl) {
                String string = "Can only be applied to declarations.";
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            PsiElement overriddenMember = DescriptorToSourceUtils.descriptorToDeclaration(overriddenDescriptor2);
            if (overriddenMember == null || !KotlinRefactoringUtilKt.canRefactor(overriddenMember) || !(overriddenMember instanceof KtCallableDeclaration)) {
                return false;
            }
            String containingDeclarationName = overriddenDescriptor2.getContainingDeclaration().getName().asString();
            this.overriddenNonOverridableMembers.add(PsiUtilsKt.createSmartPointer(overriddenMember));
            this.containingDeclarationsNames.add(containingDeclarationName);
        }
        return this.overriddenNonOverridableMembers.size() > 0;
    }

    @NotNull
    public String getText() {
        KtDeclaration ktDeclaration = (KtDeclaration)this.getElement();
        if (ktDeclaration == null) {
            return "";
        }
        KtDeclaration element2 = ktDeclaration;
        if (this.overriddenNonOverridableMembers.size() == 1) {
            String name2 = this.containingDeclarationsNames.get(0) + "." + element2.getName();
            return "Make " + name2 + " " + (Object)((Object)KtTokens.OPEN_KEYWORD);
        }
        Collections.sort((List)this.containingDeclarationsNames);
        String declarations2 = CollectionsKt.joinToString$default((Iterable)this.containingDeclarationsNames.subList(0, this.containingDeclarationsNames.size() - 1), (CharSequence)", ", null, null, (int)0, null, null, (int)62, null) + " and " + (String)CollectionsKt.last((List)this.containingDeclarationsNames);
        return "Make '" + element2.getName() + "' in " + declarations2 + " open";
    }

    @NotNull
    public String getFamilyName() {
        return "Add Modifier";
    }

    @Override
    protected void invoke(@NotNull Project project, @Nullable Editor editor, @NotNull KtFile file2) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        for (SmartPsiElementPointer<KtCallableDeclaration> overriddenMember : this.overriddenNonOverridableMembers) {
            KtCallableDeclaration ktCallableDeclaration = (KtCallableDeclaration)overriddenMember.getElement();
            if (ktCallableDeclaration == null) continue;
            ktCallableDeclaration.addModifier(KtTokens.OPEN_KEYWORD);
        }
    }

    public MakeOverriddenMemberOpenFix(@NotNull KtDeclaration declaration2) {
        Intrinsics.checkParameterIsNotNull((Object)declaration2, (String)"declaration");
        super((PsiElement)declaration2);
        this.overriddenNonOverridableMembers = new ArrayList();
        this.containingDeclarationsNames = new ArrayList();
    }

    @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0014J\u0016\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\tH\u0002J\u001c\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\t0\b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0002\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/MakeOverriddenMemberOpenFix$Companion;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinSingleIntentionActionFactory;", "()V", "createAction", "Lcom/intellij/codeInsight/intention/IntentionAction;", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "getAllDeclaredNonOverridableOverriddenDescriptors", "", "Lorg/jetbrains/kotlin/descriptors/CallableMemberDescriptor;", "callableMemberDescriptor", "retainNonOverridableMembers", "callableMemberDescriptors", "idea"})
    public static final class Companion
    extends KotlinSingleIntentionActionFactory {
        private final Collection<CallableMemberDescriptor> getAllDeclaredNonOverridableOverriddenDescriptors(CallableMemberDescriptor callableMemberDescriptor) {
            HashSet<CallableMemberDescriptor> result2 = new HashSet<CallableMemberDescriptor>();
            Collection<? extends CallableMemberDescriptor> collection = callableMemberDescriptor.getOverriddenDescriptors();
            Intrinsics.checkExpressionValueIsNotNull(collection, (String)"callableMemberDescriptor.overriddenDescriptors");
            Collection<CallableMemberDescriptor> nonOverridableOverriddenDescriptors = this.retainNonOverridableMembers(collection);
            block5: for (CallableMemberDescriptor overriddenDescriptor2 : nonOverridableOverriddenDescriptors) {
                switch (MakeOverriddenMemberOpenFix$Companion$WhenMappings.$EnumSwitchMapping$0[overriddenDescriptor2.getKind().ordinal()]) {
                    case 1: {
                        result2.add(overriddenDescriptor2);
                        continue block5;
                    }
                    case 2: 
                    case 3: {
                        result2.addAll(this.getAllDeclaredNonOverridableOverriddenDescriptors(overriddenDescriptor2));
                        continue block5;
                    }
                    case 4: {
                        continue block5;
                    }
                }
                throw (Throwable)new UnsupportedOperationException("Unexpected callable kind " + (Object)((Object)overriddenDescriptor2.getKind()));
            }
            return result2;
        }

        /*
         * WARNING - void declaration
         */
        private final Collection<CallableMemberDescriptor> retainNonOverridableMembers(Collection<? extends CallableMemberDescriptor> callableMemberDescriptors) {
            void $receiver$iv$iv;
            Iterable $receiver$iv;
            Iterable iterable = $receiver$iv = (Iterable)callableMemberDescriptors;
            Collection destination$iv$iv = new ArrayList();
            for (Object element$iv$iv : $receiver$iv$iv) {
                CallableMemberDescriptor it = (CallableMemberDescriptor)element$iv$iv;
                if (!(!ModalityKt.isOverridable(it))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            return (List)destination$iv$iv;
        }

        @Override
        @Nullable
        protected IntentionAction createAction(@NotNull Diagnostic diagnostic) {
            Intrinsics.checkParameterIsNotNull((Object)diagnostic, (String)"diagnostic");
            PsiElement $receiver$iv = diagnostic.getPsiElement();
            PsiElement psiElement2 = PsiTreeUtil.getParentOfType((PsiElement)$receiver$iv, KtDeclaration.class, (boolean)false);
            if (psiElement2 == null) {
                Intrinsics.throwNpe();
            }
            KtDeclaration declaration2 = (KtDeclaration)psiElement2;
            return new MakeOverriddenMemberOpenFix(declaration2);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

