/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix.createFromUsage.createCallable;

import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.idea.quickfix.createFromUsage.callableBuilder.CallableInfo;
import org.jetbrains.kotlin.idea.quickfix.createFromUsage.callableBuilder.CallableInfoKt;
import org.jetbrains.kotlin.idea.quickfix.createFromUsage.callableBuilder.FunctionInfo;
import org.jetbrains.kotlin.idea.quickfix.createFromUsage.callableBuilder.TypeInfo;
import org.jetbrains.kotlin.idea.quickfix.createFromUsage.createCallable.CreateCallableMemberFromUsageFactory;
import org.jetbrains.kotlin.lexer.KtToken;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtUnaryExpression;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.types.expressions.OperatorConventions;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\bH\u0014J\u0012\u0010\t\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/createFromUsage/createCallable/CreateUnaryOperationActionFactory;", "Lorg/jetbrains/kotlin/idea/quickfix/createFromUsage/createCallable/CreateCallableMemberFromUsageFactory;", "Lorg/jetbrains/kotlin/psi/KtUnaryExpression;", "()V", "createCallableInfo", "Lorg/jetbrains/kotlin/idea/quickfix/createFromUsage/callableBuilder/CallableInfo;", "element", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "getElementOfInterest", "idea"})
public final class CreateUnaryOperationActionFactory
extends CreateCallableMemberFromUsageFactory<KtUnaryExpression> {
    public static final CreateUnaryOperationActionFactory INSTANCE;

    @Override
    @Nullable
    public KtUnaryExpression getElementOfInterest(@NotNull Diagnostic diagnostic) {
        Intrinsics.checkParameterIsNotNull((Object)diagnostic, (String)"diagnostic");
        PsiElement psiElement2 = diagnostic.getPsiElement().getParent();
        if (!(psiElement2 instanceof KtUnaryExpression)) {
            psiElement2 = null;
        }
        return (KtUnaryExpression)psiElement2;
    }

    @Override
    @Nullable
    protected CallableInfo createCallableInfo(@NotNull KtUnaryExpression element2, @NotNull Diagnostic diagnostic) {
        KtExpression receiverExpr;
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        Intrinsics.checkParameterIsNotNull((Object)diagnostic, (String)"diagnostic");
        IElementType iElementType = element2.getOperationToken();
        if (iElementType == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.lexer.KtToken");
        }
        KtToken token = (KtToken)iElementType;
        Name name2 = OperatorConventions.getNameForOperationSymbol(token, true, false);
        if (name2 == null) {
            return null;
        }
        Name operationName = name2;
        boolean incDec = CollectionsKt.contains((Iterable)((Iterable)OperatorConventions.INCREMENT_OPERATIONS), (Object)((Object)token));
        KtExpression ktExpression = element2.getBaseExpression();
        if (ktExpression == null) {
            return null;
        }
        KtExpression ktExpression2 = receiverExpr = ktExpression;
        Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression2, (String)"receiverExpr");
        TypeInfo receiverType2 = CallableInfoKt.TypeInfo(ktExpression2, Variance.IN_VARIANCE);
        TypeInfo returnType2 = incDec ? (TypeInfo)new TypeInfo.ByReceiverType(Variance.OUT_VARIANCE) : CallableInfoKt.TypeInfo(element2, Variance.OUT_VARIANCE);
        String string = operationName.asString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"operationName.asString()");
        return new FunctionInfo(string, receiverType2, returnType2, null, null, null, true, false, false, 440, null);
    }

    private CreateUnaryOperationActionFactory() {
        super(false, 1, null);
        INSTANCE = this;
    }

    static {
        new CreateUnaryOperationActionFactory();
    }
}

