/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix.migration;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationsKt;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.intentions.SpecifyTypeExplicitlyIntention;
import org.jetbrains.kotlin.idea.project.PlatformKt;
import org.jetbrains.kotlin.idea.quickfix.CleanupFix;
import org.jetbrains.kotlin.idea.quickfix.KotlinQuickFixAction;
import org.jetbrains.kotlin.idea.quickfix.KotlinSingleIntentionActionFactory;
import org.jetbrains.kotlin.idea.util.ModifierListModifactorKt;
import org.jetbrains.kotlin.js.PredefinedAnnotation;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.BuilderByPattern;
import org.jetbrains.kotlin.psi.CreateByPatternKt;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtElementImplStub;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.types.SimpleType;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00182\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003:\u0001\u0018B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\u0007H\u0016J\"\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0014J\u001a\u0010\u0011\u001a\u00020\n*\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0004\u001a\u00020\u0014H\u0002J\f\u0010\u0015\u001a\u00020\u0016*\u00020\u0017H\u0002\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/migration/MigrateExternalExtensionFix;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinQuickFixAction;", "Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;", "Lorg/jetbrains/kotlin/idea/quickfix/CleanupFix;", "declaration", "(Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;)V", "getFamilyName", "", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "appendParameters", "Lorg/jetbrains/kotlin/psi/BuilderByPattern;", "Lorg/jetbrains/kotlin/psi/KtExpression;", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "isJsNative", "", "Lorg/jetbrains/kotlin/psi/KtAnnotationEntry;", "Companion", "idea"})
public final class MigrateExternalExtensionFix
extends KotlinQuickFixAction<KtNamedDeclaration>
implements CleanupFix {
    public static final Companion Companion = new Companion(null);

    @NotNull
    public String getText() {
        return "Fix with 'asDynamic'";
    }

    @NotNull
    public String getFamilyName() {
        return this.getText();
    }

    @Override
    protected void invoke(@NotNull Project project, @Nullable Editor editor, @NotNull KtFile file2) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        KtNamedDeclaration ktNamedDeclaration = (KtNamedDeclaration)this.getElement();
        if (ktNamedDeclaration == null) {
            return;
        }
        KtNamedDeclaration declaration2 = ktNamedDeclaration;
        Name name2 = declaration2.getNameAsSafeName();
        Object object = declaration2.getModifierList();
        if (object != null && (object = ((KtModifierList)object).getAnnotationEntries()) != null) {
            Object v2;
            block18: {
                Iterable $receiver$iv = (Iterable)object;
                for (Object element$iv : $receiver$iv) {
                    KtAnnotationEntry it = (KtAnnotationEntry)element$iv;
                    if (!this.isJsNative(it)) continue;
                    v2 = element$iv;
                    break block18;
                }
                v2 = null;
            }
            if ((object = (KtAnnotationEntry)v2) != null) {
                ((KtElementImplStub)object).delete();
            }
        }
        declaration2.addModifier(KtTokens.INLINE_KEYWORD);
        declaration2.removeModifier(KtTokens.EXTERNAL_KEYWORD);
        if (declaration2 instanceof KtFunction) {
            KtModifierListOwner ktModifierListOwner = declaration2;
            FqName fqName2 = KotlinBuiltIns.FQ_NAMES.suppress.toSafe();
            Intrinsics.checkExpressionValueIsNotNull((Object)fqName2, (String)"KotlinBuiltIns.FQ_NAMES.suppress.toSafe()");
            ModifierListModifactorKt.addAnnotation$default(ktModifierListOwner, fqName2, "\"NOTHING_TO_INLINE\"", null, null, 12, null);
            if (!((KtFunction)declaration2).hasDeclaredReturnType()) {
                KtCallableDeclaration ktCallableDeclaration = (KtCallableDeclaration)declaration2;
                SimpleType simpleType2 = PlatformKt.getBuiltIns(declaration2).getUnitType();
                Intrinsics.checkExpressionValueIsNotNull((Object)simpleType2, (String)"declaration.builtIns.unitType");
                SpecifyTypeExplicitlyIntention.Companion.addTypeAnnotation(editor, ktCallableDeclaration, simpleType2);
            }
        }
        KtPsiFactory ktPsiFactory = new KtPsiFactory(project);
        KtExpression body2 = CreateByPatternKt.buildExpression(ktPsiFactory, (Function1<? super BuilderByPattern<KtExpression>, Unit>)((Function1)new Function1<BuilderByPattern<KtExpression>, Unit>(this, name2, declaration2){
            final /* synthetic */ MigrateExternalExtensionFix this$0;
            final /* synthetic */ Name $name;
            final /* synthetic */ KtNamedDeclaration $declaration;

            public final void invoke(@NotNull BuilderByPattern<KtExpression> $receiver) {
                Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
                Name name2 = Name.identifier("asDynamic");
                Intrinsics.checkExpressionValueIsNotNull((Object)name2, (String)"Name.identifier(\"asDynamic\")");
                $receiver.appendName(name2);
                $receiver.appendFixedText("().");
                Name name3 = this.$name;
                Intrinsics.checkExpressionValueIsNotNull((Object)name3, (String)"name");
                $receiver.appendName(name3);
                if (this.$declaration instanceof KtNamedFunction) {
                    MigrateExternalExtensionFix.access$appendParameters(this.this$0, $receiver, (KtNamedFunction)this.$declaration);
                }
            }
            {
                this.this$0 = migrateExternalExtensionFix;
                this.$name = name2;
                this.$declaration = ktNamedDeclaration;
                super(1);
            }
        }));
        if (declaration2 instanceof KtNamedFunction) {
            KtExpression ktExpression;
            KtExpression ktExpression2 = ((KtNamedFunction)declaration2).getBodyExpression();
            if (!(ktExpression2 instanceof KtBlockExpression)) {
                ktExpression2 = null;
            }
            KtBlockExpression ktBlockExpression = (KtBlockExpression)ktExpression2;
            if (ktBlockExpression != null) {
                ktBlockExpression.delete();
            }
            if ((ktExpression = ((KtNamedFunction)declaration2).getBodyExpression()) == null || (ktExpression = ktExpression.replace((PsiElement)body2)) == null) {
                Object element$iv;
                element$iv = this;
                MigrateExternalExtensionFix $receiver = (MigrateExternalExtensionFix)element$iv;
                declaration2.add(ktPsiFactory.createEQ());
                ktExpression = declaration2.add((PsiElement)body2);
            }
        } else if (declaration2 instanceof KtProperty) {
            KtPropertyAccessor ktPropertyAccessor = ((KtProperty)declaration2).getSetter();
            if (ktPropertyAccessor != null) {
                ktPropertyAccessor.delete();
            }
            KtPropertyAccessor ktPropertyAccessor2 = ((KtProperty)declaration2).getGetter();
            if (ktPropertyAccessor2 != null) {
                ktPropertyAccessor2.delete();
            }
            KtPropertyAccessor getter = ktPsiFactory.createPropertyGetter(body2);
            declaration2.add(getter);
            if (((KtProperty)declaration2).isVar()) {
                KtExpression setterBody2 = CreateByPatternKt.buildExpression(ktPsiFactory, (Function1<? super BuilderByPattern<KtExpression>, Unit>)((Function1)new Function1<BuilderByPattern<KtExpression>, Unit>(name2){
                    final /* synthetic */ Name $name;

                    public final void invoke(@NotNull BuilderByPattern<KtExpression> $receiver) {
                        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
                        Name name2 = Name.identifier("asDynamic");
                        Intrinsics.checkExpressionValueIsNotNull((Object)name2, (String)"Name.identifier(\"asDynamic\")");
                        $receiver.appendName(name2);
                        $receiver.appendFixedText("().");
                        Name name3 = this.$name;
                        Intrinsics.checkExpressionValueIsNotNull((Object)name3, (String)"name");
                        $receiver.appendName(name3);
                        $receiver.appendFixedText(" = ");
                        Name name4 = Name.identifier("value");
                        Intrinsics.checkExpressionValueIsNotNull((Object)name4, (String)"Name.identifier(\"value\")");
                        $receiver.appendName(name4);
                    }
                    {
                        this.$name = name2;
                        super(1);
                    }
                }));
                KtProperty setterStubProperty = ktPsiFactory.createProperty("val x: Unit set(value) { Unit }");
                KtPropertyAccessor ktPropertyAccessor3 = setterStubProperty.getSetter();
                if (ktPropertyAccessor3 == null) {
                    Intrinsics.throwNpe();
                }
                KtExpression ktExpression = ktPropertyAccessor3.getBodyExpression();
                if (ktExpression == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtBlockExpression");
                }
                KtBlockExpression block = (KtBlockExpression)ktExpression;
                ((KtExpression)CollectionsKt.single(block.getStatements())).replace((PsiElement)setterBody2);
                KtPropertyAccessor ktPropertyAccessor4 = setterStubProperty.getSetter();
                if (ktPropertyAccessor4 == null) {
                    Intrinsics.throwNpe();
                }
                declaration2.add(ktPropertyAccessor4);
            }
        }
    }

    private final boolean isJsNative(@NotNull KtAnnotationEntry $receiver) {
        BindingContext bindingContext2 = ResolutionUtils.analyze($receiver, BodyResolveMode.PARTIAL_WITH_DIAGNOSTICS);
        AnnotationDescriptor annotationDescriptor = (AnnotationDescriptor)bindingContext2.get(BindingContext.ANNOTATION, $receiver);
        return annotationDescriptor != null && AnnotationsKt.checkAnnotationName(annotationDescriptor, PredefinedAnnotation.NATIVE.getFqName());
    }

    private final void appendParameters(@NotNull BuilderByPattern<KtExpression> $receiver, KtNamedFunction declaration2) {
        $receiver.appendFixedText("(");
        for (IndexedValue indexedValue : CollectionsKt.withIndex((Iterable)declaration2.getValueParameters())) {
            Name name2;
            int index2 = indexedValue.component1();
            KtParameter param = (KtParameter)indexedValue.component2();
            if (param.getNameAsName() == null) continue;
            Name paramName = name2;
            if (index2 > 0) {
                $receiver.appendFixedText(",");
            }
            Name name3 = paramName;
            Intrinsics.checkExpressionValueIsNotNull((Object)name3, (String)"paramName");
            $receiver.appendName(name3);
        }
        $receiver.appendFixedText(")");
    }

    public MigrateExternalExtensionFix(@NotNull KtNamedDeclaration declaration2) {
        Intrinsics.checkParameterIsNotNull((Object)declaration2, (String)"declaration");
        super((PsiElement)declaration2);
    }

    public static final /* synthetic */ void access$appendParameters(MigrateExternalExtensionFix $this, @NotNull BuilderByPattern $receiver, @NotNull KtNamedFunction declaration2) {
        $this.appendParameters($receiver, declaration2);
    }

    @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0014\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/migration/MigrateExternalExtensionFix$Companion;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinSingleIntentionActionFactory;", "()V", "createAction", "Lcom/intellij/codeInsight/intention/IntentionAction;", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "idea"})
    public static final class Companion
    extends KotlinSingleIntentionActionFactory {
        @Override
        @Nullable
        protected IntentionAction createAction(@NotNull Diagnostic diagnostic) {
            Intrinsics.checkParameterIsNotNull((Object)diagnostic, (String)"diagnostic");
            PsiElement e = diagnostic.getPsiElement();
            if (e instanceof KtNamedFunction && ((KtNamedFunction)e).getReceiverTypeReference() != null || e instanceof KtProperty && ((KtProperty)e).getReceiverTypeReference() != null) {
                PsiElement psiElement2 = e;
                if (psiElement2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtNamedDeclaration");
                }
                return new MigrateExternalExtensionFix((KtNamedDeclaration)psiElement2);
            }
            return null;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

