/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring.inline;

import com.google.common.collect.Sets;
import com.intellij.lang.Language;
import com.intellij.lang.refactoring.InlineActionHandler;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorSettingsExternalizable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.JavaRefactoringSettings;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.util.Query;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.idea.KotlinLanguage;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.codeInsight.shorten.ShortenWaitingSetKt;
import org.jetbrains.kotlin.idea.core.ShortenReferences;
import org.jetbrains.kotlin.idea.refactoring.KotlinRefactoringUtilKt;
import org.jetbrains.kotlin.idea.refactoring.inline.InlineUtilsKt;
import org.jetbrains.kotlin.idea.refactoring.inline.KotlinInlineValDialog;
import org.jetbrains.kotlin.idea.refactoring.inline.KotlinInlineValHandler;
import org.jetbrains.kotlin.idea.references.KtReference;
import org.jetbrains.kotlin.idea.references.ReferenceUtilKt;
import org.jetbrains.kotlin.idea.resolve.ResolutionFacade;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtImportDirective;
import org.jetbrains.kotlin.psi.KtLambdaArgumentKt;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtParameterList;
import org.jetbrains.kotlin.psi.KtParenthesizedExpression;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.psi.KtSimpleNameStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtStringTemplateEntryWithExpression;
import org.jetbrains.kotlin.psi.KtStringTemplateExpression;
import org.jetbrains.kotlin.psi.KtTypeArgumentList;
import org.jetbrains.kotlin.psi.KtUnaryExpression;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.types.ErrorUtils;
import org.jetbrains.kotlin.types.expressions.OperatorConventions;
import org.jetbrains.kotlin.utils.CollectionsKt;
import org.jetbrains.kotlin.utils.addToStdlib.AddToStdlibKt;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0001.B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0002J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u001e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\tH\u0002J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0012\u001a\u00020\tH\u0002J\"\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0018\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J0\u0010 \u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010!\u001a\u00020\u00062\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\r0#H\u0002J\"\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'2\b\u0010(\u001a\u0004\u0018\u00010)2\u0006\u0010*\u001a\u00020+H\u0002J\"\u0010,\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010-\u001a\u00020\u0006H\u0002\u00a8\u0006/"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/inline/KotlinInlineValHandler;", "Lcom/intellij/lang/refactoring/InlineActionHandler;", "()V", "addFunctionLiteralParameterTypes", "", "parameters", "", "inlinedExpressions", "", "Lorg/jetbrains/kotlin/psi/KtExpression;", "canInlineElement", "", "element", "Lcom/intellij/psi/PsiElement;", "doReplace", "expression", "replacement", "getParametersForFunctionLiteral", "initializer", "inlineElement", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "isEnabledForLanguage", "l", "Lcom/intellij/lang/Language;", "needToAddParameterTypes", "lambdaExpression", "Lorg/jetbrains/kotlin/psi/KtLambdaExpression;", "resolutionFacade", "Lorg/jetbrains/kotlin/idea/resolve/ResolutionFacade;", "reportAmbiguousAssignment", "name", "assignments", "", "showDialog", "Lorg/jetbrains/kotlin/idea/refactoring/inline/KotlinInlineValHandler$InlineMode;", "property", "Lorg/jetbrains/kotlin/psi/KtProperty;", "ref", "Lcom/intellij/psi/PsiReference;", "occurrenceCount", "", "showErrorHint", "message", "InlineMode", "idea"})
public final class KotlinInlineValHandler
extends InlineActionHandler {
    public boolean isEnabledForLanguage(@NotNull Language l) {
        Intrinsics.checkParameterIsNotNull((Object)l, (String)"l");
        return Intrinsics.areEqual((Object)l, (Object)((Object)KotlinLanguage.INSTANCE));
    }

    public boolean canInlineElement(@NotNull PsiElement element2) {
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        if (!(element2 instanceof KtProperty)) {
            return false;
        }
        return ((KtProperty)element2).getGetter() == null && ((KtProperty)element2).getReceiverTypeReference() == null;
    }

    private final List<KtExpression> doReplace(KtExpression expression2, KtExpression replacement2) {
        Object object;
        PsiElement parent2 = expression2.getParent();
        if (parent2 instanceof KtStringTemplateEntryWithExpression && replacement2 instanceof KtStringTemplateExpression && Intrinsics.areEqual((Object)((KtStringTemplateEntryWithExpression)parent2).getParent().getFirstChild().getText(), (Object)((KtStringTemplateExpression)replacement2).getFirstChild().getText())) {
            List list2;
            KtStringTemplateEntry[] entriesToAdd = ((KtStringTemplateExpression)replacement2).getEntries();
            PsiElement psiElement2 = ((KtStringTemplateEntryWithExpression)parent2).getParent();
            if (psiElement2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtStringTemplateExpression");
            }
            KtStringTemplateExpression templateExpression2 = (KtStringTemplateExpression)psiElement2;
            if (((Object[])entriesToAdd).length > 0) {
                PsiElement firstAddedEntry = templateExpression2.addRangeBefore((PsiElement)ArraysKt.first((Object[])entriesToAdd), (PsiElement)ArraysKt.last((Object[])entriesToAdd), parent2);
                PsiElement lastNewEntry = ((KtStringTemplateEntryWithExpression)parent2).getPrevSibling();
                PsiElement nextElement = ((KtStringTemplateEntryWithExpression)parent2).getNextSibling();
                if (lastNewEntry instanceof KtSimpleNameStringTemplateEntry && ((KtSimpleNameStringTemplateEntry)lastNewEntry).getExpression() != null && !KtPsiUtilKt.canPlaceAfterSimpleNameEntry(nextElement)) {
                    KtPsiFactory ktPsiFactory = KtPsiFactoryKt.KtPsiFactory((PsiElement)expression2);
                    KtExpression ktExpression = ((KtSimpleNameStringTemplateEntry)lastNewEntry).getExpression();
                    if (ktExpression == null) {
                        Intrinsics.throwNpe();
                    }
                    Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression, (String)"lastNewEntry.expression!!");
                    lastNewEntry.replace((PsiElement)ktPsiFactory.createBlockStringTemplateEntry(ktExpression));
                }
                list2 = SequencesKt.toList((Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.take((Sequence)PsiUtilsKt.siblings$default(firstAddedEntry, false, false, 3, null), (int)((Object[])entriesToAdd).length), (Function1)doReplace.inlinedExpressions.1.INSTANCE));
            } else {
                list2 = kotlin.collections.CollectionsKt.emptyList();
            }
            List inlinedExpressions2 = list2;
            parent2.delete();
            return inlinedExpressions2;
        }
        PsiElement $receiver$iv = (PsiElement)expression2;
        PsiElement result$iv = $receiver$iv.replace((PsiElement)replacement2);
        if (result$iv instanceof KtExpression) {
            object = result$iv;
        } else {
            PsiElement psiElement3 = result$iv;
            if (psiElement3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtParenthesizedExpression");
            }
            KtExpression ktExpression = ((KtParenthesizedExpression)psiElement3).getExpression();
            if (ktExpression == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtExpression");
            }
            object = ktExpression;
        }
        return AddToStdlibKt.singletonList(object);
    }

    public void inlineElement(@NotNull Project project, @Nullable Editor editor, @NotNull PsiElement element2) {
        Collection $receiver$iv$iv;
        Iterable $receiver$iv;
        KtExpression initializer2;
        KtExpression ktExpression;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        PsiElement psiElement2 = element2;
        if (psiElement2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtProperty");
        }
        KtProperty declaration2 = (KtProperty)psiElement2;
        KtFile file2 = declaration2.getContainingKtFile();
        String string = declaration2.getName();
        if (string == null) {
            return;
        }
        String name2 = string;
        Query references2 = ReferencesSearch.search((PsiElement)declaration2);
        ArrayList referenceExpressions = new ArrayList();
        ArrayList<Object> foreignUsages = new ArrayList<Object>();
        for (PsiReference ref : references2) {
            Object refElement;
            if (ref.getElement() == null) {
                continue;
            }
            if (!(refElement instanceof KtElement)) {
                foreignUsages.add(refElement);
                continue;
            }
            Collection collection = referenceExpressions;
            Object object = refElement;
            if (!(object instanceof KtExpression)) {
                object = null;
            }
            KtExpression ktExpression2 = (KtExpression)object;
            CollectionsKt.addIfNotNull(collection, ktExpression2 != null ? KtPsiUtilKt.getQualifiedExpressionForSelectorOrThis(ktExpression2) : null);
        }
        if (referenceExpressions.isEmpty()) {
            String kind2 = declaration2.isLocal() ? "Variable" : "Property";
            this.showErrorHint(project, editor, kind2 + " '" + name2 + "' is never used");
            return;
        }
        HashSet assignments = Sets.newHashSet();
        Iterable $receiver$iv2 = referenceExpressions;
        for (Object element$iv : $receiver$iv2) {
            KtExpression expression2 = (KtExpression)element$iv;
            PsiElement parent2 = expression2.getParent();
            KtBinaryExpression assignment = KtPsiUtilKt.getAssignmentByLHS(expression2);
            if (assignment != null) {
                assignments.add(parent2);
            }
            if (!(parent2 instanceof KtUnaryExpression) || !kotlin.collections.CollectionsKt.contains((Iterable)((Iterable)OperatorConventions.INCREMENT_OPERATIONS), (Object)((KtUnaryExpression)parent2).getOperationToken())) continue;
            assignments.add(parent2);
        }
        KtExpression initializerInDeclaration = declaration2.getInitializer();
        if (initializerInDeclaration != null) {
            if (!assignments.isEmpty()) {
                String string2 = name2;
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"name");
                HashSet hashSet = assignments;
                Intrinsics.checkExpressionValueIsNotNull((Object)hashSet, (String)"assignments");
                this.reportAmbiguousAssignment(project, editor, string2, hashSet);
                return;
            }
            ktExpression = initializerInDeclaration;
        } else {
            Object object = kotlin.collections.CollectionsKt.singleOrNull((Iterable)assignments);
            if (!(object instanceof KtBinaryExpression)) {
                object = null;
            }
            if ((ktExpression = (KtBinaryExpression)object) == null || (ktExpression = ((KtBinaryExpression)ktExpression).getRight()) == null) {
                String string3 = name2;
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"name");
                HashSet hashSet = assignments;
                Intrinsics.checkExpressionValueIsNotNull((Object)hashSet, (String)"assignments");
                this.reportAmbiguousAssignment(project, editor, string3, hashSet);
                return;
            }
        }
        KtExpression ktExpression3 = initializer2 = ktExpression;
        Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression3, (String)"initializer");
        KtTypeArgumentList typeArgumentsForCall = KotlinRefactoringUtilKt.getQualifiedTypeArgumentList(ktExpression3);
        KtExpression ktExpression4 = initializer2;
        Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression4, (String)"initializer");
        String parametersForFunctionLiteral = this.getParametersForFunctionLiteral(ktExpression4);
        Iterable $i$a$1$forEach = $receiver$iv = (Iterable)referenceExpressions;
        Collection destination$iv$iv = new ArrayList();
        MultiMap multiMap = $receiver$iv$iv.iterator();
        while (multiMap.hasNext()) {
            Object element$iv$iv = multiMap.next();
            KtExpression it = (KtExpression)element$iv$iv;
            if (!Intrinsics.areEqual((Object)it.getContainingFile(), (Object)file2)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List referencesInOriginalFile = (List)destination$iv$iv;
        $receiver$iv$iv = referencesInOriginalFile;
        boolean isHighlighting = !$receiver$iv$iv.isEmpty();
        InlineUtilsKt.highlightElements(project, editor, referencesInOriginalFile);
        if (referencesInOriginalFile.size() != referenceExpressions.size()) {
            KtExpression ktExpression5 = initializer2;
            Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression5, (String)"initializer");
            InlineUtilsKt.preProcessInternalUsages(ktExpression5, referenceExpressions);
        }
        Function0<Unit> performRefactoring$ = new Function0<Unit>(this, editor, referenceExpressions, declaration2, isHighlighting, project, name2, assignments, initializer2, typeArgumentsForCall, parametersForFunctionLiteral){
            final /* synthetic */ KotlinInlineValHandler this$0;
            final /* synthetic */ Editor $editor;
            final /* synthetic */ ArrayList $referenceExpressions;
            final /* synthetic */ KtProperty $declaration;
            final /* synthetic */ boolean $isHighlighting;
            final /* synthetic */ Project $project;
            final /* synthetic */ String $name;
            final /* synthetic */ HashSet $assignments;
            final /* synthetic */ KtExpression $initializer;
            final /* synthetic */ KtTypeArgumentList $typeArgumentsForCall;
            final /* synthetic */ String $parametersForFunctionLiteral;

            public final void invoke() {
                KtExpression primaryExpression;
                KtExpression ktExpression;
                if (this.$editor != null) {
                    Object v0;
                    block6: {
                        int offset2 = this.$editor.getCaretModel().getOffset();
                        Iterable $receiver$iv = this.$referenceExpressions;
                        for (T element$iv : $receiver$iv) {
                            KtExpression it = (KtExpression)element$iv;
                            if (!it.getTextRange().contains(offset2)) continue;
                            v0 = element$iv;
                            break block6;
                        }
                        v0 = null;
                    }
                    ktExpression = v0;
                } else {
                    ktExpression = null;
                }
                KtExpression ktExpression2 = primaryExpression = ktExpression;
                KtReference primaryRef = ktExpression2 != null ? ReferenceUtilKt.getMainReference(ktExpression2) : null;
                InlineMode inlineMode = KotlinInlineValHandler.access$showDialog(this.this$0, this.$declaration, (PsiReference)primaryRef, this.$referenceExpressions.size());
                if (Intrinsics.areEqual((Object)((Object)inlineMode), (Object)((Object)InlineMode.NONE))) {
                    if (this.$isHighlighting) {
                        StatusBar statusBar;
                        StatusBar statusBar2 = statusBar = WindowManager.getInstance().getStatusBar(this.$project);
                        if (statusBar2 != null) {
                            statusBar2.setInfo(RefactoringBundle.message((String)"press.escape.to.remove.the.highlighting"));
                        }
                    }
                    return;
                }
                List chosenExpressions = Intrinsics.areEqual((Object)((Object)inlineMode), (Object)((Object)InlineMode.ALL)) ? (List)this.$referenceExpressions : kotlin.collections.CollectionsKt.listOf((Object)primaryExpression);
                String string = RefactoringBundle.message((String)"inline.command", (Object[])new Object[]{this.$name});
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"RefactoringBundle.message(\"inline.command\", name)");
                ApplicationUtilsKt.executeWriteCommand(this.$project, string, (Function0<Unit>)((Function0)new Function0<Unit>(this, chosenExpressions, inlineMode){
                    final /* synthetic */ inlineElement.2 this$0;
                    final /* synthetic */ List $chosenExpressions;
                    final /* synthetic */ InlineMode $inlineMode;

                    public final void invoke() {
                        Object it;
                        Iterator<T> $receiver$iv$iv;
                        Iterable $receiver$iv = this.$chosenExpressions;
                        Iterable iterable = $receiver$iv;
                        Collection destination$iv$iv = new ArrayList<E>();
                        Iterator<T> iterator2 = $receiver$iv$iv.iterator();
                        while (iterator2.hasNext()) {
                            List list2;
                            T element$iv$iv = iterator2.next();
                            KtExpression referenceExpression = (KtExpression)element$iv$iv;
                            HashSet hashSet = this.this$0.$assignments;
                            KtExpression ktExpression = referenceExpression;
                            if (ktExpression == null) {
                                Intrinsics.throwNpe();
                            }
                            if (hashSet.contains(ktExpression.getParent())) {
                                list2 = kotlin.collections.CollectionsKt.emptyList();
                            } else {
                                PsiElement $receiver$iv2 = (PsiElement)referenceExpression;
                                KtImportDirective importDirective = (KtImportDirective)PsiTreeUtil.getParentOfType((PsiElement)$receiver$iv2, KtImportDirective.class, (boolean)true);
                                if (importDirective != null) {
                                    KtReference reference2;
                                    KtElement ktElement = KtPsiUtilKt.getQualifiedElementSelector(referenceExpression);
                                    KtReference ktReference = reference2 = ktElement != null ? ReferenceUtilKt.getMainReference(ktElement) : null;
                                    if (reference2 != null && ((Object[])reference2.multiResolve(false)).length <= 1) {
                                        importDirective.delete();
                                    }
                                    list2 = kotlin.collections.CollectionsKt.emptyList();
                                } else {
                                    KotlinInlineValHandler kotlinInlineValHandler = this.this$0.this$0;
                                    KtExpression ktExpression2 = this.this$0.$initializer;
                                    Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression2, (String)"initializer");
                                    list2 = KotlinInlineValHandler.access$doReplace(kotlinInlineValHandler, referenceExpression, ktExpression2);
                                }
                            }
                            Iterable list$iv$iv = list2;
                            kotlin.collections.CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                        }
                        $receiver$iv = (List)destination$iv$iv;
                        $receiver$iv$iv = $receiver$iv;
                        destination$iv$iv = new ArrayList<E>();
                        Iterable $receiver$iv$iv$iv = $receiver$iv$iv;
                        for (E element$iv$iv$iv : $receiver$iv$iv$iv) {
                            KtExpression ktExpression;
                            E element$iv$iv = element$iv$iv$iv;
                            KtExpression it2 = (KtExpression)element$iv$iv;
                            if ((KtExpression)InlineUtilsKt.postProcessInternalReferences((KtElement)it2) == null) continue;
                            KtExpression it$iv$iv = ktExpression;
                            destination$iv$iv.add(it$iv$iv);
                        }
                        List inlinedExpressions2 = (List)destination$iv$iv;
                        if (Intrinsics.areEqual((Object)((Object)this.$inlineMode), (Object)((Object)InlineMode.ALL))) {
                            $receiver$iv = this.this$0.$assignments;
                            for (Object element$iv : $receiver$iv) {
                                it = (PsiElement)element$iv;
                                it.delete();
                            }
                            this.this$0.$declaration.delete();
                        }
                        if (!($receiver$iv = (Collection)inlinedExpressions2).isEmpty()) {
                            if (this.this$0.$typeArgumentsForCall != null) {
                                $receiver$iv = inlinedExpressions2;
                                for (Object element$iv : $receiver$iv) {
                                    it = (KtExpression)element$iv;
                                    KotlinRefactoringUtilKt.addTypeArgumentsIfNeeded((KtExpression)it, this.this$0.$typeArgumentsForCall);
                                }
                            }
                            String string = this.this$0.$parametersForFunctionLiteral;
                            if (string != null) {
                                String string2;
                                String it3 = string2 = string;
                                KotlinInlineValHandler.access$addFunctionLiteralParameterTypes(this.this$0.this$0, it3, inlinedExpressions2);
                            }
                            if (this.this$0.$isHighlighting) {
                                InlineUtilsKt.highlightElements(this.this$0.$project, this.this$0.$editor, inlinedExpressions2);
                            }
                        }
                        ShortenWaitingSetKt.performDelayedShortening(this.this$0.$project);
                    }
                    {
                        this.this$0 = var1_1;
                        this.$chosenExpressions = list2;
                        this.$inlineMode = inlineMode;
                        super(0);
                    }
                }));
            }
            {
                this.this$0 = kotlinInlineValHandler;
                this.$editor = editor;
                this.$referenceExpressions = arrayList;
                this.$declaration = ktProperty;
                this.$isHighlighting = bl;
                this.$project = project;
                this.$name = string;
                this.$assignments = hashSet;
                this.$initializer = ktExpression;
                this.$typeArgumentsForCall = ktTypeArgumentList;
                this.$parametersForFunctionLiteral = string2;
                super(0);
            }
        };
        destination$iv$iv = foreignUsages;
        if (!destination$iv$iv.isEmpty()) {
            MultiMap $receiver = multiMap = new MultiMap();
            $receiver.putValue(null, (Object)("Property '" + name2 + "' has non-Kotlin usages. They won't be processed by the Inline refactoring."));
            Iterable $receiver$iv3 = foreignUsages;
            for (Object element$iv : $receiver$iv3) {
                PsiElement it = (PsiElement)element$iv;
                $receiver.putValue((Object)it, (Object)it.getText());
            }
            MultiMap conflicts2 = multiMap;
            KotlinRefactoringUtilKt.checkConflictsInteractively$default(project, conflicts2, null, (Function0)new Function0<Unit>(performRefactoring$){
                final /* synthetic */ inlineElement.2 $performRefactoring;

                public final void invoke() {
                    this.$performRefactoring.invoke();
                }
                {
                    this.$performRefactoring = var1_1;
                    super(0);
                }
            }, 2, null);
        } else {
            performRefactoring$.invoke();
        }
    }

    private final void reportAmbiguousAssignment(Project project, Editor editor, String name2, Set<? extends PsiElement> assignments) {
        String message2;
        String key = assignments.isEmpty() ? "variable.has.no.initializer" : "variable.has.no.dominating.definition";
        String string = message2 = RefactoringBundle.getCannotRefactorMessage((String)RefactoringBundle.message((String)key, (Object[])new Object[]{name2}));
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"message");
        this.showErrorHint(project, editor, string);
    }

    private final void showErrorHint(Project project, Editor editor, String message2) {
        CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message2, (String)RefactoringBundle.message((String)"inline.variable.title"), (String)"refactoring.inlineVariable");
    }

    private final InlineMode showDialog(KtProperty property2, PsiReference ref, int occurrenceCount) {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return InlineMode.ALL;
        }
        if (!(ref != null && occurrenceCount > 1 || EditorSettingsExternalizable.getInstance().isShowInlineLocalDialog())) {
            return InlineMode.ALL;
        }
        KotlinInlineValDialog dialog2 = new KotlinInlineValDialog(property2, ref, occurrenceCount);
        if (!dialog2.showAndGet()) {
            return InlineMode.NONE;
        }
        return JavaRefactoringSettings.getInstance().INLINE_LOCAL_THIS ? InlineMode.PRIMARY : InlineMode.ALL;
    }

    private final String getParametersForFunctionLiteral(KtExpression initializer2) {
        KtLambdaExpression ktLambdaExpression = KtLambdaArgumentKt.unpackFunctionLiteral(initializer2, true);
        if (ktLambdaExpression == null) {
            return null;
        }
        KtLambdaExpression functionLiteralExpression = ktLambdaExpression;
        BindingContext context = ResolutionUtils.analyze(initializer2, BodyResolveMode.PARTIAL);
        SimpleFunctionDescriptor lambdaDescriptor = (SimpleFunctionDescriptor)context.get(BindingContext.FUNCTION, functionLiteralExpression.getFunctionLiteral());
        if (lambdaDescriptor == null || ErrorUtils.containsErrorType(lambdaDescriptor)) {
            return null;
        }
        return kotlin.collections.CollectionsKt.joinToString$default((Iterable)lambdaDescriptor.getValueParameters(), null, null, null, (int)0, null, (Function1)getParametersForFunctionLiteral.1.INSTANCE, (int)31, null);
    }

    /*
     * WARNING - void declaration
     */
    private final void addFunctionLiteralParameterTypes(String parameters2, List<? extends KtExpression> inlinedExpressions2) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        KtFile containingFile = ((KtExpression)kotlin.collections.CollectionsKt.first(inlinedExpressions2)).getContainingKtFile();
        ResolutionFacade resolutionFacade = ResolutionUtils.getResolutionFacade(containingFile);
        Iterable iterable = $receiver$iv = (Iterable)inlinedExpressions2;
        Collection destination$iv$iv = new ArrayList();
        void $receiver$iv$iv$iv = $receiver$iv$iv;
        for (Object element$iv$iv$iv : $receiver$iv$iv$iv) {
            KtLambdaExpression ktLambdaExpression;
            KtLambdaExpression lambdaExpr;
            Object element$iv$iv = element$iv$iv$iv;
            KtExpression it = (KtExpression)element$iv$iv;
            KtLambdaExpression $receiver$iv2 = KtLambdaArgumentKt.unpackFunctionLiteral(it, true);
            if ($receiver$iv2 == null) {
                AssertionError assertionError;
                AssertionError assertionError2 = assertionError;
                AssertionError assertionError3 = assertionError;
                String string = "can't find function literal expression for " + it.getText();
                assertionError2((Object)string);
                throw (Throwable)((Object)assertionError3);
            }
            KtLambdaExpression ktLambdaExpression2 = this.needToAddParameterTypes(lambdaExpr, resolutionFacade) ? lambdaExpr : null;
            if (ktLambdaExpression2 == null) continue;
            KtLambdaExpression it$iv$iv = ktLambdaExpression = ktLambdaExpression2;
            destination$iv$iv.add(it$iv$iv);
        }
        List functionsToAddParameters = (List)destination$iv$iv;
        KtFile ktFile = containingFile;
        Intrinsics.checkExpressionValueIsNotNull((Object)ktFile, (String)"containingFile");
        KtPsiFactory psiFactory = KtPsiFactoryKt.KtPsiFactory((PsiElement)ktFile);
        for (KtLambdaExpression lambdaExpr : functionsToAddParameters) {
            KtFunctionLiteral lambda2 = lambdaExpr.getFunctionLiteral();
            KtParameterList currentParameterList = lambda2.getValueParameterList();
            KtParameterList newParameterList = psiFactory.createParameterList("(" + parameters2 + ")");
            if (currentParameterList != null) {
                currentParameterList.replace((PsiElement)newParameterList);
            } else {
                PsiElement openBraceElement = lambda2.getLBrace();
                PsiElement nextSibling = openBraceElement.getNextSibling();
                PsiElement whitespaceToAdd = nextSibling instanceof PsiWhiteSpace && StringsKt.contains$default((CharSequence)((PsiWhiteSpace)nextSibling).getText(), (CharSequence)"\n", (boolean)false, (int)2, null) ? nextSibling.copy() : null;
                Pair<PsiElement, PsiElement> whitespaceAndArrow = psiFactory.createWhitespaceAndArrow();
                lambda2.addRangeAfter((PsiElement)whitespaceAndArrow.getFirst(), (PsiElement)whitespaceAndArrow.getSecond(), openBraceElement);
                lambda2.addAfter((PsiElement)newParameterList, openBraceElement);
                if (whitespaceToAdd != null) {
                    lambda2.addAfter(whitespaceToAdd, openBraceElement);
                }
            }
            List<KtParameter> list2 = lambdaExpr.getValueParameters();
            Intrinsics.checkExpressionValueIsNotNull(list2, (String)"lambdaExpr.valueParameters");
            ShortenReferences.process$default(ShortenReferences.DEFAULT, list2, null, 2, null);
        }
    }

    private final boolean needToAddParameterTypes(KtLambdaExpression lambdaExpression2, ResolutionFacade resolutionFacade) {
        boolean bl;
        block1: {
            KtFunctionLiteral functionLiteral = lambdaExpression2.getFunctionLiteral();
            BindingContext context = resolutionFacade.analyze(lambdaExpression2, BodyResolveMode.PARTIAL_WITH_DIAGNOSTICS);
            Iterable $receiver$iv = context.getDiagnostics();
            for (Object element$iv : $receiver$iv) {
                PsiElement $receiver$iv2;
                Diagnostic diagnostic = (Diagnostic)element$iv;
                DiagnosticFactory<?> factory2 = diagnostic.getFactory();
                PsiElement element2 = diagnostic.getPsiElement();
                boolean hasCantInferParameter = Intrinsics.areEqual(factory2, Errors.CANNOT_INFER_PARAMETER_TYPE) && Intrinsics.areEqual((Object)element2.getParent().getParent(), (Object)functionLiteral);
                boolean hasUnresolvedItOrThis = Intrinsics.areEqual(factory2, Errors.UNRESOLVED_REFERENCE) && Intrinsics.areEqual((Object)element2.getText(), (Object)"it") && Intrinsics.areEqual((Object)((KtFunctionLiteral)PsiTreeUtil.getParentOfType((PsiElement)($receiver$iv2 = element2), KtFunctionLiteral.class, (boolean)true)), (Object)functionLiteral);
                if (!(hasCantInferParameter || hasUnresolvedItOrThis)) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    @NotNull
    public static final /* synthetic */ InlineMode access$showDialog(KotlinInlineValHandler $this, @NotNull KtProperty property2, @Nullable PsiReference ref, int occurrenceCount) {
        return $this.showDialog(property2, ref, occurrenceCount);
    }

    @NotNull
    public static final /* synthetic */ List access$doReplace(KotlinInlineValHandler $this, @NotNull KtExpression expression2, @NotNull KtExpression replacement2) {
        return $this.doReplace(expression2, replacement2);
    }

    public static final /* synthetic */ void access$addFunctionLiteralParameterTypes(KotlinInlineValHandler $this, @NotNull String parameters2, @NotNull List inlinedExpressions2) {
        $this.addFunctionLiteralParameterTypes(parameters2, inlinedExpressions2);
    }

    @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/inline/KotlinInlineValHandler$InlineMode;", "", "(Ljava/lang/String;I)V", "ALL", "PRIMARY", "NONE", "idea"})
    public static final class InlineMode
    extends Enum<InlineMode> {
        public static final /* enum */ InlineMode ALL;
        public static final /* enum */ InlineMode PRIMARY;
        public static final /* enum */ InlineMode NONE;
        private static final /* synthetic */ InlineMode[] $VALUES;

        static {
            InlineMode[] inlineModeArray = new InlineMode[3];
            InlineMode[] inlineModeArray2 = inlineModeArray;
            inlineModeArray[0] = ALL = new InlineMode();
            inlineModeArray[1] = PRIMARY = new InlineMode();
            inlineModeArray[2] = NONE = new InlineMode();
            $VALUES = inlineModeArray;
        }

        public static InlineMode[] values() {
            return (InlineMode[])$VALUES.clone();
        }

        public static InlineMode valueOf(String string) {
            return Enum.valueOf(InlineMode.class, string);
        }
    }
}

