/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring.introduce.extractClass;

import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.extractSuperclass.ExtractSuperClassUtil;
import com.intellij.refactoring.lang.ElementsHandler;
import com.intellij.util.containers.MultiMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.refactoring.KotlinRefactoringUtilKt;
import org.jetbrains.kotlin.idea.refactoring.SeparateFileWrapper;
import org.jetbrains.kotlin.idea.refactoring.introduce.extractClass.ExtractSuperRefactoring;
import org.jetbrains.kotlin.idea.refactoring.introduce.extractClass.KotlinExtractSuperHandlerBase;
import org.jetbrains.kotlin.idea.refactoring.introduce.extractClass.ui.KotlinExtractSuperDialogBase;
import org.jetbrains.kotlin.idea.refactoring.memberInfo.KotlinMemberInfo;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0005\b&\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0004J*\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H$J\u0017\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\r\u001a\u00020\bH \u00a2\u0006\u0002\b\u0016J+\u0010\u0017\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0096\u0002J0\u0010\u0017\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u00112\u000e\u0010\u001c\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000f0\u001d2\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0096\u0002\u00a2\u0006\u0002\u0010\u001eJ\u001d\u0010\u001f\u001a\u00020\u00042\u000e\u0010\u001c\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000f0\u001dH\u0016\u00a2\u0006\u0002\u0010 J \u0010!\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/introduce/extractClass/KotlinExtractSuperHandlerBase;", "Lcom/intellij/refactoring/RefactoringActionHandler;", "Lcom/intellij/refactoring/lang/ElementsHandler;", "isExtractInterface", "", "(Z)V", "checkConflicts", "originalClass", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "dialog", "Lorg/jetbrains/kotlin/idea/refactoring/introduce/extractClass/ui/KotlinExtractSuperDialogBase;", "doInvoke", "", "klass", "targetParent", "Lcom/intellij/psi/PsiElement;", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "getErrorMessage", "", "getErrorMessage$idea", "invoke", "file", "Lcom/intellij/psi/PsiFile;", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "elements", "", "(Lcom/intellij/openapi/project/Project;[Lcom/intellij/psi/PsiElement;Lcom/intellij/openapi/actionSystem/DataContext;)V", "isEnabledOnElements", "([Lcom/intellij/psi/PsiElement;)Z", "selectElements", "idea"})
public abstract class KotlinExtractSuperHandlerBase
implements RefactoringActionHandler,
ElementsHandler {
    private final boolean isExtractInterface;

    public boolean isEnabledOnElements(@NotNull PsiElement[] elements2) {
        Intrinsics.checkParameterIsNotNull((Object)elements2, (String)"elements");
        return ArraysKt.singleOrNull((Object[])elements2) instanceof KtClassOrObject;
    }

    public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file2, @Nullable DataContext dataContext) {
        PsiElement element2;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        int offset2 = editor.getCaretModel().getOffset();
        PsiElement psiElement2 = file2.findElementAt(offset2);
        if (psiElement2 == null) {
            return;
        }
        PsiElement $receiver$iv = element2 = psiElement2;
        KtClassOrObject ktClassOrObject = (KtClassOrObject)PsiTreeUtil.getParentOfType((PsiElement)$receiver$iv, KtClassOrObject.class, (boolean)false);
        if (ktClassOrObject == null) {
            return;
        }
        KtClassOrObject klass2 = ktClassOrObject;
        editor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
        this.selectElements(klass2, project, editor);
    }

    public void invoke(@NotNull Project project, @NotNull PsiElement[] elements2, @Nullable DataContext dataContext) {
        PsiElement $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)elements2, (String)"elements");
        if (dataContext == null) {
            return;
        }
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        PsiElement psiElement2 = PsiTreeUtil.findCommonParent((PsiElement[])Arrays.copyOf(elements2, elements2.length));
        if (psiElement2 == null || (psiElement2 = (KtClassOrObject)PsiTreeUtil.getParentOfType((PsiElement)($receiver$iv = psiElement2), KtClassOrObject.class, (boolean)false)) == null) {
            return;
        }
        PsiElement klass2 = psiElement2;
        this.selectElements((KtClassOrObject)klass2, project, editor);
    }

    public final void selectElements(@NotNull KtClassOrObject klass2, @NotNull Project project, @Nullable Editor editor) {
        Intrinsics.checkParameterIsNotNull((Object)klass2, (String)"klass");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Collection collection = KotlinRefactoringUtilKt.getExtractionContainers(klass2, true, true);
        PsiManagerEx psiManagerEx = klass2.getManager();
        Intrinsics.checkExpressionValueIsNotNull((Object)psiManagerEx, (String)"klass.manager");
        List containers = CollectionsKt.plus((Collection)collection, (Object)((Object)new SeparateFileWrapper((PsiManager)psiManagerEx)));
        if (editor == null) {
            this.doInvoke(klass2, (PsiElement)CollectionsKt.first((List)containers), project, editor);
            return;
        }
        KotlinRefactoringUtilKt.chooseContainerElementIfNecessary(containers, editor, CollectionsKt.first((List)containers) instanceof KtFile ? "Select target file" : "Select target code block / file", true, selectElements.1.INSTANCE, (Function1)new Function1<NavigatablePsiElement, Unit>(this, klass2, project, editor){
            final /* synthetic */ KotlinExtractSuperHandlerBase this$0;
            final /* synthetic */ KtClassOrObject $klass;
            final /* synthetic */ Project $project;
            final /* synthetic */ Editor $editor;

            public final void invoke(@NotNull NavigatablePsiElement it) {
                NavigatablePsiElement navigatablePsiElement;
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                if (it instanceof SeparateFileWrapper) {
                    PsiDirectory psiDirectory = this.$klass.getContainingFile().getParent();
                    if (psiDirectory == null) {
                        Intrinsics.throwNpe();
                    }
                    Intrinsics.checkExpressionValueIsNotNull((Object)psiDirectory, (String)"klass.containingFile.parent!!");
                    navigatablePsiElement = (NavigatablePsiElement)psiDirectory;
                } else {
                    navigatablePsiElement = it;
                }
                this.this$0.doInvoke(this.$klass, (PsiElement)navigatablePsiElement, this.$project, this.$editor);
            }
            {
                this.this$0 = kotlinExtractSuperHandlerBase;
                this.$klass = ktClassOrObject;
                this.$project = project;
                this.$editor = editor;
                super(1);
            }
        });
    }

    protected final boolean checkConflicts(@NotNull KtClassOrObject originalClass, @NotNull KotlinExtractSuperDialogBase dialog2) {
        Intrinsics.checkParameterIsNotNull((Object)originalClass, (String)"originalClass");
        Intrinsics.checkParameterIsNotNull((Object)((Object)dialog2), (String)"dialog");
        List<KotlinMemberInfo> list2 = dialog2.getSelectedMembers();
        PsiElement psiElement2 = dialog2.getSelectedTargetParent();
        String string = dialog2.getExtractedSuperName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"dialog.extractedSuperName");
        MultiMap<PsiElement, String> conflicts2 = ExtractSuperRefactoring.Companion.collectConflicts(originalClass, list2, psiElement2, string, this.isExtractInterface);
        return ExtractSuperClassUtil.showConflicts((DialogWrapper)((DialogWrapper)dialog2), conflicts2, (Project)originalClass.getProject());
    }

    @Nullable
    public abstract String getErrorMessage$idea(@NotNull KtClassOrObject var1);

    protected abstract void doInvoke(@NotNull KtClassOrObject var1, @NotNull PsiElement var2, @NotNull Project var3, @Nullable Editor var4);

    public KotlinExtractSuperHandlerBase(boolean isExtractInterface) {
        this.isExtractInterface = isExtractInterface;
    }
}

