/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring.move.moveFilesOrDirectories;

import com.intellij.lang.Language;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.JavaProjectRootsUtil;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.light.LightElement;
import com.intellij.refactoring.move.moveFilesOrDirectories.MoveFileHandler;
import com.intellij.refactoring.move.moveFilesOrDirectories.MoveFilesOrDirectoriesUtil;
import com.intellij.usageView.UsageInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.KotlinLanguage;
import org.jetbrains.kotlin.idea.codeInsight.shorten.ShortenWaitingSetKt;
import org.jetbrains.kotlin.idea.core.PackageUtilsKt;
import org.jetbrains.kotlin.idea.core.UtilsKt;
import org.jetbrains.kotlin.idea.refactoring.KotlinRefactoringUtilKt;
import org.jetbrains.kotlin.idea.refactoring.move.ContainerChangeInfo;
import org.jetbrains.kotlin.idea.refactoring.move.ContainerInfo;
import org.jetbrains.kotlin.idea.refactoring.move.MoveUtilsKt;
import org.jetbrains.kotlin.idea.refactoring.move.moveDeclarations.EmptyKotlinMoveTarget;
import org.jetbrains.kotlin.idea.refactoring.move.moveDeclarations.KotlinMoveTarget;
import org.jetbrains.kotlin.idea.refactoring.move.moveDeclarations.KotlinMoveTargetForDeferredFile;
import org.jetbrains.kotlin.idea.refactoring.move.moveDeclarations.MoveDeclarationsDelegate;
import org.jetbrains.kotlin.idea.refactoring.move.moveDeclarations.MoveDeclarationsDescriptor;
import org.jetbrains.kotlin.idea.refactoring.move.moveDeclarations.MoveKotlinDeclarationsProcessor;
import org.jetbrains.kotlin.idea.refactoring.move.moveDeclarations.Mover;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.FqNameUnsafe;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtPackageDirective;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0002$%B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0016J\u001d\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0000\u00a2\u0006\u0002\b\rJ0\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\u00062\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u0004H\u0016J\u001a\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0011\u001a\u00020\u00062\b\u0010\u000b\u001a\u0004\u0018\u00010\fJ,\u0010\u0016\u001a\u00020\u00172\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\f2\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u001b0\u001aH\u0016J,\u0010\u001c\u001a\u00020\u00172\u000e\u0010\u001d\u001a\n\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u000f2\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u001b0\u001eH\u0016J\u001e\u0010\u001c\u001a\u00020\u00172\u000e\u0010\u001d\u001a\n\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u000f2\u0006\u0010\u001f\u001a\u00020\u0015J\u0010\u0010 \u001a\u00020\u00172\u0006\u0010\t\u001a\u00020\u0006H\u0016J \u0010!\u001a\u0004\u0018\u00010\"*\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010#\u001a\u00020\u0004H\u0002\u00a8\u0006&"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/move/moveFilesOrDirectories/MoveKotlinFileHandler;", "Lcom/intellij/refactoring/move/moveFilesOrDirectories/MoveFileHandler;", "()V", "canProcessElement", "", "element", "Lcom/intellij/psi/PsiFile;", "findInternalUsages", "Lorg/jetbrains/kotlin/idea/refactoring/move/moveFilesOrDirectories/MoveKotlinFileHandler$InternalUsagesWrapper;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "newParent", "Lcom/intellij/psi/PsiDirectory;", "findInternalUsages$idea", "findUsages", "", "Lcom/intellij/usageView/UsageInfo;", "psiFile", "searchInComments", "searchInNonJavaFiles", "initMoveProcessor", "Lorg/jetbrains/kotlin/idea/refactoring/move/moveDeclarations/MoveKotlinDeclarationsProcessor;", "prepareMovedFile", "", "moveDestination", "oldToNewMap", "", "Lcom/intellij/psi/PsiElement;", "retargetUsages", "usageInfos", "", "moveDeclarationsProcessor", "updateMovedFile", "getPackageNameInfo", "Lorg/jetbrains/kotlin/idea/refactoring/move/ContainerChangeInfo;", "clearUserData", "InternalUsagesWrapper", "MoveContext", "idea"})
public final class MoveKotlinFileHandler
extends MoveFileHandler {
    private final ContainerChangeInfo getPackageNameInfo(@NotNull KtFile $receiver, PsiDirectory newParent, boolean clearUserData) {
        Boolean bl = MoveUtilsKt.getUpdatePackageDirective($receiver);
        boolean shouldUpdatePackageDirective = bl != null ? bl : PackageUtilsKt.packageMatchesDirectory($receiver);
        MoveUtilsKt.setUpdatePackageDirective($receiver, clearUserData ? null : Boolean.valueOf(shouldUpdatePackageDirective));
        if (!shouldUpdatePackageDirective) {
            return null;
        }
        FqName oldPackageName = $receiver.getPackageFqName();
        PsiDirectory psiDirectory = newParent;
        if (psiDirectory == null || (psiDirectory = PackageUtilsKt.getPackage(psiDirectory)) == null) {
            FqName fqName2 = oldPackageName;
            Intrinsics.checkExpressionValueIsNotNull((Object)fqName2, (String)"oldPackageName");
            return new ContainerChangeInfo(new ContainerInfo.Package(fqName2), ContainerInfo.UnknownPackage.INSTANCE);
        }
        PsiDirectory newPackage = psiDirectory;
        FqNameUnsafe newPackageName = new FqNameUnsafe(newPackage.getQualifiedName());
        if (Intrinsics.areEqual((Object)oldPackageName.asString(), (Object)newPackageName.asString()) && Intrinsics.areEqual((Object)ModuleUtilCore.findModuleForPsiElement((PsiElement)((PsiElement)$receiver)), (Object)ModuleUtilCore.findModuleForPsiElement((PsiElement)((PsiElement)newParent)))) {
            return null;
        }
        if (!KotlinRefactoringUtilKt.hasIdentifiersOnly(newPackageName)) {
            return null;
        }
        FqName fqName3 = oldPackageName;
        Intrinsics.checkExpressionValueIsNotNull((Object)fqName3, (String)"oldPackageName");
        ContainerInfo containerInfo = new ContainerInfo.Package(fqName3);
        FqName fqName4 = newPackageName.toSafe();
        Intrinsics.checkExpressionValueIsNotNull((Object)fqName4, (String)"newPackageName.toSafe()");
        return new ContainerChangeInfo(containerInfo, new ContainerInfo.Package(fqName4));
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final MoveKotlinDeclarationsProcessor initMoveProcessor(@NotNull PsiFile psiFile, @Nullable PsiDirectory newParent) {
        void $receiver$iv$iv;
        void $receiver$iv;
        MoveKotlinDeclarationsProcessor moveKotlinDeclarationsProcessor;
        MoveDeclarationsDescriptor moveDeclarationsDescriptor;
        KotlinMoveTarget kotlinMoveTarget;
        ContainerInfo newPackage;
        Intrinsics.checkParameterIsNotNull((Object)psiFile, (String)"psiFile");
        if (!(psiFile instanceof KtFile)) {
            return null;
        }
        if (newParent == null) {
            return null;
        }
        ContainerChangeInfo containerChangeInfo = this.getPackageNameInfo((KtFile)psiFile, newParent, false);
        if (containerChangeInfo == null) {
            return null;
        }
        ContainerChangeInfo packageNameInfo = containerChangeInfo;
        Project project = ((KtFile)psiFile).getProject();
        ContainerInfo containerInfo = newPackage = packageNameInfo.getNewContainer();
        if (Intrinsics.areEqual((Object)containerInfo, (Object)ContainerInfo.UnknownPackage.INSTANCE)) {
            kotlinMoveTarget = EmptyKotlinMoveTarget.INSTANCE;
        } else {
            FqName fqName2 = newPackage.getFqName();
            if (fqName2 == null) {
                Intrinsics.throwNpe();
            }
            kotlinMoveTarget = new KotlinMoveTargetForDeferredFile(fqName2, newParent, null, (Function1)new Function1<KtFile, KtFile>(newParent, psiFile){
                final /* synthetic */ PsiDirectory $newParent;
                final /* synthetic */ PsiFile $psiFile;

                @Nullable
                public final KtFile invoke(@NotNull KtFile it) {
                    KtFile ktFile;
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    PsiDirectory psiDirectory = this.$newParent;
                    if (psiDirectory != null) {
                        PsiDirectory psiDirectory2;
                        PsiDirectory it2 = psiDirectory2 = psiDirectory;
                        MoveFilesOrDirectoriesUtil.doMoveFile((PsiFile)this.$psiFile, (PsiDirectory)it2);
                        PsiFile psiFile = it2.findFile(((KtFile)this.$psiFile).getName());
                        if (!(psiFile instanceof KtFile)) {
                            psiFile = null;
                        }
                        ktFile = (KtFile)psiFile;
                    } else {
                        ktFile = null;
                    }
                    return ktFile;
                }
                {
                    this.$newParent = psiDirectory;
                    this.$psiFile = psiFile;
                    super(1);
                }
            }, 4, null);
        }
        KotlinMoveTarget moveTarget2 = kotlinMoveTarget;
        Project project2 = project;
        Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"project");
        Iterable iterable = ((KtFile)psiFile).getDeclarations();
        MoveDeclarationsDescriptor moveDeclarationsDescriptor2 = moveDeclarationsDescriptor;
        MoveDeclarationsDescriptor moveDeclarationsDescriptor3 = moveDeclarationsDescriptor;
        Project project3 = project2;
        MoveKotlinDeclarationsProcessor moveKotlinDeclarationsProcessor2 = moveKotlinDeclarationsProcessor;
        MoveKotlinDeclarationsProcessor moveKotlinDeclarationsProcessor3 = moveKotlinDeclarationsProcessor;
        void var9_14 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            if (!(element$iv$iv instanceof KtNamedDeclaration)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List list2 = (List)destination$iv$iv;
        moveDeclarationsDescriptor2(list2, moveTarget2, MoveDeclarationsDelegate.TopLevel.INSTANCE, false, false, false, false, null, false, 472, null);
        moveKotlinDeclarationsProcessor2(project3, moveDeclarationsDescriptor3, Mover.Idle.INSTANCE);
        MoveKotlinDeclarationsProcessor declarationMoveProcessor = moveKotlinDeclarationsProcessor3;
        return declarationMoveProcessor;
    }

    public boolean canProcessElement(@Nullable PsiFile element2) {
        if (element2 instanceof PsiCompiledElement || !(element2 instanceof KtFile)) {
            return false;
        }
        return !JavaProjectRootsUtil.isOutsideJavaSourceRoot((PsiFile)element2);
    }

    @NotNull
    public final InternalUsagesWrapper findInternalUsages$idea(@NotNull KtFile file2, @NotNull PsiDirectory newParent) {
        ContainerChangeInfo containerChangeInfo;
        ContainerChangeInfo it;
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)newParent, (String)"newParent");
        ContainerChangeInfo packageNameInfo = this.getPackageNameInfo(file2, newParent, false);
        Object object = packageNameInfo;
        if (object == null || (object = MoveUtilsKt.getInternalReferencesToUpdateOnPackageNameChange(file2, it = (containerChangeInfo = object))) == null) {
            object = CollectionsKt.emptyList();
        }
        List<UsageInfo> usages2 = object;
        return new InternalUsagesWrapper(file2, (List<? extends UsageInfo>)usages2);
    }

    @NotNull
    public List<UsageInfo> findUsages(@NotNull PsiFile psiFile, @Nullable PsiDirectory newParent, boolean searchInComments, boolean searchInNonJavaFiles) {
        ArrayList usages2;
        block2: {
            Object object;
            Collection collection;
            MoveKotlinDeclarationsProcessor it;
            MoveKotlinDeclarationsProcessor moveKotlinDeclarationsProcessor;
            Intrinsics.checkParameterIsNotNull((Object)psiFile, (String)"psiFile");
            if (!(psiFile instanceof KtFile)) {
                return CollectionsKt.emptyList();
            }
            usages2 = new ArrayList();
            MoveKotlinDeclarationsProcessor moveKotlinDeclarationsProcessor2 = this.initMoveProcessor(psiFile, newParent);
            if (moveKotlinDeclarationsProcessor2 != null) {
                it = moveKotlinDeclarationsProcessor = moveKotlinDeclarationsProcessor2;
                collection = usages2;
                object = it.findUsages();
                CollectionsKt.addAll((Collection)collection, (Object[])object);
                collection = usages2;
                object = it.getConflictsAsUsages();
                CollectionsKt.addAll((Collection)collection, (Iterable)object);
            }
            PsiDirectory psiDirectory = newParent;
            if (psiDirectory == null) break block2;
            moveKotlinDeclarationsProcessor = psiDirectory;
            it = (PsiDirectory)moveKotlinDeclarationsProcessor;
            collection = usages2;
            object = this.findInternalUsages$idea((KtFile)psiFile, (PsiDirectory)it);
            collection.add(object);
        }
        return usages2;
    }

    public void prepareMovedFile(@NotNull PsiFile file2, @NotNull PsiDirectory moveDestination, @NotNull Map<PsiElement, PsiElement> oldToNewMap) {
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)moveDestination, (String)"moveDestination");
        Intrinsics.checkParameterIsNotNull(oldToNewMap, (String)"oldToNewMap");
        MoveKotlinDeclarationsProcessor moveKotlinDeclarationsProcessor = this.initMoveProcessor(file2, moveDestination);
        if (moveKotlinDeclarationsProcessor == null) {
            return;
        }
        MoveKotlinDeclarationsProcessor moveProcessor = moveKotlinDeclarationsProcessor;
        PsiManager psiManager = file2.getManager();
        Intrinsics.checkExpressionValueIsNotNull((Object)psiManager, (String)"file.manager");
        MoveContext moveContext = new MoveContext(psiManager, moveProcessor);
        Map<PsiElement, PsiElement> map2 = oldToNewMap;
        MoveContext moveContext2 = moveContext;
        map2.put((PsiElement)moveContext, (PsiElement)moveContext2);
    }

    public void updateMovedFile(@NotNull PsiFile file2) {
        block4: {
            Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
            if (!(file2 instanceof KtFile)) {
                return;
            }
            PsiDirectory psiDirectory = ((KtFile)file2).getParent();
            if (psiDirectory == null) {
                return;
            }
            PsiDirectory newDirectory = psiDirectory;
            ContainerChangeInfo containerChangeInfo = this.getPackageNameInfo((KtFile)file2, newDirectory, true);
            if (containerChangeInfo == null) {
                return;
            }
            ContainerChangeInfo packageNameInfo = containerChangeInfo;
            KtPackageDirective ktPackageDirective = ((KtFile)file2).getPackageDirective();
            if (ktPackageDirective == null) break block4;
            FqName fqName2 = packageNameInfo.getNewContainer().getFqName();
            if (fqName2 == null) {
                Intrinsics.throwNpe();
            }
            ktPackageDirective.setFqName(UtilsKt.quoteIfNeeded(fqName2));
        }
    }

    public void retargetUsages(@Nullable List<? extends UsageInfo> usageInfos, @NotNull Map<PsiElement, ? extends PsiElement> oldToNewMap) {
        Object v0;
        block2: {
            Intrinsics.checkParameterIsNotNull(oldToNewMap, (String)"oldToNewMap");
            Iterable $receiver$iv = oldToNewMap.keySet();
            for (Object element$iv : $receiver$iv) {
                if (!(element$iv instanceof MoveContext)) continue;
                v0 = element$iv;
                break block2;
            }
            v0 = null;
        }
        MoveContext moveContext = v0;
        if (moveContext == null) {
            return;
        }
        MoveContext moveContext2 = moveContext;
        this.retargetUsages(usageInfos, moveContext2.getDeclarationMoveProcessor());
    }

    public final void retargetUsages(@Nullable List<? extends UsageInfo> usageInfos, @NotNull MoveKotlinDeclarationsProcessor moveDeclarationsProcessor) {
        Object object;
        block5: {
            block4: {
                Object v1;
                block3: {
                    Intrinsics.checkParameterIsNotNull((Object)((Object)moveDeclarationsProcessor), (String)"moveDeclarationsProcessor");
                    object = usageInfos;
                    if (object == null) break block4;
                    Iterable $receiver$iv = (Iterable)object;
                    for (Object element$iv : $receiver$iv) {
                        if (!(element$iv instanceof InternalUsagesWrapper)) continue;
                        v1 = element$iv;
                        break block3;
                    }
                    v1 = null;
                }
                if ((object = (InternalUsagesWrapper)v1) != null && (object = ((InternalUsagesWrapper)((Object)object)).getUsages()) != null) break block5;
            }
            object = CollectionsKt.emptyList();
        }
        MoveUtilsKt.postProcessMoveUsages$default((List)object, null, null, 6, null);
        ShortenWaitingSetKt.runWithElementsToShortenIsEmptyIgnored(moveDeclarationsProcessor.getProject(), (Function0<Unit>)((Function0)new Function0<Unit>(usageInfos, moveDeclarationsProcessor){
            final /* synthetic */ List $usageInfos;
            final /* synthetic */ MoveKotlinDeclarationsProcessor $moveDeclarationsProcessor;

            public final void invoke() {
                block0: {
                    List list2;
                    List list3 = this.$usageInfos;
                    if (list3 == null) break block0;
                    List it = list2 = list3;
                    this.$moveDeclarationsProcessor.execute(it);
                }
            }
            {
                this.$usageInfos = list2;
                this.$moveDeclarationsProcessor = moveKotlinDeclarationsProcessor;
                super(0);
            }
        }));
    }

    @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00010\u0005\u00a2\u0006\u0002\u0010\u0006R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/move/moveFilesOrDirectories/MoveKotlinFileHandler$InternalUsagesWrapper;", "Lcom/intellij/usageView/UsageInfo;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "usages", "", "(Lorg/jetbrains/kotlin/psi/KtFile;Ljava/util/List;)V", "getUsages", "()Ljava/util/List;", "idea"})
    public static final class InternalUsagesWrapper
    extends UsageInfo {
        @NotNull
        private final List<UsageInfo> usages;

        @NotNull
        public final List<UsageInfo> getUsages() {
            return this.usages;
        }

        public InternalUsagesWrapper(@NotNull KtFile file2, @NotNull List<? extends UsageInfo> usages2) {
            Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
            Intrinsics.checkParameterIsNotNull(usages2, (String)"usages");
            super((PsiFile)file2);
            this.usages = usages2;
        }
    }

    @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\t\u001a\u00020\nH\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/move/moveFilesOrDirectories/MoveKotlinFileHandler$MoveContext;", "Lcom/intellij/psi/impl/light/LightElement;", "psiManager", "Lcom/intellij/psi/PsiManager;", "declarationMoveProcessor", "Lorg/jetbrains/kotlin/idea/refactoring/move/moveDeclarations/MoveKotlinDeclarationsProcessor;", "(Lcom/intellij/psi/PsiManager;Lorg/jetbrains/kotlin/idea/refactoring/move/moveDeclarations/MoveKotlinDeclarationsProcessor;)V", "getDeclarationMoveProcessor", "()Lorg/jetbrains/kotlin/idea/refactoring/move/moveDeclarations/MoveKotlinDeclarationsProcessor;", "toString", "", "idea"})
    private static final class MoveContext
    extends LightElement {
        @NotNull
        private final MoveKotlinDeclarationsProcessor declarationMoveProcessor;

        @NotNull
        public String toString() {
            return "";
        }

        @NotNull
        public final MoveKotlinDeclarationsProcessor getDeclarationMoveProcessor() {
            return this.declarationMoveProcessor;
        }

        public MoveContext(@NotNull PsiManager psiManager, @NotNull MoveKotlinDeclarationsProcessor declarationMoveProcessor) {
            Intrinsics.checkParameterIsNotNull((Object)psiManager, (String)"psiManager");
            Intrinsics.checkParameterIsNotNull((Object)((Object)declarationMoveProcessor), (String)"declarationMoveProcessor");
            super(psiManager, (Language)KotlinLanguage.INSTANCE);
            this.declarationMoveProcessor = declarationMoveProcessor;
        }
    }
}

