/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.j2k;

import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.tree.IElementType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.j2k.CodeConverter;
import org.jetbrains.kotlin.j2k.Converter;
import org.jetbrains.kotlin.j2k.ConverterKt;
import org.jetbrains.kotlin.j2k.ConverterSettings;
import org.jetbrains.kotlin.j2k.ExpressionConverter;
import org.jetbrains.kotlin.j2k.ExpressionConverterKt;
import org.jetbrains.kotlin.j2k.ReferenceSearcherKt;
import org.jetbrains.kotlin.j2k.SpecialExpressionConverter;
import org.jetbrains.kotlin.j2k.SpecialStatementConverter;
import org.jetbrains.kotlin.j2k.StatementConverter;
import org.jetbrains.kotlin.j2k.StatementConverterKt;
import org.jetbrains.kotlin.j2k.TypeConverter;
import org.jetbrains.kotlin.j2k.UtilsKt;
import org.jetbrains.kotlin.j2k.ast.ArgumentList;
import org.jetbrains.kotlin.j2k.ast.BangBangExpression;
import org.jetbrains.kotlin.j2k.ast.Block;
import org.jetbrains.kotlin.j2k.ast.CommentsAndSpacesInheritance;
import org.jetbrains.kotlin.j2k.ast.Element;
import org.jetbrains.kotlin.j2k.ast.ElementKt;
import org.jetbrains.kotlin.j2k.ast.ErrorType;
import org.jetbrains.kotlin.j2k.ast.Expression;
import org.jetbrains.kotlin.j2k.ast.Identifier;
import org.jetbrains.kotlin.j2k.ast.IdentifierKt;
import org.jetbrains.kotlin.j2k.ast.LBrace;
import org.jetbrains.kotlin.j2k.ast.LPar;
import org.jetbrains.kotlin.j2k.ast.LiteralExpression;
import org.jetbrains.kotlin.j2k.ast.LocalVariable;
import org.jetbrains.kotlin.j2k.ast.MethodCallExpression;
import org.jetbrains.kotlin.j2k.ast.Nullability;
import org.jetbrains.kotlin.j2k.ast.Operator;
import org.jetbrains.kotlin.j2k.ast.ParenthesizedExpression;
import org.jetbrains.kotlin.j2k.ast.PrefixExpression;
import org.jetbrains.kotlin.j2k.ast.RBrace;
import org.jetbrains.kotlin.j2k.ast.RPar;
import org.jetbrains.kotlin.j2k.ast.Statement;
import org.jetbrains.kotlin.j2k.ast.Type;
import org.jetbrains.kotlin.utils.addToStdlib.AddToStdlibKt;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000\u00b4\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\nJ\u000e\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dJ\u000e\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!J0\u0010\"\u001a\u00020#2\b\u0010$\u001a\u0004\u0018\u00010%2\b\b\u0002\u0010&\u001a\u00020\u001b2\u0014\b\u0002\u0010'\u001a\u000e\u0012\u0004\u0012\u00020)\u0012\u0004\u0012\u00020\u001b0(J&\u0010*\u001a\u00020+2\b\u0010,\u001a\u0004\u0018\u00010-2\b\u0010.\u001a\u0004\u0018\u00010\t2\n\b\u0002\u0010/\u001a\u0004\u0018\u000100J\u001a\u0010*\u001a\u00020+2\b\u0010,\u001a\u0004\u0018\u00010-2\b\b\u0002\u00101\u001a\u00020\u001bJ\u001a\u00102\u001a\b\u0012\u0004\u0012\u00020+032\f\u00104\u001a\b\u0012\u0004\u0012\u00020-03J\u000e\u00105\u001a\u0002062\u0006\u0010\u001c\u001a\u00020\u001dJ\u0010\u00107\u001a\u0002082\b\u00109\u001a\u0004\u0018\u00010)J\u0016\u0010:\u001a\u00020;2\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020\tJ\u0018\u0010<\u001a\u00020\u001b2\u0006\u0010=\u001a\u00020\t2\u0006\u0010>\u001a\u00020\tH\u0002J\u000e\u0010?\u001a\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u0003J\u0010\u0010@\u001a\u00020\u00002\b\u0010\b\u001a\u0004\u0018\u00010\tJ\u000e\u0010A\u001a\u00020\u00002\u0006\u0010B\u001a\u00020CJ\u000e\u0010D\u001a\u00020\u00002\u0006\u0010B\u001a\u00020EJ\f\u0010F\u001a\u00020\u001b*\u00020GH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00150\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0016\u001a\u00020\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006H"}, d2={"Lorg/jetbrains/kotlin/j2k/CodeConverter;", "", "converter", "Lorg/jetbrains/kotlin/j2k/Converter;", "expressionConverter", "Lorg/jetbrains/kotlin/j2k/ExpressionConverter;", "statementConverter", "Lorg/jetbrains/kotlin/j2k/StatementConverter;", "methodReturnType", "Lcom/intellij/psi/PsiType;", "(Lorg/jetbrains/kotlin/j2k/Converter;Lorg/jetbrains/kotlin/j2k/ExpressionConverter;Lorg/jetbrains/kotlin/j2k/StatementConverter;Lcom/intellij/psi/PsiType;)V", "getConverter", "()Lorg/jetbrains/kotlin/j2k/Converter;", "getMethodReturnType", "()Lcom/intellij/psi/PsiType;", "settings", "Lorg/jetbrains/kotlin/j2k/ConverterSettings;", "getSettings", "()Lorg/jetbrains/kotlin/j2k/ConverterSettings;", "typeConversionMap", "", "", "typeConverter", "Lorg/jetbrains/kotlin/j2k/TypeConverter;", "getTypeConverter", "()Lorg/jetbrains/kotlin/j2k/TypeConverter;", "canChangeType", "", "variable", "Lcom/intellij/psi/PsiLocalVariable;", "convertArgumentList", "Lorg/jetbrains/kotlin/j2k/ast/ArgumentList;", "list", "Lcom/intellij/psi/PsiExpressionList;", "convertBlock", "Lorg/jetbrains/kotlin/j2k/ast/Block;", "block", "Lcom/intellij/psi/PsiCodeBlock;", "notEmpty", "statementFilter", "Lkotlin/Function1;", "Lcom/intellij/psi/PsiStatement;", "convertExpression", "Lorg/jetbrains/kotlin/j2k/ast/Expression;", "expression", "Lcom/intellij/psi/PsiExpression;", "expectedType", "expectedNullability", "Lorg/jetbrains/kotlin/j2k/ast/Nullability;", "shouldParenthesize", "convertExpressionsInList", "", "expressions", "convertLocalVariable", "Lorg/jetbrains/kotlin/j2k/ast/LocalVariable;", "convertStatement", "Lorg/jetbrains/kotlin/j2k/ast/Statement;", "statement", "convertedExpressionType", "Lorg/jetbrains/kotlin/j2k/ast/Type;", "needConversion", "actual", "expected", "withConverter", "withMethodReturnType", "withSpecialExpressionConverter", "specialConverter", "Lorg/jetbrains/kotlin/j2k/SpecialExpressionConverter;", "withSpecialStatementConverter", "Lorg/jetbrains/kotlin/j2k/SpecialStatementConverter;", "isLiteralWithSign", "Lcom/intellij/psi/PsiPrefixExpression;", "j2k"})
public final class CodeConverter {
    @NotNull
    private final TypeConverter typeConverter;
    @NotNull
    private final ConverterSettings settings;
    private final Map<String, String> typeConversionMap;
    @NotNull
    private final Converter converter;
    private final ExpressionConverter expressionConverter;
    private final StatementConverter statementConverter;
    @Nullable
    private final PsiType methodReturnType;

    @NotNull
    public final TypeConverter getTypeConverter() {
        return this.typeConverter;
    }

    @NotNull
    public final ConverterSettings getSettings() {
        return this.settings;
    }

    @NotNull
    public final CodeConverter withSpecialExpressionConverter(@NotNull SpecialExpressionConverter specialConverter) {
        Intrinsics.checkParameterIsNotNull((Object)specialConverter, (String)"specialConverter");
        return new CodeConverter(this.converter, ExpressionConverterKt.withSpecialConverter(this.expressionConverter, specialConverter), this.statementConverter, this.methodReturnType);
    }

    @NotNull
    public final CodeConverter withSpecialStatementConverter(@NotNull SpecialStatementConverter specialConverter) {
        Intrinsics.checkParameterIsNotNull((Object)specialConverter, (String)"specialConverter");
        return new CodeConverter(this.converter, this.expressionConverter, StatementConverterKt.withSpecialConverter(this.statementConverter, specialConverter), this.methodReturnType);
    }

    @NotNull
    public final CodeConverter withMethodReturnType(@Nullable PsiType methodReturnType) {
        return new CodeConverter(this.converter, this.expressionConverter, this.statementConverter, methodReturnType);
    }

    @NotNull
    public final CodeConverter withConverter(@NotNull Converter converter) {
        Intrinsics.checkParameterIsNotNull((Object)converter, (String)"converter");
        return new CodeConverter(converter, this.expressionConverter, this.statementConverter, this.methodReturnType);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Block convertBlock(@Nullable PsiCodeBlock block, boolean notEmpty, @NotNull Function1<? super PsiStatement, Boolean> statementFilter) {
        Iterable $receiver$iv$iv;
        Iterable $receiver$iv;
        Block block2;
        Intrinsics.checkParameterIsNotNull(statementFilter, (String)"statementFilter");
        if (block == null) {
            return Block.Companion.getEmpty();
        }
        LBrace lBrace = (LBrace)ElementKt.assignPrototype$default(new LBrace(), (PsiElement)block.getLBrace(), null, 2, null);
        RBrace rBrace = (RBrace)ElementKt.assignPrototype$default(new RBrace(), (PsiElement)block.getRBrace(), null, 2, null);
        Object[] objectArray = block.getStatements();
        Block block3 = block2;
        Block block4 = block2;
        void var7_9 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList();
        for (int i = 0; i < ((void)$receiver$iv$iv).length; ++i) {
            void element$iv$iv = $receiver$iv$iv[i];
            if (!((Boolean)statementFilter.invoke((Object)element$iv$iv)).booleanValue()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Collection<Statement> collection = (List)destination$iv$iv;
        $receiver$iv$iv = $receiver$iv = (Iterable)collection;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            PsiStatement $i$f$filterTo = (PsiStatement)item$iv$iv;
            collection = destination$iv$iv;
            Statement statement = this.convertStatement((PsiStatement)it);
            collection.add(statement);
        }
        collection = (List)destination$iv$iv;
        block3((List<? extends Statement>)collection, lBrace, rBrace, notEmpty);
        return (Block)ElementKt.assignPrototype$default(block4, (PsiElement)block, null, 2, null);
    }

    @NotNull
    public static /* bridge */ /* synthetic */ Block convertBlock$default(CodeConverter codeConverter, PsiCodeBlock psiCodeBlock, boolean bl, Function1 function1, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        if ((n & 4) != 0) {
            function1 = convertBlock.1.INSTANCE;
        }
        return codeConverter.convertBlock(psiCodeBlock, bl, (Function1<? super PsiStatement, Boolean>)function1);
    }

    @NotNull
    public final Statement convertStatement(@Nullable PsiStatement statement) {
        if (statement == null) {
            return Statement.Empty.INSTANCE;
        }
        return (Statement)ElementKt.assignPrototype$default(this.statementConverter.convertStatement(statement, this), (PsiElement)statement, null, 2, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Expression> convertExpressionsInList(@NotNull List<? extends PsiExpression> expressions2) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull(expressions2, (String)"expressions");
        Iterable iterable = $receiver$iv = (Iterable)expressions2;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            PsiExpression psiExpression = (PsiExpression)item$iv$iv;
            Collection collection = destination$iv$iv;
            Expression expression2 = (Expression)ElementKt.assignPrototype((Element)CodeConverter.convertExpression$default(this, (PsiExpression)it, false, 2, null), (PsiElement)it, CommentsAndSpacesInheritance.Companion.getLINE_BREAKS());
            collection.add(expression2);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public final ArgumentList convertArgumentList(@NotNull PsiExpressionList list2) {
        Intrinsics.checkParameterIsNotNull((Object)list2, (String)"list");
        return (ArgumentList)ElementKt.assignPrototype$default(new ArgumentList(this.convertExpressionsInList(ArraysKt.asList((Object[])list2.getExpressions())), LPar.Companion.withPrototype(UtilsKt.lPar(list2)), RPar.Companion.withPrototype(UtilsKt.rPar(list2))), (PsiElement)list2, null, 2, null);
    }

    @NotNull
    public final Expression convertExpression(@Nullable PsiExpression expression2, boolean shouldParenthesize) {
        if (expression2 == null) {
            return Expression.Empty.INSTANCE;
        }
        Expression converted = (Expression)ElementKt.assignPrototype$default(this.expressionConverter.convertExpression(expression2, this), (PsiElement)expression2, null, 2, null);
        if (shouldParenthesize) {
            return (Expression)ElementKt.assignNoPrototype((Element)new ParenthesizedExpression(converted));
        }
        return converted;
    }

    @NotNull
    public static /* bridge */ /* synthetic */ Expression convertExpression$default(CodeConverter codeConverter, PsiExpression psiExpression, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return codeConverter.convertExpression(psiExpression, bl);
    }

    @NotNull
    public final LocalVariable convertLocalVariable(@NotNull PsiLocalVariable variable2) {
        Intrinsics.checkParameterIsNotNull((Object)variable2, (String)"variable");
        boolean isVal = this.canChangeType(variable2);
        Type type2 = this.typeConverter.convertVariableType((PsiVariable)variable2);
        Type explicitType2 = AddToStdlibKt.check(type2, (Function1)new Function1<Type, Boolean>(this, variable2, type2, isVal){
            final /* synthetic */ CodeConverter this$0;
            final /* synthetic */ PsiLocalVariable $variable;
            final /* synthetic */ Type $type;
            final /* synthetic */ boolean $isVal;

            public final boolean invoke(@NotNull Type it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return this.this$0.getSettings().getSpecifyLocalVariableTypeByDefault() || this.this$0.getConverter().shouldDeclareVariableType((PsiVariable)this.$variable, this.$type, this.$isVal);
            }
            {
                this.this$0 = codeConverter;
                this.$variable = psiLocalVariable;
                this.$type = type2;
                this.$isVal = bl;
                super(1);
            }
        });
        return (LocalVariable)ElementKt.assignPrototype$default(new LocalVariable(IdentifierKt.declarationIdentifier((PsiNameIdentifierOwner)variable2), Converter.convertAnnotations$default(this.converter, (PsiModifierListOwner)variable2, null, 2, null), this.converter.convertModifiers((PsiModifierListOwner)variable2, false), explicitType2, CodeConverter.convertExpression$default(this, variable2.getInitializer(), variable2.getType(), null, 4, null), isVal), (PsiElement)variable2, null, 2, null);
    }

    public final boolean canChangeType(@NotNull PsiLocalVariable variable2) {
        Intrinsics.checkParameterIsNotNull((Object)variable2, (String)"variable");
        return variable2.hasModifierProperty("final") || variable2.getInitializer() == null || !ReferenceSearcherKt.hasWriteAccesses((PsiVariable)variable2, this.converter.getReferenceSearcher(), (PsiElement)UtilsKt.getContainingMethod((PsiElement)variable2));
    }

    @NotNull
    public final Expression convertExpression(@Nullable PsiExpression expression2, @Nullable PsiType expectedType, @Nullable Nullability expectedNullability) {
        if (expression2 == null) {
            return Identifier.Companion.getEmpty();
        }
        Expression convertedExpression = CodeConverter.convertExpression$default(this, expression2, false, 2, null);
        if (convertedExpression.isNullable() && expectedNullability != null && Intrinsics.areEqual((Object)((Object)expectedNullability), (Object)((Object)Nullability.NotNull))) {
            convertedExpression = BangBangExpression.Companion.surroundIfNullable(convertedExpression);
        }
        if (expectedType == null || Intrinsics.areEqual((Object)expectedType, (Object)PsiType.VOID)) {
            return convertedExpression;
        }
        PsiType psiType = expression2.getType();
        if (psiType == null) {
            return convertedExpression;
        }
        PsiType actualType = psiType;
        if (actualType instanceof PsiPrimitiveType && Intrinsics.areEqual((Object)actualType, (Object)PsiType.NULL) ^ true || actualType instanceof PsiClassType && expectedType instanceof PsiPrimitiveType) {
            convertedExpression = BangBangExpression.Companion.surroundIfNullable(convertedExpression);
        }
        PsiType psiType2 = actualType;
        Intrinsics.checkExpressionValueIsNotNull((Object)psiType2, (String)"actualType");
        if (this.needConversion(psiType2, expectedType)) {
            String expectedTypeStr = expectedType.getCanonicalText();
            if (expression2 instanceof PsiLiteralExpression) {
                if (Intrinsics.areEqual((Object)expectedTypeStr, (Object)"float") || Intrinsics.areEqual((Object)expectedTypeStr, (Object)"double")) {
                    String text2 = ElementKt.canonicalCode(convertedExpression);
                    if (SetsKt.setOf((Object[])new Character[]{Character.valueOf('f'), Character.valueOf('L')}).contains(Character.valueOf(StringsKt.last((CharSequence)text2)))) {
                        String string = text2;
                        int n = 0;
                        int n2 = text2.length() - 1;
                        String string2 = string;
                        if (string2 == null) {
                            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                        }
                        String string3 = string2.substring(n, n2);
                        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                        text2 = string3;
                    }
                    if (Intrinsics.areEqual((Object)expectedTypeStr, (Object)"float")) {
                        text2 = text2 + "f";
                    }
                    if (Intrinsics.areEqual((Object)expectedTypeStr, (Object)"double") && !StringsKt.contains$default((CharSequence)text2, (CharSequence)".", (boolean)false, (int)2, null) && !StringsKt.contains((CharSequence)text2, (CharSequence)"e", (boolean)true)) {
                        text2 = text2 + ".0";
                    }
                    convertedExpression = new LiteralExpression(text2);
                } else if (Intrinsics.areEqual((Object)expectedTypeStr, (Object)"char")) {
                    convertedExpression = MethodCallExpression.Companion.buildNonNull$default(MethodCallExpression.Companion, convertedExpression, "toChar", null, null, null, 28, null);
                }
            } else if (expression2 instanceof PsiPrefixExpression && this.isLiteralWithSign((PsiPrefixExpression)expression2)) {
                Expression operandConverted = CodeConverter.convertExpression$default(this, ((PsiPrefixExpression)expression2).getOperand(), expectedType, null, 4, null);
                IElementType iElementType = ((PsiPrefixExpression)expression2).getOperationSign().getTokenType();
                Intrinsics.checkExpressionValueIsNotNull((Object)iElementType, (String)"expression.operationSign.tokenType");
                convertedExpression = new PrefixExpression((Operator)ElementKt.assignPrototype$default(new Operator(iElementType), (PsiElement)((PsiPrefixExpression)expression2).getOperationSign(), null, 2, null), operandConverted);
            } else {
                String conversion = ConverterKt.getPRIMITIVE_TYPE_CONVERSIONS().get(expectedTypeStr);
                if (conversion != null) {
                    convertedExpression = MethodCallExpression.Companion.buildNonNull$default(MethodCallExpression.Companion, convertedExpression, conversion, null, null, null, 28, null);
                }
            }
        }
        return (Expression)ElementKt.assignPrototype$default(convertedExpression, (PsiElement)expression2, null, 2, null);
    }

    @NotNull
    public static /* bridge */ /* synthetic */ Expression convertExpression$default(CodeConverter codeConverter, PsiExpression psiExpression, PsiType psiType, Nullability nullability, int n, Object object) {
        if ((n & 4) != 0) {
            nullability = null;
        }
        return codeConverter.convertExpression(psiExpression, psiType, nullability);
    }

    @NotNull
    public final Type convertedExpressionType(@NotNull PsiExpression expression2, @NotNull PsiType expectedType) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        Intrinsics.checkParameterIsNotNull((Object)expectedType, (String)"expectedType");
        Expression convertedExpression = CodeConverter.convertExpression$default(this, expression2, false, 2, null);
        PsiType psiType = expression2.getType();
        if (psiType == null) {
            return new ErrorType();
        }
        PsiType actualType = psiType;
        Type resultType = TypeConverter.convertType$default(this.typeConverter, actualType, convertedExpression.isNullable() ? Nullability.Nullable : Nullability.NotNull, null, false, 12, null);
        if (actualType instanceof PsiPrimitiveType && resultType.isNullable() || expectedType instanceof PsiPrimitiveType && actualType instanceof PsiClassType) {
            resultType = resultType.toNotNullType();
        }
        PsiType psiType2 = actualType;
        Intrinsics.checkExpressionValueIsNotNull((Object)psiType2, (String)"actualType");
        if (this.needConversion(psiType2, expectedType)) {
            boolean willConvert;
            String expectedTypeStr = expectedType.getCanonicalText();
            boolean bl = convertedExpression instanceof LiteralExpression || expression2 instanceof PsiPrefixExpression && this.isLiteralWithSign((PsiPrefixExpression)expression2) ? Intrinsics.areEqual((Object)expectedTypeStr, (Object)"float") || Intrinsics.areEqual((Object)expectedTypeStr, (Object)"double") : (willConvert = ConverterKt.getPRIMITIVE_TYPE_CONVERSIONS().get(expectedTypeStr) != null);
            if (willConvert) {
                resultType = TypeConverter.convertType$default(this.typeConverter, expectedType, Nullability.NotNull, null, false, 12, null);
            }
        }
        return resultType;
    }

    private final boolean isLiteralWithSign(@NotNull PsiPrefixExpression $receiver) {
        return $receiver.getOperand() instanceof PsiLiteralExpression && SetsKt.setOf((Object[])new IElementType[]{JavaTokenType.PLUS, JavaTokenType.MINUS}).contains($receiver.getOperationTokenType());
    }

    private final boolean needConversion(PsiType actual, PsiType expected) {
        String actualStr;
        String expectedStr = expected.getCanonicalText();
        return Intrinsics.areEqual((Object)expectedStr, (Object)(actualStr = actual.getCanonicalText())) ^ true && Intrinsics.areEqual((Object)expectedStr, (Object)this.typeConversionMap.get(actualStr)) ^ true && Intrinsics.areEqual((Object)actualStr, (Object)this.typeConversionMap.get(expectedStr)) ^ true;
    }

    @NotNull
    public final Converter getConverter() {
        return this.converter;
    }

    @Nullable
    public final PsiType getMethodReturnType() {
        return this.methodReturnType;
    }

    public CodeConverter(@NotNull Converter converter, @NotNull ExpressionConverter expressionConverter, @NotNull StatementConverter statementConverter, @Nullable PsiType methodReturnType) {
        Intrinsics.checkParameterIsNotNull((Object)converter, (String)"converter");
        Intrinsics.checkParameterIsNotNull((Object)expressionConverter, (String)"expressionConverter");
        Intrinsics.checkParameterIsNotNull((Object)statementConverter, (String)"statementConverter");
        this.converter = converter;
        this.expressionConverter = expressionConverter;
        this.statementConverter = statementConverter;
        this.methodReturnType = methodReturnType;
        this.typeConverter = this.converter.getTypeConverter();
        this.settings = this.converter.getSettings();
        this.typeConversionMap = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"java.lang.Byte", (Object)"byte"), TuplesKt.to((Object)"java.lang.Short", (Object)"short"), TuplesKt.to((Object)"java.lang.Integer", (Object)"int"), TuplesKt.to((Object)"java.lang.Long", (Object)"long"), TuplesKt.to((Object)"java.lang.Float", (Object)"float"), TuplesKt.to((Object)"java.lang.Double", (Object)"double"), TuplesKt.to((Object)"java.lang.Character", (Object)"char")});
    }
}

