/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.j2k.usageProcessing;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiVariable;
import java.util.Collection;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.j2k.CodeConverter;
import org.jetbrains.kotlin.j2k.SpecialExpressionConverter;
import org.jetbrains.kotlin.j2k.ast.Expression;
import org.jetbrains.kotlin.j2k.usageProcessing.ConvertedCodeProcessor;
import org.jetbrains.kotlin.j2k.usageProcessing.UsageProcessing;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0018\u0010\u0002\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u0003\u00a2\u0006\u0002\u0010\u0007J\u001a\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R#\u0010\u0002\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/j2k/usageProcessing/UsageProcessingExpressionConverter;", "Lorg/jetbrains/kotlin/j2k/SpecialExpressionConverter;", "processings", "", "Lcom/intellij/psi/PsiElement;", "", "Lorg/jetbrains/kotlin/j2k/usageProcessing/UsageProcessing;", "(Ljava/util/Map;)V", "getProcessings", "()Ljava/util/Map;", "convertExpression", "Lorg/jetbrains/kotlin/j2k/ast/Expression;", "expression", "Lcom/intellij/psi/PsiExpression;", "codeConverter", "Lorg/jetbrains/kotlin/j2k/CodeConverter;", "j2k"})
public final class UsageProcessingExpressionConverter
implements SpecialExpressionConverter {
    @NotNull
    private final Map<PsiElement, Collection<UsageProcessing>> processings;

    @Override
    @Nullable
    public Expression convertExpression(@NotNull PsiExpression expression2, @NotNull CodeConverter codeConverter) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        Intrinsics.checkParameterIsNotNull((Object)codeConverter, (String)"codeConverter");
        if (this.processings.isEmpty()) {
            return null;
        }
        PsiExpression psiExpression = expression2;
        if (psiExpression instanceof PsiReferenceExpression) {
            PsiElement psiElement2 = ((PsiReferenceExpression)expression2).resolve();
            if (!(psiElement2 instanceof PsiVariable)) {
                psiElement2 = null;
            }
            PsiVariable psiVariable = (PsiVariable)psiElement2;
            if (psiVariable == null) {
                return null;
            }
            PsiVariable target = psiVariable;
            Collection<UsageProcessing> collection = this.processings.get(target);
            if (collection == null) {
                return null;
            }
            Collection<UsageProcessing> forTarget = collection;
            for (UsageProcessing processing : forTarget) {
                ConvertedCodeProcessor convertedCodeProcessor2 = processing.getConvertedCodeProcessor();
                Expression converted = convertedCodeProcessor2 != null ? convertedCodeProcessor2.convertVariableUsage((PsiReferenceExpression)expression2, codeConverter) : null;
                if (converted == null) continue;
                return converted;
            }
            return null;
        }
        if (psiExpression instanceof PsiMethodCallExpression) {
            PsiElement psiElement3 = ((PsiMethodCallExpression)expression2).getMethodExpression().resolve();
            if (!(psiElement3 instanceof PsiMethod)) {
                psiElement3 = null;
            }
            PsiMethod psiMethod2 = (PsiMethod)psiElement3;
            if (psiMethod2 == null) {
                return null;
            }
            PsiMethod target = psiMethod2;
            Collection<UsageProcessing> collection = this.processings.get(target);
            if (collection == null) {
                return null;
            }
            Collection<UsageProcessing> forTarget = collection;
            for (UsageProcessing processing : forTarget) {
                ConvertedCodeProcessor convertedCodeProcessor3 = processing.getConvertedCodeProcessor();
                Expression converted = convertedCodeProcessor3 != null ? convertedCodeProcessor3.convertMethodUsage((PsiMethodCallExpression)expression2, codeConverter) : null;
                if (converted == null) continue;
                return converted;
            }
            return null;
        }
        return null;
    }

    @NotNull
    public final Map<PsiElement, Collection<UsageProcessing>> getProcessings() {
        return this.processings;
    }

    public UsageProcessingExpressionConverter(@NotNull Map<PsiElement, ? extends Collection<? extends UsageProcessing>> processings) {
        Intrinsics.checkParameterIsNotNull(processings, (String)"processings");
        this.processings = processings;
    }
}

