/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.config;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.PathUtil;
import java.io.File;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.js.config.JSConfigurationKeys;
import org.jetbrains.kotlin.js.config.JsConfig;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.utils.JsMetadataVersion;
import org.jetbrains.kotlin.utils.KotlinJavascriptMetadata;
import org.jetbrains.kotlin.utils.KotlinJavascriptMetadataUtils;
import org.jetbrains.kotlin.utils.LibraryUtils;

public class LibrarySourcesConfig
extends JsConfig {
    public static final List<String> JS_STDLIB = Collections.singletonList(org.jetbrains.kotlin.utils.PathUtil.getKotlinPathsForDistDirectory().getJsStdLibJarPath().getAbsolutePath());
    public static final List<String> JS_KOTLIN_TEST = Collections.singletonList(org.jetbrains.kotlin.utils.PathUtil.getKotlinPathsForDistDirectory().getJsKotlinTestJarPath().getAbsolutePath());
    public static final Key<String> EXTERNAL_MODULE_NAME = Key.create((String)"externalModule");
    public static final String UNKNOWN_EXTERNAL_MODULE_NAME = "<unknown>";

    public LibrarySourcesConfig(@NotNull Project project, @NotNull CompilerConfiguration configuration2) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/js/config/LibrarySourcesConfig", "<init>"));
        }
        if (configuration2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "org/jetbrains/kotlin/js/config/LibrarySourcesConfig", "<init>"));
        }
        super(project, configuration2);
    }

    @NotNull
    public List<String> getLibraries() {
        List<String> list2 = this.getConfiguration().getList(JSConfigurationKeys.LIBRARIES);
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/config/LibrarySourcesConfig", "getLibraries"));
        }
        return list2;
    }

    @Override
    protected void init(final @NotNull List<KtFile> sourceFilesInLibraries, final @NotNull List<KotlinJavascriptMetadata> metadata) {
        if (sourceFilesInLibraries == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceFilesInLibraries", "org/jetbrains/kotlin/js/config/LibrarySourcesConfig", "init"));
        }
        if (metadata == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "metadata", "org/jetbrains/kotlin/js/config/LibrarySourcesConfig", "init"));
        }
        if (this.getLibraries().isEmpty()) {
            return;
        }
        final PsiManager psiManager = PsiManager.getInstance((Project)this.getProject());
        JsConfig.Reporter report2 = new JsConfig.Reporter(){

            @Override
            public void error(@NotNull String message2) {
                if (message2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "org/jetbrains/kotlin/js/config/LibrarySourcesConfig$1", "error"));
                }
                throw new IllegalStateException(message2);
            }
        };
        Function2<String, VirtualFile, Unit> action2 = new Function2<String, VirtualFile, Unit>(){

            public Unit invoke(String moduleName, VirtualFile file2) {
                if (moduleName != null) {
                    JetFileCollector jetFileCollector = new JetFileCollector(sourceFilesInLibraries, moduleName, psiManager);
                    VfsUtilCore.visitChildrenRecursively((VirtualFile)file2, (VirtualFileVisitor)jetFileCollector);
                } else {
                    String libraryPath = PathUtil.getLocalPath((VirtualFile)file2);
                    assert (libraryPath != null) : "libraryPath for " + file2 + " should not be null";
                    metadata.addAll(KotlinJavascriptMetadataUtils.loadMetadata(libraryPath));
                }
                return Unit.INSTANCE;
            }
        };
        boolean hasErrors = this.checkLibFilesAndReportErrors(report2, action2);
        assert (!hasErrors) : "hasErrors should be false";
    }

    @Override
    public boolean checkLibFilesAndReportErrors(@NotNull JsConfig.Reporter report2) {
        if (report2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "report", "org/jetbrains/kotlin/js/config/LibrarySourcesConfig", "checkLibFilesAndReportErrors"));
        }
        return this.checkLibFilesAndReportErrors(report2, null);
    }

    private boolean checkLibFilesAndReportErrors(@NotNull JsConfig.Reporter report2, @Nullable Function2<String, VirtualFile, Unit> action2) {
        if (report2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "report", "org/jetbrains/kotlin/js/config/LibrarySourcesConfig", "checkLibFilesAndReportErrors"));
        }
        List<String> libraries = this.getLibraries();
        if (libraries.isEmpty()) {
            return false;
        }
        VirtualFileSystem fileSystem = VirtualFileManager.getInstance().getFileSystem("file");
        VirtualFileSystem jarFileSystem = VirtualFileManager.getInstance().getFileSystem("jar");
        HashSet<String> modules = new HashSet<String>();
        for (String path : libraries) {
            String moduleName;
            File filePath = new File(path);
            if (!filePath.exists()) {
                report2.error("Path '" + path + "' does not exist");
                return true;
            }
            VirtualFile file2 = path.endsWith(".jar") || path.endsWith(".zip") ? jarFileSystem.findFileByPath(path + "!/") : fileSystem.findFileByPath(path);
            if (file2 == null) {
                report2.error("File '" + path + "' does not exist or could not be read");
                return true;
            }
            if (LibraryUtils.isOldKotlinJavascriptLibrary(filePath)) {
                moduleName = LibraryUtils.getKotlinJsModuleName(filePath);
                if (!modules.add(moduleName)) {
                    report2.warning("Module \"" + moduleName + "\" is defined in more, than one file");
                }
            } else {
                List<KotlinJavascriptMetadata> metadataList = KotlinJavascriptMetadataUtils.loadMetadata(filePath);
                if (metadataList.isEmpty()) {
                    report2.warning("'" + path + "' is not a valid Kotlin Javascript library");
                    continue;
                }
                for (KotlinJavascriptMetadata metadata : metadataList) {
                    if (!metadata.getVersion().isCompatible()) {
                        report2.error("File '" + path + "' was compiled with an incompatible version of Kotlin. The binary version of its metadata is " + metadata.getVersion() + ", expected version is " + JsMetadataVersion.INSTANCE);
                        return true;
                    }
                    if (modules.add(metadata.getModuleName())) continue;
                    report2.warning("Module \"" + metadata.getModuleName() + "\" is defined in more, than one file");
                }
                moduleName = null;
            }
            if (action2 == null) continue;
            action2.invoke((Object)moduleName, (Object)file2);
        }
        return false;
    }

    private static KtFile getJetFileByVirtualFile(VirtualFile file2, String moduleName, PsiManager psiManager) {
        PsiFile psiFile = psiManager.findFile(file2);
        assert (psiFile != null);
        LibrarySourcesConfig.setupPsiFile(psiFile, moduleName);
        return (KtFile)psiFile;
    }

    private static void setupPsiFile(PsiFile psiFile, String moduleName) {
        psiFile.putUserData(EXTERNAL_MODULE_NAME, (Object)moduleName);
    }

    private static class JetFileCollector
    extends VirtualFileVisitor {
        private final List<KtFile> jetFiles;
        private final String moduleName;
        private final PsiManager psiManager;

        private JetFileCollector(List<KtFile> files2, String name2, PsiManager manager) {
            super(new VirtualFileVisitor.Option[0]);
            this.moduleName = name2;
            this.psiManager = manager;
            this.jetFiles = files2;
        }

        public boolean visitFile(@NotNull VirtualFile file2) {
            if (file2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/js/config/LibrarySourcesConfig$JetFileCollector", "visitFile"));
            }
            if (!file2.isDirectory() && StringUtil.notNullize((String)file2.getExtension()).equalsIgnoreCase("kt")) {
                this.jetFiles.add(LibrarySourcesConfig.getJetFileByVirtualFile(file2, this.moduleName, this.psiManager));
            }
            return true;
        }
    }
}

