/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.resolve.diagnostics;

import com.google.gwt.dev.js.parserExceptions.AbortParsingException;
import com.google.gwt.dev.js.rhino.CodePosition;
import com.google.gwt.dev.js.rhino.ErrorReporter;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory1;
import org.jetbrains.kotlin.diagnostics.ParametrizedDiagnostic;
import org.jetbrains.kotlin.js.resolve.diagnostics.ErrorsJs;
import org.jetbrains.kotlin.js.resolve.diagnostics.JsCallCheckerKt;
import org.jetbrains.kotlin.js.resolve.diagnostics.JsCallData;
import org.jetbrains.kotlin.js.resolve.diagnostics.JsCallDataWithCode;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.resolve.BindingTrace;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ \u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u000bH\u0016J4\u0010\u0013\u001a\u00020\u000f2\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u000bH\u0002J \u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u000bH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\t\u001a\u00020\n*\u00020\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/js/resolve/diagnostics/JsCodeErrorReporter;", "Lcom/google/gwt/dev/js/rhino/ErrorReporter;", "nodeToReport", "Lorg/jetbrains/kotlin/psi/KtExpression;", "code", "", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "(Lorg/jetbrains/kotlin/psi/KtExpression;Ljava/lang/String;Lorg/jetbrains/kotlin/resolve/BindingTrace;)V", "absoluteOffset", "", "Lcom/google/gwt/dev/js/rhino/CodePosition;", "getAbsoluteOffset", "(Lcom/google/gwt/dev/js/rhino/CodePosition;)I", "error", "", "message", "startPosition", "endPosition", "report", "diagnosticFactory", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticFactory1;", "Lorg/jetbrains/kotlin/js/resolve/diagnostics/JsCallData;", "warning", "js.frontend"})
public final class JsCodeErrorReporter
implements ErrorReporter {
    private final KtExpression nodeToReport;
    private final String code;
    private final BindingTrace trace;

    @Override
    public void warning(@NotNull String message2, @NotNull CodePosition startPosition, @NotNull CodePosition endPosition) {
        Intrinsics.checkParameterIsNotNull((Object)message2, (String)"message");
        Intrinsics.checkParameterIsNotNull((Object)startPosition, (String)"startPosition");
        Intrinsics.checkParameterIsNotNull((Object)endPosition, (String)"endPosition");
        DiagnosticFactory1<KtExpression, JsCallData> diagnosticFactory1 = ErrorsJs.JSCODE_WARNING;
        Intrinsics.checkExpressionValueIsNotNull(diagnosticFactory1, (String)"ErrorsJs.JSCODE_WARNING");
        this.report(diagnosticFactory1, message2, startPosition, endPosition);
    }

    @Override
    public void error(@NotNull String message2, @NotNull CodePosition startPosition, @NotNull CodePosition endPosition) {
        Intrinsics.checkParameterIsNotNull((Object)message2, (String)"message");
        Intrinsics.checkParameterIsNotNull((Object)startPosition, (String)"startPosition");
        Intrinsics.checkParameterIsNotNull((Object)endPosition, (String)"endPosition");
        DiagnosticFactory1<KtExpression, JsCallData> diagnosticFactory1 = ErrorsJs.JSCODE_ERROR;
        Intrinsics.checkExpressionValueIsNotNull(diagnosticFactory1, (String)"ErrorsJs.JSCODE_ERROR");
        this.report(diagnosticFactory1, message2, startPosition, endPosition);
        throw (Throwable)new AbortParsingException();
    }

    private final void report(DiagnosticFactory1<KtExpression, JsCallData> diagnosticFactory, String message2, CodePosition startPosition, CodePosition endPosition) {
        JsCallData jsCallData;
        TextRange reportRange;
        if (JsCallCheckerKt.access$isConstantStringLiteral$p(this.nodeToReport)) {
            reportRange = new TextRange(this.getAbsoluteOffset(startPosition), this.getAbsoluteOffset(endPosition));
            jsCallData = new JsCallData(reportRange, message2);
        } else {
            reportRange = this.nodeToReport.getTextRange();
            TextRange codeRange = new TextRange(JsCallCheckerKt.access$offsetOf(this.code, startPosition), JsCallCheckerKt.access$offsetOf(this.code, endPosition));
            TextRange textRange = reportRange;
            Intrinsics.checkExpressionValueIsNotNull((Object)textRange, (String)"reportRange");
            jsCallData = new JsCallDataWithCode(textRange, message2, this.code, codeRange);
        }
        JsCallData data = jsCallData;
        ParametrizedDiagnostic<KtExpression> parametrizedDiagnostic = diagnosticFactory.on((KtExpression)((PsiElement)this.nodeToReport), data);
        this.trace.report(parametrizedDiagnostic);
    }

    private final int getAbsoluteOffset(@NotNull CodePosition $receiver) {
        int quotesLength = this.nodeToReport.getFirstChild().getTextLength();
        return this.nodeToReport.getTextOffset() + quotesLength + JsCallCheckerKt.access$offsetOf(this.code, $receiver);
    }

    public JsCodeErrorReporter(@NotNull KtExpression nodeToReport, @NotNull String code, @NotNull BindingTrace trace) {
        Intrinsics.checkParameterIsNotNull((Object)nodeToReport, (String)"nodeToReport");
        Intrinsics.checkParameterIsNotNull((Object)code, (String)"code");
        Intrinsics.checkParameterIsNotNull((Object)trace, (String)"trace");
        this.nodeToReport = nodeToReport;
        this.code = code;
        this.trace = trace;
    }
}

