/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.load.kotlin;

import com.intellij.openapi.util.Ref;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import kotlin.jvm.functions.Function4;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.load.kotlin.KotlinJvmBinaryClass;
import org.jetbrains.kotlin.load.kotlin.header.KotlinClassHeader;
import org.jetbrains.kotlin.load.kotlin.header.ReadKotlinClassHeaderAnnotationVisitor;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.org.objectweb.asm.AnnotationVisitor;
import org.jetbrains.org.objectweb.asm.ClassReader;
import org.jetbrains.org.objectweb.asm.ClassVisitor;
import org.jetbrains.org.objectweb.asm.FieldVisitor;
import org.jetbrains.org.objectweb.asm.MethodVisitor;

public abstract class FileBasedKotlinClass
implements KotlinJvmBinaryClass {
    private final ClassId classId;
    private final int classVersion;
    private final KotlinClassHeader classHeader;
    private final InnerClassesInfo innerClasses;

    protected FileBasedKotlinClass(@NotNull ClassId classId, int classVersion, @NotNull KotlinClassHeader classHeader, @NotNull InnerClassesInfo innerClasses) {
        if (classId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classId", "org/jetbrains/kotlin/load/kotlin/FileBasedKotlinClass", "<init>"));
        }
        if (classHeader == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classHeader", "org/jetbrains/kotlin/load/kotlin/FileBasedKotlinClass", "<init>"));
        }
        if (innerClasses == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "innerClasses", "org/jetbrains/kotlin/load/kotlin/FileBasedKotlinClass", "<init>"));
        }
        this.classId = classId;
        this.classVersion = classVersion;
        this.classHeader = classHeader;
        this.innerClasses = innerClasses;
    }

    @NotNull
    protected abstract byte[] getFileContents();

    @Nullable
    public static <T extends FileBasedKotlinClass> T create(@NotNull byte[] fileContents, @NotNull Function4<ClassId, Integer, KotlinClassHeader, InnerClassesInfo, T> factory2) {
        if (fileContents == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileContents", "org/jetbrains/kotlin/load/kotlin/FileBasedKotlinClass", "create"));
        }
        if (factory2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "factory", "org/jetbrains/kotlin/load/kotlin/FileBasedKotlinClass", "create"));
        }
        final ReadKotlinClassHeaderAnnotationVisitor readHeaderVisitor = new ReadKotlinClassHeaderAnnotationVisitor();
        final Ref classNameRef = Ref.create();
        final Ref classVersion = Ref.create();
        final InnerClassesInfo innerClasses = new InnerClassesInfo();
        new ClassReader(fileContents).accept(new ClassVisitor(327680){

            public void visit(int version, int access, @NotNull String name2, String signature, String superName, String[] interfaces) {
                if (name2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/load/kotlin/FileBasedKotlinClass$1", "visit"));
                }
                classNameRef.set((Object)name2);
                classVersion.set((Object)version);
            }

            public void visitInnerClass(@NotNull String name2, String outerName, String innerName, int access) {
                if (name2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/load/kotlin/FileBasedKotlinClass$1", "visitInnerClass"));
                }
                innerClasses.add(name2, outerName, innerName);
            }

            public AnnotationVisitor visitAnnotation(@NotNull String desc, boolean visible) {
                if (desc == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "desc", "org/jetbrains/kotlin/load/kotlin/FileBasedKotlinClass$1", "visitAnnotation"));
                }
                return FileBasedKotlinClass.convertAnnotationVisitor(readHeaderVisitor, desc, innerClasses);
            }

            public void visitEnd() {
                readHeaderVisitor.visitEnd();
            }
        }, 7);
        String className2 = (String)classNameRef.get();
        if (className2 == null) {
            return null;
        }
        KotlinClassHeader header = readHeaderVisitor.createHeader();
        if (header == null) {
            return null;
        }
        ClassId id = FileBasedKotlinClass.resolveNameByInternalName(className2, innerClasses);
        return (T)((FileBasedKotlinClass)factory2.invoke((Object)id, classVersion.get(), (Object)header, (Object)innerClasses));
    }

    @Override
    @NotNull
    public ClassId getClassId() {
        ClassId classId = this.classId;
        if (classId == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/load/kotlin/FileBasedKotlinClass", "getClassId"));
        }
        return classId;
    }

    public int getClassVersion() {
        return this.classVersion;
    }

    @Override
    @NotNull
    public KotlinClassHeader getClassHeader() {
        KotlinClassHeader kotlinClassHeader = this.classHeader;
        if (kotlinClassHeader == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/load/kotlin/FileBasedKotlinClass", "getClassHeader"));
        }
        return kotlinClassHeader;
    }

    @Override
    public void loadClassAnnotations(final @NotNull KotlinJvmBinaryClass.AnnotationVisitor annotationVisitor) {
        if (annotationVisitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotationVisitor", "org/jetbrains/kotlin/load/kotlin/FileBasedKotlinClass", "loadClassAnnotations"));
        }
        new ClassReader(this.getFileContents()).accept(new ClassVisitor(327680){

            public AnnotationVisitor visitAnnotation(@NotNull String desc, boolean visible) {
                if (desc == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "desc", "org/jetbrains/kotlin/load/kotlin/FileBasedKotlinClass$2", "visitAnnotation"));
                }
                return FileBasedKotlinClass.convertAnnotationVisitor(annotationVisitor, desc, FileBasedKotlinClass.this.innerClasses);
            }

            public void visitEnd() {
                annotationVisitor.visitEnd();
            }
        }, 7);
    }

    @Nullable
    private static AnnotationVisitor convertAnnotationVisitor(@NotNull KotlinJvmBinaryClass.AnnotationVisitor visitor2, @NotNull String desc, @NotNull InnerClassesInfo innerClasses) {
        if (visitor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "org/jetbrains/kotlin/load/kotlin/FileBasedKotlinClass", "convertAnnotationVisitor"));
        }
        if (desc == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "desc", "org/jetbrains/kotlin/load/kotlin/FileBasedKotlinClass", "convertAnnotationVisitor"));
        }
        if (innerClasses == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "innerClasses", "org/jetbrains/kotlin/load/kotlin/FileBasedKotlinClass", "convertAnnotationVisitor"));
        }
        KotlinJvmBinaryClass.AnnotationArgumentVisitor v = visitor2.visitAnnotation(FileBasedKotlinClass.resolveNameByDesc(desc, innerClasses), SourceElement.NO_SOURCE);
        return v == null ? null : FileBasedKotlinClass.convertAnnotationVisitor(v, innerClasses);
    }

    @NotNull
    private static AnnotationVisitor convertAnnotationVisitor(final @NotNull KotlinJvmBinaryClass.AnnotationArgumentVisitor v, final @NotNull InnerClassesInfo innerClasses) {
        if (v == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "v", "org/jetbrains/kotlin/load/kotlin/FileBasedKotlinClass", "convertAnnotationVisitor"));
        }
        if (innerClasses == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "innerClasses", "org/jetbrains/kotlin/load/kotlin/FileBasedKotlinClass", "convertAnnotationVisitor"));
        }
        AnnotationVisitor annotationVisitor = new AnnotationVisitor(327680){

            public void visit(String name2, @NotNull Object value2) {
                if (value2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "org/jetbrains/kotlin/load/kotlin/FileBasedKotlinClass$3", "visit"));
                }
                v.visit(name2 == null ? null : Name.identifier(name2), value2);
            }

            public AnnotationVisitor visitArray(String name2) {
                final KotlinJvmBinaryClass.AnnotationArrayArgumentVisitor arv = v.visitArray(Name.identifier(name2));
                return arv == null ? null : new AnnotationVisitor(327680){

                    public void visit(String name2, @NotNull Object value2) {
                        if (value2 == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "org/jetbrains/kotlin/load/kotlin/FileBasedKotlinClass$3$1", "visit"));
                        }
                        arv.visit(value2);
                    }

                    public void visitEnum(String name2, @NotNull String desc, @NotNull String value2) {
                        if (desc == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "desc", "org/jetbrains/kotlin/load/kotlin/FileBasedKotlinClass$3$1", "visitEnum"));
                        }
                        if (value2 == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "org/jetbrains/kotlin/load/kotlin/FileBasedKotlinClass$3$1", "visitEnum"));
                        }
                        arv.visitEnum(FileBasedKotlinClass.resolveNameByDesc(desc, innerClasses), Name.identifier(value2));
                    }

                    public void visitEnd() {
                        arv.visitEnd();
                    }
                };
            }

            public AnnotationVisitor visitAnnotation(String name2, @NotNull String desc) {
                if (desc == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "desc", "org/jetbrains/kotlin/load/kotlin/FileBasedKotlinClass$3", "visitAnnotation"));
                }
                KotlinJvmBinaryClass.AnnotationArgumentVisitor arv = v.visitAnnotation(Name.identifier(name2), FileBasedKotlinClass.resolveNameByDesc(desc, innerClasses));
                return arv == null ? null : FileBasedKotlinClass.convertAnnotationVisitor(arv, innerClasses);
            }

            public void visitEnum(String name2, @NotNull String desc, @NotNull String value2) {
                if (desc == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "desc", "org/jetbrains/kotlin/load/kotlin/FileBasedKotlinClass$3", "visitEnum"));
                }
                if (value2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "org/jetbrains/kotlin/load/kotlin/FileBasedKotlinClass$3", "visitEnum"));
                }
                v.visitEnum(Name.identifier(name2), FileBasedKotlinClass.resolveNameByDesc(desc, innerClasses), Name.identifier(value2));
            }

            public void visitEnd() {
                v.visitEnd();
            }
        };
        if (annotationVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/load/kotlin/FileBasedKotlinClass", "convertAnnotationVisitor"));
        }
        return annotationVisitor;
    }

    @Override
    public void visitMembers(final @NotNull KotlinJvmBinaryClass.MemberVisitor memberVisitor) {
        if (memberVisitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "memberVisitor", "org/jetbrains/kotlin/load/kotlin/FileBasedKotlinClass", "visitMembers"));
        }
        new ClassReader(this.getFileContents()).accept(new ClassVisitor(327680){

            public FieldVisitor visitField(int access, @NotNull String name2, @NotNull String desc, String signature, Object value2) {
                if (name2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/load/kotlin/FileBasedKotlinClass$4", "visitField"));
                }
                if (desc == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "desc", "org/jetbrains/kotlin/load/kotlin/FileBasedKotlinClass$4", "visitField"));
                }
                final KotlinJvmBinaryClass.AnnotationVisitor v = memberVisitor.visitField(Name.identifier(name2), desc, value2);
                if (v == null) {
                    return null;
                }
                return new FieldVisitor(327680){

                    public AnnotationVisitor visitAnnotation(@NotNull String desc, boolean visible) {
                        if (desc == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "desc", "org/jetbrains/kotlin/load/kotlin/FileBasedKotlinClass$4$1", "visitAnnotation"));
                        }
                        return FileBasedKotlinClass.convertAnnotationVisitor(v, desc, FileBasedKotlinClass.this.innerClasses);
                    }

                    public void visitEnd() {
                        v.visitEnd();
                    }
                };
            }

            public MethodVisitor visitMethod(int access, @NotNull String name2, @NotNull String desc, String signature, String[] exceptions) {
                if (name2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/load/kotlin/FileBasedKotlinClass$4", "visitMethod"));
                }
                if (desc == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "desc", "org/jetbrains/kotlin/load/kotlin/FileBasedKotlinClass$4", "visitMethod"));
                }
                final KotlinJvmBinaryClass.MethodAnnotationVisitor v = memberVisitor.visitMethod(Name.identifier(name2), desc);
                if (v == null) {
                    return null;
                }
                return new MethodVisitor(327680){

                    public AnnotationVisitor visitAnnotation(@NotNull String desc, boolean visible) {
                        if (desc == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "desc", "org/jetbrains/kotlin/load/kotlin/FileBasedKotlinClass$4$2", "visitAnnotation"));
                        }
                        return FileBasedKotlinClass.convertAnnotationVisitor(v, desc, FileBasedKotlinClass.this.innerClasses);
                    }

                    public AnnotationVisitor visitParameterAnnotation(int parameter, @NotNull String desc, boolean visible) {
                        if (desc == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "desc", "org/jetbrains/kotlin/load/kotlin/FileBasedKotlinClass$4$2", "visitParameterAnnotation"));
                        }
                        KotlinJvmBinaryClass.AnnotationArgumentVisitor av = v.visitParameterAnnotation(parameter, FileBasedKotlinClass.resolveNameByDesc(desc, FileBasedKotlinClass.this.innerClasses), SourceElement.NO_SOURCE);
                        return av == null ? null : FileBasedKotlinClass.convertAnnotationVisitor(av, FileBasedKotlinClass.this.innerClasses);
                    }

                    public void visitEnd() {
                        v.visitEnd();
                    }
                };
            }
        }, 7);
    }

    @NotNull
    private static ClassId resolveNameByDesc(@NotNull String desc, @NotNull InnerClassesInfo innerClasses) {
        if (desc == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "desc", "org/jetbrains/kotlin/load/kotlin/FileBasedKotlinClass", "resolveNameByDesc"));
        }
        if (innerClasses == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "innerClasses", "org/jetbrains/kotlin/load/kotlin/FileBasedKotlinClass", "resolveNameByDesc"));
        }
        assert (desc.startsWith("L") && desc.endsWith(";")) : "Not a JVM descriptor: " + desc;
        String name2 = desc.substring(1, desc.length() - 1);
        ClassId classId = FileBasedKotlinClass.resolveNameByInternalName(name2, innerClasses);
        if (classId == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/load/kotlin/FileBasedKotlinClass", "resolveNameByDesc"));
        }
        return classId;
    }

    @NotNull
    private static ClassId resolveNameByInternalName(@NotNull String name2, @NotNull InnerClassesInfo innerClasses) {
        OuterAndInnerName outer;
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/load/kotlin/FileBasedKotlinClass", "resolveNameByInternalName"));
        }
        if (innerClasses == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "innerClasses", "org/jetbrains/kotlin/load/kotlin/FileBasedKotlinClass", "resolveNameByInternalName"));
        }
        if (!name2.contains("$")) {
            ClassId classId = ClassId.topLevel(new FqName(name2.replace('/', '.')));
            if (classId == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/load/kotlin/FileBasedKotlinClass", "resolveNameByInternalName"));
            }
            return classId;
        }
        ArrayList<String> classes2 = new ArrayList<String>(1);
        boolean local = false;
        while ((outer = innerClasses.get(name2)) != null) {
            if (outer.outerInternalName == null) {
                local = true;
                break;
            }
            classes2.add(outer.innerSimpleName);
            name2 = outer.outerInternalName;
        }
        FqName outermostClassFqName = new FqName(name2.replace('/', '.'));
        classes2.add(outermostClassFqName.shortName().asString());
        Collections.reverse(classes2);
        FqName packageFqName = outermostClassFqName.parent();
        FqName relativeClassName2 = FqName.fromSegments(classes2);
        ClassId classId = new ClassId(packageFqName, relativeClassName2, local);
        if (classId == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/load/kotlin/FileBasedKotlinClass", "resolveNameByInternalName"));
        }
        return classId;
    }

    public abstract int hashCode();

    public abstract boolean equals(Object var1);

    public abstract String toString();

    public static class InnerClassesInfo {
        private Map<String, OuterAndInnerName> map = null;

        public void add(@NotNull String name2, @Nullable String outerName, @Nullable String innerName) {
            if (name2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/load/kotlin/FileBasedKotlinClass$InnerClassesInfo", "add"));
            }
            if (this.map == null) {
                this.map = new HashMap<String, OuterAndInnerName>();
            }
            this.map.put(name2, new OuterAndInnerName(outerName, innerName));
        }

        @Nullable
        public OuterAndInnerName get(@NotNull String name2) {
            if (name2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/load/kotlin/FileBasedKotlinClass$InnerClassesInfo", "get"));
            }
            return this.map == null ? null : this.map.get(name2);
        }
    }

    public static class OuterAndInnerName {
        public final String outerInternalName;
        public final String innerSimpleName;

        private OuterAndInnerName(@Nullable String outerInternalName, @Nullable String innerSimpleName) {
            this.outerInternalName = outerInternalName;
            this.innerSimpleName = innerSimpleName;
        }
    }
}

