/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.load.kotlin;

import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.TypeCastException;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.load.kotlin.JvmType;
import org.jetbrains.kotlin.load.kotlin.JvmTypeFactory;
import org.jetbrains.kotlin.resolve.jvm.JvmClassName;
import org.jetbrains.kotlin.resolve.jvm.JvmPrimitiveType;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c2\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\u0002H\u0016J\u0010\u0010\t\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000bH\u0016J\u0010\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u0002H\u0016R\u0014\u0010\u0004\u001a\u00020\u00028VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/load/kotlin/JvmTypeFactoryImpl;", "Lorg/jetbrains/kotlin/load/kotlin/JvmTypeFactory;", "Lorg/jetbrains/kotlin/load/kotlin/JvmType;", "()V", "javaLangClassType", "getJavaLangClassType", "()Lorg/jetbrains/kotlin/load/kotlin/JvmType;", "boxType", "possiblyPrimitiveType", "createFromString", "representation", "", "createObjectType", "Lorg/jetbrains/kotlin/load/kotlin/JvmType$Object;", "internalName", "toString", "type", "descriptor.loader.java"})
final class JvmTypeFactoryImpl
implements JvmTypeFactory<JvmType> {
    public static final JvmTypeFactoryImpl INSTANCE;

    @Override
    @NotNull
    public JvmType boxType(@NotNull JvmType possiblyPrimitiveType) {
        JvmType jvmType;
        Intrinsics.checkParameterIsNotNull((Object)possiblyPrimitiveType, (String)"possiblyPrimitiveType");
        if (possiblyPrimitiveType instanceof JvmType.Primitive && ((JvmType.Primitive)possiblyPrimitiveType).getJvmPrimitiveType() != null) {
            String string = JvmClassName.byFqNameWithoutInnerClasses(((JvmType.Primitive)possiblyPrimitiveType).getJvmPrimitiveType().getWrapperFqName()).getInternalName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"JvmClassName.byFqNameWit\u2026apperFqName).internalName");
            jvmType = this.createObjectType(string);
        } else {
            jvmType = possiblyPrimitiveType;
        }
        return jvmType;
    }

    @Override
    @NotNull
    public JvmType createFromString(@NotNull String representation) {
        JvmType jvmType;
        Object object;
        Object object2;
        int n;
        char firstChar;
        block10: {
            boolean bl;
            Intrinsics.checkParameterIsNotNull((Object)representation, (String)"representation");
            boolean bl2 = bl = representation.length() > 0;
            if (_Assertions.ENABLED && !bl) {
                String string = "empty string as JvmType";
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            firstChar = representation.charAt(0);
            Object[] $receiver$iv = (Object[])JvmPrimitiveType.values();
            for (n = 0; n < $receiver$iv.length; ++n) {
                Object element$iv = $receiver$iv[n];
                JvmPrimitiveType it = (JvmPrimitiveType)((Object)element$iv);
                if (!(it.getDesc().charAt(0) == firstChar)) continue;
                object2 = element$iv;
                break block10;
            }
            object2 = null;
        }
        JvmPrimitiveType jvmPrimitiveType = (JvmPrimitiveType)((Object)object2);
        if (jvmPrimitiveType != null) {
            JvmPrimitiveType it = object = jvmPrimitiveType;
            return new JvmType.Primitive(it);
        }
        switch (firstChar) {
            case 'V': {
                jvmType = new JvmType.Primitive(null);
                break;
            }
            case '[': {
                JvmType.Array array;
                object = representation;
                int it = 1;
                JvmTypeFactoryImpl jvmTypeFactoryImpl = this;
                JvmType.Array array2 = array;
                JvmType.Array array3 = array;
                Object object3 = object;
                if (object3 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                String string = ((String)object3).substring(it);
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"(this as java.lang.String).substring(startIndex)");
                String string2 = string;
                array2(jvmTypeFactoryImpl.createFromString(string2));
                jvmType = array3;
                break;
            }
            default: {
                JvmType.Object object4;
                boolean bl;
                boolean bl3 = bl = firstChar == 'L' && StringsKt.endsWith$default((CharSequence)representation, (char)';', (boolean)false, (int)2, null);
                if (_Assertions.ENABLED && !bl) {
                    String string = "Type that is not primitive nor array should be Object, but '" + representation + "' was found";
                    throw (Throwable)((Object)new AssertionError((Object)string));
                }
                String string = representation;
                n = 1;
                int n2 = representation.length() - 1;
                JvmType.Object object5 = object4;
                JvmType.Object object6 = object4;
                String string3 = string;
                if (string3 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                String string4 = string3.substring(n, n2);
                Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                String string5 = string4;
                object5(string5);
                jvmType = object6;
            }
        }
        return jvmType;
    }

    @Override
    @NotNull
    public JvmType.Object createObjectType(@NotNull String internalName) {
        Intrinsics.checkParameterIsNotNull((Object)internalName, (String)"internalName");
        return new JvmType.Object(internalName);
    }

    @Override
    @NotNull
    public String toString(@NotNull JvmType type2) {
        Object object;
        Intrinsics.checkParameterIsNotNull((Object)type2, (String)"type");
        JvmType jvmType = type2;
        if (jvmType instanceof JvmType.Array) {
            object = "[" + this.toString(((JvmType.Array)type2).getElementType());
        } else if (jvmType instanceof JvmType.Primitive) {
            object = ((JvmType.Primitive)type2).getJvmPrimitiveType();
            if (object == null || (object = object.getDesc()) == null) {
                object = "V";
            }
        } else if (jvmType instanceof JvmType.Object) {
            object = "L" + ((JvmType.Object)type2).getInternalName() + ";";
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return object;
    }

    @Override
    @NotNull
    public JvmType getJavaLangClassType() {
        return this.createObjectType("java/lang/Class");
    }

    private JvmTypeFactoryImpl() {
        INSTANCE = this;
    }

    static {
        new JvmTypeFactoryImpl();
    }
}

