/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi2ir.generators;

import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.builders.ExpressionHelpersKt;
import org.jetbrains.kotlin.ir.builders.IrBlockBuilder;
import org.jetbrains.kotlin.ir.builders.IrBuilderWithScope;
import org.jetbrains.kotlin.ir.builders.IrGeneratorWithScope;
import org.jetbrains.kotlin.ir.builders.PrimitivesKt;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrStatementOrigin;
import org.jetbrains.kotlin.ir.expressions.IrTypeOperator;
import org.jetbrains.kotlin.ir.expressions.impl.IrBinaryPrimitiveImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrTypeOperatorCallImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrUnaryPrimitiveImpl;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtBinaryExpressionWithTypeRHS;
import org.jetbrains.kotlin.psi.KtConstantExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtIsExpression;
import org.jetbrains.kotlin.psi.KtPostfixExpression;
import org.jetbrains.kotlin.psi.KtPrefixExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.psi2ir.generators.ArgumentsGenerationUtilsKt;
import org.jetbrains.kotlin.psi2ir.generators.AssignmentGenerator;
import org.jetbrains.kotlin.psi2ir.generators.CallGenerator;
import org.jetbrains.kotlin.psi2ir.generators.CallGeneratorKt;
import org.jetbrains.kotlin.psi2ir.generators.GeneratorKt;
import org.jetbrains.kotlin.psi2ir.generators.OperatorConventionsKt;
import org.jetbrains.kotlin.psi2ir.generators.OperatorExpressionGenerator$WhenMappings;
import org.jetbrains.kotlin.psi2ir.generators.StatementGenerator;
import org.jetbrains.kotlin.psi2ir.generators.StatementGeneratorExtension;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.constants.CompileTimeConstant;
import org.jetbrains.kotlin.resolve.constants.evaluate.ConstantExpressionEvaluator;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;
import org.jetbrains.kotlin.util.slicedMap.ReadOnlySlice;
import org.jetbrains.kotlin.util.slicedMap.WritableSlice;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u000e\u0010\u000b\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u001a\u0010\f\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\r\u001a\u0004\u0018\u00010\nH\u0002J\u000e\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u000fJ\u0018\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\nH\u0002J\u0010\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0018\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00142\u0006\u0010\r\u001a\u00020\nH\u0002J\u0018\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0018\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u000e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0007\u001a\u00020\u0019J\u000e\u0010\u001a\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0014J\u000e\u0010\u001b\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u001cJ\u0018\u0010\u001d\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u001c2\u0006\u0010\r\u001a\u00020\nH\u0002\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/kotlin/psi2ir/generators/OperatorExpressionGenerator;", "Lorg/jetbrains/kotlin/psi2ir/generators/StatementGeneratorExtension;", "statementGenerator", "Lorg/jetbrains/kotlin/psi2ir/generators/StatementGenerator;", "(Lorg/jetbrains/kotlin/psi2ir/generators/StatementGenerator;)V", "generateBinaryBooleanOperator", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "expression", "Lorg/jetbrains/kotlin/psi/KtBinaryExpression;", "irOperator", "Lorg/jetbrains/kotlin/ir/expressions/IrStatementOrigin;", "generateBinaryExpression", "generateBinaryOperatorAsCall", "origin", "generateCastExpression", "Lorg/jetbrains/kotlin/psi/KtBinaryExpressionWithTypeRHS;", "generateComparisonOperator", "generateElvis", "generateEqualityOperator", "generateExclExclOperator", "Lorg/jetbrains/kotlin/psi/KtPostfixExpression;", "generateIdentityOperator", "generateInOperator", "generateInstanceOfExpression", "Lorg/jetbrains/kotlin/ir/IrStatement;", "Lorg/jetbrains/kotlin/psi/KtIsExpression;", "generatePostfixExpression", "generatePrefixExpression", "Lorg/jetbrains/kotlin/psi/KtPrefixExpression;", "generatePrefixOperatorAsCall", "ir.psi2ir"})
public final class OperatorExpressionGenerator
extends StatementGeneratorExtension {
    @NotNull
    public final IrExpression generatePrefixExpression(@NotNull KtPrefixExpression expression2) {
        IrExpression irExpression;
        IrStatementOrigin irOperator;
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        IElementType ktOperator = expression2.getOperationReference().getReferencedNameElementType();
        IrStatementOrigin irStatementOrigin = irOperator = OperatorConventionsKt.getPrefixOperator(ktOperator);
        if (Intrinsics.areEqual((Object)irStatementOrigin, null)) {
            throw (Throwable)((Object)new AssertionError((Object)("Unexpected prefix operator: " + ktOperator)));
        }
        if (CollectionsKt.contains((Iterable)OperatorConventionsKt.getINCREMENT_DECREMENT_OPERATORS(), (Object)irStatementOrigin)) {
            irExpression = new AssignmentGenerator(this.getStatementGenerator()).generatePrefixIncrementDecrement(expression2, irOperator);
        } else if (CollectionsKt.contains((Iterable)OperatorConventionsKt.getOPERATORS_DESUGARED_TO_CALLS(), (Object)irStatementOrigin)) {
            irExpression = this.generatePrefixOperatorAsCall(expression2, irOperator);
        } else {
            KtExpression ktExpression = expression2;
            String string = ktOperator.toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"ktOperator.toString()");
            irExpression = GeneratorKt.createDummyExpression(this, ktExpression, string);
        }
        return irExpression;
    }

    @NotNull
    public final IrExpression generatePostfixExpression(@NotNull KtPostfixExpression expression2) {
        IrExpression irExpression;
        IrStatementOrigin irOperator;
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        IElementType ktOperator = expression2.getOperationReference().getReferencedNameElementType();
        IrStatementOrigin irStatementOrigin = irOperator = OperatorConventionsKt.getPostfixOperator(ktOperator);
        if (Intrinsics.areEqual((Object)irStatementOrigin, null)) {
            throw (Throwable)((Object)new AssertionError((Object)("Unexpected postfix operator: " + ktOperator)));
        }
        if (CollectionsKt.contains((Iterable)OperatorConventionsKt.getINCREMENT_DECREMENT_OPERATORS(), (Object)irStatementOrigin)) {
            irExpression = new AssignmentGenerator(this.getStatementGenerator()).generatePostfixIncrementDecrement(expression2, irOperator);
        } else if (Intrinsics.areEqual((Object)irStatementOrigin, (Object)IrStatementOrigin.EXCLEXCL.INSTANCE)) {
            irExpression = this.generateExclExclOperator(expression2, irOperator);
        } else {
            KtExpression ktExpression = expression2;
            String string = ktOperator.toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"ktOperator.toString()");
            irExpression = GeneratorKt.createDummyExpression(this, ktExpression, string);
        }
        return irExpression;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public final IrExpression generateCastExpression(@NotNull KtBinaryExpressionWithTypeRHS expression2) {
        KotlinType kotlinType;
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        IElementType ktOperator = expression2.getOperationReference().getReferencedNameElementType();
        IrTypeOperator irOperator = OperatorConventionsKt.getIrTypeOperator(ktOperator);
        WritableSlice<KtTypeReference, KotlinType> writableSlice = BindingContext.TYPE;
        Intrinsics.checkExpressionValueIsNotNull(writableSlice, (String)"BindingContext.TYPE");
        ReadOnlySlice readOnlySlice = writableSlice;
        KtTypeReference ktTypeReference = expression2.getRight();
        if (ktTypeReference == null) {
            Intrinsics.throwNpe();
        }
        KotlinType rhsType = (KotlinType)GeneratorKt.getOrFail(this, readOnlySlice, ktTypeReference);
        IrTypeOperator irTypeOperator = irOperator;
        if (irTypeOperator == null) throw (Throwable)((Object)new AssertionError((Object)("Unexpected IrTypeOperator: " + (Object)((Object)irOperator))));
        switch (OperatorExpressionGenerator$WhenMappings.$EnumSwitchMapping$0[irTypeOperator.ordinal()]) {
            case 1: {
                kotlinType = rhsType;
                break;
            }
            case 2: {
                kotlinType = TypeUtilsKt.makeNullable(rhsType);
                break;
            }
            default: {
                throw (Throwable)((Object)new AssertionError((Object)("Unexpected IrTypeOperator: " + (Object)((Object)irOperator))));
            }
        }
        KotlinType resultType = kotlinType;
        int n = PsiUtilsKt.getStartOffset((PsiElement)expression2);
        int n2 = PsiUtilsKt.getEndOffset((PsiElement)expression2);
        KotlinType kotlinType2 = resultType;
        Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType2, (String)"resultType");
        KotlinType kotlinType3 = rhsType;
        Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType3, (String)"rhsType");
        StatementGenerator statementGenerator = this.getStatementGenerator();
        KtExpression ktExpression = expression2.getLeft();
        Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression, (String)"expression.left");
        return new IrTypeOperatorCallImpl(n, n2, kotlinType2, irOperator, kotlinType3, statementGenerator.generateExpression(ktExpression));
    }

    @NotNull
    public final IrStatement generateInstanceOfExpression(@NotNull KtIsExpression expression2) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        IElementType ktOperator = expression2.getOperationReference().getReferencedNameElementType();
        IrTypeOperator irTypeOperator = OperatorConventionsKt.getIrTypeOperator(ktOperator);
        if (irTypeOperator == null) {
            Intrinsics.throwNpe();
        }
        IrTypeOperator irOperator = irTypeOperator;
        WritableSlice<KtTypeReference, KotlinType> writableSlice = BindingContext.TYPE;
        Intrinsics.checkExpressionValueIsNotNull(writableSlice, (String)"BindingContext.TYPE");
        KotlinType againstType = (KotlinType)GeneratorKt.getOrFail(this, writableSlice, expression2.getTypeReference());
        int n = PsiUtilsKt.getStartOffset((PsiElement)expression2);
        int n2 = PsiUtilsKt.getEndOffset((PsiElement)expression2);
        SimpleType simpleType2 = this.getContext().getBuiltIns().getBooleanType();
        Intrinsics.checkExpressionValueIsNotNull((Object)simpleType2, (String)"context.builtIns.booleanType");
        KotlinType kotlinType = simpleType2;
        KotlinType kotlinType2 = againstType;
        Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType2, (String)"againstType");
        StatementGenerator statementGenerator = this.getStatementGenerator();
        KtExpression ktExpression = expression2.getLeftHandSide();
        Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression, (String)"expression.leftHandSide");
        return new IrTypeOperatorCallImpl(n, n2, kotlinType, irOperator, kotlinType2, statementGenerator.generateExpression(ktExpression));
    }

    @NotNull
    public final IrExpression generateBinaryExpression(@NotNull KtBinaryExpression expression2) {
        IrExpression irExpression;
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        IElementType ktOperator = expression2.getOperationReference().getReferencedNameElementType();
        if (Intrinsics.areEqual((Object)ktOperator, (Object)((Object)KtTokens.IDENTIFIER))) {
            return this.generateBinaryOperatorAsCall(expression2, null);
        }
        IrStatementOrigin irOperator = OperatorConventionsKt.getInfixOperator(ktOperator);
        IrStatementOrigin irStatementOrigin = irOperator;
        if (Intrinsics.areEqual((Object)irStatementOrigin, null)) {
            throw (Throwable)((Object)new AssertionError((Object)("Unexpected infix operator: " + ktOperator)));
        }
        if (Intrinsics.areEqual((Object)irStatementOrigin, (Object)IrStatementOrigin.EQ.INSTANCE)) {
            irExpression = new AssignmentGenerator(this.getStatementGenerator()).generateAssignment(expression2);
        } else if (CollectionsKt.contains((Iterable)OperatorConventionsKt.getAUGMENTED_ASSIGNMENTS(), (Object)irStatementOrigin)) {
            irExpression = new AssignmentGenerator(this.getStatementGenerator()).generateAugmentedAssignment(expression2, irOperator);
        } else if (Intrinsics.areEqual((Object)irStatementOrigin, (Object)IrStatementOrigin.ELVIS.INSTANCE)) {
            irExpression = this.generateElvis(expression2);
        } else if (CollectionsKt.contains((Iterable)OperatorConventionsKt.getOPERATORS_DESUGARED_TO_CALLS(), (Object)irStatementOrigin)) {
            irExpression = this.generateBinaryOperatorAsCall(expression2, irOperator);
        } else if (CollectionsKt.contains((Iterable)OperatorConventionsKt.getCOMPARISON_OPERATORS(), (Object)irStatementOrigin)) {
            irExpression = this.generateComparisonOperator(expression2, irOperator);
        } else if (CollectionsKt.contains((Iterable)OperatorConventionsKt.getEQUALITY_OPERATORS(), (Object)irStatementOrigin)) {
            irExpression = this.generateEqualityOperator(expression2, irOperator);
        } else if (CollectionsKt.contains((Iterable)OperatorConventionsKt.getIDENTITY_OPERATORS(), (Object)irStatementOrigin)) {
            irExpression = this.generateIdentityOperator(expression2, irOperator);
        } else if (CollectionsKt.contains((Iterable)OperatorConventionsKt.getIN_OPERATORS(), (Object)irStatementOrigin)) {
            irExpression = this.generateInOperator(expression2, irOperator);
        } else if (CollectionsKt.contains((Iterable)OperatorConventionsKt.getBINARY_BOOLEAN_OPERATORS(), (Object)irStatementOrigin)) {
            irExpression = this.generateBinaryBooleanOperator(expression2, irOperator);
        } else {
            KtExpression ktExpression = expression2;
            String string = ktOperator.toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"ktOperator.toString()");
            irExpression = GeneratorKt.createDummyExpression(this, ktExpression, string);
        }
        return irExpression;
    }

    /*
     * WARNING - void declaration
     */
    private final IrExpression generateElvis(KtBinaryExpression expression2) {
        void this_$iv$iv$iv;
        void startOffset$iv$iv;
        void $receiver$iv$iv;
        void $receiver$iv;
        ResolvedCall<? extends CallableDescriptor> resolvedCall2 = GeneratorKt.getResolvedCall(this, expression2);
        if (resolvedCall2 == null) {
            Intrinsics.throwNpe();
        }
        ResolvedCall<? extends CallableDescriptor> specialCallForElvis = resolvedCall2;
        KotlinType kotlinType = specialCallForElvis.getResultingDescriptor().getReturnType();
        if (kotlinType == null) {
            Intrinsics.throwNpe();
        }
        KotlinType resultType = kotlinType;
        StatementGenerator statementGenerator = this.getStatementGenerator();
        KtExpression ktExpression = expression2.getLeft();
        if (ktExpression == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression, (String)"expression.left!!");
        IrExpression irArgument0 = statementGenerator.generateExpression(ktExpression);
        StatementGenerator statementGenerator2 = this.getStatementGenerator();
        KtExpression ktExpression2 = expression2.getRight();
        if (ktExpression2 == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression2, (String)"expression.right!!");
        IrExpression irArgument1 = statementGenerator2.generateExpression(ktExpression2);
        OperatorExpressionGenerator operatorExpressionGenerator = this;
        IrStatementOrigin origin$iv = IrStatementOrigin.ELVIS.INSTANCE;
        IrGeneratorWithScope irGeneratorWithScope = (IrGeneratorWithScope)$receiver$iv;
        KtElement ktElement = expression2;
        int n = ktElement != null ? PsiUtilsKt.getStartOffset((PsiElement)ktElement) : -1;
        KtElement ktElement2 = expression2;
        int endOffset$iv$iv = ktElement2 != null ? PsiUtilsKt.getEndOffset((PsiElement)ktElement2) : -1;
        IrBlockBuilder irBlockBuilder = new IrBlockBuilder($receiver$iv$iv.getContext(), $receiver$iv$iv.getScope(), (int)startOffset$iv$iv, endOffset$iv$iv, origin$iv, resultType);
        IrBlockBuilder $receiver = (IrBlockBuilder)this_$iv$iv$iv;
        VariableDescriptor temporary = ExpressionHelpersKt.defineTemporary($receiver, irArgument0, "elvis_lhs");
        IrBuilderWithScope irBuilderWithScope = $receiver;
        KotlinType kotlinType2 = resultType;
        Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType2, (String)"resultType");
        $receiver.unaryPlus(ExpressionHelpersKt.irIfNull(irBuilderWithScope, kotlinType2, ExpressionHelpersKt.irGet($receiver, temporary), irArgument1, ExpressionHelpersKt.irGet($receiver, temporary)));
        return IrBlockBuilder.access$doBuild((IrBlockBuilder)this_$iv$iv$iv);
    }

    private final IrExpression generateBinaryBooleanOperator(KtBinaryExpression expression2, IrStatementOrigin irOperator) {
        IrExpression irExpression;
        StatementGenerator statementGenerator = this.getStatementGenerator();
        KtExpression ktExpression = expression2.getLeft();
        if (ktExpression == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression, (String)"expression.left!!");
        IrExpression irArgument0 = statementGenerator.generateExpression(ktExpression);
        StatementGenerator statementGenerator2 = this.getStatementGenerator();
        KtExpression ktExpression2 = expression2.getRight();
        if (ktExpression2 == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression2, (String)"expression.right!!");
        IrExpression irArgument1 = statementGenerator2.generateExpression(ktExpression2);
        IrStatementOrigin irStatementOrigin = irOperator;
        if (Intrinsics.areEqual((Object)irStatementOrigin, (Object)IrStatementOrigin.OROR.INSTANCE)) {
            irExpression = PrimitivesKt.oror$default(this.getContext(), PsiUtilsKt.getStartOffset((PsiElement)expression2), PsiUtilsKt.getEndOffset((PsiElement)expression2), irArgument0, irArgument1, null, 16, null);
        } else if (Intrinsics.areEqual((Object)irStatementOrigin, (Object)IrStatementOrigin.ANDAND.INSTANCE)) {
            irExpression = PrimitivesKt.andand$default(this.getContext(), PsiUtilsKt.getStartOffset((PsiElement)expression2), PsiUtilsKt.getEndOffset((PsiElement)expression2), irArgument0, irArgument1, null, 16, null);
        } else {
            throw (Throwable)((Object)new AssertionError((Object)("Unexpected binary boolean operator " + irOperator)));
        }
        return irExpression;
    }

    private final IrExpression generateInOperator(KtBinaryExpression expression2, IrStatementOrigin irOperator) {
        IrExpression irExpression;
        ResolvedCall<? extends CallableDescriptor> resolvedCall2 = GeneratorKt.getResolvedCall(this, expression2);
        if (resolvedCall2 == null) {
            Intrinsics.throwNpe();
        }
        ResolvedCall<? extends CallableDescriptor> containsCall = resolvedCall2;
        IrExpression irContainsCall = CallGeneratorKt.generateCall(new CallGenerator(this.getStatementGenerator()), expression2, ArgumentsGenerationUtilsKt.pregenerateCall(this.getStatementGenerator(), containsCall), irOperator);
        IrStatementOrigin irStatementOrigin = irOperator;
        if (Intrinsics.areEqual((Object)irStatementOrigin, (Object)IrStatementOrigin.IN.INSTANCE)) {
            irExpression = irContainsCall;
        } else if (Intrinsics.areEqual((Object)irStatementOrigin, (Object)IrStatementOrigin.NOT_IN.INSTANCE)) {
            irExpression = new IrUnaryPrimitiveImpl(PsiUtilsKt.getStartOffset((PsiElement)expression2), PsiUtilsKt.getEndOffset((PsiElement)expression2), IrStatementOrigin.NOT_IN.INSTANCE, this.getContext().getIrBuiltIns().getBooleanNot(), irContainsCall);
        } else {
            throw (Throwable)((Object)new AssertionError((Object)("Unexpected in-operator " + irOperator)));
        }
        return irExpression;
    }

    private final IrExpression generateIdentityOperator(KtBinaryExpression expression2, IrStatementOrigin irOperator) {
        IrExpression irExpression;
        StatementGenerator statementGenerator = this.getStatementGenerator();
        KtExpression ktExpression = expression2.getLeft();
        if (ktExpression == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression, (String)"expression.left!!");
        IrExpression irArgument0 = statementGenerator.generateExpression(ktExpression);
        StatementGenerator statementGenerator2 = this.getStatementGenerator();
        KtExpression ktExpression2 = expression2.getRight();
        if (ktExpression2 == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression2, (String)"expression.right!!");
        IrExpression irArgument1 = statementGenerator2.generateExpression(ktExpression2);
        IrBinaryPrimitiveImpl irIdentityEquals = new IrBinaryPrimitiveImpl(PsiUtilsKt.getStartOffset((PsiElement)expression2), PsiUtilsKt.getEndOffset((PsiElement)expression2), irOperator, this.getContext().getIrBuiltIns().getEqeqeq(), irArgument0, irArgument1);
        IrStatementOrigin irStatementOrigin = irOperator;
        if (Intrinsics.areEqual((Object)irStatementOrigin, (Object)IrStatementOrigin.EQEQEQ.INSTANCE)) {
            irExpression = irIdentityEquals;
        } else if (Intrinsics.areEqual((Object)irStatementOrigin, (Object)IrStatementOrigin.EXCLEQEQ.INSTANCE)) {
            irExpression = new IrUnaryPrimitiveImpl(PsiUtilsKt.getStartOffset((PsiElement)expression2), PsiUtilsKt.getEndOffset((PsiElement)expression2), IrStatementOrigin.EXCLEQEQ.INSTANCE, this.getContext().getIrBuiltIns().getBooleanNot(), irIdentityEquals);
        } else {
            throw (Throwable)((Object)new AssertionError((Object)("Unexpected identity operator " + irOperator)));
        }
        return irExpression;
    }

    private final IrExpression generateEqualityOperator(KtBinaryExpression expression2, IrStatementOrigin irOperator) {
        IrExpression irExpression;
        StatementGenerator statementGenerator = this.getStatementGenerator();
        KtExpression ktExpression = expression2.getLeft();
        if (ktExpression == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression, (String)"expression.left!!");
        IrExpression irArgument0 = statementGenerator.generateExpression(ktExpression);
        StatementGenerator statementGenerator2 = this.getStatementGenerator();
        KtExpression ktExpression2 = expression2.getRight();
        if (ktExpression2 == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression2, (String)"expression.right!!");
        IrExpression irArgument1 = statementGenerator2.generateExpression(ktExpression2);
        IrBinaryPrimitiveImpl irEquals = new IrBinaryPrimitiveImpl(PsiUtilsKt.getStartOffset((PsiElement)expression2), PsiUtilsKt.getEndOffset((PsiElement)expression2), irOperator, this.getContext().getIrBuiltIns().getEqeq(), irArgument0, irArgument1);
        IrStatementOrigin irStatementOrigin = irOperator;
        if (Intrinsics.areEqual((Object)irStatementOrigin, (Object)IrStatementOrigin.EQEQ.INSTANCE)) {
            irExpression = irEquals;
        } else if (Intrinsics.areEqual((Object)irStatementOrigin, (Object)IrStatementOrigin.EXCLEQ.INSTANCE)) {
            irExpression = new IrUnaryPrimitiveImpl(PsiUtilsKt.getStartOffset((PsiElement)expression2), PsiUtilsKt.getEndOffset((PsiElement)expression2), IrStatementOrigin.EXCLEQ.INSTANCE, this.getContext().getIrBuiltIns().getBooleanNot(), irEquals);
        } else {
            throw (Throwable)((Object)new AssertionError((Object)("Unexpected equality operator " + irOperator)));
        }
        return irExpression;
    }

    private final IrExpression generateComparisonOperator(KtBinaryExpression expression2, IrStatementOrigin origin) {
        FunctionDescriptor functionDescriptor2;
        ResolvedCall<? extends CallableDescriptor> resolvedCall2 = GeneratorKt.getResolvedCall(this, expression2);
        if (resolvedCall2 == null) {
            Intrinsics.throwNpe();
        }
        ResolvedCall<? extends CallableDescriptor> compareToCall = resolvedCall2;
        IrExpression irCompareToCall = CallGeneratorKt.generateCall(new CallGenerator(this.getStatementGenerator()), expression2, ArgumentsGenerationUtilsKt.pregenerateCall(this.getStatementGenerator(), compareToCall), origin);
        IrStatementOrigin irStatementOrigin = origin;
        if (Intrinsics.areEqual((Object)irStatementOrigin, (Object)IrStatementOrigin.LT.INSTANCE)) {
            functionDescriptor2 = this.getContext().getIrBuiltIns().getLt0();
        } else if (Intrinsics.areEqual((Object)irStatementOrigin, (Object)IrStatementOrigin.LTEQ.INSTANCE)) {
            functionDescriptor2 = this.getContext().getIrBuiltIns().getLteq0();
        } else if (Intrinsics.areEqual((Object)irStatementOrigin, (Object)IrStatementOrigin.GT.INSTANCE)) {
            functionDescriptor2 = this.getContext().getIrBuiltIns().getGt0();
        } else if (Intrinsics.areEqual((Object)irStatementOrigin, (Object)IrStatementOrigin.GTEQ.INSTANCE)) {
            functionDescriptor2 = this.getContext().getIrBuiltIns().getGteq0();
        } else {
            throw (Throwable)((Object)new AssertionError((Object)("Unexpected comparison operator: " + origin)));
        }
        FunctionDescriptor compareToZeroDescriptor = functionDescriptor2;
        return new IrUnaryPrimitiveImpl(PsiUtilsKt.getStartOffset((PsiElement)expression2), PsiUtilsKt.getEndOffset((PsiElement)expression2), origin, compareToZeroDescriptor, irCompareToCall);
    }

    /*
     * WARNING - void declaration
     */
    private final IrExpression generateExclExclOperator(KtPostfixExpression expression2, IrStatementOrigin origin) {
        void this_$iv$iv$iv;
        void startOffset$iv$iv;
        void $receiver$iv$iv;
        KtExpression ktExpression = expression2.getBaseExpression();
        if (ktExpression == null) {
            Intrinsics.throwNpe();
        }
        KtExpression ktArgument = ktExpression;
        StatementGenerator statementGenerator = this.getStatementGenerator();
        KtExpression ktExpression2 = ktArgument;
        Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression2, (String)"ktArgument");
        IrExpression irArgument = statementGenerator.generateExpression(ktExpression2);
        KtSimpleNameExpression ktOperator = expression2.getOperationReference();
        KotlinType resultType = TypeUtilsKt.makeNotNullable(irArgument.getType());
        OperatorExpressionGenerator $receiver$iv = this;
        IrGeneratorWithScope irGeneratorWithScope = $receiver$iv;
        KtElement ktElement = ktOperator;
        int n = ktElement != null ? PsiUtilsKt.getStartOffset((PsiElement)ktElement) : -1;
        KtElement ktElement2 = ktOperator;
        int endOffset$iv$iv = ktElement2 != null ? PsiUtilsKt.getEndOffset((PsiElement)ktElement2) : -1;
        IrBlockBuilder irBlockBuilder = new IrBlockBuilder($receiver$iv$iv.getContext(), $receiver$iv$iv.getScope(), (int)startOffset$iv$iv, endOffset$iv$iv, origin, resultType);
        IrBlockBuilder $receiver = (IrBlockBuilder)this_$iv$iv$iv;
        VariableDescriptor temporary = ExpressionHelpersKt.defineTemporary($receiver, irArgument, "notnull");
        $receiver.unaryPlus(ExpressionHelpersKt.irIfNull($receiver, resultType, ExpressionHelpersKt.irGet($receiver, temporary), ExpressionHelpersKt.irThrowNpe($receiver, origin), ExpressionHelpersKt.irGet($receiver, temporary)));
        return IrBlockBuilder.access$doBuild((IrBlockBuilder)this_$iv$iv$iv);
    }

    private final IrExpression generateBinaryOperatorAsCall(KtBinaryExpression expression2, IrStatementOrigin origin) {
        ResolvedCall<? extends CallableDescriptor> resolvedCall2 = GeneratorKt.getResolvedCall(this, expression2);
        if (resolvedCall2 == null) {
            Intrinsics.throwNpe();
        }
        ResolvedCall<? extends CallableDescriptor> operatorCall = resolvedCall2;
        return CallGeneratorKt.generateCall(new CallGenerator(this.getStatementGenerator()), expression2, ArgumentsGenerationUtilsKt.pregenerateCall(this.getStatementGenerator(), operatorCall), origin);
    }

    private final IrExpression generatePrefixOperatorAsCall(KtPrefixExpression expression2, IrStatementOrigin origin) {
        ResolvedCall<? extends CallableDescriptor> resolvedCall2 = GeneratorKt.getResolvedCall(this, expression2);
        if (resolvedCall2 == null) {
            Intrinsics.throwNpe();
        }
        ResolvedCall<? extends CallableDescriptor> resolvedCall3 = resolvedCall2;
        if (expression2.getBaseExpression() instanceof KtConstantExpression) {
            CompileTimeConstant<?> compileTimeConstant = ConstantExpressionEvaluator.Companion.getConstant(expression2, this.getContext().getBindingContext());
            if (compileTimeConstant != null) {
                KotlinType receiverType2;
                CompileTimeConstant<?> compileTimeConstant2;
                CompileTimeConstant<?> constant = compileTimeConstant2 = compileTimeConstant;
                ReceiverValue receiverValue = resolvedCall3.getDispatchReceiver();
                KotlinType kotlinType = receiverType2 = receiverValue != null ? receiverValue.getType() : null;
                if (receiverType2 != null && KotlinBuiltIns.isPrimitiveType(receiverType2)) {
                    return this.getStatementGenerator().generateConstantExpression(expression2, constant);
                }
            }
        }
        return CallGeneratorKt.generateCall(new CallGenerator(this.getStatementGenerator()), expression2, ArgumentsGenerationUtilsKt.pregenerateCall(this.getStatementGenerator(), resolvedCall3), origin);
    }

    public OperatorExpressionGenerator(@NotNull StatementGenerator statementGenerator) {
        Intrinsics.checkParameterIsNotNull((Object)statementGenerator, (String)"statementGenerator");
        super(statementGenerator);
    }
}

