/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.tasks;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.functions.FunctionClassDescriptor;
import org.jetbrains.kotlin.builtins.functions.FunctionInvokeDescriptor;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.types.TypeSubstitutor;
import org.jetbrains.kotlin.util.OperatorNameConventions;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=2, d1={"\u0000&\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u001a\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00040\u0007\u001a\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u000b\"\u0014\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"BUILTIN_FUNCTIONS", "", "Lorg/jetbrains/kotlin/builtins/functions/FunctionClassDescriptor$Kind;", "createSynthesizedFunctionWithFirstParameterAsReceiver", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "descriptor", "createSynthesizedInvokes", "", "functions", "isSynthesizedInvoke", "", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "resolution"})
public final class SynthesizedInvokesKt {
    private static final Set<FunctionClassDescriptor.Kind> BUILTIN_FUNCTIONS = SetsKt.setOf((Object[])new FunctionClassDescriptor.Kind[]{FunctionClassDescriptor.Kind.Function, FunctionClassDescriptor.Kind.SuspendFunction});

    @NotNull
    public static final Collection<FunctionDescriptor> createSynthesizedInvokes(@NotNull Collection<? extends FunctionDescriptor> functions2) {
        Intrinsics.checkParameterIsNotNull(functions2, (String)"functions");
        ArrayList<FunctionDescriptor> result2 = new ArrayList<FunctionDescriptor>(1);
        for (FunctionDescriptor functionDescriptor2 : functions2) {
            FunctionDescriptor functionDescriptor3;
            if (!(functionDescriptor2 instanceof FunctionInvokeDescriptor) || functionDescriptor2.getValueParameters().isEmpty()) continue;
            Iterable iterable = BUILTIN_FUNCTIONS;
            DeclarationDescriptor declarationDescriptor = functionDescriptor2.getContainingDeclaration();
            if (!(declarationDescriptor instanceof FunctionClassDescriptor)) {
                declarationDescriptor = null;
            }
            FunctionClassDescriptor functionClassDescriptor = (FunctionClassDescriptor)declarationDescriptor;
            if (CollectionsKt.contains((Iterable)iterable, (Object)((Object)(functionClassDescriptor != null ? functionClassDescriptor.getFunctionKind() : null)))) {
                functionDescriptor3 = SynthesizedInvokesKt.createSynthesizedFunctionWithFirstParameterAsReceiver(functionDescriptor2);
            } else {
                FunctionDescriptor invokeDeclaration;
                FunctionDescriptor functionDescriptor4 = invokeDeclaration = (FunctionDescriptor)CollectionsKt.single((Iterable)functionDescriptor2.getOverriddenDescriptors());
                Intrinsics.checkExpressionValueIsNotNull((Object)functionDescriptor4, (String)"invokeDeclaration");
                FunctionDescriptor synthesizedSuperFun = SynthesizedInvokesKt.createSynthesizedFunctionWithFirstParameterAsReceiver(functionDescriptor4);
                FunctionDescriptor fakeOverride = synthesizedSuperFun.copy(functionDescriptor2.getContainingDeclaration(), synthesizedSuperFun.getModality(), synthesizedSuperFun.getVisibility(), CallableMemberDescriptor.Kind.FAKE_OVERRIDE, false);
                DescriptorUtilsKt.setSingleOverridden(fakeOverride, synthesizedSuperFun);
                FunctionDescriptor functionDescriptor5 = fakeOverride;
                functionDescriptor3 = functionDescriptor5;
                Intrinsics.checkExpressionValueIsNotNull((Object)functionDescriptor5, (String)"fakeOverride");
            }
            FunctionDescriptor synthesized = functionDescriptor3;
            ReceiverParameterDescriptor receiverParameterDescriptor = functionDescriptor2.getDispatchReceiverParameter();
            if (receiverParameterDescriptor == null) {
                Intrinsics.throwNpe();
            }
            FunctionDescriptor functionDescriptor6 = synthesized.substitute(TypeSubstitutor.create(receiverParameterDescriptor.getType()));
            if (functionDescriptor6 == null) {
                continue;
            }
            result2.add(functionDescriptor6);
        }
        return result2;
    }

    /*
     * WARNING - void declaration
     */
    private static final FunctionDescriptor createSynthesizedFunctionWithFirstParameterAsReceiver(FunctionDescriptor descriptor2) {
        Collection<ValueParameterDescriptor> collection;
        void $receiver$iv$iv;
        void $receiver$iv;
        FunctionDescriptor.CopyBuilder<? extends FunctionDescriptor> copyBuilder;
        FunctionDescriptor.CopyBuilder<? extends FunctionDescriptor> $receiver = copyBuilder = descriptor2.getOriginal().newCopyBuilder();
        $receiver.setExtensionReceiverType(((ValueParameterDescriptor)CollectionsKt.first(descriptor2.getOriginal().getValueParameters())).getType());
        Iterable iterable = CollectionsKt.drop((Iterable)descriptor2.getOriginal().getValueParameters(), (int)1);
        FunctionDescriptor.CopyBuilder<? extends FunctionDescriptor> copyBuilder2 = $receiver;
        void var5_5 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void p;
            ValueParameterDescriptor valueParameterDescriptor = (ValueParameterDescriptor)item$iv$iv;
            collection = destination$iv$iv;
            FunctionDescriptor functionDescriptor2 = descriptor2.getOriginal();
            Intrinsics.checkExpressionValueIsNotNull((Object)functionDescriptor2, (String)"descriptor.original");
            CallableDescriptor callableDescriptor = functionDescriptor2;
            Name name2 = Name.identifier("p" + (p.getIndex() + 1));
            Intrinsics.checkExpressionValueIsNotNull((Object)name2, (String)"Name.identifier(\"p${p.index + 1}\")");
            ValueParameterDescriptor valueParameterDescriptor2 = p.copy(callableDescriptor, name2, p.getIndex() - 1);
            collection.add(valueParameterDescriptor2);
        }
        collection = (List)destination$iv$iv;
        copyBuilder2.setValueParameters((List<ValueParameterDescriptor>)collection);
        FunctionDescriptor functionDescriptor3 = copyBuilder.build();
        if (functionDescriptor3 == null) {
            Intrinsics.throwNpe();
        }
        return functionDescriptor3;
    }

    public static final boolean isSynthesizedInvoke(@NotNull DeclarationDescriptor descriptor2) {
        Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
        if (Intrinsics.areEqual((Object)descriptor2.getName(), (Object)OperatorNameConventions.INVOKE) ^ true || !(descriptor2 instanceof FunctionDescriptor)) {
            return false;
        }
        FunctionDescriptor real = (FunctionDescriptor)descriptor2;
        while (!real.getKind().isReal()) {
            if ((FunctionDescriptor)CollectionsKt.singleOrNull((Iterable)real.getOverriddenDescriptors()) != null) continue;
            return false;
        }
        return Intrinsics.areEqual((Object)((Object)real.getKind()), (Object)((Object)CallableMemberDescriptor.Kind.SYNTHESIZED)) && real.getContainingDeclaration() instanceof FunctionClassDescriptor;
    }
}

