/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.serialization.deserialization.descriptors;

import kotlin.DeprecationLevel;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.protobuf.MessageLite;
import org.jetbrains.kotlin.serialization.ProtoBuf;
import org.jetbrains.kotlin.serialization.deserialization.NameResolver;
import org.jetbrains.kotlin.serialization.deserialization.descriptors.SinceKotlinInfo$Companion$WhenMappings;
import org.jetbrains.kotlin.serialization.deserialization.descriptors.SinceKotlinInfoTable;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000e\u0018\u0000 \u00152\u00020\u0001:\u0002\u0015\u0016B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\u0014\u001a\u00020\tH\u0016R\u0015\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\n\n\u0002\u0010\r\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0013\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/serialization/deserialization/descriptors/SinceKotlinInfo;", "", "version", "Lorg/jetbrains/kotlin/serialization/deserialization/descriptors/SinceKotlinInfo$Version;", "level", "Lkotlin/DeprecationLevel;", "errorCode", "", "message", "", "(Lorg/jetbrains/kotlin/serialization/deserialization/descriptors/SinceKotlinInfo$Version;Lkotlin/DeprecationLevel;Ljava/lang/Integer;Ljava/lang/String;)V", "getErrorCode", "()Ljava/lang/Integer;", "Ljava/lang/Integer;", "getLevel", "()Lkotlin/DeprecationLevel;", "getMessage", "()Ljava/lang/String;", "getVersion", "()Lorg/jetbrains/kotlin/serialization/deserialization/descriptors/SinceKotlinInfo$Version;", "toString", "Companion", "Version", "deserialization"})
public final class SinceKotlinInfo {
    @NotNull
    private final Version version;
    @NotNull
    private final DeprecationLevel level;
    @Nullable
    private final Integer errorCode;
    @Nullable
    private final String message;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public String toString() {
        return "since " + this.version + " " + this.level + (this.errorCode != null ? " error " + this.errorCode : "") + (this.message != null ? ": " + this.message : "");
    }

    @NotNull
    public final Version getVersion() {
        return this.version;
    }

    @NotNull
    public final DeprecationLevel getLevel() {
        return this.level;
    }

    @Nullable
    public final Integer getErrorCode() {
        return this.errorCode;
    }

    @Nullable
    public final String getMessage() {
        return this.message;
    }

    public SinceKotlinInfo(@NotNull Version version, @NotNull DeprecationLevel level, @Nullable Integer errorCode, @Nullable String message2) {
        Intrinsics.checkParameterIsNotNull((Object)version, (String)"version");
        Intrinsics.checkParameterIsNotNull((Object)level, (String)"level");
        this.version = version;
        this.level = level;
        this.errorCode = errorCode;
        this.message = message2;
    }

    @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0086\b\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u000b\u001a\u00020\fJ\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J'\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0003H\u00c6\u0001J.\u0010\u0011\u001a\u00020\u00122\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00120\u00142\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00120\u0014J\u0013\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0019\u001a\u00020\u0003H\u00d6\u0001J\b\u0010\u001a\u001a\u00020\fH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\b\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/serialization/deserialization/descriptors/SinceKotlinInfo$Version;", "", "major", "", "minor", "patch", "(III)V", "getMajor", "()I", "getMinor", "getPatch", "asString", "", "component1", "component2", "component3", "copy", "encode", "", "writeVersion", "Lkotlin/Function1;", "writeVersionFull", "equals", "", "other", "hashCode", "toString", "Companion", "deserialization"})
    public static final class Version {
        private final int major;
        private final int minor;
        private final int patch;
        @JvmField
        @NotNull
        public static final Version INFINITY;
        private static final int MAJOR_BITS = 3;
        private static final int MINOR_BITS = 4;
        private static final int PATCH_BITS = 7;
        private static final int MAJOR_MASK = 7;
        private static final int MINOR_MASK = 15;
        private static final int PATCH_MASK = 127;
        public static final Companion Companion;

        @NotNull
        public final String asString() {
            return this.patch == 0 ? this.major + "." + this.minor : this.major + "." + this.minor + "." + this.patch;
        }

        public final void encode(@NotNull Function1<? super Integer, Unit> writeVersion, @NotNull Function1<? super Integer, Unit> writeVersionFull) {
            Intrinsics.checkParameterIsNotNull(writeVersion, (String)"writeVersion");
            Intrinsics.checkParameterIsNotNull(writeVersionFull, (String)"writeVersionFull");
            if (!Intrinsics.areEqual((Object)this, (Object)INFINITY)) {
                if (this.major > 7 || this.minor > 15 || this.patch > 127) {
                    writeVersionFull.invoke((Object)(this.major | this.minor << 8 | this.patch << 16));
                } else {
                    writeVersion.invoke((Object)(this.major | this.minor << 3 | this.patch << 7));
                }
            }
        }

        @NotNull
        public String toString() {
            return this.asString();
        }

        public final int getMajor() {
            return this.major;
        }

        public final int getMinor() {
            return this.minor;
        }

        public final int getPatch() {
            return this.patch;
        }

        public Version(int major, int minor, int patch) {
            this.major = major;
            this.minor = minor;
            this.patch = patch;
        }

        public /* synthetic */ Version(int n, int n2, int n3, int n4, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n4 & 4) != 0) {
                n3 = 0;
            }
            this(n, n2, n3);
        }

        static {
            Companion = new Companion(null);
            INFINITY = new Version(256, 256, 256);
        }

        public final int component1() {
            return this.major;
        }

        public final int component2() {
            return this.minor;
        }

        public final int component3() {
            return this.patch;
        }

        @NotNull
        public final Version copy(int major, int minor, int patch) {
            return new Version(major, minor, patch);
        }

        @NotNull
        public static /* bridge */ /* synthetic */ Version copy$default(Version version, int n, int n2, int n3, int n4, Object object) {
            if ((n4 & 1) != 0) {
                n = version.major;
            }
            if ((n4 & 2) != 0) {
                n2 = version.minor;
            }
            if ((n4 & 4) != 0) {
                n3 = version.patch;
            }
            return version.copy(n, n2, n3);
        }

        public int hashCode() {
            return (this.major * 31 + this.minor) * 31 + this.patch;
        }

        public boolean equals(Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof Version)) break block3;
                    Version version = (Version)object;
                    if (!(this.major == version.major) || !(this.minor == version.minor) || !(this.patch == version.patch)) break block3;
                }
                return true;
            }
            return false;
        }

        @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\n\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001f\u0010\f\u001a\u00020\u00042\b\u0010\r\u001a\u0004\u0018\u00010\u00062\b\u0010\u000e\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u000fR\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/serialization/deserialization/descriptors/SinceKotlinInfo$Version$Companion;", "", "()V", "INFINITY", "Lorg/jetbrains/kotlin/serialization/deserialization/descriptors/SinceKotlinInfo$Version;", "MAJOR_BITS", "", "MAJOR_MASK", "MINOR_BITS", "MINOR_MASK", "PATCH_BITS", "PATCH_MASK", "decode", "version", "versionFull", "(Ljava/lang/Integer;Ljava/lang/Integer;)Lorg/jetbrains/kotlin/serialization/deserialization/descriptors/SinceKotlinInfo$Version;", "deserialization"})
        public static final class Companion {
            @NotNull
            public final Version decode(@Nullable Integer version, @Nullable Integer versionFull) {
                return versionFull != null ? new Version((int)(versionFull & 0xFF), versionFull >> 8 & 0xFF, versionFull >> 16 & 0xFF) : (version != null ? new Version(version & 7, version >> 3 & 0xF, version >> 7 & 0x7F) : INFINITY);
            }

            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/serialization/deserialization/descriptors/SinceKotlinInfo$Companion;", "", "()V", "create", "Lorg/jetbrains/kotlin/serialization/deserialization/descriptors/SinceKotlinInfo;", "proto", "Lorg/jetbrains/kotlin/protobuf/MessageLite;", "nameResolver", "Lorg/jetbrains/kotlin/serialization/deserialization/NameResolver;", "table", "Lorg/jetbrains/kotlin/serialization/deserialization/descriptors/SinceKotlinInfoTable;", "deserialization"})
    public static final class Companion {
        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Nullable
        public final SinceKotlinInfo create(@NotNull MessageLite proto, @NotNull NameResolver nameResolver, @NotNull SinceKotlinInfoTable table) {
            DeprecationLevel deprecationLevel;
            int n;
            Intrinsics.checkParameterIsNotNull((Object)proto, (String)"proto");
            Intrinsics.checkParameterIsNotNull((Object)nameResolver, (String)"nameResolver");
            Intrinsics.checkParameterIsNotNull((Object)table, (String)"table");
            MessageLite messageLite = proto;
            if (messageLite instanceof ProtoBuf.Class) {
                if (!((ProtoBuf.Class)proto).hasSinceKotlinInfo()) return null;
                n = ((ProtoBuf.Class)proto).getSinceKotlinInfo();
            } else if (messageLite instanceof ProtoBuf.Constructor) {
                if (!((ProtoBuf.Constructor)proto).hasSinceKotlinInfo()) return null;
                n = ((ProtoBuf.Constructor)proto).getSinceKotlinInfo();
            } else if (messageLite instanceof ProtoBuf.Function) {
                if (!((ProtoBuf.Function)proto).hasSinceKotlinInfo()) return null;
                n = ((ProtoBuf.Function)proto).getSinceKotlinInfo();
            } else if (messageLite instanceof ProtoBuf.Property) {
                if (!((ProtoBuf.Property)proto).hasSinceKotlinInfo()) return null;
                n = ((ProtoBuf.Property)proto).getSinceKotlinInfo();
            } else {
                if (!(messageLite instanceof ProtoBuf.TypeAlias)) throw (Throwable)new IllegalStateException("Unexpected declaration: " + proto.getClass());
                if (!((ProtoBuf.TypeAlias)proto).hasSinceKotlinInfo()) return null;
                n = ((ProtoBuf.TypeAlias)proto).getSinceKotlinInfo();
            }
            int id = n;
            ProtoBuf.SinceKotlinInfo sinceKotlinInfo2 = table.get(id);
            if (sinceKotlinInfo2 == null) {
                return null;
            }
            ProtoBuf.SinceKotlinInfo info = sinceKotlinInfo2;
            Version version = Version.Companion.decode(info.hasVersion() ? Integer.valueOf(info.getVersion()) : null, info.hasVersionFull() ? Integer.valueOf(info.getVersionFull()) : null);
            ProtoBuf.SinceKotlinInfo.Level level = info.getLevel();
            if (level == null) {
                Intrinsics.throwNpe();
            }
            switch (SinceKotlinInfo$Companion$WhenMappings.$EnumSwitchMapping$0[level.ordinal()]) {
                case 1: {
                    deprecationLevel = DeprecationLevel.WARNING;
                    break;
                }
                case 2: {
                    deprecationLevel = DeprecationLevel.ERROR;
                    break;
                }
                case 3: {
                    deprecationLevel = DeprecationLevel.HIDDEN;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            DeprecationLevel level2 = deprecationLevel;
            Integer errorCode = info.hasErrorCode() ? Integer.valueOf(info.getErrorCode()) : null;
            String message2 = info.hasMessage() ? nameResolver.getString(info.getMessage()) : null;
            return new SinceKotlinInfo(version, level2, errorCode, message2);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

