/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.serialization.js;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.DataOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.MemberDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentProvider;
import org.jetbrains.kotlin.descriptors.PackageViewDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.protobuf.MessageLiteOrBuilder;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.scopes.DescriptorKindFilter;
import org.jetbrains.kotlin.resolve.scopes.MemberScope;
import org.jetbrains.kotlin.resolve.scopes.ResolutionScope;
import org.jetbrains.kotlin.serialization.AnnotationSerializer;
import org.jetbrains.kotlin.serialization.DescriptorSerializer;
import org.jetbrains.kotlin.serialization.ProtoBuf;
import org.jetbrains.kotlin.serialization.deserialization.DeserializationConfiguration;
import org.jetbrains.kotlin.serialization.js.JavaScriptStringTable;
import org.jetbrains.kotlin.serialization.js.JsModuleDescriptor;
import org.jetbrains.kotlin.serialization.js.JsProtoBuf;
import org.jetbrains.kotlin.serialization.js.JsSerializerProtocol;
import org.jetbrains.kotlin.serialization.js.KotlinFileRegistry;
import org.jetbrains.kotlin.serialization.js.KotlinJavascriptPackageFragmentProviderKt;
import org.jetbrains.kotlin.serialization.js.KotlinJavascriptSerializationUtil;
import org.jetbrains.kotlin.serialization.js.KotlinJavascriptSerializationUtil$WhenMappings;
import org.jetbrains.kotlin.serialization.js.KotlinJavascriptSerializerExtension;
import org.jetbrains.kotlin.serialization.js.ModuleKind;
import org.jetbrains.kotlin.storage.StorageManager;
import org.jetbrains.kotlin.utils.JsMetadataVersion;
import org.jetbrains.kotlin.utils.KotlinJavascriptMetadataUtils;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000\u0098\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u001e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\t0\u0011H\u0002J\u001c\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0016J0\u0010\u0017\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00180\u00162\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u001d\u001a\u00020\u001eH\u0007J \u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010#\u001a\u00020$H\u0002J\u0010\u0010%\u001a\u00020&2\b\u0010'\u001a\u0004\u0018\u00010\tJ,\u0010(\u001a\u00020)2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010*\u001a\u00020+2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00040-J\u001e\u0010.\u001a\u00020/2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\n\u001a\u00020\u000b2\u0006\u00100\u001a\u00020\tJ\"\u00101\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u001a022\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\n\u001a\u00020\u000bJ \u00103\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020/0-0\u0016*\u00020\u001a2\u0006\u00104\u001a\u00020\u0004H\u0002J\u001a\u00105\u001a\u00020\u001a*\b\u0012\u0004\u0012\u00020\u000b0\u00162\u0006\u0010\u0013\u001a\u00020\u0014H\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u00066"}, d2={"Lorg/jetbrains/kotlin/serialization/js/KotlinJavascriptSerializationUtil;", "", "()V", "CLASS_METADATA_FILE_EXTENSION", "", "getCLASS_METADATA_FILE_EXTENSION", "()Ljava/lang/String;", "getPackagesFqNames", "", "Lorg/jetbrains/kotlin/name/FqName;", "module", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "getSubPackagesFqNames", "", "packageView", "Lorg/jetbrains/kotlin/descriptors/PackageViewDescriptor;", "result", "", "metadataAsString", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "jsDescriptor", "Lorg/jetbrains/kotlin/serialization/js/JsModuleDescriptor;", "readModule", "Lorg/jetbrains/kotlin/descriptors/PackageFragmentProvider;", "metadata", "", "storageManager", "Lorg/jetbrains/kotlin/storage/StorageManager;", "configuration", "Lorg/jetbrains/kotlin/serialization/deserialization/DeserializationConfiguration;", "serializeFiles", "Lorg/jetbrains/kotlin/serialization/js/JsProtoBuf$Files;", "fileRegistry", "Lorg/jetbrains/kotlin/serialization/js/KotlinFileRegistry;", "serializer", "Lorg/jetbrains/kotlin/serialization/AnnotationSerializer;", "serializeHeader", "Lorg/jetbrains/kotlin/serialization/js/JsProtoBuf$Header;", "packageFqName", "serializeMetadata", "Lorg/jetbrains/kotlin/serialization/js/JsProtoBuf$Library;", "moduleKind", "Lorg/jetbrains/kotlin/serialization/js/ModuleKind;", "importedModules", "", "serializePackage", "Lorg/jetbrains/kotlin/serialization/js/JsProtoBuf$Library$Part;", "fqName", "toContentMap", "", "deserializeToLibraryParts", "name", "serializeToBinaryMetadata", "js.serializer"})
public final class KotlinJavascriptSerializationUtil {
    @NotNull
    private static final String CLASS_METADATA_FILE_EXTENSION = "kjsm";
    public static final KotlinJavascriptSerializationUtil INSTANCE;

    @NotNull
    public final String getCLASS_METADATA_FILE_EXTENSION() {
        return CLASS_METADATA_FILE_EXTENSION;
    }

    @JvmStatic
    @NotNull
    public static final JsModuleDescriptor<PackageFragmentProvider> readModule(@NotNull byte[] metadata, @NotNull StorageManager storageManager, @NotNull ModuleDescriptor module, @NotNull DeserializationConfiguration configuration2) {
        Intrinsics.checkParameterIsNotNull((Object)metadata, (String)"metadata");
        Intrinsics.checkParameterIsNotNull((Object)storageManager, (String)"storageManager");
        Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
        Intrinsics.checkParameterIsNotNull((Object)configuration2, (String)"configuration");
        String string = module.getName().asString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"module.name.asString()");
        JsModuleDescriptor<List<JsProtoBuf.Library.Part>> jsModule = INSTANCE.deserializeToLibraryParts(metadata, string);
        return jsModule.copy(KotlinJavascriptPackageFragmentProviderKt.createKotlinJavascriptPackageFragmentProvider(storageManager, module, jsModule.getData(), configuration2));
    }

    @NotNull
    public final JsProtoBuf.Library serializeMetadata(@NotNull BindingContext bindingContext2, @NotNull ModuleDescriptor module, @NotNull ModuleKind moduleKind, @NotNull List<String> importedModules) {
        JsProtoBuf.Library.Kind kind2;
        Intrinsics.checkParameterIsNotNull((Object)bindingContext2, (String)"bindingContext");
        Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
        Intrinsics.checkParameterIsNotNull((Object)((Object)moduleKind), (String)"moduleKind");
        Intrinsics.checkParameterIsNotNull(importedModules, (String)"importedModules");
        JsProtoBuf.Library.Builder builder = JsProtoBuf.Library.newBuilder();
        switch (KotlinJavascriptSerializationUtil$WhenMappings.$EnumSwitchMapping$0[moduleKind.ordinal()]) {
            case 1: {
                kind2 = JsProtoBuf.Library.Kind.PLAIN;
                break;
            }
            case 2: {
                kind2 = JsProtoBuf.Library.Kind.AMD;
                break;
            }
            case 3: {
                kind2 = JsProtoBuf.Library.Kind.COMMON_JS;
                break;
            }
            case 4: {
                kind2 = JsProtoBuf.Library.Kind.UMD;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        JsProtoBuf.Library.Kind moduleProtoKind = kind2;
        if (Intrinsics.areEqual((Object)builder.getKind(), (Object)moduleProtoKind) ^ true) {
            builder.setKind(moduleProtoKind);
        }
        Iterable $receiver$iv = importedModules;
        for (Object element$iv : $receiver$iv) {
            String it = (String)element$iv;
            builder.addImportedModule(it);
        }
        for (FqName fqName2 : this.getPackagesFqNames(module)) {
            JsProtoBuf.Library.Part part = this.serializePackage(bindingContext2, module, fqName2);
            if (!part.hasPackage() && part.getClass_Count() <= 0) continue;
            builder.addPart(part);
        }
        JsProtoBuf.Library library = builder.build();
        Intrinsics.checkExpressionValueIsNotNull((Object)library, (String)"builder.build()");
        return library;
    }

    @NotNull
    public final String metadataAsString(@NotNull BindingContext bindingContext2, @NotNull JsModuleDescriptor<? extends ModuleDescriptor> jsDescriptor) {
        Intrinsics.checkParameterIsNotNull((Object)bindingContext2, (String)"bindingContext");
        Intrinsics.checkParameterIsNotNull(jsDescriptor, (String)"jsDescriptor");
        return KotlinJavascriptMetadataUtils.INSTANCE.formatMetadataAsString(jsDescriptor.getName(), this.serializeToBinaryMetadata(jsDescriptor, bindingContext2));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final JsProtoBuf.Library.Part serializePackage(@NotNull BindingContext bindingContext2, @NotNull ModuleDescriptor module, @NotNull FqName fqName2) {
        void qualifiedNames;
        void strings;
        Iterable $receiver$iv$iv;
        Object $receiver$iv;
        Object element$iv$iv2;
        void $receiver$iv$iv2;
        void $receiver$iv2;
        Intrinsics.checkParameterIsNotNull((Object)bindingContext2, (String)"bindingContext");
        Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
        Intrinsics.checkParameterIsNotNull((Object)fqName2, (String)"fqName");
        JsProtoBuf.Library.Part.Builder builder = JsProtoBuf.Library.Part.newBuilder();
        PackageViewDescriptor packageView = module.getPackage(fqName2);
        Function1 skip2 = (Function1)new Function1<DeclarationDescriptor, Boolean>(module){
            final /* synthetic */ ModuleDescriptor $module;

            public final boolean invoke(@NotNull DeclarationDescriptor it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return Intrinsics.areEqual((Object)DescriptorUtils.getContainingModule(it), (Object)this.$module) ^ true || it instanceof MemberDescriptor && ((MemberDescriptor)it).isHeader();
            }
            {
                this.$module = moduleDescriptor;
                super(1);
            }
        };
        KotlinFileRegistry fileRegistry = new KotlinFileRegistry();
        KotlinJavascriptSerializerExtension serializerExtension = new KotlinJavascriptSerializerExtension(fileRegistry, fqName2);
        DescriptorSerializer serializer = DescriptorSerializer.Companion.createTopLevel(serializerExtension);
        Iterable iterable = DescriptorSerializer.Companion.sort(ResolutionScope.DefaultImpls.getContributedDescriptors$default(packageView.getMemberScope(), DescriptorKindFilter.CLASSIFIERS, null, 2, null));
        void var12_11 = $receiver$iv2;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv2 : $receiver$iv$iv2) {
            if (!(element$iv$iv2 instanceof ClassDescriptor)) continue;
            destination$iv$iv.add(element$iv$iv2);
        }
        List classDescriptors2 = (List)destination$iv$iv;
        Function1<Collection<? extends DeclarationDescriptor>, Unit> serializeClasses$ = new Function1<Collection<? extends DeclarationDescriptor>, Unit>(skip2, serializer, builder){
            final /* synthetic */ Function1 $skip;
            final /* synthetic */ DescriptorSerializer $serializer;
            final /* synthetic */ JsProtoBuf.Library.Part.Builder $builder;

            public final void invoke(@NotNull Collection<? extends DeclarationDescriptor> descriptors2) {
                Intrinsics.checkParameterIsNotNull(descriptors2, (String)"descriptors");
                Function1<ClassDescriptor, Unit> serializeClass$ = new Function1<ClassDescriptor, Unit>(this){
                    final /* synthetic */ serializePackage.1 this$0;

                    public final void invoke(@NotNull ClassDescriptor classDescriptor) {
                        Intrinsics.checkParameterIsNotNull((Object)classDescriptor, (String)"classDescriptor");
                        if (((Boolean)this.this$0.$skip.invoke((Object)classDescriptor)).booleanValue()) {
                            return;
                        }
                        ProtoBuf.Class clazz = this.this$0.$serializer.classProto(classDescriptor).build();
                        if (clazz == null) {
                            String string = "Class not serialized: " + classDescriptor;
                            throw (Throwable)new IllegalStateException(string.toString());
                        }
                        ProtoBuf.Class classProto = clazz;
                        this.this$0.$builder.addClass_(classProto);
                        this.this$0.invoke(ResolutionScope.DefaultImpls.getContributedDescriptors$default(classDescriptor.getUnsubstitutedInnerClassesScope(), null, null, 3, null));
                    }
                    {
                        this.this$0 = var1_1;
                        super(1);
                    }
                };
                for (DeclarationDescriptor declarationDescriptor : descriptors2) {
                    if (!(declarationDescriptor instanceof ClassDescriptor)) continue;
                    serializeClass$.invoke((ClassDescriptor)declarationDescriptor);
                }
            }
            {
                this.$skip = function1;
                this.$serializer = descriptorSerializer;
                this.$builder = builder;
                super(1);
            }
        };
        serializeClasses$.invoke((Collection<? extends DeclarationDescriptor>)classDescriptors2);
        JavaScriptStringTable stringTable = serializerExtension.getStringTable();
        List<PackageFragmentDescriptor> fragments2 = packageView.getFragments();
        element$iv$iv2 = fragments2;
        void $i$f$filterIsInstanceTo = $receiver$iv;
        Collection destination$iv$iv2 = new ArrayList();
        for (Object element$iv$iv3 : $receiver$iv$iv) {
            PackageFragmentDescriptor fragment = (PackageFragmentDescriptor)element$iv$iv3;
            Iterable list$iv$iv = DescriptorUtils.getAllDescriptors(fragment.getMemberScope());
            CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
        }
        $receiver$iv = (List)destination$iv$iv2;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv2 = new ArrayList();
        for (Object element$iv$iv3 : $receiver$iv$iv) {
            if (((Boolean)skip2.invoke(element$iv$iv3)).booleanValue()) continue;
            destination$iv$iv2.add(element$iv$iv3);
        }
        List members = (List)destination$iv$iv2;
        $receiver$iv = serializer.packagePartProto(members);
        JsProtoBuf.Library.Part.Builder builder2 = builder;
        MessageLiteOrBuilder $receiver = (ProtoBuf.Package.Builder)$receiver$iv;
        $receiver.setExtension(JsProtoBuf.packageFqName, stringTable.getPackageFqNameIndex(fqName2));
        Object object = $receiver$iv;
        builder2.setPackage(((ProtoBuf.Package.Builder)object).build());
        builder.setFiles(this.serializeFiles(fileRegistry, bindingContext2, new AnnotationSerializer(stringTable)));
        Pair<ProtoBuf.StringTable, ProtoBuf.QualifiedNameTable> pair2 = stringTable.buildProto();
        $receiver$iv = (ProtoBuf.StringTable)pair2.component1();
        $receiver = (ProtoBuf.QualifiedNameTable)pair2.component2();
        pair2 = null;
        builder.setStrings((ProtoBuf.StringTable)strings);
        builder.setQualifiedNames((ProtoBuf.QualifiedNameTable)qualifiedNames);
        JsProtoBuf.Library.Part part = builder.build();
        Intrinsics.checkExpressionValueIsNotNull((Object)part, (String)"builder.build()");
        return part;
    }

    private final JsProtoBuf.Files serializeFiles(KotlinFileRegistry fileRegistry, BindingContext bindingContext2, AnnotationSerializer serializer) {
        Iterable $receiver$iv;
        JsProtoBuf.Files.Builder filesProto = JsProtoBuf.Files.newBuilder();
        Iterable iterable = $receiver$iv = (Iterable)fileRegistry.getFileIds().entrySet();
        Object object = new Comparator<Map.Entry<? extends KtFile, ? extends Integer>>(){

            /*
             * Ignored method signature, as it can't be verified against descriptor
             */
            public int compare(Object a, Object b) {
                Map.Entry it = (Map.Entry)a;
                Comparable comparable = Integer.valueOf(((Number)it.getValue()).intValue());
                it = (Map.Entry)b;
                Comparable comparable2 = comparable;
                Integer n = ((Number)it.getValue()).intValue();
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)n);
            }
        };
        for (Map.Entry entry : CollectionsKt.sortedWith((Iterable)iterable, (Comparator)object)) {
            object = entry;
            KtFile file2 = (KtFile)object.getKey();
            object = entry;
            int id = ((Number)object.getValue()).intValue();
            JsProtoBuf.File.Builder fileProto = JsProtoBuf.File.newBuilder();
            if (id != filesProto.getFileCount()) {
                fileProto.setId(id);
            }
            for (KtAnnotationEntry annotationPsi : file2.getAnnotationEntries()) {
                AnnotationDescriptor annotation2;
                Object v = bindingContext2.get(BindingContext.ANNOTATION, annotationPsi);
                if (v == null) {
                    Intrinsics.throwNpe();
                }
                AnnotationDescriptor annotationDescriptor = annotation2 = (AnnotationDescriptor)v;
                Intrinsics.checkExpressionValueIsNotNull((Object)annotationDescriptor, (String)"annotation");
                fileProto.addAnnotation(serializer.serializeAnnotation(annotationDescriptor));
            }
            filesProto.addFile(fileProto);
        }
        JsProtoBuf.Files files2 = filesProto.build();
        Intrinsics.checkExpressionValueIsNotNull((Object)files2, (String)"filesProto.build()");
        return files2;
    }

    @NotNull
    public final Map<String, byte[]> toContentMap(@NotNull BindingContext bindingContext2, @NotNull ModuleDescriptor module) {
        Intrinsics.checkParameterIsNotNull((Object)bindingContext2, (String)"bindingContext");
        Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
        HashMap contentMap = new HashMap();
        for (FqName fqName2 : this.getPackagesFqNames(module)) {
            byte[] byArray;
            ProtoBuf.Package package_;
            ProtoBuf.Package packageProto;
            JsProtoBuf.Library.Part part = this.serializePackage(bindingContext2, module, fqName2);
            if (part.getClass_Count() == 0 && (packageProto = (package_ = part.getPackage())).getFunctionCount() == 0 && packageProto.getPropertyCount() == 0 && packageProto.getTypeAliasCount() == 0) continue;
            ByteArrayOutputStream stream2 = new ByteArrayOutputStream();
            Object object = new DataOutputStream(stream2);
            DataOutputStream $receiver = object;
            int[] version = JsMetadataVersion.INSTANCE.toArray();
            $receiver.writeInt(version.length);
            int[] $receiver$iv = version;
            for (int i = 0; i < $receiver$iv.length; ++i) {
                int element$iv;
                int p1 = element$iv = $receiver$iv[i];
                $receiver.writeInt(p1);
            }
            this.serializeHeader(fqName2).writeDelimitedTo(stream2);
            part.writeTo(stream2);
            object = contentMap;
            String string = JsSerializerProtocol.INSTANCE.getKjsmFilePath(fqName2);
            Intrinsics.checkExpressionValueIsNotNull((Object)stream2.toByteArray(), (String)"stream.toByteArray()");
            object.put(string, byArray);
        }
        return contentMap;
    }

    @NotNull
    public final JsProtoBuf.Header serializeHeader(@Nullable FqName packageFqName) {
        JsProtoBuf.Header.Builder header = JsProtoBuf.Header.newBuilder();
        if (packageFqName != null) {
            header.setPackageFqName(packageFqName.asString());
        }
        JsProtoBuf.Header header2 = header.build();
        Intrinsics.checkExpressionValueIsNotNull((Object)header2, (String)"header.build()");
        return header2;
    }

    private final Set<FqName> getPackagesFqNames(ModuleDescriptor module) {
        HashSet<FqName> hashSet;
        HashSet<FqName> $receiver = hashSet = new HashSet<FqName>();
        FqName fqName2 = FqName.ROOT;
        Intrinsics.checkExpressionValueIsNotNull((Object)fqName2, (String)"FqName.ROOT");
        INSTANCE.getSubPackagesFqNames(module.getPackage(fqName2), (Set<FqName>)$receiver);
        $receiver.add(FqName.ROOT);
        return hashSet;
    }

    private final void getSubPackagesFqNames(PackageViewDescriptor packageView, Set<FqName> result2) {
        FqName fqName2 = packageView.getFqName();
        if (!fqName2.isRoot()) {
            result2.add(fqName2);
        }
        for (DeclarationDescriptor descriptor2 : packageView.getMemberScope().getContributedDescriptors(DescriptorKindFilter.PACKAGES, MemberScope.Companion.getALL_NAME_FILTER())) {
            if (!(descriptor2 instanceof PackageViewDescriptor)) continue;
            this.getSubPackagesFqNames((PackageViewDescriptor)descriptor2, result2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final byte[] serializeToBinaryMetadata(@NotNull JsModuleDescriptor<? extends ModuleDescriptor> $receiver, BindingContext bindingContext2) {
        ByteArrayOutputStream byteArrayOutputStream;
        ByteArrayOutputStream $receiver2 = byteArrayOutputStream = new ByteArrayOutputStream();
        Closeable closeable = new GZIPOutputStream($receiver2);
        boolean bl = false;
        try {
            GZIPOutputStream stream2 = (GZIPOutputStream)closeable;
            INSTANCE.serializeHeader(null).writeDelimitedTo(stream2);
            INSTANCE.serializeMetadata(bindingContext2, $receiver.getData(), $receiver.getKind(), $receiver.getImported()).writeTo(stream2);
            Unit unit = Unit.INSTANCE;
        }
        catch (Exception exception) {
            bl = true;
            try {
                closeable.close();
            }
            catch (Exception exception2) {
                // empty catch block
            }
            throw (Throwable)exception;
        }
        finally {
            if (!bl) {
                closeable.close();
            }
        }
        byte[] byArray = byteArrayOutputStream.toByteArray();
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"ByteArrayOutputStream().\u2026}\n        }.toByteArray()");
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private final JsModuleDescriptor<List<JsProtoBuf.Library.Part>> deserializeToLibraryParts(@NotNull byte[] $receiver, String name) {
        var4_3 = new GZIPInputStream(new ByteArrayInputStream($receiver));
        var5_4 = false;
        try {
            stream = (GZIPInputStream)var4_3;
            JsProtoBuf.Header.parseDelimitedFrom(stream, JsSerializerProtocol.INSTANCE.getExtensionRegistry());
            var6_6 = JsProtoBuf.Library.parseFrom(stream, JsSerializerProtocol.INSTANCE.getExtensionRegistry());
        }
        catch (Exception var6_7) {
            var5_4 = true;
            try {
                var4_3.close();
            }
            catch (Exception var7_9) {
                // empty catch block
            }
            throw (Throwable)var6_7;
        }
        finally {
            if (!var5_4) {
                var4_3.close();
            }
        }
        content = var6_6;
        v0 = content.getPartList();
        v1 = content.getKind();
        if (v1 == null) ** GOTO lbl-1000
        switch (KotlinJavascriptSerializationUtil$WhenMappings.$EnumSwitchMapping$1[v1.ordinal()]) {
            case 1: lbl-1000:
            // 2 sources

            {
                v2 = ModuleKind.PLAIN;
                break;
            }
            case 2: {
                v2 = ModuleKind.AMD;
                break;
            }
            case 3: {
                v2 = ModuleKind.COMMON_JS;
                break;
            }
            case 4: {
                v2 = ModuleKind.UMD;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        v3 = content.getImportedModuleList();
        Intrinsics.checkExpressionValueIsNotNull((Object)v3, (String)"content.importedModuleList");
        var4_3 = v3;
        var5_5 = v2;
        var6_6 = v0;
        return new JsModuleDescriptor<Object>(name, var5_5, (List<String>)var4_3, var6_6);
    }

    private KotlinJavascriptSerializationUtil() {
        INSTANCE = this;
        CLASS_METADATA_FILE_EXTENSION = CLASS_METADATA_FILE_EXTENSION;
    }

    static {
        new KotlinJavascriptSerializationUtil();
    }
}

